<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=Edge">
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">
    <?php wp_head(); ?>
</head>

<!-- Body -->
<body <?php body_class(); ?>>

    <div class="error-404-container">

        <?php
            if ( agrarium_get_theme_mod('error_additional_text_customize') == 'on' ) {
                if ( !empty(agrarium_get_theme_mod('error_additional_text_top_left')) ) {
                    echo '<div class="error-404-bg-text position-top-left">';
                        echo esc_html(agrarium_get_theme_mod('error_additional_text_top_left'));
                    echo '</div>';
                }
                if ( agrarium_get_theme_mod('error_additional_text_bottom_right') ) {
                    echo '<div class="error-404-bg-text position-bottom-right">';
                        echo esc_html(agrarium_get_theme_mod('error_additional_text_bottom_right'));
                    echo '</div>';
                }
            }
        ?>
        <div class="error-404-header">
            <!-- Logo Block -->
            <?php
                if ( agrarium_get_prefered_option('error_logo_status') == 'on' ) {
                    echo '<div class="logo-container">' . agrarium_get_logo_output() . '</div>';
                }
            ?>
        </div>
        <div class="error-404-inner">
            <div class="error-404-content">
                <?php
                    if ( !empty(agrarium_get_theme_mod('error_image')) ) {
                        echo '<img class="error-404-image" src="' . esc_url(agrarium_get_theme_mod('error_image')) . '">';
                    }
                    if ( !empty(agrarium_get_theme_mod('error_title')) ) {
                        echo '<h2 class="error-404-title">' . wp_kses(agrarium_get_theme_mod('error_title'), array('br' => array())) . '</h2>';
                    }
                    if ( !empty(agrarium_get_theme_mod('error_text')) ) {
                        echo '<p class="error-404-info-text">' . esc_html(agrarium_get_theme_mod('error_text')) . '</p>';
                    }
                    if ( !empty(agrarium_get_theme_mod('error_button_text')) ) {
                        echo '<div class="error-404-button">';
                            echo '<a class="error-404-home-button agrarium-button" href="' . esc_url(home_url('/')) . '">' . esc_html(agrarium_get_theme_mod('error_button_text')) . '</a>';
                        echo '</div>';
                    }
                ?>
            </div>
        </div>
        <div class="error-404-footer">
            <?php
                // Social Buttons
                if ( agrarium_get_prefered_option('error_socials_status') == 'on' ) {
                    echo '<div class="footer-socials-container">';
                        echo agrarium_socials_output('footer-socials wrapper-socials');
                    echo '</div>';
                }
            ?>
        </div>
    </div>

<?php
    wp_footer();
?>

</body>
</html>