<?php
    $columns_number = !empty($args['columns_number']) ? $args['columns_number'] : agrarium_get_theme_mod('portfolio_archive_columns_number');
    $item_class     = !empty($args['item_class']) ? $args['item_class'] : 'portfolio-item-wrapper';
    $listing_type   = !empty($args['listing_type']) ? $args['listing_type'] : 'grid';
    if($listing_type !== 'slider') {
        $categories = get_the_terms(get_the_ID(), 'agrarium_portfolio_category');
        $cat_array = array();
        foreach ( $categories as $category ) {
            $category_name = $category->slug;
            $cat_array[] = $category_name;
        }
        $cat_classes = ' all ' . implode(' ', $cat_array);
        $item_class .= esc_attr($cat_classes);
    }
?>

<div <?php post_class($item_class); ?>>
    <div class="portfolio-item">
        <a href="<?php the_permalink(); ?>" class="portfolio-item-link">
            <?php
                echo '<span class="portfolio-item-overlay fontello icon-plus"></span>';
                echo '<span class="portfolio-item-media">';
                    if($listing_type == 'masonry' && strpos($item_class, 'wide')) {
                        echo agrarium_portfolio_grid_media_output(null, $columns_number, $listing_type, 2);
                    } else {
                        echo agrarium_portfolio_grid_media_output(null, $columns_number, $listing_type);
                    }                    
                echo '</span>';
                $categories = get_the_terms(get_the_ID(), 'agrarium_portfolio_category');
                if ( !empty(get_the_title() || !empty($categories)) ) {
                    echo '<span class="portfolio-item-content">';
                        echo '<span class="portfolio-item-categories">';
                            if(!empty($categories)) {
                                $category = $categories[0];
                                echo esc_html($category->name);
                            }
                        echo '</span>';
                        echo '<span class="post-title">' . get_the_title() . '</span>';
                    echo '</span>';
                }
            ?>
        </a>
    </div>
</div>