<?php
    $columns_number = (isset($args['columns_number']) ? $args['columns_number'] : 1);
    $item_class     = (isset($args['item_class']) ? $args['item_class'] : 'production-item-wrapper');
    $listing_type   = (isset($args['listing_type']) ? $args['listing_type'] : 'grid');
    $show_excerpt = (isset($args['show_excerpt']) ? $args['show_excerpt'] : true);
    $excerpt_length = (isset($args['excerpt_length']) ? $args['excerpt_length'] : '285');
    $show_read_more_button = (isset($args['show_read_more_button']) ? $args['show_read_more_button'] : 'yes');
    $read_more_button_text = (isset($args['read_more_button_text']) ? $args['read_more_button_text'] : esc_html__('Read More', 'agrarium'));

    $is_grid = $listing_type === 'grid' ? true : false;
?>

<div <?php post_class($item_class); ?>>
    <div class="production-item">
        <?php 
            if($listing_type === 'slider') { 
                echo '<div class="agrarium_production_header">';
                if (!empty(get_the_title()) ) {
                    $header_tag = ( $columns_number > 2 ? 'h5' : 'h4' );
                    echo '<' . esc_html($header_tag) . ' class="post-title"><a href="' . esc_url(get_the_permalink()) . '">' . get_the_title() . '</a></' . esc_html($header_tag) . '>';
                }
                if ( $show_excerpt == 'yes' ) {
                    echo '<div class="post-content">';
                        if (!empty($excerpt_length)) {
                            echo substr(get_the_excerpt(), 0, $excerpt_length);
                        } else {
                            the_excerpt();
                        }
                    echo '</div>';
                }
                $terms = get_the_terms(get_the_ID(), 'agrarium_production_category');
                if ($terms && !is_wp_error($terms)) {
                    $term = $terms[0];
                    echo '<a class="production_term_link" href="' . get_term_link($term, 'agrarium_production_category') . '">' . $term->name . '</a>';
                }
                echo '</div>';
                echo '<a href="'. esc_url(get_the_permalink()) .'" class="production-item-link">';
                    echo '<span class="production-item-media">';
                        echo agrarium_production_grid_media_output(null, $columns_number, $is_grid);
                    echo '</span>';
                echo '</a>';
            } else {
                echo '<div class="production-item-column">';
                    echo '<div class="production-item-media">';
                        echo '<a href="'. esc_url(get_the_permalink()) .'" class="production-item-link">';
                            if(!empty(agrarium_production_grid_media_output(null, $columns_number, $is_grid))) {
                                echo agrarium_production_grid_media_output(null, $columns_number, $is_grid);
                            }                        
                            if(!empty(agrarium_get_post_option('production_subtitle'))) {
                                echo '<span class="production-item-subtitle">' . wp_kses_post(agrarium_get_post_option('production_subtitle')) . '</span>';
                            }                            
                        echo '</a>';
                    echo '</div>';
                echo '</div>';
                echo '<div class="production-item-column">';
                    echo '<div class="production-item-content">';
                        echo '<span class="production-item-counter"></span>';
                        echo '<div class="agrarium_production_header">';
                        if (!empty(get_the_title()) ) {
                            echo '<h2 class="post-title"><a href="' . esc_url(get_the_permalink()) . '">' . get_the_title() . '</a></h2>';
                        }
                        echo '</div>';
                        if ( $show_excerpt == 'yes' ) {
                            echo '<div class="post-content">';
                                if (!empty($excerpt_length)) {
                                    echo substr(get_the_excerpt(), 0, $excerpt_length);
                                } else {
                                    the_excerpt();
                                }
                            echo '</div>';
                        }
                        if(empty(!agrarium_get_post_option('production_feature_items'))) {
                            echo '<div class="production-item-features">';
                                echo agrarium_get_production_features();
                            echo '</div>';
                        }
                        if( $show_read_more_button == 'yes' && !empty($read_more_button_text)) {
                            echo '<div class="read-more-button">';
                                echo '<a class="agrarium-button" href="' . esc_url(get_the_permalink()) . '">';
                                    echo '<span>' . esc_html($read_more_button_text) . '</span>';
                                echo '</a>';
                            echo '</div>'; 
                        }                                               
                    echo '</div>';
                echo '</div>';
            }?>                    
    </div>
</div>