<?php
/*
 * Created by Artureanec
*/

# Custom Fields
if ( class_exists( 'RWMB_Field' ) ) {
    class RWMB_Help_Field extends RWMB_Key_Value_Field {
        public static function html( $meta, $field ) {
            // Question.
            $key                            = isset( $meta[0] ) ? $meta[0] : '';
            $attributes                     = self::get_attributes( $field, $key );
            $attributes['placeholder']      = esc_attr__('Title', 'agrarium');
            $html                           = sprintf( '<input %s>', self::render_attributes( $attributes ) );

            // Answer.
            $val                            = isset( $meta[1] ) ? $meta[1] : '';
            $attributes                     = self::get_attributes( $field, $val );
            $attributes['placeholder']      = esc_attr__('Text', 'agrarium');
            $attributes['id']               = $attributes['id'] . esc_attr('_text');
            $attributes['value']            = false;
            $html                           .= sprintf( '<textarea %s>%s</textarea>', self::render_attributes( $attributes ), $val );

            return $html;
        }
    }  

    class RWMB_Benefits_Field extends RWMB_Input_Field {
        public static function admin_enqueue_scripts() {
            wp_enqueue_style( 'rwmb-color', RWMB_CSS_URL . 'color.css', array( 'wp-color-picker' ), RWMB_VER );

            $dependencies = array( 'wp-color-picker' );
            $args         = func_get_args();
            $field        = reset( $args );
            if ( ! empty( $field['alpha_channel'] ) ) {
                wp_enqueue_script( 'wp-color-picker-alpha', RWMB_JS_URL . 'wp-color-picker-alpha/wp-color-picker-alpha.min.js', array( 'wp-color-picker' ), RWMB_VER, true );
                $dependencies = array( 'wp-color-picker-alpha' );
            }
            wp_enqueue_script( 'rwmb-color', RWMB_JS_URL . 'color.js', $dependencies, RWMB_VER, true );
        }

        public static function html( $meta, $field ) {
            $icon_container = agrarium_icon_picker_popover(true, true, true, true, true);

            // Icon.
            $key                                    = isset( $meta[0] ) ? $meta[0] : '';
            $attributes                             = self::get_attributes( $field, $key );
            $attributes['placeholder']              = esc_attr__('Icon', 'agrarium');
            $attributes['class']                    = esc_attr('rwmb-icon icp icp-auto');
            $attributes['type']                     = esc_attr('text');
            $attributes['readonly']                 = true;
            $attributes['id']                       = $attributes['id'] . esc_attr('_icon');
            $attributes['data-options']             = false;
            $attributes['data-alpha-enabled']       = false;
            $attributes['data-alpha-color-type']    = false;
            $html                                   = '<div class="rwmb-benefits-icon-picker">';
            $html                                   .= '<div class="input-group icp-container">';
            $html                                   .= sprintf('<input data-placement="bottomRight" %s">', self::render_attributes($attributes) );

            if ( !empty($key) ) {
                $html .= '<span class="input-group-addon"><i class="' . esc_attr($key) . '"></i></span></div>' . sprintf('%s', $icon_container);
            } else {
                $html .= '<span class="input-group-addon"></span></div>' . sprintf('%s', $icon_container);
            };
            $html                                   .= '</div>';

            // Title.
            if ( $field['field_title'] ) {
                $val                                    = isset( $meta[1] ) ? $meta[1] : '';
                $attributes                             = self::get_attributes( $field, $val );
                $attributes['placeholder']              = esc_attr__('Title', 'agrarium');
                $attributes['id']                       = $attributes['id'] . esc_attr('_title');
                $attributes['data-options']             = false;
                $attributes['data-alpha-enabled']       = false;
                $attributes['data-alpha-color-type']    = false;
                $html                                   .= '<div class="rwmb-benefits-title">';
                $html                                   .= sprintf( '<input %s>', self::render_attributes($attributes) );
                $html                                   .= '</div>';
            }

            // Color.
            if ( $field['field_color'] ) {
                $key                                    = isset( $meta[2] ) ? $meta[2] : '';
                $attributes                             = self::get_attributes( $field, $key );
                $attributes['placeholder']              = false;
                $attributes['class']                    = 'rwmb-color wp-color-picker';
                $attributes['id']                       = $attributes['id'] . esc_attr('_color');
                $html                                   .= '<div class="rwmb-benefits-color">';
                $html                                   .= sprintf( '<input %s>', self::render_attributes($attributes) );
                $html                                   .= '</div>';
            }

            return $html;
        }

        protected static function begin_html( array $field ) : string {
            $desc = $field['desc'] ? "<p id='{$field['id']}_description' class='description'>{$field['desc']}</p>" : '';
            if ( empty( $field['name'] ) ) {
                return '<div class="rwmb-input">' . $desc;
            }
            return sprintf(
                '<div class="rwmb-label">
				<label for="%s">%s</label>
			</div>
			<div class="rwmb-input">
			%s',
                $field['id'],
                $field['name'],
                $desc
            );
        }

        protected static function input_description( array $field ) : string {
            return '';
        }

        protected static function label_description( array $field ) : string {
            return '';
        }

        public static function esc_meta( $meta ) {
            foreach ( (array) $meta as $k => $pairs ) {
                $meta[ $k ] = array_map( 'esc_attr', (array) $pairs );
            }
            return $meta;
        }

        public static function value( $new, $old, $post_id, $field ) {
            foreach ( $new as &$arr ) {
                if ( empty( $arr[0] ) && empty( $arr[1] ) ) {
                    $arr = false;
                }
            }
            $new = array_filter( $new );
            return $new;
        }

        public static function normalize( $field ) {
            $field['clone']         = true;
            $field['multiple']      = true;
            $field                  = wp_parse_args(
                $field,
                array(
                    'alpha_channel' => false,
                    'js_options'    => array(),
                )
            );
            $field                  = wp_parse_args(
                $field,
                array(
                    'field_title'   => false,
                    'field_color'   => false,
                    'size'          => 30,
                    'maxlength'     => false,
                    'pattern'       => false,
                )
            );
            $field['js_options']    = wp_parse_args(
                $field['js_options'],
                array(
                    'defaultColor' => false,
                    'hide'         => true,
                    'palettes'     => true,
                )
            );
            $field             = parent::normalize( $field );

            $field['attributes']['type'] = 'text';
            $field['placeholder']        = wp_parse_args(
                (array) $field['placeholder'],
                array(
                    'key'   => esc_html__( 'Icon', 'agrarium' ),
                    'value' => esc_html__( 'Title', 'agrarium' ),
                )
            );
            return $field;
        }

        public static function format_clone_value( $field, $value, $args, $post_id ) {
            return sprintf( '<label>%s:</label> %s', $value[0], $value[1] );
        }

        public static function get_attributes( $field, $value = null ) {
            $attributes         = parent::get_attributes( $field, $value );
            $attributes         = wp_parse_args(
                $attributes,
                array(
                    'size'          => $field['size'],
                    'maxlength'     => $field['maxlength'],
                    'pattern'       => $field['pattern'],
                    'placeholder'   => $field['placeholder'],
                    'data-options'  => wp_json_encode( $field['js_options'] ),
                )
            );
            $attributes['type'] = 'text';

            if ( $field['alpha_channel'] ) {
                $attributes['data-alpha-enabled']    = 'true';
                $attributes['data-alpha-color-type'] = 'hex';
            }

            return $attributes;
        }

        public static function format_single_value( $field, $value, $args, $post_id ) {
            return sprintf( "<span style='display:inline-block;width:20px;height:20px;border-radius:50%;background:%s;'></span>", $value );
        }
    }

    class RWMB_Iconpicker_Field extends RWMB_Input_Field {

        public static function html( $meta, $field ) {
            $icon_container = agrarium_icon_picker_popover(true, true, true, true, true);

            // Icon.
            $attributes                              = self::call( 'get_attributes', $field, $meta );
            $attributes['placeholder']              = '';
            $attributes['class']                    = esc_attr('icp icp-auto');
            $attributes['type']                     = esc_attr('text');
            $attributes['readonly']                 = true;
            $html                                   = '<div class="rwmb-iconpicker-icon-picker">';
            $html                                   .= '<div class="input-group icp-container">';
            $html                                   .= sprintf('<input data-placement="bottomRight" %s">', self::render_attributes($attributes) );

            if ( !empty($meta) ) {
                $html .= '<span class="input-group-addon"><i class="' . esc_attr($meta) . '"></i></span></div>' . sprintf('%s', $icon_container);
            } else {
                $html .= '<span class="input-group-addon"></span></div>' . sprintf('%s', $icon_container);
            };
            $html                                   .= '</div>';

            return $html;
        }

        public static function normalize( $field ) {
            $field = parent::normalize( $field );

            $field = wp_parse_args(
                $field,
                array(
                    'size'      => 30,
                    'maxlength' => false,
                    'pattern'   => false,
                )
            );

            return $field;
        }

        public static function get_attributes( $field, $value = null ) {
            $attributes = parent::get_attributes( $field, $value );
            $attributes = wp_parse_args(
                $attributes,
                array(
                    'size'        => $field['size'],
                    'maxlength'   => $field['maxlength'],
                    'pattern'     => $field['pattern'],
                    'placeholder' => $field['placeholder'],
                )
            );

            return $attributes;
        }
    }
}
# RWMB check
if (!function_exists('agrarium_post_options')) {
    function agrarium_post_options()
    {
        if (class_exists('RWMB_Loader')) {
            return true;
        } else {
            return false;
        }
    }
}

# RWMB get option
if (!function_exists('agrarium_get_post_option')) {
    function agrarium_get_post_option($name, $default = false) {
        if (class_exists('RWMB_Loader')) {
            if (rwmb_meta($name)) {
                return rwmb_meta($name);
            } else {
                return $default;
            }
        } else {
            return $default;
        }
    }
}

# RWMB get value
if (!function_exists('agrarium_get_post_value')) {
    function agrarium_get_post_value($name, $default = false) {
        if (class_exists('RWMB_Loader')) {
            if (rwmb_the_value($name, null, null, false)) {
                return rwmb_the_value($name, null, null, false);
            } else {
                return $default;
            }
        } else {
            return $default;
        }
    }
}

# RWMB get image
if (!function_exists('agrarium_get_post_image')) {
    function agrarium_get_post_image($name, $size = 'large', $default = false) {
        if (class_exists('RWMB_Loader')) {
            if (rwmb_meta($name)) {
                $out = '';
                $images = rwmb_meta( $name, array( 'size' => $size ) );
                foreach ( $images as $image ) {
                    $out .= '<div class="image_wrapper"><img src="'. $image['url']. '" alt="'. $image['alt']. '"></div>';
                }
                return $out;
            } else {
                return $default;
            }
        } else {
            return $default;
        }
    }
}

# RWMB get time
if (!function_exists('agrarium_get_post_time')) {
    function agrarium_get_post_time($time, $default = false) {
        if (class_exists('RWMB_Loader')) {
            if (rwmb_meta($time)) {
                $time = ' ' . rwmb_meta($time);
                $time = str_replace(esc_html__(' 0 Hours', 'agrarium'), '', $time);
                $time = str_replace(esc_html__(' 0 Minutes', 'agrarium'), '', $time);
                $time = str_replace(esc_html__(' 1 Hours', 'agrarium'), esc_html__(' 1 Hour', 'agrarium'), $time);
                $time = str_replace(esc_html__(' 1 Minutes', 'agrarium'), esc_html__('1 Minute', 'agrarium'), $time);
                return trim($time);
            } else {
                return $default;
            }
        } else {
            return $default;
        }
    }
}

if (class_exists('RWMB_Loader')) {
    if (!function_exists('agrarium_custom_meta_boxes')) {
        add_filter('rwmb_meta_boxes', 'agrarium_custom_meta_boxes');

        function agrarium_custom_meta_boxes($meta_boxes) {
            $sidebar_list_default = array(
                'default' => esc_html__('Default', 'agrarium')
            );
            $sidebar_list = agrarium_get_all_sidebar_list();
            $sidebar_list = $sidebar_list_default + $sidebar_list;

            # Quote Post Format
            $meta_boxes[] = array(
                'title'         => esc_html__('Quote Post Format Settings', 'agrarium'),
                'post_types'    => array('post'),
                'context'       => 'advanced',
                'fields'        => array(
                    array(
                        'id'            => 'post_media_quote_text',
                        'name'          => esc_html__('Quote Text', 'agrarium'),
                        'placeholder'   => esc_html__('Enter Quote Text', 'agrarium'),
                        'type'          => 'textarea',
                    ),
                    array(
                        'id'            => 'post_media_quote_author',
                        'name'          => esc_html__('Quote Author Name', 'agrarium'),
                        'placeholder'   => esc_html__('Quote Author Name', 'agrarium'),
                        'type'          => 'text',
                    ),
                ),
            );

            # Gallery Post Format
            $meta_boxes[] = array(
                'title'         => esc_html__('Gallery Post Format Settings', 'agrarium'),
                'post_types'    => array('post'),
                'context'       => 'advanced',
                'fields'        => array(
                    array(
                        'id'        => 'post_media_gallery_select',
                        'name'      => esc_html__('Select Images', 'agrarium'),
                        'type'      => 'image_advanced',
                    ),
                ),
            );

            # Video Post Format
            $meta_boxes[] = array(
                'title'         => esc_html__('Video Post Format Settings', 'agrarium'),
                'post_types'    => array('post'),
                'context'       => 'advanced',
                'fields'        => array(
                    array(
                        'id'        => 'post_media_video_type',
                        'name'      => esc_html__('Video Source', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'link',
                        'options'   => array(
                            'link'      => esc_html__('Outer Link', 'agrarium'),
                            'self'      => esc_html__('Self Hosted', 'agrarium')
                        )
                    ),
                    array(
                        'id'            => 'post_media_video_url',
                        'name'          => esc_html__('Enter Video Link', 'agrarium'),
                        'type'          => 'oembed',
                        'desc'          => esc_html__('Copy link to the video from YouTube or other video-sharing website.', 'agrarium'),
                        'attributes'    => array(
                            'data-dependency-id'    => 'post_media_video_type',
                            'data-dependency-val'   => 'link'
                        )
                    ),
                    array(
                        'id'                => 'post_media_video_select',
                        'name'              => esc_html__('Select Video From Media Library', 'agrarium'),
                        'type'              => 'video',
                        'max_file_uploads'  => 1,
                        'max_status'        => false,
                        'attributes'        => array(
                            'data-dependency-id'    => 'post_media_video_type',
                            'data-dependency-val'   => 'self'
                        )
                    ),
                ),
            );

            # Content Output Settings
            $meta_boxes[] = array(
                'title'         => esc_html__('Single Post Settings', 'agrarium'),
                'post_types'    => array('post'),
                'context'       => 'advanced',
                'fields'        => array(

                    //-- Single Post Settings
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Post Output Settings', 'agrarium'),
                    ),

                    array(
                        'id'        => 'post_media_image_status',
                        'name'      => esc_html__('Show Media Block', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'        => 'post_category_status',
                        'name'      => esc_html__('Show Post Categories', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'        => 'post_date_status',
                        'name'      => esc_html__('Show Post Date', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'        => 'post_author_status',
                        'name'      => esc_html__('Show Post Author', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'        => 'post_comment_counter_status',
                        'name'      => esc_html__('Show Number of Post Comments', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'        => 'post_title_status',
                        'name'      => esc_html__('Show Post Title', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'        => 'post_tags_status',
                        'name'      => esc_html__('Show Post Tags', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'        => 'post_socials_status',
                        'name'      => esc_html__('Show Post Social Buttons', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    //-- Sticky Header
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Recent Posts', 'agrarium'),
                    ),

                    array(
                        'id'        => 'recent_posts_status',
                        'name'      => esc_html__('Show Recent Posts', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'        => 'recent_posts_customize',
                        'name'      => esc_html__('Customize', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium')
                        )
                    ),

                    array(
                        'id'            => 'recent_posts_section_heading',
                        'name'          => esc_html__('Recent Posts Section Title', 'agrarium'),
                        'type'          => 'text',
                        'std'           => '',
                        'placeholder'   => agrarium_get_theme_mod('recent_posts_section_heading')
                    ),

                    array(
                        'id'            => 'recent_posts_number',
                        'name'          => esc_html__('Number of Posts', 'agrarium'),
                        'type'          => 'select',
                        'options'       => array(
                            'default'       => esc_html__('Default', 'agrarium'),
                            '2'             => esc_html__('2 Items', 'agrarium'),
                            '3'             => esc_html__('3 Items', 'agrarium'),
                            '4'             => esc_html__('4 Items', 'agrarium')
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'recent_posts_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'recent_posts_order_by',
                        'name'          => esc_html__('Order By', 'agrarium'),
                        'type'          => 'select',
                        'options'       => array(
                            'default'       => esc_html__('Default', 'agrarium'),
                            'random'        => esc_html__('Random', 'agrarium'),
                            'date'          => esc_html__('Date', 'agrarium'),
                            'name'          => esc_html__('Name', 'agrarium')
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'recent_posts_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'recent_posts_order',
                        'name'          => esc_html__('Sort Order', 'agrarium'),
                        'type'          => 'select',
                        'options'       => array(
                            'default'       => esc_html__('Default', 'agrarium'),
                            'desc'          => esc_html__('Descending', 'agrarium'),
                            'asc'           => esc_html__('Ascending', 'agrarium')
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'recent_posts_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'recent_posts_image',
                        'name'          => esc_html__('Show Recent Post Image', 'agrarium'),
                        'type'          => 'select',
                        'std'           => 'default',
                        'options'       => array(
                            'default'       => esc_html__('Default', 'agrarium'),
                            'on'            => esc_html__('Yes', 'agrarium'),
                            'off'           => esc_html__('No', 'agrarium')
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'recent_posts_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'recent_posts_category',
                        'name'          => esc_html__('Show Recent Post Categories', 'agrarium'),
                        'type'          => 'select',
                        'std'           => 'default',
                        'options'       => array(
                            'default'       => esc_html__('Default', 'agrarium'),
                            'on'            => esc_html__('Yes', 'agrarium'),
                            'off'           => esc_html__('No', 'agrarium')
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'recent_posts_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'recent_posts_date',
                        'name'          => esc_html__('Show Recent Post Date', 'agrarium'),
                        'type'          => 'select',
                        'std'           => 'default',
                        'options'       => array(
                            'default'       => esc_html__('Default', 'agrarium'),
                            'on'            => esc_html__('Yes', 'agrarium'),
                            'off'           => esc_html__('No', 'agrarium')
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'recent_posts_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'recent_posts_author',
                        'name'          => esc_html__('Show Recent Post Author', 'agrarium'),
                        'type'          => 'select',
                        'std'           => 'default',
                        'options'       => array(
                            'default'       => esc_html__('Default', 'agrarium'),
                            'on'            => esc_html__('Yes', 'agrarium'),
                            'off'           => esc_html__('No', 'agrarium')
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'recent_posts_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'recent_posts_comment_counter',
                        'name'          => esc_html__('Show Recent Post Number of Comments', 'agrarium'),
                        'type'          => 'select',
                        'std'           => 'default',
                        'options'       => array(
                            'default'       => esc_html__('Default', 'agrarium'),
                            'on'            => esc_html__('Yes', 'agrarium'),
                            'off'           => esc_html__('No', 'agrarium')
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'recent_posts_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'recent_posts_title',
                        'name'          => esc_html__('Show Recent Post Title', 'agrarium'),
                        'type'          => 'select',
                        'std'           => 'default',
                        'options'       => array(
                            'default'       => esc_html__('Default', 'agrarium'),
                            'on'            => esc_html__('Yes', 'agrarium'),
                            'off'           => esc_html__('No', 'agrarium')
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'recent_posts_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'recent_posts_excerpt',
                        'name'          => esc_html__('Show Recent Post Excerpt', 'agrarium'),
                        'type'          => 'select',
                        'std'           => 'default',
                        'options'       => array(
                            'default'       => esc_html__('Default', 'agrarium'),
                            'on'            => esc_html__('Yes', 'agrarium'),
                            'off'           => esc_html__('No', 'agrarium')
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'recent_posts_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'recent_posts_excerpt_length',
                        'name'          => esc_html__('Page Title Height', 'agrarium'),
                        'type'          => 'number',
                        'placeholder'   => agrarium_get_theme_mod('recent_posts_excerpt_length'),
                        'std'           => '',
                        'attributes'    => array(
                            'data-dependency-id'    => 'recent_posts_customize',
                            'data-dependency-val'   => 'custom'
                        )
                    ),

                    array(
                        'id'            => 'recent_posts_tags',
                        'name'          => esc_html__('Show Recent Post Tags', 'agrarium'),
                        'type'          => 'select',
                        'std'           => 'default',
                        'options'       => array(
                            'default'       => esc_html__('Default', 'agrarium'),
                            'on'            => esc_html__('Yes', 'agrarium'),
                            'off'           => esc_html__('No', 'agrarium')
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'recent_posts_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'recent_posts_more',
                        'name'          => esc_html__('Show Recent Post \'Read More\' Button', 'agrarium'),
                        'type'          => 'select',
                        'std'           => 'default',
                        'options'       => array(
                            'default'       => esc_html__('Default', 'agrarium'),
                            'on'            => esc_html__('Yes', 'agrarium'),
                            'off'           => esc_html__('No', 'agrarium')
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'recent_posts_customize',
                            'data-dependency-val'   => 'on'
                        )
                    )
                )
            );

            # Portfolio Custom Fields

            $meta_boxes[] = array(
                'title'         => esc_html__('Portfolio Gallery', 'agrarium'),
                'post_types'    => array('agrarium_portfolio'),
                'context'       => 'side',
                'fields'        => array(                    
                    array(
                        'id'    => 'portfolio_gallery',
                        'type'  => 'image_advanced'
                    )
                )
            );

            $meta_boxes[] = array(
                'title'         => esc_html__('Portfolio Fields', 'agrarium'),
                'post_types'    => array('agrarium_portfolio'),
                'context'       => 'after_title',
                'fields'        => array(
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Subtitle', 'agrarium'),
                    ),
                    array(
                        'id'        => 'portfolio_subtitle',
                        'name'      => esc_html__('Subtitle', 'agrarium'),
                        'type'      => 'text'
                    ),
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Portfolio Features', 'agrarium'),
                    ),
                    array(
                        'id'            => 'portfolio_feature',
                        'name'          => esc_html__('Feature', 'agrarium'),
                        'type'          => 'text',
                        'clone'         => true,
                        'sortable'      => true,
                        'placeholder'   => 'Feature'
                    ),
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Portfolio Button', 'agrarium'),
                    ),
                    array(
                        'id'        => 'portfolio_more_button_show',
                        'name'      => esc_html__('Show Read More Button', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'show',
                        'options'   => array(
                            'on'      => esc_html__('Show', 'agrarium'),
                            'off'      => esc_html__('Hide', 'agrarium')
                        )
                    ),
                    array(
                        'id'            => 'portfolio_more_button_text',
                        'name'          => esc_html__('Read More Button Text', 'agrarium'),
                        'type'          => 'text',
                        'placeholder'   => 'Read more',
                        'std'           => 'Read more',
                        'attributes'    => array(
                            'data-dependency-id'    => 'portfolio_more_button_show',
                            'data-dependency-val'   => 'on'
                        )
                    ),
                    array(
                        'id'            => 'portfolio_more_button_link',
                        'name'          => esc_html__('Read More Button Link', 'agrarium'),
                        'type'          => 'text',
                        'placeholder'   => '#',
                        'std'           => '#',
                        'attributes'    => array(
                            'data-dependency-id'    => 'portfolio_more_button_show',
                            'data-dependency-val'   => 'on'
                        )
                    )
                )
            );           
            
            # Projects Custom Fields
            $meta_boxes[] = array(
                'title'         => esc_html__('Project Fields', 'agrarium'),
                'post_types'    => array('agrarium_project'),
                'context'       => 'advanced',
                'fields'        => array(
                    array(
                        'id'            => 'project_strategy',
                        'name'          => esc_html__('Strategy', 'agrarium'),
                        'type'          => 'text',
                        'add_button'    => esc_html__('+ Add More', 'agrarium'),
                        'clone'         => true
                    ),
                    array(
                        'id'            => 'project_design',
                        'name'          => esc_html__('Design', 'agrarium'),
                        'type'          => 'text',
                        'add_button'    => esc_html__('+ Add More', 'agrarium'),
                        'clone'         => true
                    ),
                    array(
                        'id'            => 'project_client',
                        'name'          => esc_html__('Client', 'agrarium'),
                        'type'          => 'text'
                    ),
                    array(
                        'id'            => 'project_button',
                        'name'          => esc_html__('Link Button', 'agrarium'),
                        'type'          => 'text_list',
                        'options'       => array(
                            esc_attr__('Link', 'agrarium')   => esc_html__('Link', 'agrarium'),
                            esc_attr__('Label', 'agrarium')  => esc_html__('Label', 'agrarium')
                        ),
                        'clone'         => false
                    ),
                    array(
                        'type' => 'divider',
                    ),
                    array(
                        'id'            => 'project_gallery',
                        'name'          => esc_html__('Project Gallery', 'agrarium'),
                        'type'          => 'image_advanced'
                    )
                )
            );

            # Team Member Custom Fields
            $meta_boxes[] = array(
                'title'         => esc_html__('Team Member Fields', 'agrarium'),
                'post_types'    => array('agrarium_team_member'),
                'context'       => 'advanced',
                'fields'        => array(
                    array(
                        'id'            => 'team_member_position',
                        'name'          => esc_html__('Position', 'agrarium'),
                        'type'          => 'text'
                    ),
                    array(
                        'type' => 'divider',
                    ),
                    array(
                        'id'            => 'team_member_short_text',
                        'name'          => esc_html__('Member Short Info', 'agrarium'),
                        'type'          => 'wysiwyg',
                        'options'       => array(
                            'textarea_rows' => 6,
                            'teeny'         => true
                        ),
                    ),
                    array(
                        'type' => 'divider',
                    ),
                    array(
                        'id'            => 'team_member_contacts_link',
                        'name'          => esc_html__('Contacts Link', 'agrarium'),
                        'type'          => 'text',
                        'std'           => '#'
                    ),
                    array(
                        'type' => 'divider',
                    ),
                    array(
                        'id'            => 'team_member_socials',
                        'name'          => esc_html__('Social Links', 'agrarium'),
                        'type'          => 'key_value',
                        'placeholder'   => array(
                            'key'           => esc_attr__('Icon', 'agrarium'),
                            'value'         => esc_attr__('Link', 'agrarium')
                        ),
                        'add_button'    => esc_html__('+ Add More', 'agrarium'),
                        'class'         => 'icon-picker',
                        'clone'         => true,
                        'sort_clone'    => true,
                        'max_clone'     => 7
                    ),
                    array(
                        'type' => 'divider',
                    ),
                    array(
                        'id'            => 'team_member_biography_title',
                        'name'          => esc_html__('Biography Title', 'agrarium'),
                        'type'          => 'text'
                    ),
                    array(
                        'id'            => 'team_member_biography_text',
                        'name'          => esc_html__('Biography Text', 'agrarium'),
                        'type'          => 'wysiwyg',
                        'options'       => array(
                            'textarea_rows' => 6,
                            'teeny'         => true
                        ),
                    ),
                    array(
                        'type' => 'divider',
                    ),
                    array(
                        'id'            => 'team_member_personal_info_title',
                        'name'          => esc_html__('Personal Info Title', 'agrarium'),
                        'type'          => 'text',
                        'std'           => esc_html__('Personal Info', 'agrarium')
                    ),
                    array(
                        'id'            => 'team_member_personal_info_item',
                        'name'          => esc_html__('Personal Info Item', 'agrarium'),
                        'type'          => 'text',
                        'clone'         => true,
                        'add_button'    => esc_html__('+ Add More', 'agrarium')
                    ),
                    array(
                        'id'            => 'team_member_email',
                        'name'          => esc_html__('Personal Info E-mail', 'agrarium'),
                        'type'          => 'text'
                    ),
                    array(
                        'type' => 'divider',
                    ),
                    array(
                        'id'            => 'team_member_skills_title',
                        'name'          => esc_html__('Skills List Title', 'agrarium'),
                        'type'          => 'text',
                        'std'           => esc_html__('Main Skills', 'agrarium')
                    ),
                    array(
                        'id'            => 'team_member_skills_list',
                        'name'          => esc_html__('Personal Skills', 'agrarium'),
                        'type'          => 'text',
                        'clone'         => true,
                        'add_button'    => esc_html__('+ Add More', 'agrarium')
                    ),
                    array(
                        'type' => 'divider',
                    ),
                    array(
                        'id'            => 'team_member_values_title',
                        'name'          => esc_html__('Values List Title', 'agrarium'),
                        'type'          => 'text',
                        'std'           => esc_html__('Values', 'agrarium')
                    ),
                    array(
                        'id'            => 'team_member_values_list',
                        'name'          => esc_html__('Values', 'agrarium'),
                        'type'          => 'text',
                        'clone'         => true,
                        'add_button'    => esc_html__('+ Add More', 'agrarium')
                    ),
                    array(
                        'type' => 'divider',
                    ),
                    array(
                        'id'            => 'team_member_experience_title',
                        'name'          => esc_html__('Experience & Education Section Title', 'agrarium'),
                        'type'          => 'text',
                        'std'           => sprintf(esc_html__('My experience%s & years of education', 'agrarium'), wp_kses('<br>', array('br' => array())))
                    ),
                    array(
                        'id'            => 'team_member_education_list',
                        'name'          => esc_html__('Education List', 'agrarium'),
                        'type'          => 'text_list',
                        'clone'         => true,
                        'options'       => array(
                            esc_attr__('Title', 'agrarium')          => esc_html__('Title', 'agrarium'),
                            esc_attr__('Period', 'agrarium')         => esc_html__('Period', 'agrarium'),
                            esc_attr__('Description', 'agrarium')    => esc_html__('Description', 'agrarium'),
                        ),
                        'add_button'    => esc_html__('+ Add More', 'agrarium')
                    ),
                    array(
                        'id'            => 'team_member_experience_list',
                        'name'          => esc_html__('Experience List', 'agrarium'),
                        'type'          => 'text_list',
                        'clone'         => true,
                        'options'       => array(
                            esc_attr__('Title', 'agrarium')          => esc_html__('Title', 'agrarium'),
                            esc_attr__('Period', 'agrarium')         => esc_html__('Period', 'agrarium'),
                            esc_attr__('Description', 'agrarium')    => esc_html__('Description', 'agrarium'),
                        ),
                        'add_button'    => esc_html__('+ Add More', 'agrarium')
                    ),
                )
            );

            # Vacancy Custom Fields
            $meta_boxes[] = array(
                'title'         => esc_html__('Vacancy Fields', 'agrarium'),
                'post_types'    => array('agrarium_vacancy'),
                'context'       => 'advanced',
                'fields'        => array(
                    array(
                        'id'        => 'vacancy_occupation',
                        'name'      => esc_html__('Occupation', 'agrarium'),
                        'type'      => 'text',
                        'desc'      => esc_html__('Full-time, part-time, contract, etc.', 'agrarium')
                    ),
                    array(
                        'id'        => 'vacancy_location',
                        'name'      => esc_html__('Location', 'agrarium'),
                        'type'      => 'text',
                    ),
                    array(
                        'id'        => 'vacancy_salary',
                        'name'      => esc_html__('Salary', 'agrarium'),
                        'type'      => 'text',
                    ),
                    array(
                        'id'        => 'vacancy_responsibilities',
                        'name'      => esc_html__('Responsibilities', 'agrarium'),
                        'type'      => 'wysiwyg',
                        'raw'       => false,
                        'options'   => array(
                            'textarea_rows' => 8,
                            'teeny'         => true,
                        ),
                    ),
                    array(
                        'id'        => 'vacancy_qualifications',
                        'name'      => esc_html__('Preferred Qualifications', 'agrarium'),
                        'type'      => 'wysiwyg',
                        'raw'       => false,
                        'options'   => array(
                            'textarea_rows' => 8,
                            'teeny'         => true,
                        ),
                    ),
                    array(
                        'id'            => 'vacancy_button',
                        'name'          => esc_html__('Contact Button', 'agrarium'),
                        'type'          => 'text_list',
                        'options'       => array(
                            esc_attr__('Link', 'agrarium')   => esc_html__('Link', 'agrarium'),
                            esc_attr__('Label', 'agrarium')  => esc_html__('Label', 'agrarium')
                        ),
                        'clone'         => false
                    ),

                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Recent Vacancies', 'agrarium'),
                    ),

                    array(
                        'id'        => 'recent_vacancies_status',
                        'name'      => esc_html__('Show Recent Vacancies', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'        => 'recent_vacancies_customize',
                        'name'      => esc_html__('Customize', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium')
                        )
                    ),

                    array(
                        'id'            => 'recent_vacancies_section_heading',
                        'name'          => esc_html__('Recent Vacancies Section Title', 'agrarium'),
                        'type'          => 'text',
                        'std'           => '',
                        'placeholder'   => agrarium_get_theme_mod('recent_vacancies_section_heading')
                    ),

                    array(
                        'id'            => 'recent_vacancies_number',
                        'name'          => esc_html__('Number of Posts', 'agrarium'),
                        'type'          => 'number',
                        'min'           => 1,
                        'max'           => 20,
                        'step'          => 1,
                        'std'           => '',
                        'attributes'    => array(
                            'data-dependency-id'    => 'recent_vacancies_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'recent_vacancies_order_by',
                        'name'          => esc_html__('Order By', 'agrarium'),
                        'type'          => 'select',
                        'options'       => array(
                            'default'       => esc_html__('Default', 'agrarium'),
                            'random'        => esc_html__('Random', 'agrarium'),
                            'date'          => esc_html__('Date', 'agrarium'),
                            'name'          => esc_html__('Name', 'agrarium')
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'recent_vacancies_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'recent_vacancies_order',
                        'name'          => esc_html__('Sort Order', 'agrarium'),
                        'type'          => 'select',
                        'options'       => array(
                            'default'       => esc_html__('Default', 'agrarium'),
                            'desc'          => esc_html__('Descending', 'agrarium'),
                            'asc'           => esc_html__('Ascending', 'agrarium')
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'recent_vacancies_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                )
            );            

            # Service Post Icon Settings
            $meta_boxes[] = array(
                'title'         => esc_html__('Service Icon', 'agrarium'),
                'post_types'    => array('agrarium_service'),
                'context'       => 'advanced',
                'fields'        => array(
                    array(
                        'id'            => 'service_main_icon',
                        'type'          => 'iconpicker',
                        'name'          => esc_html__('Service Icon', 'agrarium'),
                    ),
                    array(
                        'id'            => 'service_main_icon_color',
                        'name'          => esc_html__('Icon Color', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),
                )
            );
            # Service Custom Fields
            $meta_boxes[] = array(
                'title'         => esc_html__('Service Fields', 'agrarium'),
                'post_types'    => array('agrarium_service'),
                'context'       => 'after_title',
                'fields'        => array(
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Short Description', 'agrarium'),
                    ),
                    array(
                        'id'        => 'service_description',
                        'type'      => 'wysiwyg',
                        'sanitize_callback' => 'wp_kses_post',
                        'raw'       => true,
                        'options'   => array(
                            'textarea_rows' => 12,
                            'teeny'         => false,
                        ),
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    array(
                        'id'            => 'service_benefits_title',
                        'name'          => esc_html__('Benefits Section Title', 'agrarium'),
                        'type'          => 'text',
                        'std'           => wp_kses(esc_html__('Benefits', 'agrarium'), array('br' => array()))
                    ),
                    array(
                        'id'            => 'service_benefit_items',
                        'name'          => esc_html__('Benefits', 'agrarium'),
                        'type'          => 'benefits',
                        'add_button'    => esc_html__('+ Add More', 'agrarium'),
                        'clone'         => true,
                        'sort_clone'    => true,
                        'alpha_channel' => true,
                        'field_title'   => true,
                        'field_color'   => true
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    array(
                        'id'            => 'service_help_title',
                        'name'          => esc_html__('Help Section Title', 'agrarium'),
                        'type'          => 'text',
                        'std'           => esc_html__('We’re Here to Help You', 'agrarium'),
                    ),
                    array(
                        'id'            => 'service_help_items',
                        'name'          => esc_html__('Help Items', 'agrarium'),
                        'type'          => 'help',
                        'clone'         => true,
                        'add_button'    => esc_html__('+ Add More', 'agrarium')
                    ),

                )
            );

            # Case Study Custom Fields
            $meta_boxes[] = array(
                'title'         => esc_html__('Case Study Fields', 'agrarium'),
                'post_types'    => array('agrarium_case_study'),
                'context'       => 'advanced',
                'fields'        => array(
                    array(
                        'id'        => 'case_study_result',
                        'name'      => esc_html__('Results', 'agrarium'),
                        'type'      => 'wysiwyg',
                        'raw'       => false,
                        'options'   => array(
                            'textarea_rows' => 8,
                            'teeny'         => true,
                        ),
                    ),

                    array(
                        'id'        => 'case_study_boxes',
                        'name'      => 'Result Boxes',
                        'type'      => 'text_list',
                        'clone'     => true,
                        'options'   => array(
                            'Value'     => 'Value',
                            'Title'     => 'Title'
                        ),
                    ),
                )
            );
            
            # Production Custom Fields
            $meta_boxes[] = array(
                'title'         => esc_html__('Production Fields', 'agrarium'),
                'post_types'    => array('agrarium_production'),
                'context'       => 'advanced',
                'fields'        => array(
                    array(
                        'id'        => 'production_subtitle',
                        'name'      => esc_html__('Subtitle', 'agrarium'),
                        'type'      => 'textarea'
                    ),
                    array(
                        'type' => 'divider',
                    ),
                    array(
                        'id'        => 'production_description',
                        'name'      => esc_html__('Description', 'agrarium'),
                        'type'      => 'wysiwyg'
                    ),
                    array(
                        'type' => 'divider',
                    ),
                    array(
                        'id'            => 'production_feature_items',
                        'name'          => esc_html__('Features', 'agrarium'),
                        'type'          => 'benefits',
                        'add_button'    => esc_html__('+ Add Feature', 'agrarium'),
                        'clone'         => true,
                        'sort_clone'    => true,
                        'field_title'   => true,
                        'alpha_channel' => true,
                        'field_color'   => true
                    )
                )
            );            

            # Post and Page Settings
            $meta_boxes[] = array(
                'title'         => esc_html__('Color Settings', 'agrarium'),
                'post_types'    => array('post', 'page', 'agrarium_portfolio', 'agrarium_team_member', 'agrarium_vacancy', 'agrarium_service', 'agrarium_case_study', 'product', 'agrarium_production'),
                'closed'        => true,
                'context'       => 'advanced',
                'fields'        => array(

                    # Color Options

                    //-- Standard colors
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Standard Colors', 'agrarium'),
                    ),

                    array(
                        'id'            => 'standard_default_text_color',
                        'name'          => esc_html__('Default Text Color', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'id'            => 'standard_dark_text_color',
                        'name'          => esc_html__('Dark Text Color', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'id'            => 'standard_light_text_color',
                        'name'          => esc_html__('Light Text Color', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'id'            => 'standard_accent_text_color',
                        'name'          => esc_html__('Accent Text Color', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    array(
                        'id'            => 'standard_border_color',
                        'name'          => esc_html__('Border Color', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'id'            => 'standard_border_hover_color',
                        'name'          => esc_html__('Hovered Border Color', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    array(
                        'id'            => 'standard_background_color',
                        'name'          => esc_html__('Background Color', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'id'            => 'standard_background_alter_color',
                        'name'          => esc_html__('Alternative Background Color', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    array(
                        'id'            => 'standard_button_text_color',
                        'name'          => esc_html__('Button Text Color', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'id'            => 'standard_button_border_color',
                        'name'          => esc_html__('Button Border Color', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'id'            => 'standard_button_background_color',
                        'name'          => esc_html__('Button Background Color', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'id'            => 'standard_button_text_hover',
                        'name'          => esc_html__('Button Text Hover', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'id'            => 'standard_button_border_hover',
                        'name'          => esc_html__('Button Border Hover', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'id'            => 'standard_button_background_hover',
                        'name'          => esc_html__('Button Background Hover', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    //-- Contrast Colors
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Contrast Colors', 'agrarium'),
                    ),

                    array(
                        'id'            => 'contrast_default_text_color',
                        'name'          => esc_html__('Default Text Color', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'id'            => 'contrast_dark_text_color',
                        'name'          => esc_html__('Dark Text Color', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'id'            => 'contrast_light_text_color',
                        'name'          => esc_html__('Light Text Color', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'id'            => 'contrast_accent_text_color',
                        'name'          => esc_html__('Accent Text Color', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    array(
                        'id'            => 'contrast_border_color',
                        'name'          => esc_html__('Border Color', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'id'            => 'contrast_border_hover_color',
                        'name'          => esc_html__('Hovered Border Color', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    array(
                        'id'            => 'contrast_background_color',
                        'name'          => esc_html__('Background Color', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'id'            => 'contrast_background_alter_color',
                        'name'          => esc_html__('Alternative Background Color', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    array(
                        'id'            => 'contrast_button_text_color',
                        'name'          => esc_html__('Button Text Color', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'id'            => 'contrast_button_border_color',
                        'name'          => esc_html__('Button Border Color', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'id'            => 'contrast_button_background_color',
                        'name'          => esc_html__('Button Background Color', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'id'            => 'contrast_button_text_hover',
                        'name'          => esc_html__('Button Text Hover', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'id'            => 'contrast_button_border_hover',
                        'name'          => esc_html__('Button Border Hover', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),

                    array(
                        'id'            => 'contrast_button_background_hover',
                        'name'          => esc_html__('Button Background Hover', 'agrarium'),
                        'type'          => 'color',
                        'std'           => '',
                        'alpha_channel' => true
                    ),
                )
            );

            $meta_boxes[] = array(
                'title'         => esc_html__('Top Bar Settings', 'agrarium'),
                'post_types'    => array('post', 'page', 'agrarium_portfolio', 'agrarium_team_member', 'agrarium_vacancy', 'agrarium_service', 'agrarium_case_study', 'product', 'agrarium_production'),
                'closed'        => true,
                'context'       => 'advanced',
                'fields'        => array(

                # Top Bar Options

                    //-- Top Bar General
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('General', 'agrarium'),
                    ),

                    array(
                        'id'        => 'top_bar_status',
                        'name'      => esc_html__('Show Top Bar', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'        => 'top_bar_customize',
                        'name'      => esc_html__('Customize', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium')
                        )
                    ),

                    array(
                        'id'            => 'top_bar_default_text_color',
                        'name'          => esc_html__('Default Text Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'class'         => 'divider-before',
                        'attributes'    => array(
                            'data-dependency-id'    => 'top_bar_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'top_bar_dark_text_color',
                        'name'          => esc_html__('Dark Text Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'top_bar_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'top_bar_light_text_color',
                        'name'          => esc_html__('Light Text Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'top_bar_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'top_bar_accent_text_color',
                        'name'          => esc_html__('Accent Text Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'top_bar_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'top_bar_border_color',
                        'name'          => esc_html__('Border Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'class'         => 'divider-before',
                        'attributes'    => array(
                            'data-dependency-id'    => 'top_bar_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'top_bar_border_hover_color',
                        'name'          => esc_html__('Hovered Border Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'top_bar_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'top_bar_background_color',
                        'name'          => esc_html__('Background Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'class'         => 'divider-before',
                        'attributes'    => array(
                            'data-dependency-id'    => 'top_bar_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'top_bar_background_alter_color',
                        'name'          => esc_html__('Alternative Background Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'top_bar_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'top_bar_button_text_color',
                        'name'          => esc_html__('Button Text Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'class'         => 'divider-before',
                        'attributes'    => array(
                            'data-dependency-id'    => 'top_bar_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'top_bar_button_border_color',
                        'name'          => esc_html__('Button Border Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'top_bar_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'top_bar_button_background_color',
                        'name'          => esc_html__('Button Background Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'top_bar_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'top_bar_button_text_hover',
                        'name'          => esc_html__('Button Text Hover', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'top_bar_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'top_bar_button_border_hover',
                        'name'          => esc_html__('Button Border Hover', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'top_bar_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'top_bar_button_background_hover',
                        'name'          => esc_html__('Button Background Hover', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'top_bar_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'type' => 'divider',
                    ),
                     //-- Top Bar Menu
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Menu', 'agrarium'),
                    ),

                    array(
                        'id'        => 'top_bar_menu_status',
                        'name'      => esc_html__('Show Menu', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),
                    array(
                        'id'        => 'top_bar_menu_select',
                        'name'      => esc_html__('Select Menu', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => agrarium_get_all_menu_list()
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    //-- Top Bar Social Buttons
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Social Buttons', 'agrarium'),
                    ),

                    array(
                        'id'        => 'top_bar_socials_status',
                        'name'      => esc_html__('Show Social Buttons', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    //-- Top Bar Additional Text
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Additional Text', 'agrarium'),
                    ),

                    array(
                        'id'        => 'top_bar_additional_text_status',
                        'name'      => esc_html__('Show Additional Text', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'            => 'top_bar_additional_text_title',
                        'name'          => esc_html__('Additional Text Title', 'agrarium'),
                        'type'          => 'textarea',
                        'placeholder'   => agrarium_get_theme_mod('top_bar_additional_text_title'),
                        'std'           => '',
                        'attributes'    => array(
                            'data-dependency-id'    => 'top_bar_additional_text_status',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'top_bar_additional_text',
                        'name'          => esc_html__('Additional Text', 'agrarium'),
                        'type'          => 'textarea',
                        'placeholder'   => agrarium_get_theme_mod('top_bar_additional_text'),
                        'std'           => '',
                        'attributes'    => array(
                            'data-dependency-id'    => 'top_bar_additional_text_status',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    //-- Top Bar Contacts
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Contacts', 'agrarium'),
                    ),

                    array(
                        'id'        => 'top_bar_contacts_email_status',
                        'name'      => esc_html__('Show Email Address', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'            => 'top_bar_contacts_email_title',
                        'name'          => esc_html__('Email Title', 'agrarium'),
                        'type'          => 'text',
                        'placeholder'   => agrarium_get_theme_mod('top_bar_contacts_email_title'),
                        'std'           => '',
                        'attributes'    => array(
                            'data-dependency-id'    => 'top_bar_contacts_email_status',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'top_bar_contacts_email',
                        'name'          => esc_html__('Email Address', 'agrarium'),
                        'type'          => 'text',
                        'placeholder'   => agrarium_get_theme_mod('top_bar_contacts_email'),
                        'std'           => '',
                        'attributes'    => array(
                            'data-dependency-id'    => 'top_bar_contacts_email_status',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'        => 'top_bar_contacts_phone_status',
                        'name'      => esc_html__('Show Phone Number', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),
                    
                    array(
                        'id'            => 'top_bar_contacts_phone_title',
                        'name'          => esc_html__('Phone Title', 'agrarium'),
                        'type'          => 'text',
                        'placeholder'   => agrarium_get_theme_mod('top_bar_contacts_phone_title'),
                        'std'           => '',
                        'attributes'    => array(
                            'data-dependency-id'    => 'top_bar_contacts_phone_status',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'top_bar_contacts_phone',
                        'name'          => esc_html__('Phone Number', 'agrarium'),
                        'type'          => 'text',
                        'placeholder'   => agrarium_get_theme_mod('top_bar_contacts_phone'),
                        'std'           => '',
                        'attributes'    => array(
                            'data-dependency-id'    => 'top_bar_contacts_phone_status',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'        => 'top_bar_contacts_address_status',
                        'name'      => esc_html__('Show Address', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'            => 'top_bar_contacts_address_title',
                        'name'          => esc_html__('Address Title', 'agrarium'),
                        'type'          => 'text',
                        'placeholder'   => agrarium_get_theme_mod('top_bar_contacts_address_title'),
                        'std'           => '',
                        'attributes'    => array(
                            'data-dependency-id'    => 'top_bar_contacts_address_status',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'top_bar_contacts_address',
                        'name'          => esc_html__('Address', 'agrarium'),
                        'type'          => 'text',
                        'placeholder'   => agrarium_get_theme_mod('top_bar_contacts_address'),
                        'std'           => '',
                        'attributes'    => array(
                            'data-dependency-id'    => 'top_bar_contacts_address_status',
                            'data-dependency-val'   => 'on'
                        )
                    )

                )
            );

            $meta_boxes[] = array(
                'title'         => esc_html__('Header Settings', 'agrarium'),
                'post_types'    => array('post', 'page', 'agrarium_portfolio', 'agrarium_team_member', 'agrarium_vacancy', 'agrarium_service', 'agrarium_case_study', 'product', 'agrarium_production'),
                'closed'        => true,
                'context'       => 'advanced',
                'fields'        => array(

                # Header Options

                    //-- Header General
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('General', 'agrarium'),
                    ),

                    array(
                        'id'        => 'header_status',
                        'name'      => esc_html__('Show Header', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'        => 'header_style',
                        'name'      => esc_html__('Header Style', 'agrarium'),
                        'type'      => 'select',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'type-1'    => esc_html__('Style 1', 'agrarium'),
                            'type-2'    => esc_html__('Style 2', 'agrarium'),
                            'type-3'    => esc_html__('Style 3', 'agrarium')
                        )
                    ),

                    array(
                        'id'        => 'header_position',
                        'name'      => esc_html__('Header Position', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'above'     => esc_html__('Above', 'agrarium'),
                            'over'      => esc_html__('Over', 'agrarium')
                        )
                    ),

                    array(
                        'id'        => 'header_phone_status',
                        'name'      => esc_html__('Show Header Phone', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'off'     => esc_html__('No', 'agrarium'),
                            'on'      => esc_html__('Yes', 'agrarium')
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'header_style',
                            'data-dependency-val'   => 'type-3'
                        )
                    ),
                    array(
                        'id'        => 'header_phone_title',
                        'name'      => esc_html__('Header Phone Title', 'agrarium'),
                        'placeholder' => agrarium_get_theme_mod('header_phone_title'),
                        'type'      => 'text',
                        'std'       => '',
                        'attributes'    => array(
                            'data-dependency-id'    => 'header_style',
                            'data-dependency-val'   => 'type-3',
                        )
                    ),
                    array(
                        'id'        => 'header_phone_number',
                        'name'      => esc_html__('Header Phone Number', 'agrarium'),
                        'placeholder' => agrarium_get_theme_mod('header_phone_number'),
                        'type'      => 'text',
                        'std'       => '',
                        'attributes'    => array(
                            'data-dependency-id'    => 'header_style',
                            'data-dependency-val'   => 'type-3',
                        )
                    ),
                    array(
                        'id'            => 'header_overlay_status',
                        'name'          => esc_html__('Show Header Overlay', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'off'     => esc_html__('No', 'agrarium'),
                            'on'      => esc_html__('Yes', 'agrarium')
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'header_style',
                            'data-dependency-val'   => 'type-3'
                        )
                    ),

                    array(
                        'id'        => 'header_customize',
                        'name'      => esc_html__('Customize', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium')
                        )
                    ),
                    
                    array(
                        'id'            => 'header_logo_bg_color',
                        'name'          => esc_html__('Logo Background Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'class'         => 'divider-before',
                        'attributes'    => array(
                            'data-dependency-id'    => 'header_style',
                            'data-dependency-val'   => 'type-3'
                        )
                    ),

                    array(
                        'id'            => 'header_default_text_color',
                        'name'          => esc_html__('Default Text Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'class'         => 'divider-before',
                        'attributes'    => array(
                            'data-dependency-id'    => 'header_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'header_dark_text_color',
                        'name'          => esc_html__('Dark Text Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'header_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'header_light_text_color',
                        'name'          => esc_html__('Light Text Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'header_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'header_accent_text_color',
                        'name'          => esc_html__('Accent Text Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'header_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'header_border_color',
                        'name'          => esc_html__('Border Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'class'         => 'divider-before',
                        'attributes'    => array(
                            'data-dependency-id'    => 'header_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'header_border_hover_color',
                        'name'          => esc_html__('Hovered Border Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'header_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'header_background_color',
                        'name'          => esc_html__('Background Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'class'         => 'divider-before',
                        'attributes'    => array(
                            'data-dependency-id'    => 'header_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'header_background_alter_color',
                        'name'          => esc_html__('Alternative Background Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'header_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'header_button_text_color',
                        'name'          => esc_html__('Button Text Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'class'         => 'divider-before',
                        'attributes'    => array(
                            'data-dependency-id'    => 'header_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'header_button_border_color',
                        'name'          => esc_html__('Button Border Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'header_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'header_button_background_color',
                        'name'          => esc_html__('Button Background Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'header_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'header_button_text_hover',
                        'name'          => esc_html__('Button Text Hover', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'header_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'header_button_border_hover',
                        'name'          => esc_html__('Button Border Hover', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'header_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'header_button_background_hover',
                        'name'          => esc_html__('Button Background Hover', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'header_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),                    

                    array(
                        'type' => 'divider',
                    ),

                    //-- Sticky Header
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Sticky Header', 'agrarium'),
                    ),

                    array(
                        'id'        => 'sticky_header_status',
                        'name'      => esc_html__('Show Sticky Header', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    //-- Header Logo
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Logo', 'agrarium'),
                    ),

                    array(
                        'id'        => 'header_logo_status',
                        'name'      => esc_html__('Show Header Logo', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'        => 'header_logo_customize',
                        'name'      => esc_html__('Customize', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium')
                        )
                    ),

                    array(
                        'id'                => 'header_logo_image',
                        'name'              => esc_html__('Logo Image', 'agrarium'),
                        'type'              => 'image_advanced',
                        'max_file_uploads'  => 1,
                        'max_status'        => false,
                        'size'              => 'full',
                        'attributes'        => array(
                            'data-dependency-id'    => 'header_logo_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'header_logo_retina',
                        'name'          => esc_html__('Logo Retina', 'agrarium'),
                        'type'          => 'checkbox',
                        'std'           => 1,
                        'attributes'    => array(
                            'data-dependency-id'    => 'header_logo_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'                => 'header_logo_mobile_image',
                        'name'              => esc_html__('Mobile Logo Image', 'agrarium'),
                        'type'              => 'image_advanced',
                        'max_file_uploads'  => 1,
                        'max_status'        => false,
                        'size'              => 'full',
                        'attributes'        => array(
                            'data-dependency-id'    => 'header_logo_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'header_logo_mobile_retina',
                        'name'          => esc_html__('Mobile Logo Retina', 'agrarium'),
                        'type'          => 'checkbox',
                        'std'           => 1,
                        'attributes'    => array(
                            'data-dependency-id'    => 'header_logo_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    //-- Header Button
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Header Button', 'agrarium'),
                    ),

                    array(
                        'id'        => 'header_button_status',
                        'name'      => esc_html__('Show Header Button', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'            => 'header_button_text',
                        'name'          => esc_html__('Header Button Text', 'agrarium'),
                        'type'          => 'text',
                        'placeholder'   => agrarium_get_theme_mod('header_button_text'),
                        'std'           => ''
                    ),

                    array(
                        'id'            => 'header_button_url',
                        'name'          => esc_html__('Header Button Link', 'agrarium'),
                        'type'          => 'text',
                        'placeholder'   => agrarium_get_theme_mod('header_button_url'),
                        'std'           => ''
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    //-- Header Menu
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Header Menu', 'agrarium'),
                    ),

                    array(
                        'id'        => 'header_menu_status',
                        'name'      => esc_html__('Show Main Menu', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'        => 'header_menu_select',
                        'name'      => esc_html__('Select Menu', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => agrarium_get_all_menu_list()
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    //-- Header Side Panel
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Header Icons', 'agrarium'),
                    ),

                    array(
                        'id'        => 'side_panel_status',
                        'name'      => esc_html__('Show side panel trigger', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),
                    array(
                        'id'        => 'side_panel_on_mobile_status',
                        'name'      => esc_html__('Show side panel trigger on mobile', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),                    

                    array(
                        'id'        => 'header_search_status',
                        'name'      => esc_html__('Show search icon', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'            => 'header_minicart_status',
                        'name'          => esc_html__('Show product cart', 'agrarium'),
                        'type'          => 'select',
                        'std'           => 'default',
                        'options'       => array(
                            'default'       => esc_html__('Default', 'agrarium'),
                            'on'            => esc_html__('Yes', 'agrarium'),
                            'off'           => esc_html__('No', 'agrarium')
                        ),
                    ),
                ),
            );

            $meta_boxes[] = array(
                'title'         => esc_html__('Page Title Settings', 'agrarium'),
                'post_types'    => array('post', 'page', 'agrarium_portfolio', 'agrarium_team_member', 'agrarium_vacancy', 'agrarium_service', 'agrarium_case_study', 'product', 'agrarium_production'),
                'closed'        => true,
                'context'       => 'advanced',
                'fields'        => array(

                    # Page Title Options

                    //-- Page Title General
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('General', 'agrarium'),
                    ),

                    array(
                        'id'        => 'page_title_status',
                        'name'      => esc_html__('Show Page Title', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'        => 'page_title_overlay_status',
                        'name'      => esc_html__('Show overlay', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium')
                        )
                    ),
                    array(
                        'id'        => 'page_title_bottom_overlay_status',
                        'name'      => esc_html__('Show bottom overlay', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium')
                        )
                    ),

                    array(
                        'id'            => 'page_title_overlay_color',
                        'name'          => esc_html__('Overlay Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'page_title_overlay_status',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'        => 'page_title_image_decoration_status',
                        'name'      => esc_html__('Show image decoration', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium')
                        )
                    ),

                    array(
                        'id'                => 'page_title_decoration_image',
                        'name'              => esc_html__('Decoration Image', 'agrarium'),
                        'type'              => 'image_advanced',
                        'max_file_uploads'  => 1,
                        'max_status'        => false,
                        'size'              => 'full',
                        'class'             => 'divider-before',
                        'attributes'        => array(
                            'data-dependency-id'    => 'page_title_image_decoration_status',
                            'data-dependency-val'   => 'on'
                        )
                    ),
                    
                    array(
                        'id'        => 'page_title_customize',
                        'name'      => esc_html__('Customize', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'class'     => 'divider-before',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium')
                        )
                    ),

                    array(
                        'id'            => 'page_title_height',
                        'name'          => esc_html__('Page Title Height', 'agrarium'),
                        'type'          => 'number',
                        'placeholder'   => agrarium_get_theme_mod('page_title_height'),
                        'std'           => '',
                        'attributes'    => array(
                            'data-dependency-id'    => 'page_title_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'page_title_default_text_color',
                        'name'          => esc_html__('Default Text Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'class'         => 'divider-before',
                        'attributes'    => array(
                            'data-dependency-id'    => 'page_title_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'page_title_dark_text_color',
                        'name'          => esc_html__('Dark Text Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'page_title_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'page_title_light_text_color',
                        'name'          => esc_html__('Light Text Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'page_title_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'page_title_accent_text_color',
                        'name'          => esc_html__('Accent Text Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'page_title_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'page_title_border_color',
                        'name'          => esc_html__('Border Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'class'         => 'divider-before',
                        'attributes'    => array(
                            'data-dependency-id'    => 'page_title_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'page_title_border_hover_color',
                        'name'          => esc_html__('Hovered Border Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'page_title_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'page_title_background_color',
                        'name'          => esc_html__('Background Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'class'         => 'divider-before',
                        'attributes'    => array(
                            'data-dependency-id'    => 'page_title_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'page_title_background_alter_color',
                        'name'          => esc_html__('Alternative Background Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'page_title_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'page_title_button_text_color',
                        'name'          => esc_html__('Button Text Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'class'         => 'divider-before',
                        'attributes'    => array(
                            'data-dependency-id'    => 'page_title_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'page_title_button_border_color',
                        'name'          => esc_html__('Button Border Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'page_title_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'page_title_button_background_color',
                        'name'          => esc_html__('Button Background Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'page_title_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'page_title_button_text_hover',
                        'name'          => esc_html__('Button Text Hover', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'page_title_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'page_title_button_border_hover',
                        'name'          => esc_html__('Button Border Hover', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'page_title_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'page_title_button_background_hover',
                        'name'          => esc_html__('Button Background Hover', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'page_title_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'                => 'page_title_background_image',
                        'name'              => esc_html__('Background Image', 'agrarium'),
                        'type'              => 'image_advanced',
                        'max_file_uploads'  => 1,
                        'max_status'        => false,
                        'size'              => 'full',
                        'class'             => 'divider-before',
                        'attributes'        => array(
                            'data-dependency-id'    => 'page_title_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'page_title_background_position',
                        'name'          => esc_html__('Background Position', 'agrarium'),
                        'type'          => 'select',
                        'std'           => 'default',
                        'options'       => array(
                            'default'       => esc_html__('Default', 'agrarium'),
                            'center center' => esc_html__('Center Center', 'agrarium'),
                            'center left'   => esc_html__('Center Left', 'agrarium'),
                            'center right'  => esc_html__('Center Right', 'agrarium'),
                            'top center'    => esc_html__('Top Center', 'agrarium'),
                            'top left'      => esc_html__('Top Left', 'agrarium'),
                            'top right'     => esc_html__('Top Right', 'agrarium'),
                            'bottom center' => esc_html__('Bottom Center', 'agrarium'),
                            'bottom left'   => esc_html__('Bottom Left', 'agrarium'),
                            'bottom right'  => esc_html__('Bottom Right', 'agrarium')
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'page_title_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'page_title_background_repeat',
                        'name'          => esc_html__('Background Repeat', 'agrarium'),
                        'type'          => 'select',
                        'std'           => 'default',
                        'options'       => array(
                            'default'       => esc_html__('Default', 'agrarium'),
                            'no-repeat'     => esc_html__('No-repeat', 'agrarium'),
                            'repeat'        => esc_html__('Repeat', 'agrarium'),
                            'repeat-x'      => esc_html__('Repeat-x', 'agrarium'),
                            'repeat-y'      => esc_html__('Repeat-y', 'agrarium')
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'page_title_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'page_title_background_size',
                        'name'          => esc_html__('Background Size', 'agrarium'),
                        'type'          => 'select',
                        'std'           => 'default',
                        'options'       => array(
                            'default'       => esc_html__('Default', 'agrarium'),
                            'initial'       => esc_html__('Initial', 'agrarium'),
                            'auto'          => esc_html__('Auto', 'agrarium'),
                            'cover'         => esc_html__('Cover', 'agrarium'),
                            'contain'       => esc_html__('Contain', 'agrarium'),
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'page_title_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    //-- Page Title Breadcrumbs
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Page Title Breadcrumbs', 'agrarium'),
                    ),

                    array(
                        'id'        => 'page_title_breadcrumbs_status',
                        'name'      => esc_html__('Show Page Title Breadcrumbs', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Show', 'agrarium'),
                            'off'       => esc_html__('Hide', 'agrarium')
                        )
                    ),



                    //-- Page Title Additional Text
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Page Title Additional Text', 'agrarium'),
                    ),
                    array(
                        'id'        => 'page_title_additional_text_status',
                        'name'      => esc_html__('Show Additional Text', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium')
                        )
                    ),

                    array(
                        'id'            => 'page_title_additional_text',
                        'name'          => esc_html__('Additional Text', 'agrarium'),
                        'type'          => 'text',
                        'placeholder'   => agrarium_get_theme_mod('page_title_additional_text'),
                        'std'           => '',
                        'attributes'    => array(
                            'data-dependency-id'    => 'page_title_additional_text_status',
                            'data-dependency-val'   => 'on'
                        )
                    ),
                    array(
                        'id'            => 'page_title_additional_text_color',
                        'name'          => esc_html__('Text Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'page_title_additional_text_status',
                            'data-dependency-val'   => 'on'
                        )
                    ),
                    array(
                        'id'            => 'page_title_additional_text_right_position',
                        'name'          => esc_html__('Text Right Offset, %', 'agrarium'),
                        'type'          => 'number',
                        'min'           => 0,
                        'max'           => 50,
                        'step'          => 0.5,
                        'std'           => 14.5,
                        'size'          => 20,
                        'attributes'    => array(
                            'data-dependency-id'    => 'page_title_additional_text_status',
                            'data-dependency-val'   => 'on'
                        )
                    ),
                    array(
                        'id'            => 'page_title_additional_text_bottom_position',
                        'name'          => esc_html__('Text Bottom Offset, px', 'agrarium'),
                        'type'          => 'number',
                        'min'           => -200,
                        'max'           => 200,
                        'step'          => 1,
                        'std'           => -25,
                        'size'          => 20,
                        'attributes'    => array(
                            'data-dependency-id'    => 'page_title_additional_text_status',
                            'data-dependency-val'   => 'on'
                        )
                    )
                )
            );

            // Layout Settings
            $meta_boxes[] = array(
                'title'         => esc_html__('Layout Settings', 'agrarium'),
                'post_types'    => array('page'),
                'context'       => 'advanced',
                'closed'        => true,
                'fields'        => array(

                    //-- Content Margin
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Content Margin', 'agrarium'),
                    ),
                    array(
                        'id'        => 'content_top_margin',
                        'name'      => esc_html__('Remove Top Margin', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'off',
                        'options'   => array(
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'        => 'content_bottom_margin',
                        'name'      => esc_html__('Remove Bottom Margin', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'off',
                        'options'   => array(
                            'off'       => esc_html__('No', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium')
                        )
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    //-- Sidebar Options
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Sidebar', 'agrarium'),
                    ),

                    array(
                        'id'        => 'sidebar_position',
                        'name'      => esc_html__('Sidebar Position', 'agrarium'),
                        'type'      => 'select',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'left'      => esc_html__('Left', 'agrarium'),
                            'right'     => esc_html__('Right', 'agrarium'),
                            'none'      => esc_html__('None', 'agrarium')
                        )
                    ),

                    array(
                        'id'            => 'page_sidebar_select',
                        'name'          => esc_html__('Select Sidebar', 'agrarium'),
                        'type'          => 'select',
                        'std'           => 'default',
                        'options'       => $sidebar_list
                    ),
                )
            );

            // Layout Settings
            $meta_boxes[] = array(
                'title'         => esc_html__('Layout Settings', 'agrarium'),
                'post_types'    => array('agrarium_service'),
                'context'       => 'advanced',
                'closed'        => true,
                'fields'        => array(

                    //-- Content Margin
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Content Margin', 'agrarium'),
                    ),
                    array(
                        'id'        => 'content_top_margin',
                        'name'      => esc_html__('Remove Top Margin', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'off',
                        'options'   => array(
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'        => 'content_bottom_margin',
                        'name'      => esc_html__('Remove Bottom Margin', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'off',
                        'options'   => array(
                            'off'       => esc_html__('No', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium')
                        )
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    //-- Sidebar Options
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Sidebar', 'agrarium'),
                    ),

                    array(
                        'id'        => 'service_sidebar_position',
                        'name'      => esc_html__('Sidebar Position', 'agrarium'),
                        'type'      => 'select',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'left'      => esc_html__('Left', 'agrarium'),
                            'right'     => esc_html__('Right', 'agrarium'),
                            'none'      => esc_html__('None', 'agrarium')
                        )
                    ),

                    array(
                        'id'            => 'service_sidebar_select',
                        'name'          => esc_html__('Select Sidebar', 'agrarium'),
                        'type'          => 'select',
                        'std'           => 'default',
                        'options'       => $sidebar_list
                    ),
                )
            );

            // Layout Settings
            $meta_boxes[] = array(
                'title'         => esc_html__('Layout Settings', 'agrarium'),
                'post_types'    => array('post'),
                'context'       => 'advanced',
                'closed'        => true,
                'fields'        => array(

                    //-- Content Margin
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Content Margin', 'agrarium'),
                    ),
                    array(
                        'id'        => 'content_top_margin',
                        'name'      => esc_html__('Remove Top Margin', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'off',
                        'options'   => array(
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'        => 'content_bottom_margin',
                        'name'      => esc_html__('Remove Bottom Margin', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'off',
                        'options'   => array(
                            'off'       => esc_html__('No', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium')
                        )
                    ),
                    //-- Sidebar Options
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Sidebar', 'agrarium'),
                    ),

                    array(
                        'id'        => 'post_sidebar_position',
                        'name'      => esc_html__('Sidebar Position', 'agrarium'),
                        'type'      => 'select',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'left'      => esc_html__('Left', 'agrarium'),
                            'right'     => esc_html__('Right', 'agrarium'),
                            'none'      => esc_html__('None', 'agrarium')
                        )
                    ),

                    array(
                        'id'            => 'post_sidebar_select',
                        'name'          => esc_html__('Select Sidebar', 'agrarium'),
                        'type'          => 'select',
                        'std'           => 'default',
                        'options'       => $sidebar_list
                    ),
                )
            );
            // Layout Settings
            $meta_boxes[] = array(
                'title'         => esc_html__('Layout Settings', 'agrarium'),
                'post_types'    => array('agrarium_production'),
                'context'       => 'advanced',
                'closed'        => true,
                'fields'        => array(

                    //-- Content Margin
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Content Margin', 'agrarium'),
                    ),
                    array(
                        'id'        => 'content_top_margin',
                        'name'      => esc_html__('Remove Top Margin', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'off',
                        'options'   => array(
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'        => 'content_bottom_margin',
                        'name'      => esc_html__('Remove Bottom Margin', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'off',
                        'options'   => array(
                            'off'       => esc_html__('No', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium')
                        )
                    )
                )
            );

            // Layout Settings Portfolio
            $meta_boxes[] = array(
                'title'         => esc_html__('Layout Settings', 'agrarium'),
                'post_types'    => array('agrarium_portfolio'),
                'context'       => 'advanced',
                'closed'        => true,
                'fields'        => array(

                    //-- Content Margin
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Content Margin', 'agrarium'),
                    ),
                    array(
                        'id'        => 'content_top_margin',
                        'name'      => esc_html__('Remove Top Margin', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'off',
                        'options'   => array(
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'        => 'content_bottom_margin',
                        'name'      => esc_html__('Remove Bottom Margin', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'off',
                        'options'   => array(
                            'off'       => esc_html__('No', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium')
                        )
                    )
                )
            );

            $meta_boxes[] = array(
                'title'         => esc_html__('Bottom Section Settings', 'agrarium'),
                'post_types'    => array('post', 'page', 'agrarium_portfolio', 'agrarium_team_member', 'agrarium_vacancy', 'agrarium_service', 'agrarium_case_study', 'product', 'agrarium_production'),
                'closed'        => true,
                'context'       => 'advanced',
                'fields'        => array(
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Bottom Background Section', 'agrarium'),
                    ),
                    array(
                        'id'        => 'bottom_section_background_status',
                        'name'      => esc_html__('Show Bottom Background', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),
                    array(
                        'id'            => 'bottom_section_background_height',
                        'name'          => esc_html__('Bottom Background Section Height, px', 'agrarium'),
                        'type'          => 'number',
                        'placeholder'   => agrarium_get_theme_mod('bottom_section_background_height'),
                        'std'           => agrarium_get_theme_mod('bottom_section_background_height'),
                        'attributes'    => array(
                            'data-dependency-id'    => 'bottom_section_background_status',
                            'data-dependency-val'   => 'on'
                        )
                    ),
                    array(
                        'id'            => 'bottom_section_background_margin_top',
                        'name'          => esc_html__('Bottom Background Section margin top, px', 'agrarium'),
                        'type'          => 'number',
                        'min'           => -500,
                        'max'           => 500,
                        'step'          => 1,
                        'placeholder'   => agrarium_get_theme_mod('bottom_section_background_margin_top'),
                        'std'           => '',
                        'attributes'    => array(
                            'data-dependency-id'    => 'bottom_section_background_status',
                            'data-dependency-val'   => 'on'
                        )
                    ),
                    array(
                        'id'                => 'bottom_section_background_image',
                        'name'              => esc_html__('Background Image', 'agrarium'),
                        'type'              => 'image_advanced',
                        'max_file_uploads'  => 1,
                        'max_status'        => false,
                        'size'              => 'full',
                        'class'             => 'divider-before',
                        'attributes'        => array(
                            'data-dependency-id'    => 'bottom_section_background_status',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'bottom_section_background_position',
                        'name'          => esc_html__('Background Position', 'agrarium'),
                        'type'          => 'select',
                        'std'           => 'default',
                        'options'       => array(
                            'default'       => esc_html__('Default', 'agrarium'),
                            'center center' => esc_html__('Center Center', 'agrarium'),
                            'center left'   => esc_html__('Center Left', 'agrarium'),
                            'center right'  => esc_html__('Center Right', 'agrarium'),
                            'top center'    => esc_html__('Top Center', 'agrarium'),
                            'top left'      => esc_html__('Top Left', 'agrarium'),
                            'top right'     => esc_html__('Top Right', 'agrarium'),
                            'bottom center' => esc_html__('Bottom Center', 'agrarium'),
                            'bottom left'   => esc_html__('Bottom Left', 'agrarium'),
                            'bottom right'  => esc_html__('Bottom Right', 'agrarium')
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'bottom_section_background_status',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'bottom_section_background_repeat',
                        'name'          => esc_html__('Background Repeat', 'agrarium'),
                        'type'          => 'select',
                        'std'           => 'default',
                        'options'       => array(
                            'default'       => esc_html__('Default', 'agrarium'),
                            'no-repeat'     => esc_html__('No-repeat', 'agrarium'),
                            'repeat'        => esc_html__('Repeat', 'agrarium'),
                            'repeat-x'      => esc_html__('Repeat-x', 'agrarium'),
                            'repeat-y'      => esc_html__('Repeat-y', 'agrarium')
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'bottom_section_background_status',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'bottom_section_background_size',
                        'name'          => esc_html__('Background Size', 'agrarium'),
                        'type'          => 'select',
                        'std'           => 'default',
                        'options'       => array(
                            'default'       => esc_html__('Default', 'agrarium'),
                            'initial'       => esc_html__('Initial', 'agrarium'),
                            'auto'          => esc_html__('Auto', 'agrarium'),
                            'cover'         => esc_html__('Cover', 'agrarium'),
                            'contain'       => esc_html__('Contain', 'agrarium'),
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'bottom_section_background_status',
                            'data-dependency-val'   => 'on'
                        )
                    ),
                    array(
                        'id'        => 'hide_bottom_section_background_mobile',
                        'name'      => esc_html__('Hide Bottom Background Section on Mobile', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'off', 
                        'options'   => array(
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'bottom_section_background_status',
                            'data-dependency-val'   => 'on'
                        )
                    ),
                )
            );

            $meta_boxes[] = array(
                'title'         => esc_html__('Footer Settings', 'agrarium'),
                'post_types'    => array('post', 'page', 'agrarium_portfolio', 'agrarium_team_member', 'agrarium_vacancy', 'agrarium_service', 'agrarium_case_study', 'product', 'agrarium_production'),
                'closed'        => true,
                'context'       => 'advanced',
                'fields'        => array(

                    # Footer Options

                    //-- Footer General
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('General', 'agrarium'),
                    ),

                    array(
                        'id'        => 'footer_status',
                        'name'      => esc_html__('Show Footer', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'        => 'footer_style',
                        'name'      => esc_html__('Footer Style', 'agrarium'),
                        'type'      => 'select',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'type-1'    => esc_html__('Style 1', 'agrarium'),
                            'type-2'    => esc_html__('Style 2', 'agrarium'),
                            'type-3'    => esc_html__('Style 3', 'agrarium')
                        )
                    ),

                    array(
                        'id'        => 'footer_customize',
                        'name'      => esc_html__('Customize', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium')
                        )
                    ),

                    array(
                        'id'            => 'footer_default_text_color',
                        'name'          => esc_html__('Default Text Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'class'         => 'divider-before',
                        'attributes'    => array(
                            'data-dependency-id'    => 'footer_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'footer_dark_text_color',
                        'name'          => esc_html__('Dark Text Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'footer_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'footer_light_text_color',
                        'name'          => esc_html__('Light Text Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'footer_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'footer_accent_text_color',
                        'name'          => esc_html__('Accent Text Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'footer_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'footer_border_color',
                        'name'          => esc_html__('Border Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'class'         => 'divider-before',
                        'attributes'    => array(
                            'data-dependency-id'    => 'footer_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'footer_border_hover_color',
                        'name'          => esc_html__('Hovered Border Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'footer_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'footer_background_color',
                        'name'          => esc_html__('Background Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'class'         => 'divider-before',
                        'attributes'    => array(
                            'data-dependency-id'    => 'footer_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'footer_background_alter_color',
                        'name'          => esc_html__('Alternative Background Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'footer_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'footer_button_text_color',
                        'name'          => esc_html__('Button Text Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'class'         => 'divider-before',
                        'attributes'    => array(
                            'data-dependency-id'    => 'footer_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'footer_button_border_color',
                        'name'          => esc_html__('Button Border Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'footer_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'footer_button_background_color',
                        'name'          => esc_html__('Button Background Color', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'footer_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'footer_button_text_hover',
                        'name'          => esc_html__('Button Text Hover', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'footer_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'footer_button_border_hover',
                        'name'          => esc_html__('Button Border Hover', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'footer_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'footer_button_background_hover',
                        'name'          => esc_html__('Button Background Hover', 'agrarium'),
                        'type'          => 'color',
                        'alpha_channel' => true,
                        'attributes'    => array(
                            'data-dependency-id'    => 'footer_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'                => 'footer_background_image',
                        'name'              => esc_html__('Background Image', 'agrarium'),
                        'type'              => 'image_advanced',
                        'max_file_uploads'  => 1,
                        'max_status'        => false,
                        'attributes'        => array(
                            'data-dependency-id'    => 'footer_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'footer_background_position',
                        'name'          => esc_html__('Background Position', 'agrarium'),
                        'type'          => 'select',
                        'std'           => 'default',
                        'options'       => array(
                            'default'       => esc_html__('Default', 'agrarium'),
                            'center center' => esc_html__('Center Center', 'agrarium'),
                            'center left'   => esc_html__('Center Left', 'agrarium'),
                            'center right'  => esc_html__('Center Right', 'agrarium'),
                            'top center'    => esc_html__('Top Center', 'agrarium'),
                            'top left'      => esc_html__('Top Left', 'agrarium'),
                            'top right'     => esc_html__('Top Right', 'agrarium'),
                            'bottom center' => esc_html__('Bottom Center', 'agrarium'),
                            'bottom left'   => esc_html__('Bottom Left', 'agrarium'),
                            'bottom right'  => esc_html__('Bottom Right', 'agrarium')
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'footer_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'footer_background_repeat',
                        'name'          => esc_html__('Background Repeat', 'agrarium'),
                        'type'          => 'select',
                        'std'           => 'default',
                        'options'       => array(
                            'default'       => esc_html__('Default', 'agrarium'),
                            'no-repeat'     => esc_html__('No-repeat', 'agrarium'),
                            'repeat'        => esc_html__('Repeat', 'agrarium'),
                            'repeat-x'      => esc_html__('Repeat-x', 'agrarium'),
                            'repeat-y'      => esc_html__('Repeat-y', 'agrarium')
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'footer_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'id'            => 'footer_background_size',
                        'name'          => esc_html__('Background Size', 'agrarium'),
                        'type'          => 'select',
                        'std'           => 'default',
                        'options'       => array(
                            'default'       => esc_html__('Default', 'agrarium'),
                            'initial'       => esc_html__('Initial', 'agrarium'),
                            'auto'          => esc_html__('Auto', 'agrarium'),
                            'cover'         => esc_html__('Cover', 'agrarium'),
                            'contain'       => esc_html__('Contain', 'agrarium'),
                        ),
                        'attributes'    => array(
                            'data-dependency-id'    => 'footer_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    array(
                        'id'            => 'footer_height',
                        'name'          => esc_html__('Footer Height On Desktop, px', 'agrarium'),
                        'type'          => 'number',
                        'placeholder'   => '',
                        'std'           => '',
                        'attributes'    => array(
                            'data-dependency-id'    => 'footer_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),
                    array(
                        'id'            => 'footer_height_tablet',
                        'name'          => esc_html__('Footer Height On Tablet, px', 'agrarium'),
                        'type'          => 'number',
                        'placeholder'   => '',
                        'std'           => '',
                        'attributes'    => array(
                            'data-dependency-id'    => 'footer_customize',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    //-- Footer Widgets
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Footer Widgets', 'agrarium'),
                    ),
                    array(
                        'id'        => 'footer_sidebar_top_status',
                        'name'      => esc_html__('Show Top Footer Widgets', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'            => 'footer_sidebar_top_select',
                        'name'          => esc_html__('Select Top Sidebar', 'agrarium'),
                        'type'          => 'select',
                        'std'           => 'default',
                        'options'       => $sidebar_list,
                        'attributes'    => array(
                            'data-dependency-id'    => 'footer_sidebar_top_status',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    array(
                        'id'        => 'footer_sidebar_status',
                        'name'      => esc_html__('Show Footer Widgets', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'            => 'footer_sidebar_select',
                        'name'          => esc_html__('Select Sidebar', 'agrarium'),
                        'type'          => 'select',
                        'std'           => 'default',
                        'options'       => $sidebar_list,
                        'attributes'    => array(
                            'data-dependency-id'    => 'footer_sidebar_status',
                            'data-dependency-val'   => 'on'
                        )
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    //-- Copyright
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Copyright', 'agrarium'),
                    ),

                    array(
                        'id'        => 'footer_copyright_status',
                        'name'      => esc_html__('Show Copyright', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'            => 'footer_copyright_text',
                        'name'          => esc_html__('Copyright Text', 'agrarium'),
                        'type'          => 'text',
                        'placeholder'   => agrarium_get_theme_mod('footer_copyright_text'),
                        'std'           => ''
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    //-- Footer Menu
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Footer Menu', 'agrarium'),
                    ),

                    array(
                        'id'        => 'footer_menu_status',
                        'name'      => esc_html__('Show Footer Menu', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'        => 'footer_menu_select',
                        'name'      => esc_html__('Select Menu', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => agrarium_get_all_menu_list()
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    //-- Footer Additional Menu
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Footer Additional Menu', 'agrarium'),
                    ),

                    array(
                        'id'        => 'footer_additional_menu_status',
                        'name'      => esc_html__('Show Footer Additional Menu', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    ),

                    array(
                        'id'        => 'footer_additional_menu_select',
                        'name'      => esc_html__('Select Menu', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => agrarium_get_all_menu_list()
                    ),

                    array(
                        'type' => 'divider',
                    ),

                    //-- Footer Social Button
                    array(
                        'type'  => 'heading',
                        'name'  => esc_html__('Footer Social Buttons', 'agrarium'),
                    ),

                    array(
                        'id'        => 'footer_socials_status',
                        'name'      => esc_html__('Show social buttons in footer', 'agrarium'),
                        'type'      => 'select',
                        'std'       => 'default',
                        'options'   => array(
                            'default'   => esc_html__('Default', 'agrarium'),
                            'on'        => esc_html__('Yes', 'agrarium'),
                            'off'       => esc_html__('No', 'agrarium')
                        )
                    )
                )                
            );          

            return $meta_boxes;
        }
    }
}