let preprocessor = 'sass';
const {src, dest, parallel, series, watch} = require('gulp');
const browserSync = require('browser-sync').create();
const uglify = require('gulp-uglify-es').default;
const sass = require('gulp-sass');
const less = require('gulp-less');
const autoprefixer = require('gulp-autoprefixer');
const cleancss = require('gulp-clean-css');

function browsersync() {
	browserSync.init({
		proxy: 'http://agrarium.com/',
		notify: false,
		online: true
	});
}

function scripts() {
	return src([
		'app/js/**/*.js',
		'!app/js/**/*.min.js'
	])
	.pipe(uglify())
	.pipe(dest('app/js/'))
	.pipe(browserSync.stream());
}

function styles() {
	if(!preprocessor) {
		return src(['app/css/**/*.css', '!app/css/**/*.min.css'])
		.pipe(autoprefixer({overrideBrowsersList: ['last 10 versions'], grid: true}))
		.pipe(cleancss({level: {1: {specialComments: 0}}}))
		.pipe(dest('app/css/'))
		.pipe(browserSync.stream());
	}
	return src(['scss' + '/theme.{scss, sass}', 'scss' + '/woocommerce.{scss, sass}'])
	.pipe(eval(preprocessor)({outputStyle: 'expanded'}))
	.pipe(autoprefixer({overrideBrowsersList: ['last 10 versions'], grid: true}))
	.pipe(dest('css/'))
	.pipe(browserSync.stream());
}

function startwatch() {
	watch(['app/**/*.js', '!app/**/*.min.js'], scripts);
	if(preprocessor) watch(['scss' +'/**/*.{scss, sass}'], styles);
	else watch(['app/css/**/*.css', '!app/css/**/*.min.css'], styles);
}

exports.browsersync = browsersync;
exports.scripts = scripts;
exports.styles = styles;
exports.default = parallel(styles, browsersync, startwatch); 