<?php
    defined( 'ABSPATH' ) or die();

    $slide_sidebar_classes = 'slide-sidebar-wrapper';
    if ( !empty(agrarium_get_prefered_option('header_style')) ) {
        $slide_sidebar_classes .= ' slide-sidebar-position-' . ( agrarium_get_prefered_option('header_style') == 'type-3' ? 'right' : 'left' );
    }

    $header_classes = 'header';
    if ( !empty(agrarium_get_prefered_option('header_style')) ) {
        $header_classes .= ' header-' . esc_attr(agrarium_get_prefered_option('header_style'));
    }
    if ( !empty(agrarium_get_prefered_option('header_position')) ) {
        $header_classes .= ' header-position-' . esc_attr(agrarium_get_prefered_option('header_position'));
    }
    if ( !empty(agrarium_get_prefered_option('sticky_header_status')) ) {
        $header_classes .= ' sticky-header-' . esc_attr(agrarium_get_prefered_option('sticky_header_status'));
    }
    if( !empty(agrarium_get_prefered_option('header_style')) && 
        agrarium_get_prefered_option('header_style') === 'type-3' &&
        agrarium_get_prefered_option('header_overlay_status') == 'on' ) {
        $header_classes .= ' with_overlay';
    }

    $mobile_classes = 'mobile-header';
    if ( !empty(agrarium_get_prefered_option('header_position')) ) {
        $mobile_classes .= ' mobile-header-position-' . esc_attr(agrarium_get_prefered_option('header_position'));
    }
    if ( !empty(agrarium_get_prefered_option('sticky_header_status')) ) {
        $mobile_classes .= ' sticky-header-' . esc_attr(agrarium_get_prefered_option('sticky_header_status'));
    }
    if ( !empty(agrarium_get_prefered_option('header_style')) ) {
        $mobile_classes .= ' mobile-header-' . esc_attr(agrarium_get_prefered_option('header_style'));
    }
?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
    <head>
        <meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
        <meta http-equiv="X-UA-Compatible" content="IE=Edge">
        <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">
        <?php wp_head(); ?>

        <?php
            add_filter ('wp_head', '', 1);
        ?>
    </head>

    <!-- Body -->
    <body <?php body_class(); ?>>
        <?php if ( function_exists( 'wp_body_open' ) ) {
                wp_body_open();
        } ?>
        <div class="body-overlay"></div>

        <?php if ( agrarium_get_prefered_option('page_loader_status') == 'on' ) { ?>
            <!-- Page Pre Loader -->
            <div class="page-loader-container">
                <div class="page-loader">
                    <div class="page-loader-inner">
                        <?php
                            if ( !empty(agrarium_get_prefered_option('page_loader_image')) ) {
                                $loader_image_metadata = wp_get_attachment_metadata(attachment_url_to_postid(agrarium_get_prefered_option('page_loader_image')));
                                $loader_image_width = (isset($loader_image_metadata['width']) ? $loader_image_metadata['width'] : 0);
                                $loader_image_height = (isset($loader_image_metadata['height']) ? $loader_image_metadata['height'] : 0);
                                $loader_image_url = agrarium_get_theme_mod('page_loader_image');

                                echo '<img width="' . esc_attr($loader_image_width) . '" height="' . esc_attr($loader_image_height) . '" src="' . esc_url($loader_image_url) . '" alt="' . esc_attr__('Page Loader Image', 'agrarium') . '"  class="page-loader-logo" />';
                            } else {
                                echo '<svg 
                                     width="43px" height="52px" class="page-loader-logo">
                                    <image  x="0px" y="0px" width="43px" height="52px"  xlink:href="data:img/png;base64,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" />
                                    </svg>';
                            }
                        ?>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if ( agrarium_get_prefered_option('header_search_status') == 'on' ) { ?>
            <!-- Search Panel -->
            <div class="site-search">
                <div class="site-search-close"></div>
                <?php
                    $search_args = array(
                        'echo'          => true,
                        'aria_label'    => 'global'
                    );
                    get_search_form($search_args);
                ?>
            </div>
        <?php } ?>

        <!-- Mobile Menu Panel -->
        <?php
            get_template_part( 'templates/header/header-mobile-aside' );
        ?>

        <!-- Top Bar -->
        <?php
            if ( agrarium_get_prefered_option('top_bar_status') == 'on' ) {
                get_template_part( 'templates/top-bar/top-bar' );
            }
        ?>

        <div class="body-container">

            <?php
            if ( agrarium_get_prefered_option('side_panel_status') == 'on' && is_active_sidebar('sidebar-side') ) { ?>
                <!-- Side Panel -->
                <div class="<?php echo esc_attr($slide_sidebar_classes); ?>">
                    <div class="slide-sidebar">
                        <div class="slide-sidebar-close"></div>
                        <div class="slide-sidebar-content">
                            <?php dynamic_sidebar('sidebar-side'); ?> 
                        </div>
                    </div>
                </div>
            <?php
            } ?>

            <!-- Mobile Header -->
            <?php
            echo '<div class="' . esc_attr($mobile_classes) . '">';
                echo (agrarium_get_prefered_option('sticky_header_status') == 'on' ? '<div class="sticky-wrapper">' : '');
                    get_template_part( 'templates/header/header-mobile' );
                echo (agrarium_get_prefered_option('sticky_header_status') == 'on' ? '</div>' : '');
            echo '</div>';
            ?>

            <?php
            if ( agrarium_get_prefered_option('header_status') == 'on' ) { ?>
                <!-- Header -->
                <?php
                echo '<header class="' . esc_attr($header_classes) . '">';
                    echo(agrarium_get_prefered_option('sticky_header_status') == 'on' ? '<div class="sticky-wrapper">' : '');
                        switch (agrarium_get_prefered_option('header_style')) {
                            case 'type-2' :
                                get_template_part('templates/header/header-2');
                                break;
                            case 'type-3' :
                                get_template_part('templates/header/header-3');
                                break;
                            default :
                                get_template_part('templates/header/header-1');
                                break;
                        }
                    echo(agrarium_get_prefered_option('sticky_header_status') == 'on' ? '</div>' : '');
                echo '</header>';
            }
            ?>

            <?php
            // Page Title
            if (agrarium_get_prefered_option('page_title_status') == 'on') {
                get_template_part( 'templates/page-title/page-title' );
            }
            ?>