<?php
/**
 * The template for displaying single portfolio item page
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage Agrarium
 * @since Agrarium 1.0
 */

the_post();
get_header();

$sidebar_args = agrarium_get_sidebar_args();
$sidebar_position = $sidebar_args['sidebar_position'];

$content_classes = 'content-wrapper';
$content_classes .= ' content-wrapper-sidebar-position-' . esc_attr($sidebar_position);
$content_classes .= ( agrarium_get_post_option('content_top_margin') == 'on' ? ' content-wrapper-remove-top-margin' : '' );
$content_classes .= ( agrarium_get_post_option('content_bottom_margin') == 'on' ? ' content-wrapper-remove-bottom-margin' : '' );
?>

    <div class="<?php echo esc_attr($content_classes); ?>">

        <!-- Content Container -->
        <div class="content">

            <div id="portfolio-<?php the_ID(); ?>" class="single-portfolio">

                <?php if ( !empty(agrarium_media_gallery_output('portfolio_gallery')) ) {
                    echo '<div class="portfolio-post-gallery">';
                        echo agrarium_media_gallery_output('portfolio_gallery');
                    echo '</div>';
                ?>

                <div class="portfolio-post-content">
                    <?php
                        if ( !empty(agrarium_get_post_option('portfolio_subtitle')) ) {
                            echo '<h3 class="portfolio-post-subtitle">' . agrarium_get_post_option('portfolio_subtitle') . '</h3>';
                        }
                        if ( !empty(get_the_title()) ) {
                            echo '<h2 class="portfolio-post-title">' . get_the_title() . '</h2>';
                        }
                    }
                    ?>

                    <?php the_content(); ?>

                    <div class="portfolio-post-meta">
                        <?php
                            if ( !empty(agrarium_get_post_option('portfolio_feature')) ) {
                                echo '<ul class="portfolio-features">';
                                    $features = agrarium_get_post_option('portfolio_feature');
                                    foreach ($features as $feature) {
                                        echo '<li>' . esc_html($feature) . '</li>';
                                    }
                                echo '</ul>';
                            }
                            if ( !empty(agrarium_get_post_option('portfolio_more_button_show')) &&
                                agrarium_get_post_option('portfolio_more_button_show') == 'on' &&
                                !empty(agrarium_get_post_option('portfolio_more_button_text')) 
                            ) {
                                $text = agrarium_get_post_option('portfolio_more_button_text');
                                $href = agrarium_get_post_option('portfolio_more_button_link');
                                echo '<div class="portfolio-more-button">';
                                    echo '<a class="agrarium-button" href="' . esc_url($href) . '">' . esc_html($text) . '</a>';
                                echo '</div>';
                            }
                        ?>
                    </div>
                </div>
            </div>

            <?php
                $args = array(
                    'prev_label'            => esc_html__('Prev Products', 'agrarium'),
                    'next_label'            => esc_html__('Next Products', 'agrarium'),
                    'taxonomy_name'         => 'agrarium_portfolio_category',
                    'taxonomy_separator'    => ' / '
                );
                echo agrarium_post_navigation($args);
            ?>
        </div>

        <!-- Sidebar Container -->
        <?php get_sidebar(); ?>

    </div>

<?php
get_footer();