<?php
/**
 * The template for displaying single portfolio item page
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage Agrarium
 * @since Agrarium 1.0
 */

the_post();
get_header();

$sidebar_args = agrarium_get_sidebar_args();
$sidebar_position = $sidebar_args['sidebar_position'];

$content_classes = 'content-wrapper';
$content_classes .= ' content-wrapper-sidebar-position-' . esc_attr($sidebar_position);
$content_classes .= ( agrarium_get_post_option('content_top_margin') == 'on' ? ' content-wrapper-remove-top-margin' : '' );
$content_classes .= ( agrarium_get_post_option('content_bottom_margin') == 'on' ? ' content-wrapper-remove-bottom-margin' : '' );
?>

    <div class="<?php echo esc_attr($content_classes); ?>">

        <!-- Content Container -->
        <div class="content">

            <div id="production-<?php the_ID(); ?>" class="single-production"> 
                <div class="production-item">             
                    <div class="production-item-column">
                        <div class="production-item-media">
                            <?php
                            if(!empty(agrarium_production_grid_media_output(null, 1))) {
                                echo agrarium_production_grid_media_output(null, 1);
                            } ?>
                        </div>
                    </div>
                    <div class="production-item-column">
                        <div class="production-item-meta">
                            <div class="agrarium_production_header">
                                <?php 
                                    if(!empty(agrarium_get_post_option('production_subtitle'))) { ?>
                                        <h3 class="production-item-subtitle"> <?php echo wp_kses(agrarium_get_post_option('production_subtitle'), 'strip');?></h3>
                                    <?php }
                                ?>                               
                                <?php if (!empty(get_the_title()) ) {
                                    echo '<h2 class="post-title">' . get_the_title() . '</h2>';
                                }?>
                            </div>
                            <?php if(!empty(agrarium_get_post_option('production_description'))) {
                                echo '<div class="production-description">';
                                    echo wp_kses_post(agrarium_get_post_option('production_description'));
                                echo '</div>';
                            }                        
                            if(!empty(agrarium_get_post_option('production_feature_items'))) {
                                echo '<div class="production-item-features">';
                                    echo '<span class="production-item-features-title">' . esc_html__('Our Features', 'agrarium') . '</span>';
                                    echo agrarium_get_production_features();
                                echo '</div>';
                            } ?>                      
                        </div>
                    </div>
                </div>
                <div class="production-post-content">
                    <?php the_content(); ?>
                </div>
            </div>
        </div>
    </div>

<?php
get_footer();