<?php
defined( 'ABSPATH' ) or die();
?>
<div class="header-row">

    <!-- Icons Block -->
    <?php
    if (
        agrarium_get_prefered_option('header_search_status') == 'on' ||
        agrarium_get_prefered_option('side_panel_status') == 'on' ||
        (
            agrarium_get_prefered_option('header_button_status') == 'on' &&
            !empty(agrarium_get_prefered_option('header_button_text'))
        ) ||
        (
            class_exists('WooCommerce') && agrarium_get_prefered_option('header_minicart_status') == 'on'
        )
    ) {
        echo '<div class="header-icons-container">';

            // Header Side Panel
            if ( agrarium_get_prefered_option('side_panel_status') == 'on' && is_active_sidebar('sidebar-side') ) {
                echo '<div class="header-icon dropdown-trigger">';
                    echo '<div class="dropdown-trigger-item"></div>';
                echo '</div>';
            }

        echo '</div>';
    }
    ?>

    <!-- Menu Block -->
    <?php
        if ( agrarium_get_prefered_option('header_menu_status') == 'on' && agrarium_get_prefered_option('header_logo_status') == 'on' ) {
            // Menu with Logo
            if ( !empty(agrarium_get_prefered_option('header_menu_select')) && agrarium_get_prefered_option('header_menu_select') != 'default' ) {
                $menu_string = wp_nav_menu(
                    array(
                        'menu'              => agrarium_get_prefered_option('header_menu_select'),
                        'items_wrap'        => '%3$s',
                        'depth'             => 1,
                        'container'         => '',
                        'echo'              => false,
                        'fallback_cb' => ''
                    )
                );
            } else {
                $menu_string = wp_nav_menu(
                    array(
                        'theme_location'    => 'main',
                        'items_wrap'        => '%3$s',
                        'depth'             => 1,
                        'container'         => '',
                        'echo'              => false,
                        'fallback_cb' => ''
                    )
                );
            }
            $menu_string = str_replace('</li>
<li', '</li>@@@<li', $menu_string);
            $menu_array = explode('@@@', $menu_string);
            $menu_count = count($menu_array);
            $menu_center_item_num = ceil($menu_count / 2) - 1;
            $menu_center_item = $menu_array[$menu_center_item_num];
            preg_match('/menu-item-[0-9]+"/u', $menu_center_item, $menu_center_item_id);
            $menu_center_item_id = str_replace('menu-item-', '', $menu_center_item_id[0]);
            $menu_center_item_id = str_replace('"', '', $menu_center_item_id);

            echo '<div class="header-menu-container">';
                echo '<nav class="header-menu-row">';
                    if ( !empty(agrarium_get_prefered_option('header_menu_select')) && agrarium_get_prefered_option('header_menu_select') != 'default' ) {
                        wp_nav_menu(
                            array(
                                'menu'          => agrarium_get_prefered_option('header_menu_select'),
                                'menu_class'    => 'main-menu',
                                'depth'         => 0,
                                'container'     => '',
                                'center'        => $menu_center_item_id,
                                'walker'        => new AgrariUm_Double_Menu_Walker(),
                                'fallback_cb' => ''
                            )
                        );
                    } else {
                        $menu_locations = get_nav_menu_locations();
                        if ( isset($menu_locations['main']) && $menu_locations['main'] !== 0 ) {
                            wp_nav_menu(
                                array(
                                    'theme_location'    => 'main',
                                    'menu_class'        => 'main-menu',
                                    'depth'             => 0,
                                    'container'         => '',
                                    'center'            => $menu_center_item_id,
                                    'walker'            => new AgrariUm_Double_Menu_Walker(),
                                    'fallback_cb' => ''
                                )
                            );
                        }
                    }
                echo '</nav>';
            echo '</div>';
        } elseif ( agrarium_get_prefered_option('header_menu_status') == 'on' ) {
            // Menu without Logo
            echo '<div class="header-menu-container">';
                echo '<nav>';
                    if ( !empty(agrarium_get_prefered_option('header_menu_select')) && agrarium_get_prefered_option('header_menu_select') != 'default' ) {
                        wp_nav_menu(
                            array(
                                'menu'          => agrarium_get_prefered_option('header_menu_select'),
                                'menu_class'    => 'main-menu',
                                'depth'         => 0,
                                'container'     => '',
                                'fallback_cb' => ''
                            )
                        );
                    } else {
                        $menu_locations = get_nav_menu_locations();
                        if ( isset($menu_locations['main']) && $menu_locations['main'] !== 0 ) {
                            wp_nav_menu(
                                array(
                                    'theme_location'    => 'main',
                                    'menu_class'        => 'main-menu',
                                    'depth'             => 0,
                                    'container'         => '',
                                    'fallback_cb' => ''
                                )
                            );
                        }
                    }
                echo '</nav>';
            echo '</div>';
        } elseif ( agrarium_get_prefered_option('header_logo_status') == 'on' ) {
            // Logo only
            echo '<div class="logo-container">' . agrarium_get_logo_output() . '</div>';
        }
    ?>

    <!-- Icons Block -->
    <?php
        if (
            agrarium_get_prefered_option('header_search_status') == 'on' ||
            agrarium_get_prefered_option('side_panel_status') == 'on' ||
            (
                agrarium_get_prefered_option('header_button_status') == 'on' &&
                !empty(agrarium_get_prefered_option('header_button_text'))
            ) ||
            (
                class_exists('WooCommerce') && agrarium_get_prefered_option('header_minicart_status') == 'on'
            ) ||
            agrarium_get_prefered_option('header_login_status') == 'on'
        ) {
            echo '<div class="header-icons-container">';

                // Header Button
                if ( agrarium_get_prefered_option('header_button_status') == 'on' && !empty(agrarium_get_prefered_option('header_button_text')) ) {
                    echo '<div class="header-icon header-button-container">';
                        echo '<a class="agrarium-button" href="' . ( !empty(agrarium_get_prefered_option('header_button_url')) ? esc_url(agrarium_get_prefered_option('header_button_url')) : esc_js('javascript:void(0);')) . '">';
                            echo esc_html(agrarium_get_prefered_option('header_button_text'));
                        echo '</a>';
                    echo '</div>';
                }

                // Header Product Cart
                if ( class_exists('WooCommerce') && agrarium_get_prefered_option('header_minicart_status') == 'on' ) {
                    echo '<div class="header-icon mini-cart">';
                        echo '<a href="' . esc_url(wc_get_cart_url()) . '" class="mini-cart-trigger">';
                            echo '<span class="mini-cart_count">';
                                echo '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                     viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
                                <g>
                                    <path d="M492,80H120V20c0-11-9-20-20-20H20C9,0,0,9,0,20s9,20,20,20h60v292c0,11,9,20,20,20h332.5c9.1,0,17.1-6.2,19.4-15l59.5-232
                                        C514.6,92.3,505,80,492,80L492,80z M417,312H120V120h346.2L417,312z M140,392c-33.1,0-60,26.9-60,60s26.9,60,60,60s60-26.9,60-60
                                        S173.1,392,140,392z M140,472c-11,0-20-9-20-20s9-20,20-20s20,9,20,20S151,472,140,472z M353.1,392c-33.1,0-60,26.9-60,60
                                        s26.9,60,60,60s60-26.9,60-60S386.2,392,353.1,392z M353.1,472c-11,0-20-9-20-20s9-20,20-20s20,9,20,20S364.1,472,353.1,472z"/>
                                </g>
                                </svg>';
                                echo '<span>' . WC()->cart->cart_contents_count . '</span>';
                            echo '</span>';
                        echo '</a>';
                        echo '<div class="mini-cart-panel woocommerce">';
                            woocommerce_mini_cart();
                        echo '<div>';
                    echo '</div>';
                }

                // Login/Logout
                if ( agrarium_get_prefered_option('header_login_status') == 'on' ) {
                    if ( class_exists('WooCommerce') ) {
                        echo '<div class="header-icon login-logout">';
                        if (is_user_logged_in()) {
                            echo '<a href="' . wp_logout_url(home_url()) . '" title="' . esc_attr__('Logout', 'agrarium') . '" class="link-logout"></a>';
                        } else {
                            echo '<a href="' . get_permalink(get_option('woocommerce_myaccount_page_id')) . '" title="' . esc_attr__('Login/Register', 'agrarium') . '" class="link-login"></a>';
                        };
                        echo '</div>';
                    } else {
                        echo '<div class="header-icon login-logout">';
                        if (is_user_logged_in()) {
                            echo '<a href="' . wp_logout_url(home_url()) . '" title="' . esc_attr__('Logout', 'agrarium') . '" class="link-logout"></a>';
                        } else {
                            echo '<a href="' . wp_login_url(get_permalink()) . '" title="' . esc_attr__('Login/Register', 'agrarium') . '" class="link-login"></a>';
                        };
                        echo '</div>';
                    }
                }

                // Header Search
                if ( agrarium_get_prefered_option('header_search_status') == 'on' ) {
                    echo '<div class="header-icon search-trigger">';
                        echo '<span class="search-trigger-icon"></span>';
                    echo '</div>';
                }

            echo '</div>';
        }
    ?>

</div>