<?php
    defined( 'ABSPATH' ) or die();

    if ( is_home() ) {
        $page_title = esc_html__('Home', 'agrarium');
    } elseif ( class_exists('WooCommerce') && is_product() ) {
        $page_title = sprintf(stripslashes(agrarium_get_theme_mod('woo_single_product_title')), get_the_title());
    } elseif ( class_exists('WooCommerce') && is_product_category()  ) {
        $page_title = sprintf(stripslashes(agrarium_get_theme_mod('woo_product_categories_title')), single_term_title('', false));
    } elseif ( class_exists('WooCommerce') && is_product_tag() ) {
        $page_title = sprintf(stripslashes(agrarium_get_theme_mod('woo_product_tags_title')), single_term_title('', false));
    } elseif ( class_exists('WooCommerce') && is_search() ) {
        $page_title = sprintf(esc_html__('Search Results By "%s"', 'agrarium'), get_search_query());
    } elseif (is_archive()) {
        if ( class_exists('WooCommerce') && is_woocommerce() ) {
            $page_title = get_the_title();
        } elseif ( !empty(get_queried_object()) && get_queried_object()->name == 'agrarium_portfolio') {
            $page_title = sprintf(esc_html(agrarium_get_theme_mod('portfolio_archive_page_title')), post_type_archive_title('', false));
        } elseif ( !empty(get_queried_object()) && get_queried_object()->name == 'agrarium_project') {
            $page_title = sprintf(esc_html(agrarium_get_theme_mod('project_archive_page_title')), post_type_archive_title('', false));
        } elseif ( !empty(get_queried_object()) && get_queried_object()->name == 'agrarium_case_study') {
            $page_title = sprintf(esc_html(agrarium_get_theme_mod('case_studies_archive_page_title')), post_type_archive_title('', false));
        } elseif ( !empty(get_queried_object()) && get_queried_object()->name == 'agrarium_team_member') {
            $page_title = sprintf(esc_html(agrarium_get_theme_mod('team_archive_page_title')), post_type_archive_title('', false));
        } elseif ( !empty(get_queried_object()) && get_queried_object()->name == 'agrarium_vacancy') {
            $page_title = sprintf(esc_html(agrarium_get_theme_mod('vacancy_archive_page_title')), post_type_archive_title('', false));
        } elseif ( !empty(get_queried_object()) && get_queried_object()->name == 'agrarium_service') {
            $page_title = sprintf(esc_html(agrarium_get_theme_mod('service_archive_page_title')), post_type_archive_title('', false));
        } elseif ( !empty(get_queried_object()) && get_queried_object()->name == 'agrarium_production') {
            $page_title = sprintf(esc_html(agrarium_get_theme_mod('production_archive_page_title')), post_type_archive_title('', false));
        }else {
            $page_title = get_the_archive_title();
        }
    } elseif (is_search()) {
        $page_title = sprintf(esc_html__('Search Results By "%s"', 'agrarium'), get_search_query());
    } elseif (is_singular('agrarium_portfolio')) {
        $page_title = sprintf(stripslashes(agrarium_get_theme_mod('portfolio_single_page_title')), get_the_title());
    } elseif (is_singular('agrarium_project')) {
        $page_title = sprintf(stripslashes(agrarium_get_theme_mod('project_single_page_title')), get_the_title());
    } elseif (is_singular('agrarium_case_study')) {
        $page_title = sprintf(stripslashes(agrarium_get_theme_mod('case_studies_single_page_title')), get_the_title());
    } elseif (is_singular('agrarium_team_member')) {
        $page_title = sprintf(stripslashes(agrarium_get_theme_mod('team_single_page_title')), get_the_title());
    } elseif (is_singular('agrarium_vacancy')) {
        $page_title = sprintf(stripslashes(agrarium_get_theme_mod('vacancy_single_page_title')), get_the_title());
    } elseif (is_singular('agrarium_service')) {
        $page_title = sprintf(stripslashes(agrarium_get_theme_mod('service_single_page_title')), get_the_title());
    } elseif (is_singular('agrarium_production')) {
        $page_title = sprintf(stripslashes(agrarium_get_theme_mod('production_single_page_title')), get_the_title());
    } elseif (is_single()) {
        $page_title = sprintf(stripslashes(agrarium_get_theme_mod('post_page_title')), get_the_title());
    } else {
        $page_title = get_the_title();
    }
    $breadcrumbs_status = agrarium_get_prefered_option('page_title_breadcrumbs_status');
?>

<!-- Page Title -->
<div class="page-title-container">
    <div class="page-title-bg"></div>
    <?php
        if ( agrarium_get_prefered_option('page_title_overlay_status') == 'on' ) {
            echo '<div class="page-title-overlay"></div>';
        }
    ?>
    <div class="page-title-row">
        <div class="page-title-wrapper">
            <div class="page-title-box">  
                <?php 
                    if(agrarium_get_prefered_option('page_title_image_decoration_status') == 'on' &&
                       !empty(agrarium_get_prepared_option('page_title_decoration_image', '', 'page_title_image_decoration_status'))
                    ) {
                        echo '<div class="page-title-decoration-image">';
                            $decoration_image_id = attachment_url_to_postid(agrarium_get_prepared_img_url('page_title_decoration_image', 'page_title_image_decoration_status'));
                            $decoration_image_metadata = wp_get_attachment_metadata($decoration_image_id);
                            $title = get_post($decoration_image_id)->post_title;
                            $alt = ( !empty(get_post_meta($decoration_image_id, '_wp_attachment_image_alt', true)) ) ? get_post_meta($decoration_image_id, '_wp_attachment_image_alt', true) : $title;
                            $decoration_image_width = (isset($decoration_image_metadata['width']) ? $decoration_image_metadata['width'] : 0);
                            $decoration_image_height = (isset($decoration_image_metadata['height']) ? $decoration_image_metadata['height'] : 0);
                            $decoration_image_url = agrarium_get_prepared_img_url('page_title_decoration_image', 'page_title_image_decoration_status');

                            echo '<img width="' . esc_attr($decoration_image_width) . '" height="' . esc_attr($decoration_image_height) . '" src="' . esc_url($decoration_image_url) . '" alt="' . esc_attr($alt) . '"/>';                
                        echo '</div>';
                    }
                ?>              
                <h1 class="page-title"><?php echo sprintf('%s', $page_title); ?></h1>
            </div>
            <?php
                if ( $breadcrumbs_status == 'on' ) {
                    agrarium_breadcrumbs();
                }
            ?>
        </div>
    </div>
    <?php
        if (agrarium_get_prefered_option('page_title_additional_text_status') == 'on' && !empty(agrarium_get_prepared_option('page_title_additional_text', '', 'page_title_additional_text_status')) ) {
            echo '<div class="page-title-additional">' . esc_html(agrarium_get_prepared_option('page_title_additional_text', '', 'page_title_additional_text_status')) . '</div>';
        }
    ?>
    <?php 
        if( (agrarium_get_prefered_option('page_title_bottom_overlay_status')) == 'on' ) {
            echo '<div class="page-title-bottom-overlay"></div>';
        }
    ?>
    
</div>