<?php
/*
Plugin Name: Agrarium Plugin
Plugin URI: https://demo.artureanec.com/
Description: Register Custom Widgets and Custom Post Types for Agrarium Theme.
Version: 1.0.1
Author: Artureanec
Author URI: https://demo.artureanec.com/
Text Domain: agrarium_plugin
*/

// --- Register Custom Widgets --- //
if (!function_exists('agrarium_widgets_load')) {
    function agrarium_widgets_load() {
        require_once(__DIR__ . "/widgets/banner.php");
        require_once(__DIR__ . "/widgets/contacts.php");
        require_once(__DIR__ . "/widgets/featured-posts.php");
        require_once(__DIR__ . "/widgets/nav-menu.php");
        require_once(__DIR__ . "/widgets/quote.php");
    }
}
add_action('plugins_loaded', 'agrarium_widgets_load');

if (!function_exists('agrarium_add_custom_widget')) {
    function agrarium_add_custom_widget($name) {
        register_widget($name);
    }
}

// --- Add Mime Types --- //

function agrarium_upload_mimes( $mimes = array() ) {
    // allow SVG file upload
    $mimes['svg'] = 'image/svg+xml';
    $mimes['svgz'] = 'image/svg+xml';

    return $mimes;
}
add_filter( 'upload_mimes', 'agrarium_upload_mimes', 99 );

// --- Register Custom Post Types --- //
add_action('init', 'agrarium_register_custom_post_types');
if (!function_exists('agrarium_register_custom_post_types')) {
    function agrarium_register_custom_post_types() {
        # Portfolio
        register_taxonomy(
            'agrarium_portfolio_category',
            array('agrarium_portfolio'),
            array(
                'label'             => null,
                'labels'            => array(
                    'name'              => esc_html__('Portfolio Categories', 'agrarium_plugin'),
                    'singular_name'     => esc_html__('Portfolio Category', 'agrarium_plugin'),
                    'search_items'      => esc_html__('Search Category', 'agrarium_plugin'),
                    'all_items'         => esc_html__('All Portfolio Categories', 'agrarium_plugin'),
                    'view_item'         => esc_html__('View Category', 'agrarium_plugin'),
                    'parent_item'       => esc_html__('Parent Category', 'agrarium_plugin'),
                    'parent_item_colon' => esc_html__('Parent Category:', 'agrarium_plugin'),
                    'edit_item'         => esc_html__('Edit Category', 'agrarium_plugin'),
                    'update_item'       => esc_html__('Update Category', 'agrarium_plugin'),
                    'add_new_item'      => esc_html__('Add New Category', 'agrarium_plugin'),
                    'new_item_name'     => esc_html__('New Portfolio Category', 'agrarium_plugin'),
                    'menu_name'         => esc_html__('Portfolio Categories', 'agrarium_plugin'),
                ),
                'hierarchical'      => true,
                'show_admin_column' => false
            )
        );
        register_post_type(
            'agrarium_portfolio',
            array(
                'label'             => null,
                'labels'            => array(
                    'name'              => esc_html__('Portfolios', 'agrarium_plugin'),
                    'singular_name'     => esc_html__('Portfolio', 'agrarium_plugin'),
                    'search_items'      => esc_html__('Search Portfolio', 'agrarium_plugin'),
                    'all_items'         => esc_html__('All Portfolios', 'agrarium_plugin'),
                    'view_item'         => esc_html__('View Portfolio', 'agrarium_plugin'),
                    'edit_item'         => esc_html__('Edit Portfolio', 'agrarium_plugin'),
                    'add_new'           => esc_html__('Add New Portfolio', 'agrarium_plugin'),
                    'add_new_item'      => esc_html__('New Portfolio', 'agrarium_plugin'),
                    'archives'          => esc_html__('Portfolios', 'agrarium_plugin')
                ),
                'public'            => true,
                'rewrite'           => array(
                    'slug'              => 'portfolio',
                    'with_front'        => false
                ),
                'hierarchical'      => true,
                'menu_position'     => 4,
                'menu_icon'         => 'dashicons-format-gallery',
                'supports'          => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt' ),
                'taxonomies'        => array( 'agrarium_portfolio_category' ),
                'has_archive'       => true
            )
        );        

        # Team
        register_taxonomy(
            'agrarium_team_department',
            array('agrarium_team_member'),
            array(
                'label'             => null,
                'labels'            => array(
                    'name'              => esc_html__('Departments', 'agrarium_plugin'),
                    'singular_name'     => esc_html__('Department', 'agrarium_plugin'),
                    'search_items'      => esc_html__('Search Departments', 'agrarium_plugin'),
                    'all_items'         => esc_html__('All Departments', 'agrarium_plugin'),
                    'view_item'         => esc_html__('View Department', 'agrarium_plugin'),
                    'parent_item'       => esc_html__('Parent Department', 'agrarium_plugin'),
                    'parent_item_colon' => esc_html__('Parent Department:', 'agrarium_plugin'),
                    'edit_item'         => esc_html__('Edit Department', 'agrarium_plugin'),
                    'update_item'       => esc_html__('Update Department', 'agrarium_plugin'),
                    'add_new_item'      => esc_html__('Add New Department', 'agrarium_plugin'),
                    'new_item_name'     => esc_html__('New Department Name', 'agrarium_plugin'),
                    'menu_name'         => esc_html__('Departments', 'agrarium_plugin'),
                ),
                'hierarchical'      => true,
                'show_admin_column' => false
            )
        );
        register_post_type('agrarium_team_member',
            array(
                'label'             => null,
                'labels'            => array(
                    'name'              => esc_html__('Team Members', 'agrarium_plugin'),
                    'singular_name'     => esc_html__('Team Member', 'agrarium_plugin'),
                    'search_items'      => esc_html__('Search Team Member', 'agrarium_plugin'),
                    'all_items'         => esc_html__('All Team Members', 'agrarium_plugin'),
                    'view_item'         => esc_html__('View Team Member', 'agrarium_plugin'),
                    'edit_item'         => esc_html__('Edit Team Member', 'agrarium_plugin'),
                    'add_new'           => esc_html__('Add New Member', 'agrarium_plugin'),
                    'add_new_item'      => esc_html__('New Team Member', 'agrarium_plugin'),
                    'archives'          => esc_html__('Team', 'agrarium_plugin')
                ),
                'public'            => true,
                'rewrite'           => array(
                    'slug'              => 'team',
                    'with_front'        => false
                ),
                'hierarchical'      => false,
                'menu_position'     => 6,
                'menu_icon'         => 'dashicons-groups',
                'supports'          => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt' ),
                'taxonomies'        => array( 'agrarium_team_department' ),
                'has_archive'       => true
            )
        );

        # Services
        register_taxonomy(
            'agrarium_services_category',
            array('agrarium_service'),
            array(
                'label'             => null,
                'labels'            => array(
                    'name'              => esc_html__('Service Categories', 'agrarium_plugin'),
                    'singular_name'     => esc_html__('Service Category', 'agrarium_plugin'),
                    'search_items'      => esc_html__('Search Category', 'agrarium_plugin'),
                    'all_items'         => esc_html__('All Categories', 'agrarium_plugin'),
                    'view_item'         => esc_html__('View Category', 'agrarium_plugin'),
                    'parent_item'       => esc_html__('Parent Category', 'agrarium_plugin'),
                    'parent_item_colon' => esc_html__('Parent Category:', 'agrarium_plugin'),
                    'edit_item'         => esc_html__('Edit Category', 'agrarium_plugin'),
                    'update_item'       => esc_html__('Update Category', 'agrarium_plugin'),
                    'add_new_item'      => esc_html__('Add New Category', 'agrarium_plugin'),
                    'new_item_name'     => esc_html__('New Category Name', 'agrarium_plugin'),
                    'menu_name'         => esc_html__('Categories', 'agrarium_plugin'),
                ),
                'hierarchical'      => true,
                'show_admin_column' => false
            )
        );
        register_post_type('agrarium_service',
            array(
                'label'             => null,
                'labels'            => array(
                    'name'              => esc_html__('Services', 'agrarium_plugin'),
                    'singular_name'     => esc_html__('Service', 'agrarium_plugin'),
                    'search_items'      => esc_html__('Search Service', 'agrarium_plugin'),
                    'all_items'         => esc_html__('All Services', 'agrarium_plugin'),
                    'view_item'         => esc_html__('View Service', 'agrarium_plugin'),
                    'edit_item'         => esc_html__('Edit Service', 'agrarium_plugin'),
                    'add_new'           => esc_html__('Add New Service', 'agrarium_plugin'),
                    'add_new_item'      => esc_html__('New Service', 'agrarium_plugin'),
                    'archives'          => esc_html__('Services', 'agrarium_plugin')
                ),
                'public'            => true,
                'rewrite'           => array(
                    'slug'              => 'service',
                    'with_front'        => false
                ),
                'hierarchical'      => false,
                'menu_position'     => 8,
                'menu_icon'         => 'dashicons-admin-generic',
                'supports'          => array( 'title', 'editor', 'thumbnail' ),
                'taxonomies'        => array( 'agrarium_services_category' ),
                'has_archive'       => true
            )
        );

        # Production
        register_taxonomy(
            'agrarium_production_category',
            array('agrarium_production'),
            array(
                'label'             => null,
                'labels'            => array(
                    'name'              => esc_html__('Production Categories', 'agrarium_plugin'),
                    'singular_name'     => esc_html__('Production Category', 'agrarium_plugin'),
                    'search_items'      => esc_html__('Search Category', 'agrarium_plugin'),
                    'all_items'         => esc_html__('All Production Categories', 'agrarium_plugin'),
                    'view_item'         => esc_html__('View Category', 'agrarium_plugin'),
                    'parent_item'       => esc_html__('Parent Category', 'agrarium_plugin'),
                    'parent_item_colon' => esc_html__('Parent Category:', 'agrarium_plugin'),
                    'edit_item'         => esc_html__('Edit Category', 'agrarium_plugin'),
                    'update_item'       => esc_html__('Update Category', 'agrarium_plugin'),
                    'add_new_item'      => esc_html__('Add New Category', 'agrarium_plugin'),
                    'new_item_name'     => esc_html__('New Production Category', 'agrarium_plugin'),
                    'menu_name'         => esc_html__('Production Categories', 'agrarium_plugin'),
                ),
                'hierarchical'      => true,
                'show_admin_column' => false
            )
        );
        register_post_type(
            'agrarium_production',
            array(
                'label'             => null,
                'labels'            => array(
                    'name'              => esc_html__('Productions', 'agrarium_plugin'),
                    'singular_name'     => esc_html__('Production', 'agrarium_plugin'),
                    'search_items'      => esc_html__('Search Production', 'agrarium_plugin'),
                    'all_items'         => esc_html__('All Productions', 'agrarium_plugin'),
                    'view_item'         => esc_html__('View Production', 'agrarium_plugin'),
                    'edit_item'         => esc_html__('Edit Production', 'agrarium_plugin'),
                    'add_new'           => esc_html__('Add New Production', 'agrarium_plugin'),
                    'add_new_item'      => esc_html__('New Production', 'agrarium_plugin'),
                    'archives'          => esc_html__('Productions', 'agrarium_plugin')
                ),
                'public'            => true,
                'rewrite'           => array(
                    'slug'              => 'production',
                    'with_front'        => false
                ),
                'hierarchical'      => true,
                'menu_position'     => 10,
                'menu_icon'         => 'dashicons-cart',
                'supports'          => array( 'title', 'editor', 'thumbnail', 'excerpt' ),
                'taxonomies'        => array( 'agrarium_production_category' ),
                'has_archive'       => true
            )
        );

    }
}

// Init Custom Widgets for Elementor
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

final class AgrariUm_Custom_Widgets {
    const  VERSION = '1.0.0';
    const  MINIMUM_ELEMENTOR_VERSION = '2.0.0';
    const  MINIMUM_PHP_VERSION = '5.4';
    private static $_instance = null;

    public static function instance() {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    public function __construct() {
        add_action('plugins_loaded', [$this, 'init']);
    }

    public function i18n() {
        load_plugin_textdomain('agrarium_plugin', false, plugin_basename(dirname(__FILE__)) . '/languages');
    }

    public function init() {

        $this->i18n();
        
        // Check if Elementor installed and activated
        if (!did_action('elementor/loaded')) {
            add_action('admin_notices', [$this, 'agrarium_admin_notice_missing_main_plugin']);
            return;
        }

        // Check for required Elementor version
        if (!version_compare(ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=')) {
            add_action('admin_notices', [$this, 'agrarium_admin_notice_minimum_elementor_version']);
            return;
        }

        // Check for required PHP version
        if (version_compare(PHP_VERSION, self::MINIMUM_PHP_VERSION, '<')) {
            add_action('admin_notices', [$this, 'agrarium_admin_notice_minimum_php_version']);
            return;
        }

        // Add Custom Fonts Group
        if ( !function_exists('agrarium_add_custom_fonts_group_to_elementor') ) {
            function agrarium_add_custom_fonts_group_to_elementor($font_groups) {
                $additional_groups = array(
                    'theme_fonts'     => esc_html__( 'Theme Fonts', 'agrarium_plugin' )
                );
                $font_groups = array_merge($font_groups, $additional_groups);
                return $font_groups;
            }
        }
        add_filter( 'elementor/fonts/groups', 'agrarium_add_custom_fonts_group_to_elementor' );

        // Add Custom Fonts
        if ( !function_exists('agrarium_add_custom_fonts_to_elementor') ) {
            function agrarium_add_custom_fonts_to_elementor($fonts) {
                $additional_fonts = array(
                    'Herbarium'        => 'theme_fonts',
                    'Herbarium Alt'    => 'theme_fonts',
                    'Herbarium Extras' => 'theme_fonts'
                );
                $fonts = array_merge($fonts, $additional_fonts);
                return $fonts;
            }
        }
        add_filter( 'elementor/fonts/additional_fonts', 'agrarium_add_custom_fonts_to_elementor' );

        // Include Additional Files
        add_action('elementor/init', [$this, 'agrarium_include_additional_files']);

        // Add new Elementor Categories
        add_action('elementor/init', [$this, 'agrarium_add_elementor_category']);

        // Register Widget Scripts
        add_action('elementor/frontend/after_register_scripts', [$this, 'agrarium_register_widget_scripts']);

        add_action('wp_enqueue_scripts', function () {
            wp_localize_script('ajax_query_products', 'agrarium_ajaxurl',
                array(
                    'url' => admin_url('admin-ajax.php')
                )
            );
        });

        // Register New Widgets
        add_action('elementor/widgets/register', [$this, 'agrarium_widgets_register']);

        // Register Editor Styles
        add_action('elementor/editor/before_enqueue_scripts', function () {
            wp_register_style('agrarium_elementor_admin', plugins_url('agrarium-plugin/css/agrarium-plugin-admin.css'));
            wp_enqueue_style('agrarium_elementor_admin');
        });      
    }


    public function agrarium_admin_notice_missing_main_plugin() {
        $message = sprintf(
        /* translators: 1: Restbeef Core 2: Elementor */
            esc_html__('"%1$s" requires "%2$s" to be installed and activated.', 'agrarium_plugin'),
            '<strong>' . esc_html__('Restbeef Core', 'agrarium_plugin') . '</strong>',
            '<strong>' . esc_html__('Elementor', 'agrarium_plugin') . '</strong>'
        );
        printf('<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message);
    }

    public function agrarium_admin_notice_minimum_elementor_version() {
        $message = sprintf(
        /* translators: 1: Restbeef Core 2: Elementor 3: Required Elementor version */
            esc_html__('"%1$s" requires "%2$s" version %3$s or greater.', 'agrarium_plugin'),
            '<strong>' . esc_html__('Restbeef Core', 'agrarium_plugin') . '</strong>',
            '<strong>' . esc_html__('Elementor', 'agrarium_plugin') . '</strong>',
            self::MINIMUM_ELEMENTOR_VERSION
        );
        printf('<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message);
    }

    public function agrarium_admin_notice_minimum_php_version() {
        $message = sprintf(
        /* translators: 1: Press Elements 2: PHP 3: Required PHP version */
            esc_html__('"%1$s" requires "%2$s" version %3$s or greater.', 'agrarium_plugin'),
            '<strong>' . esc_html__('Press Elements', 'agrarium_plugin') . '</strong>',
            '<strong>' . esc_html__('PHP', 'agrarium_plugin') . '</strong>',
            self::MINIMUM_PHP_VERSION
        );
        printf('<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message);
    }

    public function agrarium_include_additional_files() {}

    public function agrarium_add_elementor_category() {
        $categories = [];
        $categories['agrarium_widgets'] = [
            'title' => esc_html__('Agrarium Widgets', 'agrarium_plugin'),
            'icon'  => 'fa fa-plug'
        ];
        $old_categories = \Elementor\Plugin::$instance->elements_manager->get_categories();
        $categories     = array_merge($categories, $old_categories);

        $set_categories = function ( $categories ) {
            $this->categories = $categories;
        };
        $set_categories->call( \Elementor\Plugin::$instance->elements_manager, $categories );
    }

    public function agrarium_register_widget_scripts() {
        // Lib
        wp_register_script('fancybox', plugins_url('agrarium-plugin/js/lib/jquery.fancybox.min.js'), array('jquery'));
        wp_register_script('slick_slider', plugins_url('agrarium-plugin/js/lib/slick.min.js'), array('jquery'));
        wp_register_script('isotope', plugins_url('agrarium-plugin/js/lib/isotope.min.js'), array('jquery', 'imagesloaded'));
        wp_register_script('plugin', plugins_url('agrarium-plugin/js/lib/jquery.plugin.js'), array('jquery'));
        wp_register_script('countdown', plugins_url('agrarium-plugin/js/lib/jquery.countdown.min.js'), array('jquery', 'plugin'));

        // Scripts
        wp_register_script('product_carousel_widget', plugins_url('agrarium-plugin/js/product-carousel-widget.js'), array('jquery', 'slick_slider'));
        wp_register_script('content_slider_widget', plugins_url('agrarium-plugin/js/content-slider-widget.js'), array('jquery', 'slick_slider', 'fancybox'));        
        wp_register_script('countdown_widget', plugins_url('agrarium-plugin/js/countdown-widget.js'), array('jquery', 'countdown'));
        wp_register_script('image_carousel_widget', plugins_url('agrarium-plugin/js/image-carousel-widget.js'), array('jquery', 'swiper'));

        wp_register_script('video_widget', plugins_url('agrarium-plugin/js/video-button-widget.js'), array('jquery'));

        wp_register_script('elementor_widgets', plugins_url('agrarium-plugin/js/elementor-widgets.js'), array('jquery', 'owl-carousel', 'isotope', 'agrarium-theme'));
    }

    public function agrarium_widgets_register() {

        // --- Include Widget Files --- //
        require_once __DIR__ . '/elements/banner.php';
        require_once __DIR__ . '/elements/blog.php';
        require_once __DIR__ . '/elements/button.php';
        require_once __DIR__ . '/elements/content-slider.php';
        require_once __DIR__ . '/elements/countdown.php';
        require_once __DIR__ . '/elements/heading.php';
        require_once __DIR__ . '/elements/icon-box.php';
        require_once __DIR__ . '/elements/image.php';
        require_once __DIR__ . '/elements/portfolio-listing.php';
        require_once __DIR__ . '/elements/price-item.php';
        require_once __DIR__ . '/elements/special-text.php';
        require_once __DIR__ . '/elements/services-listing.php';
        require_once __DIR__ . '/elements/team-members.php';
        require_once __DIR__ . '/elements/testimonial-carousel.php';
        require_once __DIR__ . '/elements/video-button.php';
        require_once __DIR__ . '/elements/production-listing.php';
        require_once __DIR__ . '/elements/slogan.php';
        require_once __DIR__ . '/elements/vertical-text.php';
        require_once __DIR__ . '/elements/history-carousel.php';        
        require_once __DIR__ . '/elements/product-carousel.php'; 

        // --- Register Widgets --- //
        \Elementor\Plugin::instance()->widgets_manager->register(new AgrariUm\Widgets\AgrariUm_Banner_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new AgrariUm\Widgets\AgrariUm_Blog_Listing_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new AgrariUm\Widgets\AgrariUm_Button_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new AgrariUm\Widgets\AgrariUm_Content_Slider_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new AgrariUm\Widgets\AgrariUm_Countdown_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new AgrariUm\Widgets\AgrariUm_Heading_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new AgrariUm\Widgets\AgrariUm_Icon_Box_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new AgrariUm\Widgets\AgrariUm_Image_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new AgrariUm\Widgets\AgrariUm_Portfolio_Listing_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new AgrariUm\Widgets\AgrariUm_Price_Item_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new AgrariUm\Widgets\AgrariUm_Services_Listing_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new AgrariUm\Widgets\AgrariUm_Special_Text_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new AgrariUm\Widgets\AgrariUm_Team_Members_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new AgrariUm\Widgets\AgrariUm_Testimonial_Carousel_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new AgrariUm\Widgets\AgrariUm_Video_Button_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new AgrariUm\Widgets\AgrariUm_Production_Listing_Widget());   
        \Elementor\Plugin::instance()->widgets_manager->register(new AgrariUm\Widgets\AgrariUm_Slogan_Widget()); 
        \Elementor\Plugin::instance()->widgets_manager->register(new AgrariUm\Widgets\AgrariUm_Vertical_Text_Widget());      
        \Elementor\Plugin::instance()->widgets_manager->register(new AgrariUm\Widgets\AgrariUm_History_Carousel_Widget());  
        \Elementor\Plugin::instance()->widgets_manager->register(new AgrariUm\Widgets\AgrariUm_Product_Carousel_Widget());  

        if (class_exists('WooCommerce')) {
            require_once __DIR__ . '/elements/products.php';
            require_once __DIR__ . '/elements/product-category.php';
            \Elementor\Plugin::instance()->widgets_manager->register(new AgrariUm\Widgets\AgrariUm_Products_Widget());
            \Elementor\Plugin::instance()->widgets_manager->register(new AgrariUm\Widgets\AgrariUm_Product_Category_Widget());
        }

        if ( function_exists( 'wpforms' ) ) {
            require_once __DIR__ . '/elements/wpforms.php';
            \Elementor\Plugin::instance()->widgets_manager->register(new AgrariUm\Widgets\AgrariUm_Wpforms_Widget());
        }

        if ( function_exists( 'sb_instagram_feed_init' ) ) {
            require_once __DIR__ . '/elements/instagram-feed.php';
            \Elementor\Plugin::instance()->widgets_manager->register(new AgrariUm\Widgets\AgrariUm_Instagram_Feed_Widget());
        }
    }
}

AgrariUm_Custom_Widgets::instance();

add_action('plugins_loaded', function() {
	if(did_action('elementor/loaded')) {
        add_action('elementor/widgets/register', function ($widget_manager) {
            $widget_manager->unregister('tabs');
        }, 15);

        add_action('elementor/element/before_section_end', function ($element, $section_id, $args) {
            if ('section' === $element->get_name() && 'section_background' === $section_id) {
                $element->add_control(
                    'use_parallax',
                    [
                        'label'         => esc_html__( 'Parallax Effect', 'agrarium_plugin' ),
                        'type'          => \Elementor\Controls_Manager::SWITCHER,
                        'label_on'      => esc_html__( 'On', 'agrarium_plugin' ),
                        'label_off'     => esc_html__( 'Off', 'agrarium_plugin' ),
                        'return_value'  => 'yes',
                        'default'       => 'no'
                    ]
                );
            }
            if ('section' === $element->get_name() && 'section_layout' === $section_id) {
                $element->add_control(
                    'section_container_padding',
                    [
                        'label'         => esc_html__( 'Remove Container Padding', 'agrarium_plugin' ),
                        'type'          => \Elementor\Controls_Manager::SWITCHER,
                        'label_on'      => esc_html__( 'On', 'agrarium_plugin' ),
                        'label_off'     => esc_html__( 'Off', 'agrarium_plugin' ),
                        'return_value'  => 'container-padding-remove',
                        'default'       => '',
                        'prefix_class'  => 'elementor-section-',
                        'hide_in_inner' => true,
                        'condition'     => [
                            'stretch_section' => 'section-stretched',
                            'gap!'       => 'no'
                        ] 
                    ]
                );
            }
            if ('image' === $element->get_name() && 'section_style_image' === $section_id) {
                $element->add_control(
                    'use_scroll_motion',
                    [
                        'label'         => esc_html__( 'Scroll Motion Effect', 'agrarium_plugin' ),
                        'type'          => \Elementor\Controls_Manager::SWITCHER,
                        'label_on'      => esc_html__( 'On', 'agrarium_plugin' ),
                        'label_off'     => esc_html__( 'Off', 'agrarium_plugin' ),
                        'return_value'  => 'yes',
                        'default'       => 'no',
                        'prefix_class'  => 'scroll-motion-'
                    ]
                );
                $element->add_control(
                    'scroll_direction',
                    [
                        'label'     => esc_html__('Scroll Direction', 'agrarium_plugin'),
                        'type'      => \Elementor\Controls_Manager::SELECT,
                        'default'   => 'up',
                        'options'   => [
                            'up'   => esc_html__('Up', 'agrarium_plugin'),
                            'down'   => esc_html__('Down', 'agrarium_plugin')
                        ],
                        'condition' => [
                            'use_scroll_motion' => 'yes'
                        ],
                        'separator'     => 'after',
                        'prefix_class'  => 'scroll-motion-direction-'
                    ]
                );
            }
            if ('image-box' === $element->get_name() && 'section_style_image' === $section_id) {
                $element->add_control(
                    'image_alignment_mobile',
                    [
                        'label' => esc_html__( 'Image Alignment On Mobile', 'elementor' ),
                        'type' => \Elementor\Controls_Manager::CHOOSE,
                        'default' => 'center',
                        'options' => [
                            'left' => [
                                'title' => esc_html__( 'Left', 'elementor' ),
                                'icon' => 'eicon-h-align-left',
                            ],
                            'center' => [
                                'title' => esc_html__( 'Center', 'elementor' ),
                                'icon' => 'eicon-h-align-center',
                            ],
                            'right' => [
                                'title' => esc_html__( 'Right', 'elementor' ),
                                'icon' => 'eicon-h-align-right',
                            ],
                        ],
                        'prefix_class'  => 'elementor-image-alignment-mobile-',
                        'toggle' => false
                    ]
                );
            }
            if ('counter' === $element->get_name() && 'section_counter' === $section_id) {
                $element->add_responsive_control(
                    'info_align',
                    [
                        'label'     => esc_html__('Text Alignment', 'agrarium_plugin'),
                        'type'      => \Elementor\Controls_Manager::CHOOSE,
                        'options'   => [
                            'left'      => [
                                'title'     => esc_html__('Left', 'agrarium_plugin'),
                                'icon'      => 'fa fa-align-left',
                            ],
                            'center'    => [
                                'title'     => esc_html__('Center', 'agrarium_plugin'),
                                'icon'      => 'fa fa-align-center',
                            ],
                            'right'     => [
                                'title'     => esc_html__('Right', 'agrarium_plugin'),
                                'icon'      => 'fa fa-align-right',
                            ]
                        ],
                        'default'   => 'center',
                        'selectors' => [
                            '{{WRAPPER}} .elementor-counter .elementor-counter-title, {{WRAPPER}} .elementor-counter .elementor-counter-number-wrapper' => 'text-align: {{VALUE}};',
                        ],
                    ]
                );
            }
            if ('counter' === $element->get_name() && 'section_number' === $section_id) {
                $element->remove_control('number_color');
                $element->add_control(
                    'number_color',
                    [
                        'label'     => esc_html__('Text Color', 'agrarium_plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .elementor-counter-number-wrapper' => 'color: {{VALUE}};'
                        ]
                    ]
                );
            }

            if ('image-carousel' === $element->get_name() && 'section_image_carousel' === $section_id) {
                $element->add_control(
                    'view_style',
                    [
                        'label'         => esc_html__('View Style', 'agrarium_plugin'),
                        'type'          => \Elementor\Controls_Manager::SELECT,
                        'default'       => 'style_1',
                        'options'       => [
                            'style_1'       => esc_html__('Style 1', 'agrarium_plugin'),
                            'style_2'       => esc_html__('Style 2', 'agrarium_plugin')
                        ],
                        'separator'     => 'before',
                        'prefix_class'  => 'image_',
                        'toggle'        => false
                    ]
                );
            }
            if ('image-carousel' === $element->get_name() && 'section_style_image' === $section_id) {
                $element->add_control(
                    'show_overflow',
                    [
                        'label'         => esc_html__('Show Overflow', 'agrarium_plugin'),
                        'type'          => \Elementor\Controls_Manager::SWITCHER,
                        'label_on'      => esc_html__( 'Show', 'your-plugin' ),
                        'label_off'     => esc_html__( 'Hide', 'your-plugin' ),
                        'return_value'  => 'yes',
                        'default'       => 'no',
                        'prefix_class'  => 'overflow_',
                    ]
                );            
            }

            if ( 'video' === $element->get_name() && 'section_video_style' === $section_id ) {
                $element->remove_control('play_icon_title');
                $element->remove_control('play_icon_color');
                $element->remove_responsive_control('play_icon_size');
                $element->remove_control('play_icon_text_shadow_color');
                $element->remove_control('play_icon_text_shadow_blur');
                $element->remove_control('play_icon_text_shadow_horizontal');
                $element->remove_control('play_icon_text_shadow_vertical');

                $element->add_responsive_control(
                    'video_width',
                    [
                        'label'         => esc_html__('Video Max Width', 'agrarium_plugin'),
                        'type'          => \Elementor\Controls_Manager::SLIDER,
                        'size_units'    => [ 'px', '%' ],
                        'range'         => [
                            'px'            => [
                                'min'           => 100,
                                'max'           => 1170,
                            ],
                            '%'             => [
                                'min'           => 1,
                                'max'           => 100,
                            ]
                        ],
                        'selectors'     => [
                            '{{WRAPPER}} .elementor-widget-container' => 'max-width: {{SIZE}}{{UNIT}};'
                        ]
                    ]
                );
                $element->add_control(
                    'video_play_icon_title',
                    [
                        'label' => esc_html__( 'Play Icon', 'agrarium_plugin' ),
                        'type' => \Elementor\Controls_Manager::HEADING,
                        'condition' => [
                            'show_image_overlay' => 'yes',
                            'show_play_icon' => 'yes',
                        ],
                        'separator' => 'before',
                    ]
                );

                $element->add_responsive_control(
                    'play_button_size',
                    [
                        'label' => esc_html__( 'Button Size', 'agrarium_plugin' ),
                        'type' => \Elementor\Controls_Manager::SLIDER,
                        'range' => [
                            'px' => [
                                'min' => 10,
                                'max' => 300,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .elementor-custom-embed-play'        => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                        ],
                        'condition' => [
                            'show_image_overlay' => 'yes',
                            'show_play_icon' => 'yes',
                        ],
                    ]
                );

                $element->add_responsive_control(
                    'video_play_icon_size',
                    [
                        'label' => esc_html__( 'Icon Size', 'agrarium_plugin' ),
                        'type' => \Elementor\Controls_Manager::SLIDER,
                        'range' => [
                            'px' => [
                                'min' => 10,
                                'max' => 300,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .elementor-custom-embed-play svg' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                        'condition' => [
                            'show_image_overlay' => 'yes',
                            'show_play_icon' => 'yes',
                        ],
                    ]
                );

                $element->start_controls_tabs('button_settings_tabs');

                    // ------------------------ //
                    // ------ Normal Tab ------ //
                    // ------------------------ //
                    $element->start_controls_tab(
                        'tab_button_normal',
                        [
                            'label' => esc_html__('Normal', 'agrarium_plugin')
                        ]
                    );

                        $element->add_control(
                            'video_play_icon_color',
                            [
                                'label'     => esc_html__('Icon Color', 'agrarium_plugin'),
                                'type'      => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .elementor-custom-embed-play svg path' => 'fill: {{VALUE}};'
                                ]
                            ]
                        );

                        $element->add_control(
                            'play_icon_bg',
                            [
                                'label'     => esc_html__('Icon Background', 'agrarium_plugin'),
                                'type'      => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .elementor-custom-embed-play' => 'background: {{VALUE}};'
                                ]
                            ]
                        );

                    $element->end_controls_tab();

                    // ----------------------- //
                    // ------ Hover Tab ------ //
                    // ----------------------- //
                    $element->start_controls_tab(
                        'tab_button_hover',
                        [
                            'label' => esc_html__('Hover', 'agrarium_plugin')
                        ]
                    );

                        $element->add_control(
                            'play_icon_hover',
                            [
                                'label'     => esc_html__('Icon Hover', 'agrarium_plugin'),
                                'type'      => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .elementor-custom-embed-play:hover svg path' => 'fill: {{VALUE}};'
                                ]
                            ]
                        );

                        $element->add_control(
                            'play_icon_bg_hover',
                            [
                                'label'     => esc_html__('Icon Background Hover', 'agrarium_plugin'),
                                'type'      => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .elementor-custom-embed-play:hover' => 'background: {{VALUE}};'
                                ]
                            ]
                        );

                    $element->end_controls_tab();

                $element->end_controls_tabs();
                
                $element->add_control(
                    'overlay_radius',
                    [
                        'label'         => esc_html__('Overlay Border Radius', 'agrarium_plugin'),
                        'type'          => \Elementor\Controls_Manager::DIMENSIONS,
                        'size_units'    => ['px', '%'],
                        'selectors'     => [
                            '{{WRAPPER}} .elementor-custom-embed-image-overlay' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ]
                    ]
                );
            }


            if ('image-carousel' === $element->get_name() && 'section_style_navigation' === $section_id) {
                $element->remove_control('dots_position');
                $element->remove_control('dots_size');
                $element->remove_control('dots_color');
                $element->start_controls_tabs('button_settings_tabs');

                // ------------------------ //
                // ------ Normal Tab ------ //
                // ------------------------ //
                $element->start_controls_tab(
                    'pagination_normal',
                    [
                        'label' => esc_html__('Normal', 'agrarium_plugin')
                    ]
                );

                $element->add_control(
                    'dot_color',
                    [
                        'label'     => esc_html__('Pagination Dot Color', 'agrarium_plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .swiper-pagination-bullet:after' => 'background: {{VALUE}};'
                        ]
                    ]
                );

                $element->add_control(
                    'dot_border',
                    [
                        'label'     => esc_html__('Pagination Dot Border', 'agrarium_plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .swiper-pagination-bullet' => 'border-color: {{VALUE}};'
                        ]
                    ]
                );

                $element->end_controls_tab();

                // ------------------------ //
                // ------ Active Tab ------ //
                // ------------------------ //
                $element->start_controls_tab(
                    'pagination_active',
                    [
                        'label' => esc_html__('Active', 'agrarium_plugin')
                    ]
                );

                $element->add_control(
                    'dot_active',
                    [
                        'label'     => esc_html__('Pagination Active Dot Color', 'agrarium_plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .swiper-pagination-bullet.swiper-pagination-bullet-active:after' => 'background: {{VALUE}};'
                        ]
                    ]
                );

                $element->add_control(
                    'dot_border_active',
                    [
                        'label'     => esc_html__('Pagination Active Dot Border', 'agrarium_plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .swiper-pagination-bullet.swiper-pagination-bullet-active' => 'border-color: {{VALUE}};'
                        ]
                    ]
                );

                $element->end_controls_tab();

                $element->end_controls_tabs();
            }

            if ('image-carousel' === $element->get_name() && 'section_style_image' === $section_id) {
                $element->remove_control('image_spacing');
                $element->remove_control('image_spacing_custom');
                $element->add_group_control(
                    \Elementor\Group_Control_Box_Shadow::get_type(),
                    [
                        'name'      => 'image_shadow',
                        'selector'  => '{{WRAPPER}} .elementor-image-carousel-wrapper .elementor-image-carousel .swiper-slide-image',
                    ]
                );

                $element->add_control(
                    'image_spacing',
                    [
                        'label'     => esc_html__( 'Spacing', 'agrarium_plugin' ),
                        'type'      => \Elementor\Controls_Manager::SELECT,
                        'options'   => [
                            ''          => esc_html__( 'Default', 'agrarium_plugin' ),
                            'custom'    => esc_html__( 'Custom', 'agrarium_plugin' ),
                        ],
                        'default'   => '',
                        'condition' => [
                            'slides_to_show!' => '1',
                        ],
                    ]
                );
                $element->add_control(
                    'image_spacing_custom',
                    [
                        'label'                 => esc_html__( 'Image Spacing', 'agrarium_plugin' ),
                        'type'                  => \Elementor\Controls_Manager::SLIDER,
                        'range'                 => [
                            'px'                    => [
                                'max'                   => 100,
                            ],
                        ],
                        'default'               => [
                            'size'                  => 20,
                        ],
                        'show_label'            => false,
                        'condition'             => [
                            'image_spacing'         => 'custom',
                            'slides_to_show!'       => '1',
                        ],
                        'frontend_available'    => true,
                        'render_type'           => 'none',
                        'separator'             => 'after',
                        'selectors'             => [
                            '{{WRAPPER}} .elementor-image-carousel-wrapper' => 'margin: -{{SIZE}}px; padding: {{SIZE}}px !important;'
                        ],
                    ]
                );

                $element->add_control(
                    'icon_color',
                    [
                        'label'     => esc_html__('Icon Color', 'agrarium_plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .swiper-slide a:after' => 'color: {{VALUE}};'
                        ],
                        'separator' => 'before',
                        'condition' => [
                            'link_to'   => ['file', 'custom']
                        ]
                    ]
                );

                $element->add_control(
                    'icon_bg_color',
                    [
                        'label'     => esc_html__('Icon Background Color', 'agrarium_plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .swiper-slide a:after' => 'background-color: {{VALUE}};'
                        ],
                        'condition' => [
                            'link_to'   => ['file', 'custom']
                        ]
                    ]
                );

                $element->add_control(
                    'overlay_color',
                    [
                        'label'     => esc_html__('Image Overlay Color', 'agrarium_plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .swiper-slide a:before' => 'background-color: {{VALUE}};'
                        ],
                        'condition' => [
                            'link_to'       => ['file', 'custom'],
                            'view_style'    => 'style_2'
                        ]
                    ]
                );


                $element->start_controls_tabs('frame_settings_tabs');

                    // ------------------------ //
                    // ------ Normal Tab ------ //
                    // ------------------------ //
                    $element->start_controls_tab(
                        'frame_normal',
                        [
                            'label'     => esc_html__('Normal', 'agrarium_plugin'),
                            'condition' => [
                                'link_to'    => ['file', 'custom'],
                                'view_style' => 'style_2'
                            ]
                        ]
                    );

                        $element->add_control(
                            'frame_color',
                            [
                                'label'     => esc_html__('Frame Color', 'agrarium_plugin'),
                                'type'      => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .swiper-slide a:before' => 'border-color: {{VALUE}};'
                                ],
                                'condition' => [
                                    'link_to'    => ['file', 'custom'],
                                    'view_style' => 'style_2'
                                ]
                            ]
                        );

                    $element->end_controls_tab();

                    // ------------------------ //
                    // ------ Active Tab ------ //
                    // ------------------------ //
                    $element->start_controls_tab(
                        'frame_hover',
                        [
                            'label'     => esc_html__('Hover', 'agrarium_plugin'),
                            'condition' => [
                                'link_to'    => ['file', 'custom'],
                                'view_style' => 'style_2'
                            ]
                        ]
                    );

                        $element->add_control(
                            'frame_color_hover',
                            [
                                'label'     => esc_html__('Frame Color on Hover', 'agrarium_plugin'),
                                'type'      => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .swiper-slide a:hover:before' => 'border-color: {{VALUE}};'
                                ],
                                'condition' => [
                                    'link_to'    => ['file', 'custom'],
                                    'view_style' => 'style_2'
                                ]
                            ]
                        );

                    $element->end_controls_tab();

                $element->end_controls_tabs();
            }

            if ('accordion' === $element->get_name() && 'section_title_style' === $section_id) {
                $element->remove_control('border_width');
                $element->remove_control('border_color');

                $element->add_responsive_control(
                    'space_between',
                    [
                        'label'     => esc_html__( 'Space Between', 'agrarium_plugin' ),
                        'type'      => \Elementor\Controls_Manager::SLIDER,
                        'range'     => [
                            'px'        => [
                                'min'       => 0,
                                'max'       => 100,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .elementor-accordion-item:not(:last-of-type)' => 'margin-bottom: {{SIZE}}{{UNIT}}',
                        ],
                    ]
                );
                $element->add_group_control(
                    \Elementor\Group_Control_Box_Shadow::get_type(),
                    [
                        'name'      => 'box_shadow',
                        'selector'  => '{{WRAPPER}} .elementor-accordion-item',
                    ]
                );
            }

            if ('accordion' === $element->get_name() && 'section_toggle_style_title' === $section_id) {
                $element->remove_control('title_background');
                $element->remove_control('title_color');
                $element->remove_control('tab_active_color');

                $element->start_controls_tabs('title_colors_tabs');

                    // ------------------------ //
                    // ------ Normal Tab ------ //
                    // ------------------------ //
                    $element->start_controls_tab(
                        'title_colors_normal',
                        [
                            'label' => esc_html__('Normal', 'agrarium_plugin')
                        ]
                    );

                        $element->add_control(
                            'title_color',
                            [
                                'label'     => esc_html__('Title Color', 'agrarium_plugin'),
                                'type'      => \Elementor\Controls_Manager::COLOR,
                                'default'   => '',
                                'selectors' => [
                                    '{{WRAPPER}} .elementor-tab-title:not(.elementor-active) .elementor-accordion-title' => 'color: {{VALUE}};'
                                ]
                            ]
                        );

                        $element->add_control(
                            'title_bg_color',
                            [
                                'label'     => esc_html__('Title Background Color', 'agrarium_plugin'),
                                'type'      => \Elementor\Controls_Manager::COLOR,
                                'default'   => '',
                                'selectors' => [
                                    '{{WRAPPER}} .elementor-tab-title:not(.elementor-active)' => 'background-color: {{VALUE}};'
                                ]
                            ]
                        );

                    $element->end_controls_tab();

                    // ------------------------ //
                    // ------ Active Tab ------ //
                    // ------------------------ //
                    $element->start_controls_tab(
                        'title_colors_active',
                        [
                            'label' => esc_html__('Active', 'agrarium_plugin')
                        ]
                    );

                        $element->add_control(
                            'active_title_color',
                            [
                                'label'     => esc_html__('Title Color', 'agrarium_plugin'),
                                'type'      => \Elementor\Controls_Manager::COLOR,
                                'default'   => '',
                                'selectors' => [
                                    '{{WRAPPER}} .elementor-tab-title.elementor-active .elementor-accordion-title' => 'color: {{VALUE}};'
                                ]
                            ]
                        );

                        $element->add_control(
                            'active_title_bg_color',
                            [
                                'label'     => esc_html__('Title Background Color', 'agrarium_plugin'),
                                'type'      => \Elementor\Controls_Manager::COLOR,
                                'default'   => '',
                                'selectors' => [
                                    '{{WRAPPER}} .elementor-tab-title.elementor-active' => 'background-color: {{VALUE}};'
                                ]
                            ]
                        );

                    $element->end_controls_tab();

                $element->end_controls_tabs();
            }

            if ('toggle' === $element->get_name() && 'section_toggle_style' === $section_id) {
                $element->remove_control('border_width');
                $element->remove_control('border_color');
            }

            if ('toggle' === $element->get_name() && 'section_toggle_style_title' === $section_id) {
                $element->remove_control('title_background');
                $element->remove_control('title_color');
                $element->remove_control('tab_active_color');

                $element->start_controls_tabs('title_colors_tabs');

                    // ------------------------ //
                    // ------ Normal Tab ------ //
                    // ------------------------ //
                    $element->start_controls_tab(
                        'title_colors_normal',
                        [
                            'label' => esc_html__('Normal', 'agrarium_plugin')
                        ]
                    );

                        $element->add_control(
                            'title_color',
                            [
                                'label'     => esc_html__('Title Color', 'agrarium_plugin'),
                                'type'      => \Elementor\Controls_Manager::COLOR,
                                'default'   => '',
                                'selectors' => [
                                    '{{WRAPPER}} .elementor-tab-title:not(.elementor-active) .elementor-toggle-title' => 'color: {{VALUE}};'
                                ]
                            ]
                        );

                        $element->add_control(
                            'title_bg_color',
                            [
                                'label'     => esc_html__('Title Background Color', 'agrarium_plugin'),
                                'type'      => \Elementor\Controls_Manager::COLOR,
                                'default'   => '',
                                'selectors' => [
                                    '{{WRAPPER}} .elementor-tab-title:not(.elementor-active)' => 'background-color: {{VALUE}};'
                                ]
                            ]
                        );

                    $element->end_controls_tab();

                    // ------------------------ //
                    // ------ Active Tab ------ //
                    // ------------------------ //
                    $element->start_controls_tab(
                        'title_colors_active',
                        [
                            'label' => esc_html__('Active', 'agrarium_plugin')
                        ]
                    );

                        $element->add_control(
                            'active_title_color',
                            [
                                'label'     => esc_html__('Title Color', 'agrarium_plugin'),
                                'type'      => \Elementor\Controls_Manager::COLOR,
                                'default'   => '',
                                'selectors' => [
                                    '{{WRAPPER}} .elementor-tab-title.elementor-active .elementor-toggle-title' => 'color: {{VALUE}};'
                                ]
                            ]
                        );

                        $element->add_control(
                            'active_title_bg_color',
                            [
                                'label'     => esc_html__('Title Background Color', 'agrarium_plugin'),
                                'type'      => \Elementor\Controls_Manager::COLOR,
                                'default'   => '',
                                'selectors' => [
                                    '{{WRAPPER}} .elementor-tab-title.elementor-active' => 'background-color: {{VALUE}};'
                                ]
                            ]
                        );

                    $element->end_controls_tab();

                $element->end_controls_tabs();
            }

            if('image-box' === $element->get_name() && 'section_style_image' === $section_id) {
            	$element->add_responsive_control(
                'image_space_vertical',
                [
                    'label'     => esc_html__('Spacing Vertical', 'agrarium_plugin'),
                    'type' =>   \Elementor\Controls_Manager::SLIDER,
    								'default' => [
    									'size' => 10,
    								],
    								'range' => [
    									'px' => [
    										'min' => 0,
    										'max' => 100,
    									],
    								],
    								'selectors' => [
    									'{{WRAPPER}}.elementor-position-right .elementor-image-box-img' => 'margin-bottom: {{SIZE}}{{UNIT}};',
    									'{{WRAPPER}}.elementor-position-left .elementor-image-box-img' => 'margin-bottom: {{SIZE}}{{UNIT}};',
    								],
                    'conditions' => [
    							    'relation' => 'or',
    							    'terms' => [
    							        [
    							            'name' => 'position',
    							            'operator' => '==',
    							            'value' => 'left'
    							        ],
    							        [
    							            'name' => 'position',
    							            'operator' => '==',
    							            'value' => 'right'
    							        ]
    							    ]
    							]
                ]
            );
            }

        }, 10, 3);

        add_action('elementor/frontend/section/before_render', function( \Elementor\Element_Base $element ) {
            $settings = $element->get_settings();
            if ( $settings['use_parallax'] == 'yes' ) {
                $element->add_render_attribute('_wrapper', [
                    'data-parallax'     => 'scroll'
                ] );
            }
        } );
	    add_action('elementor/widget/render_content', function( $content, $widget ) {
            if ( 'google_maps' === $widget->get_name() ) {
                $content = str_replace(' frameborder="0"', '', $content);
                $content = str_replace(' scrolling="no"', '', $content);
                $content = str_replace(' marginheight="0"', '', $content);
                $content = str_replace(' marginwidth="0"', '', $content);
            }

            return $content;
        }, 10, 2 );
    }
});