<?php
/*
 * Created by Artureanec
*/

namespace AgrariUm\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class AgrariUm_Banner_Widget extends Widget_Base {

    public function get_name() {
        return 'agrarium_banner';
    }

    public function get_title() {
        return esc_html__('Banner', 'agrarium_plugin');
    }

    public function get_icon() {
        return 'eicon-banner';
    }

    public function get_categories() {
        return ['agrarium_widgets'];
    }

    protected function register_controls() {

        // ----------------------------- //
        // ---------- Content ---------- //
        // ----------------------------- //
        $this->start_controls_section(
            'section_image',
            [
                'label' => esc_html__('Banner', 'agrarium_plugin')
            ]
        );

//        $this->add_control(
//            'bg_image',
//            [
//                'label'     => esc_html__('Choose Background Image', 'agrarium_plugin'),
//                'type'      => Controls_Manager::MEDIA,
//                'default'   => [
//                    'url'       => Utils::get_placeholder_image_src(),
//                ]
//            ]
//        );
        $this->add_control(
            'banner_type',
            [
                'label'     => esc_html__('Banner Type', 'agrarium_plugin'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'type-1',
                'options'   => [
                    'type-1'   => esc_html__('Type 1', 'agrarium_plugin'),
                    'type-2'   => esc_html__('Type 2', 'agrarium_plugin')
                ],
                'separator' => 'after'
            ]
        );

        $this->add_group_control(
           Group_Control_Background::get_type(),
            [
                'name'      => 'bg_image',
                'label'     => esc_html__( 'Choose Background Image', 'agrarium_plugin' ),
                'types'     => [ 'classic', 'gradient' ],
                'selector'  => '{{WRAPPER}} .banner-inner .banner-bg',
            ]
        );

        $this->add_responsive_control(
            'banner_align',
            [
                'label'     => esc_html__('Banner Alignment', 'agrarium_plugin'),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'      => [
                        'title'     => esc_html__('Left', 'agrarium_plugin'),
                        'icon'      => 'fa fa-align-left',
                    ],
                    'center'    => [
                        'title'     => esc_html__('Center', 'agrarium_plugin'),
                        'icon'      => 'fa fa-align-center',
                    ],
                    'right'     => [
                        'title'     => esc_html__('Right', 'agrarium_plugin'),
                        'icon'      => 'fa fa-align-right',
                    ]
                ],
                'default'   => 'left',
                'selectors' => [
                    '{{WRAPPER}} .banner-content' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title',
            [
                'label'         => esc_html__('Title', 'agrarium_plugin'),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'Enter title', 'agrarium_plugin' ),
                'default'       => ''
            ]
        );

        $this->add_control(
            'subtitle',
            [
                'label'         => esc_html__('Subtitle', 'agrarium_plugin'),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'Enter subtitle', 'agrarium_plugin' ),
                'default'       => ''
            ]
        );

        $this->add_control(
            'description',
            [
                'label'         => esc_html__('Description', 'agrarium_plugin'),
                'type'          => Controls_Manager::TEXTAREA,
                'placeholder'   => esc_html__( 'Enter description', 'agrarium_plugin' ),
                'default'       => ''
            ]
        );

        $this->add_control(
            'additional_title',
            [
                'label'         => esc_html__('Additional Title', 'agrarium_plugin'),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'Enter title', 'agrarium_plugin' ),
                'default'       => '',
                'condition'     => [
                    'banner_type' => 'type-2'
                ],
                'separator'     => 'before'
            ]
        );
        $this->add_control(
            'overlay_title',
            [
                'label'         => esc_html__('Overlay Title', 'agrarium_plugin'),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'Enter title', 'agrarium_plugin' ),
                'default'       => '',
                'condition'     => [
                    'banner_type' => 'type-2'
                ]
            ]
        );

        $this->add_control(
            'overlay_status',
            [
                'label'         => esc_html__('Banner Overlay', 'agrarium_plugin'),
                'type'          => Controls_Manager::SWITCHER,
                'label_off'     => esc_html__('Off', 'agrarium_plugin'),
                'label_on'      => esc_html__('On', 'agrarium_plugin'),
                'default'       => 'no',
                'separator'     => 'before'
            ]
        );

        $this->add_control(
            'button_status',
            [
                'label'         => esc_html__('Banner Button', 'agrarium_plugin'),
                'type'          => Controls_Manager::SWITCHER,
                'label_off'     => esc_html__('Off', 'agrarium_plugin'),
                'label_on'      => esc_html__('On', 'agrarium_plugin'),
                'default'       => 'no',
                'separator'     => 'before'
            ]
        );

        $this->add_control(
            'banner_link',
            [
                'label'         => esc_html__('Banner Link', 'agrarium_plugin'),
                'type'          => Controls_Manager::URL,
                'label_block'   => true,
                'default'       => [
                    'url'           => '',
                    'is_external'   => 'true',
                ],
                'placeholder'   => esc_html__( 'http://your-link.com', 'agrarium_plugin' ),
                'condition'     => [
                    'button_status!' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label'     => esc_html__('Button Text', 'agrarium_plugin'),
                'type'      => Controls_Manager::TEXT,
                'default'   => esc_html__('Button', 'agrarium_plugin'),
                'condition' => [
                    'button_status' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'button_link',
            [
                'label'         => esc_html__('Button Link', 'agrarium_plugin'),
                'type'          => Controls_Manager::URL,
                'label_block'   => true,
                'default'       => [
                    'url'           => '',
                    'is_external'   => 'true',
                ],
                'placeholder'   => esc_html__( 'http://your-link.com', 'agrarium_plugin' ),
                'condition'     => [
                    'button_status' => 'yes'
                ]
            ]
        );

        $this->end_controls_section();

        // -------------------------------------- //
        // ---------- Content Settings ---------- //
        // -------------------------------------- //
        $this->start_controls_section(
            'section_content_settings',
            [
                'label' => esc_html__('Content Settings', 'agrarium_plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'banner_height',
            [
                'label'     => esc_html__('Banner height', 'agrarium_plugin'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px'        => [
                        'min'       => 0,
                        'max'       => 1000
                    ]
                ],
                'default'   => [
                    'unit'      => 'px',
                    'size'      => 360
                ],
                'selectors' => [
                    '{{WRAPPER}} .banner-inner' => 'height: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'banner_paddings',
            [
                'label'         => esc_html__('Banner paddings', 'agrarium_plugin'),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
                    '{{WRAPPER}} .banner-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]
        );
        $this->add_control(
            'banner_content_valign_center',
            [
                'label'         => esc_html__('Banner Content Vertical Align Center', 'agrarium_plugin'),
                'type'          => Controls_Manager::SWITCHER,
                'label_off'     => esc_html__('Off', 'agrarium_plugin'),
                'label_on'      => esc_html__('On', 'agrarium_plugin'),
                'default'       => '',
                'return_value'  => 'valign-center',
                'separator'     => 'after',
                'prefix_class'  => 'elementor-element-'
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'title_typography',
                'label'     => esc_html__('Title Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .banner-title'
            ]
        );

        $this->add_responsive_control(
            'title_margin',
            [
                'label'     => esc_html__('Space between title and subtitle', 'agrarium_plugin'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px'        => [
                        'min'       => -100,
                        'max'       => 100
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .banner-subtitle' => 'margin-top: {{SIZE}}{{UNIT}};'
                ],
                'separator' => 'after'
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'subtitle_typography',
                'label'     => esc_html__('Subtitle Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .banner-subtitle',
                'separator' => 'after'
            ]
        );

        $this->add_responsive_control(
            'subtitle_margin',
            [
                'label'     => esc_html__('Space between subtitle and description', 'agrarium_plugin'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px'        => [
                        'min'       => -50,
                        'max'       => 50
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .banner-description' => 'margin-top: {{SIZE}}{{UNIT}};'
                ],
                'separator' => 'after'
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'description_typography',
                'label'     => esc_html__('Description Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .banner-description',
                'separator' => 'after'
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'additional_title_typography',
                'label'     => esc_html__('Additional Title Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .additional-title',
                'separator' => 'after',
                'condition'     => [
                    'banner_type' => 'type-2'
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'overlay_title_typography',
                'label'     => esc_html__('Overlay Title Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .overlay-title',
                'condition'     => [
                    'banner_type' => 'type-2'
                ]
            ]
        );
        $this->add_responsive_control(
            'overlay_title_align',
            [
                'label'     => esc_html__('Overlay Title Alignment', 'agrarium_plugin'),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'      => [
                        'title'     => esc_html__('Left', 'agrarium_plugin'),
                        'icon'      => 'fa fa-align-left',
                    ],
                    'center'    => [
                        'title'     => esc_html__('Center', 'agrarium_plugin'),
                        'icon'      => 'fa fa-align-center',
                    ],
                    'right'     => [
                        'title'     => esc_html__('Right', 'agrarium_plugin'),
                        'icon'      => 'fa fa-align-right',
                    ]
                ],
                'default'   => 'left',
                'selectors' => [
                    '{{WRAPPER}} .banner-content .overlay-title' => 'text-align: {{VALUE}};',
                ],
                'condition' => [
                    'banner_type' => 'type-2'
                ]
            ]
        );
        $this->add_responsive_control(
            'overlay_title_margin',
            [
                'label' => esc_html__('Overlay Title Margin', 'agrarium_plugin'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .overlay-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                'condition' => [
                    'banner_type' => 'type-2'
                ]
            ]
        );

        $this->start_controls_tabs('content_settings_tabs');

            // ------------------------ //
            // ------ Normal Tab ------ //
            // ------------------------ //
            $this->start_controls_tab(
                'tab_content_normal',
                [
                    'label' => esc_html__('Normal', 'agrarium_plugin')
                ]
            );

                $this->add_control(
                    'title_color',
                    [
                        'label'     => esc_html__('Title Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .banner-title' => 'color: {{VALUE}};'
                        ],
                        'separator' => 'after'
                    ]
                );

                $this->add_control(
                    'subtitle_color',
                    [
                        'label'     => esc_html__('Subtitle Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .banner-subtitle' => 'color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'description_color',
                    [
                        'label'     => esc_html__('Description Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .banner-description' => 'color: {{VALUE}};'
                        ],
                        'separator' => 'before'
                    ]
                );
                $this->add_control(
                    'additional_title_color',
                    [
                        'label'     => esc_html__('Additional Title Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .additional-title' => 'color: {{VALUE}};'
                        ],
                        'separator' => 'before',
                        'condition'     => [
                            'banner_type' => 'type-2'
                        ]
                    ]
                );
                $this->add_control(
                    'overlay_title_color',
                    [
                        'label'     => esc_html__('Overlay Title Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .overlay-title' => 'color: {{VALUE}};'
                        ],
                        'separator' => 'before',
                        'condition'     => [
                            'banner_type' => 'type-2'
                        ]
                    ]
                );

            $this->end_controls_tab();

            // ----------------------- //
            // ------ Hover Tab ------ //
            // ----------------------- //
            $this->start_controls_tab(
                'tab_content_hover',
                [
                    'label' => esc_html__('Hover', 'agrarium_plugin')
                ]
            );

                $this->add_control(
                    'title_color_hover',
                    [
                        'label'     => esc_html__('Title Color on Hover', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}:hover .banner-title' => 'color: {{VALUE}};'
                        ],
                        'separator' => 'after'
                    ]
                );

                $this->add_control(
                    'subtitle_color_hover',
                    [
                        'label'     => esc_html__('Subtitle Color on Hover', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}:hover .banner-subtitle' => 'color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'description_color_hover',
                    [
                        'label'     => esc_html__('Description Color on Hover', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}:hover .banner-description' => 'color: {{VALUE}};'
                        ],
                        'separator' => 'before'
                    ]
                );
                $this->add_control(
                    'additional_title_color_hover',
                    [
                        'label'     => esc_html__('Additional Title Color on Hover', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}:hover .additional-title' => 'color: {{VALUE}};'
                        ],
                        'separator' => 'before'
                    ]
                );
                $this->add_control(
                    'overlay_title_color_hover',
                    [
                        'label'     => esc_html__('Overlay Title Color on Hover', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}:hover .overlay-title' => 'color: {{VALUE}};'
                        ],
                        'separator' => 'before'
                    ]
                );

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        // ------------------------------------ //
        // ---------- Overlay Settings ---------- //
        // ------------------------------------ //
        $this->start_controls_section(
            'section_overlay_settings',
            [
                'label'     => esc_html__('Overlay Settings', 'agrarium_plugin'),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'overlay_status' => 'yes'
                ]
            ]
        );

        $this->start_controls_tabs('overlay_settings_tabs');

            // ------------------------ //
            // ------ Normal Tab ------ //
            // ------------------------ //
            $this->start_controls_tab(
                'tab_overlay_normal',
                [
                    'label' => esc_html__('Normal', 'agrarium_plugin')
                ]
            );
            $this->add_group_control(
               Group_Control_Background::get_type(),
                [
                    'name'      => 'overlay_bg',
                    'label'     => esc_html__( 'Overlay Background Color', 'agrarium_plugin' ),
                    'types'     => [ 'color', 'gradient' ],
                    'selector'  => '{{WRAPPER}} .banner-overlay',
                    'condition' => [
                        'overlay_status' => 'yes'
                    ]
                ]
            );

            $this->end_controls_tab();

            // ----------------------- //
            // ------ Hover Tab ------ //
            // ----------------------- //
            $this->start_controls_tab(
                'tab_overlay_hover',
                [
                    'label' => esc_html__('Hover', 'agrarium_plugin')
                ]
            );
            $this->add_group_control(
               Group_Control_Background::get_type(),
                [
                    'name'      => 'overlay_bg_hover',
                    'label'     => esc_html__( 'Overlay Background Color on Hover', 'agrarium_plugin' ),
                    'types'     => [ 'color', 'gradient' ],
                    'selector'  => '{{WRAPPER}}:hover .banner-overlay',
                    'condition' => [
                        'overlay_status' => 'yes'
                    ]
                ]
            );

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        // ------------------------------------- //
        // ---------- Button Settings ---------- //
        // ------------------------------------- //
        $this->start_controls_section(
            'section_settings',
            [
                'label'     => esc_html__('Button Settings', 'agrarium_plugin'),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'button_status' => 'yes'
                ]
            ]
        );
        $this->add_control(
            'button_style',
            [
                'label'     => esc_html__('Button Style', 'agrarium_plugin'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'default',
                'options'   => [
                    'default'    => esc_html__('Default', 'agrarium_plugin'),
                    'underlined' => esc_html__('Underlined', 'agrarium_plugin')
                ],
                'separator' => 'after'
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'button_typography',
                'label'     => esc_html__('Button Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .agrarium-button'
            ]
        );

        $this->add_responsive_control(
            'button_margin',
            [
                'label'     => esc_html__('Space between content and button', 'agrarium_plugin'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px'        => [
                        'min'       => -100,
                        'max'       => 100
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .banner-button' => 'margin-top: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->start_controls_tabs('button_settings_tabs');

            // ------------------------ //
            // ------ Normal Tab ------ //
            // ------------------------ //
            $this->start_controls_tab(
                'tab_button_normal',
                [
                    'label' => esc_html__('Normal', 'agrarium_plugin')
                ]
            );

                $this->add_control(
                    'button_color',
                    [
                        'label'     => esc_html__('Button Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .agrarium-button' => 'color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'button_bg',
                    [
                        'label'     => esc_html__('Button Background', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .agrarium-button:after' => 'background-color: {{VALUE}};'
                        ],
                        'condition' => [
                            'button_style' => 'default'
                        ]
                    ]
                );

                $this->add_control(
                    'button_bd',
                    [
                        'label'     => esc_html__('Button Border', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .agrarium-button' => 'border-color: {{VALUE}};'
                        ],
                        'condition' => [
                            'button_style' => 'default'
                        ]
                    ]
                );
                $this->add_control(
                    'button_underlined_bg',
                    [
                        'label'     => esc_html__('Button Underline Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .banner-button.underline .agrarium-button:before' => 'background-color: {{VALUE}};'
                        ],
                        'condition' => [
                            'button_style' => 'underlined'
                        ]
                    ]
                );

            $this->end_controls_tab();

            // ----------------------- //
            // ------ Hover Tab ------ //
            // ----------------------- //
            $this->start_controls_tab(
                'tab_button_hover',
                [
                    'label' => esc_html__('Hover', 'agrarium_plugin')
                ]
            );

                $this->add_control(
                    'button_color_hover',
                    [
                        'label'     => esc_html__('Button Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .banner-button.underline .agrarium-button:hover' => 'color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'button_bg_hover',
                    [
                        'label'     => esc_html__('Button Background', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .agrarium-button:hover:after' => 'background-color: {{VALUE}};'
                        ],
                        'condition' => [
                            'button_style' => 'default'
                        ]
                    ]
                );

                $this->add_control(
                    'button_bd_hover',
                    [
                        'label'     => esc_html__('Button Border', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .agrarium-button:hover' => 'border-color: {{VALUE}};'
                        ],
                        'condition' => [
                            'button_style' => 'default'
                        ]
                    ]
                );
                $this->add_control(
                    'button_underlined_bg_hover',
                    [
                        'label'     => esc_html__('Button Underline Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .banner-button.underline .agrarium-button:hover:before' => 'background-color: {{VALUE}};'
                        ],
                        'condition' => [
                            'button_style' => 'underlined'
                        ]
                    ]
                );

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render() {
        $settings         = $this->get_settings();

        $title            = $settings['title'];
        $subtitle         = $settings['subtitle'];
        $description      = $settings['description'];
        $overlay_status   = $settings['overlay_status'];
        $additional_title = $settings['additional_title'];
        $overlay_title    = $settings['overlay_title'];
        $banner_type      = $settings['banner_type'];
        $button_style = $settings['button_style'];

        $button_status = $settings['button_status'];
        if ( $button_status == 'yes' ) {
            $button_text    = $settings['button_text'];
            $button_link    = $settings['button_link'];
            if ($button_link['url'] !== '') {
                $button_url = $button_link['url'];
            } else {
                $button_url = '#';
            }
        } else {
            $banner_link    = $settings['banner_link'];
        }

        // ------------------------------------ //
        // ---------- Widget Content ---------- //
        // ------------------------------------ //

        if ( !empty($banner_link['url']) && $button_status != 'yes' ) {
            $start_tag = '<a href="' . esc_url($banner_link['url']) . '" class="banner-inner"' . ($banner_link['is_external'] == true ? ' target="_blank"' : '') . ($banner_link['nofollow'] == 'on' ? ' rel="nofollow"' : '') . '>';
            $close_tag = '</a>';
        } else {
            $start_tag = '<span class="banner-inner">';
            $close_tag = '</span>';
        } 
        $banner_class = $banner_type;
        ?>        
        <div class="banner-widget banner-widget-<?php echo $banner_class?>">
            <?php            
            echo sprintf('%s', $start_tag);                
                echo '<span class="banner-bg"></span>';

                if ($overlay_status == 'yes') {
                    echo '<span class="banner-overlay"></span>';
                }

                echo '<span class="banner-content">';
                    if('type-2' === $banner_type && !empty($additional_title)) {
                        echo '<span class="additional-title">' . wp_kses($additional_title, array(
                            'br' => array(),
                            'strong' => array(),
                            'mark' => array(),
                            'b' => array(),
                            'i' => array(),
                            'em' => array(),
                            'span' => array()
                        )) . '</span>';
                    }
                    if (!empty($title)) {
                        echo '<span class="banner-title">' . wp_kses($title, array(
                            'br' => array(),
                            'strong' => array(),
                            'mark' => array(),
                            'b' => array(),
                            'i' => array(),
                            'em' => array(),
                            'span' => array()
                        )) . '</span>';
                    }

                    if (!empty($subtitle)) {
                        echo '<span class="banner-subtitle">' . wp_kses($subtitle, array(
                            'br' => array(),
                            'strong' => array(),
                            'mark' => array(),
                            'b' => array(),
                            'i' => array(),
                            'em' => array(),
                            'span' => array()
                        )) . '</span>';
                    }

                    if (!empty($description)) {
                        echo '<span class="banner-description">' . wp_kses($description, array(
                            'br' => array(),
                            'strong' => array(),
                            'mark' => array(),
                            'b' => array(),
                            'i' => array(),
                            'em' => array(),
                            'span' => array()
                        )) . '</span>';
                    }

                    if ( $button_status == 'yes' && !empty($button_text) ) {
                        $button_class = ('underlined' === $button_style) ? ' underline' : '';
                        echo '<span class="banner-button'. $button_class . '">';
                            echo '<a class="agrarium-button" href="' . esc_url($button_url) . '"' . (($button_link['is_external'] == true) ? ' target="_blank"' : '') . (($button_link['nofollow'] == 'on') ? ' rel="nofollow"' : '') . '>' . esc_html($button_text) . '</a>';
                        echo '</span>';
                    }
                    if('type-2' === $banner_type && !empty($overlay_title)) {
                        echo '<span class="overlay-title">' . wp_kses($overlay_title, array(
                            'br' => array(),
                            'strong' => array(),
                            'mark' => array(),
                            'b' => array(),
                            'i' => array(),
                            'em' => array(),
                            'span' => array()
                        )) . '</span>';
                    }
                echo '</span>';
            echo sprintf('%s', $close_tag);
            ?>
        </div>
        <?php
    }

    protected function content_template() {}

    public function render_plain_content() {}
}