<?php

/*
 * Created by Artureanec
*/

namespace AgrariUm\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class AgrariUm_Product_Category_Widget extends Widget_Base {

    public function get_name() {
        return 'agrarium_product_category';
    }

    public function get_title() {
        return esc_html__('Product Category', 'agrarium_plugin');
    }

    public function get_icon() {
        return 'eicon-product-categories';
    }

    public function get_categories() {
        return ['agrarium_widgets'];
    }

    public function get_script_depends() {
        return ['elementor_widgets'];
    }

    protected function register_controls() {

        // ----------------------------- //
        // ---------- Content ---------- //
        // ----------------------------- //
        $this->start_controls_section(
            'section_display_product_category',
            [
                'label' => esc_html__('Product Category', 'agrarium_plugin')
            ]
        );

        $cat_args = array(
            'orderby'    => 'name',
            'order'      => 'asc',
            'hide_empty' => false,
        );
        $product_categories = get_terms( 'product_cat', $cat_args );
        $category_arr       = [ '' => esc_attr__('None', 'agrarium_plugin') ];
        if( !empty($product_categories) ){
            foreach ($product_categories as $key => $category) {
                $category_arr[$category->term_taxonomy_id] = $category->name;
            }
        }
        $this->add_control(
            'category',
            [
                'label'         => esc_html__('Select Category', 'agrarium_plugin'),
                'type'          => Controls_Manager::SELECT,
                'options'       => $category_arr,
                'default'       => ''
            ]
        );

        $this->add_control(
            'image',
            [
                'label'     => esc_html__('Image', 'agrarium_plugin'),
                'type'      => Controls_Manager::MEDIA,
                'default'   => [
                    'url'       => Utils::get_placeholder_image_src(),
                ]
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label'       => esc_html__('Category Subtitle', 'agrarium_plugin'),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => esc_html__('Subtitle', 'agrarium_plugin'),
            ]
        );

        $this->end_controls_section();

        // ------------------------------------ //
        // ---------- Style Settings ---------- //
        // ------------------------------------ //
        $this->start_controls_section(
            'section_item_settings',
            [
                'label' => esc_html__('Product Category Settings', 'agrarium_plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'block_height',
            [
                'label'     => esc_html__('Block height', 'agrarium_plugin'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px'        => [
                        'min'       => 0,
                        'max'       => 1000
                    ]
                ],
                'default'   => [
                    'unit'      => 'px',
                    'size'      => 592
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-category-widget' => 'height: {{SIZE}}{{UNIT}};'
                ]
            ]
        );      

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'title_typography',
                'label'     => esc_html__('Title Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .product-category-widget .product-category-title'
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__('Title Color', 'agrarium_plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-category-widget .product-category-title' => 'color: {{VALUE}};'
                ]
            ]
        ); 
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'subtitle_typography',
                'label'     => esc_html__('Subtitle Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .product-category-widget .product-category-subtitle',
                'condition' => [
                    'subtitle!' => '' 
                ]
            ]
        );        

        $this->end_controls_section();

        $this->start_controls_section(
            'color_settings',
            [
                'label' => esc_html__('Subtitle Color Settings', 'agrarium_plugin'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'subtitle!' => '' 
                ]
            ]
        );        
        $this->start_controls_tabs('color_settings_tabs');

            // ------------------------ //
            // ------ Normal Tab ------ //
            // ------------------------ //
            $this->start_controls_tab(
                'tab_color_normal',
                [
                    'label' => esc_html__('Normal', 'agrarium_plugin')
                ]
            );
            $this->add_control(
                'subtitle_color',
                [
                    'label'     => esc_html__('Subtitle Color', 'agrarium_plugin'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .product-category-widget .product-category-subtitle' => 'color: {{VALUE}};'
                    ]
                ]
            );           
            $this->add_control(
                'subtitle_bg_color',
                [
                    'label'     => esc_html__('Subtitle Background Color', 'agrarium_plugin'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .product-category-widget .product-category-subtitle' => 'background-color: {{VALUE}};'
                    ]
                ]
            );

            $this->end_controls_tab();
            // ------------------------ //
            // ------ Hover Tab ------- //
            // ------------------------ //
            $this->start_controls_tab(
                'tab_color_hover',
                [
                    'label' => esc_html__('Hover', 'agrarium_plugin')
                ]
            );
            $this->add_control(
                'subtitle_color_hover',
                [
                    'label'     => esc_html__('Subtitle Hover Color', 'agrarium_plugin'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .product-category-widget .product-category-subtitle:hover' => 'color: {{VALUE}};'
                    ]
                ]
            );
            $this->add_control(
                'subtitle_bg_color_hover',
                [
                    'label'     => esc_html__('Subtitle Hover Background Color', 'agrarium_plugin'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .product-category-widget:hover .product-category-subtitle' => 'background-color: {{VALUE}};'
                    ]
                ]
            );

            $this->end_controls_tab();

        $this->end_controls_tabs();   

        $this->end_controls_section();        
    }

    protected function render() {
        $settings           = $this->get_settings();
        $image              = $settings['image'];
        $category           = $settings['category'];
        $subtitle           = $settings['subtitle'];

        $image_src          = $image['url'];
        $image_meta         = agrarium_get_attachment_meta($image['id']);
        $image_alt_text     = $image_meta['alt'];

        $product_category   = get_term( $category );
        $category_link      = get_term_link($product_category);

        // ------------------------------------ //
        // ---------- Widget Content ---------- //
        // ------------------------------------ //
        if ( !empty($category) ) {
            echo '<a href="' . esc_url($category_link) . '" class="product-category-widget">';
                if (!empty($image_src)) {
                    echo '<img class="product-category-image" src="' . esc_url($image_src) . '" alt="' . esc_attr($image_alt_text) . '" />';
                }
                echo '<span class="product-category-header">';
                    echo '<span class="product-category-title">' . esc_html($product_category->name) . '</span>';
                    if(!empty($subtitle)) {
                        echo '<span class="product-category-subtitle"><span>' . esc_html($subtitle) . '</span>';
                            echo '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="14" viewBox="0 0 20 14">
                                  <path data-name="Product Category Icon" class="cls-1" d="M19.999,8.30 L18.896,8.30 L13.20,14.13 L11.605,12.574 L16.68,8.30 L0.0,8.30 L0.0,5.968 L16.68,5.968 L11.605,1.424 L13.20,0.15 L18.896,5.968 L19.999,5.968 L19.999,8.30 Z"/>
                                </svg>'; 
                        echo '</span>';
                    }
                echo '</span>';
            echo '</a>';
        }
    }

    protected function content_template() {}

    public function render_plain_content() {}
}