<?php

/*
 * Created by Artureanec
*/

namespace AgrariUm\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class AgrariUm_Products_Widget extends Widget_Base {

    public function get_name() {
        return 'agrarium_products';
    }

    public function get_title() {
        return esc_html__('Products', 'agrarium_plugin');
    }

    public function get_icon() {
        return 'eicon-products';
    }

    public function is_reload_preview_required() {
        return true;
    }

    public function get_categories() {
        return ['agrarium_widgets'];
    }

    public function get_script_depends() {
        return ['elementor_widgets'];
    }

    protected function register_controls() {

        // ----------------------------- //
        // ---------- Content ---------- //
        // ----------------------------- //
        $this->start_controls_section(
            'section_display_product',
            [
                'label' => esc_html__('Display Product', 'agrarium_plugin')
            ]
        );

        $this->add_control(
            'view_style',
            [
                'label'   => esc_html__('View Style', 'agrarium_plugin'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'standard',
                'options' => [
                    'standard' => esc_html__('Standard', 'agrarium_plugin'),
                    'compact'  => esc_html__('Compact', 'agrarium_plugin')
                ]
            ]
        );

        $this->add_control(
            'products_type',
            [
                'label'   => esc_html__('Products Type', 'agrarium_plugin'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'all',
                'options' => [
                    'all'           => esc_html__('All', 'agrarium_plugin'),
                    'on_sale'       => esc_html__('On sale products', 'agrarium_plugin'),
                    'best_selling'  => esc_html__('The best selling products', 'agrarium_plugin'),
                    'top_rated'     => esc_html__('Top-rated products', 'agrarium_plugin')
                ]
            ]
        );

        $this->add_control(
            'limit',
            [
                'label'         => esc_html__('Limit', 'agrarium_plugin'),
                'description'   => esc_html__('The number of products to display', 'agrarium_plugin'),
                'type'          => Controls_Manager::NUMBER,
                'min'           => -1,
                'max'           => 50,
                'default'       => 4
            ]
        );

        $this->add_control(
            'columns',
            [
                'label'         => esc_html__('Columns', 'agrarium_plugin'),
                'description'   => esc_html__('The number of columns to display.', 'agrarium_plugin'),
                'type'          => Controls_Manager::NUMBER,
                'min'           => 1,
                'max'           => 6,
                'default'       => 4
            ]
        );

        $this->add_control(
            'paginate',
            [
                'label'         => esc_html__('Show Pagination', 'agrarium_plugin'),
                'description'   => esc_html__('Toggles pagination on. Use in conjunction with "limit"', 'agrarium_plugin'),
                'type'          => Controls_Manager::SWITCHER,
                'default'       => 'no',
                'label_off'     => esc_html__('Hide', 'agrarium_plugin'),
                'label_on'      => esc_html__('Show', 'agrarium_plugin')
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label'   => esc_html__('Orderby', 'agrarium_plugin'),
                'type'    => Controls_Manager::SELECT,
                'description' => esc_html__('Sorts the products displayed by the entered option.', 'agrarium_plugin'),
                'default' => 'date',
                'options' => [
                    'date'        => esc_html__('Date', 'agrarium_plugin'),
                    'id'          => esc_html__('ID', 'agrarium_plugin'),
                    'menu_order'  => esc_html__('Menu order', 'agrarium_plugin'),
                    'popularity'  => esc_html__('Popularity', 'agrarium_plugin'),
                    'rand'        => esc_html__('Random', 'agrarium_plugin'),
                    'rating'      => esc_html__('Rating', 'agrarium_plugin'),
                    'title'       => esc_html__('Title', 'agrarium_plugin')
                ]
            ]
        );

        $this->add_control(
            'order',
            [
                'label'   => esc_html__('Order', 'agrarium_plugin'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => [
                    'ASC'        => esc_html__('ASC', 'agrarium_plugin'),
                    'DESC'       => esc_html__('DESC', 'agrarium_plugin')
                ]
            ]
        );

        $cat_args = array(
            'orderby'    => 'name',
            'order'      => 'asc',
            'hide_empty' => false,
        );
        $product_categories = get_terms( 'product_cat', $cat_args );
        $category_arr = [];
        if( !empty($product_categories) ){
            foreach ($product_categories as $key => $category) {
                $category_arr[$category->slug] = $category->name;
            }
        }
        $this->add_control(
            'category',
            [
                'label'         => esc_html__('Categories', 'agrarium_plugin'),
                'label_block'   => true,
                'type'          => Controls_Manager::SELECT2,
                'multiple'      => true,
                'description'   => esc_html__('List of categories.', 'agrarium_plugin'),
                'options'       => $category_arr
            ]
        );

        $this->add_control(
            'skus',
            [
                'label'         => esc_html__('SKUs', 'agrarium_plugin'),
                'label_block'   => true,
                'description'   => esc_html__('Comma-separated list of product SKUs.', 'agrarium_plugin'),
                'type'          => Controls_Manager::TEXTAREA,
                'placeholder'   => esc_html__( 'Enter SKU list', 'agrarium_plugin' )
            ]
        );

        $this->add_control(
            'tag',
            [
                'label'         => esc_html__('Tags', 'agrarium_plugin'),
                'label_block'   => true,
                'description'   => esc_html__('Comma-separated list of tag slugs.', 'agrarium_plugin'),
                'type'          => Controls_Manager::TEXTAREA,
                'placeholder'   => esc_html__( 'Enter tags list', 'agrarium_plugin' )
            ]
        );

        $this->end_controls_section();

        // ----------------------------------- //
        // ---------- Item Settings ---------- //
        // ----------------------------------- //
        $this->start_controls_section(
            'section_item_settings',
            [
                'label' => esc_html__('Product Item Settings', 'agrarium_plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->start_controls_tabs('item_settings_tabs');

            // ------------------------ //
            // ------ Normal Tab ------ //
            // ------------------------ //
            $this->start_controls_tab(
                'tab_item_normal',
                [
                    'label' => esc_html__('Normal', 'agrarium_plugin')
                ]
            );

                $this->add_control(
                    'border_color',
                    [
                        'label'     => esc_html__('Border Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .products-widget ul.products li.product .woocommerce-loop-product__wrapper .attachment-woocommerce_wrapper' => 'border-color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();

            // ----------------------- //
            // ------ Hover Tab ------ //
            // ----------------------- //
            $this->start_controls_tab(
                'tab_item_hover',
                [
                    'label' => esc_html__('Hover', 'agrarium_plugin')
                ]
            );

                $this->add_control(
                    'border_hover',
                    [
                        'label'     => esc_html__('Border Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .products-widget ul.products li.product .woocommerce-loop-product__wrapper:hover .attachment-woocommerce_wrapper' => 'border-color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();



        // -------------------------------------- //
        // ---------- Content Settings ---------- //
        // -------------------------------------- //
        $this->start_controls_section(
            'section_content_settings',
            [
                'label' => esc_html__('Product Content Settings', 'agrarium_plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'title_typography',
                'label'     => esc_html__('Title Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .products-widget ul.products li.product .woocommerce-loop-product__wrapper .content-woocommerce-wrapper .woocommerce-loop-product-title, {{WRAPPER}} .products-widget ul.products li.product .woocommerce-loop-product__wrapper .content-woocommerce-wrapper h3'
            ]
        );

        $this->start_controls_tabs('title_settings_tabs' );

            // ------------------------ //
            // ------ Normal Tab ------ //
            // ------------------------ //
            $this->start_controls_tab(
                'tab_title_normal',
                [
                    'label' => esc_html__('Normal', 'agrarium_plugin')
                ]
            );

            $this->add_control(
                'title_color',
                [
                    'label'     => esc_html__('Title Color', 'agrarium_plugin'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .products-widget ul.products li.product .woocommerce-loop-product__wrapper .content-woocommerce-wrapper .woocommerce-loop-product-title, {{WRAPPER}} .products-widget ul.products li.product .woocommerce-loop-product__wrapper .content-woocommerce-wrapper h3, {{WRAPPER}} .products-widget ul.products li.product .woocommerce-loop-product__wrapper .content-woocommerce-wrapper .woocommerce-loop-product-title a, {{WRAPPER}} .products-widget ul.products li.product .woocommerce-loop-product__wrapper .content-woocommerce-wrapper h3 a' => 'color: {{VALUE}};'
                    ],
                    'separator' => 'after'
                ]
            );

            $this->end_controls_tab();

            // ----------------------- //
            // ------ Hover Tab ------ //
            // ----------------------- //
            $this->start_controls_tab(
                'tab_title_hover',
                [
                    'label' => esc_html__('Hover', 'agrarium_plugin')
                ]
            );

            $this->add_control(
                'title_hover',
                [
                    'label'     => esc_html__('Title Hover', 'agrarium_plugin'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .products-widget ul.products li.product .woocommerce-loop-product__wrapper .content-woocommerce-wrapper .woocommerce-loop-product-title a:hover, {{WRAPPER}} .products-widget ul.products li.product .woocommerce-loop-product__wrapper .content-woocommerce-wrapper h3 a:hover' => 'color: {{VALUE}};'
                    ],
                    'separator' => 'after'
                ]
            );

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'price_typography',
                'label'     => esc_html__('Price Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .products .product .woocommerce-loop-product__wrapper .content-woocommerce-wrapper .price',
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'current_price_color',
            [
                'label'     => esc_html__('Current Price Color', 'agrarium_plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ul.products li.product .price' => 'color: {{VALUE}};',
                    '{{WRAPPER}} ul.products li.product .woocommerce-loop-product__wrapper .content-woocommerce-wrapper .price ins' => 'color: {{VALUE}};',
                    '{{WRAPPER}} ul.products li.product .woocommerce-loop-product__wrapper .content-woocommerce-wrapper .price .price_wrapper > .amount' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'old_price_color',
            [
                'label'     => esc_html__('Old Price Color', 'agrarium_plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ul.products li.product .woocommerce-loop-product__wrapper .content-woocommerce-wrapper .price del' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'rating_default_color',
            [
                'label'     => esc_html__('Rating Inactive Color', 'agrarium_plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .star-rating:before' => 'color: {{VALUE}};'
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'rating_active_color',
            [
                'label'     => esc_html__('Rating Active Color', 'agrarium_plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .star-rating span' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();



        // ------------------------------------- //
        // ---------- Button Settings ---------- //
        // ------------------------------------- //
        $this->start_controls_section(
            'section_button_settings',
            [
                'label' => esc_html__('Product Button Settings', 'agrarium_plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'button_typography',
                'label'     => esc_html__('Button Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} ul.products li.product .woocommerce-loop-product__wrapper .attachment-woocommerce_wrapper .product-buttons-wrapper a.button, {{WRAPPER}} ul.products li.product .woocommerce-loop-product__wrapper .attachment-woocommerce_wrapper .product-buttons-wrapper a.added_to_cart'
            ]
        );

        $this->start_controls_tabs('button_settings_tabs');

            // ------------------------ //
            // ------ Normal Tab ------ //
            // ------------------------ //
            $this->start_controls_tab(
                'tab_button_normal',
                [
                    'label' => esc_html__('Normal', 'agrarium_plugin')
                ]
            );

                $this->add_control(
                    'button_color',
                    [
                        'label'     => esc_html__('Button Text Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} ul.products li.product .woocommerce-loop-product__wrapper .attachment-woocommerce_wrapper .product-buttons-wrapper a.button, {{WRAPPER}} ul.products li.product .woocommerce-loop-product__wrapper .attachment-woocommerce_wrapper .product-buttons-wrapper a.added_to_cart' => 'color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'button_bg_color',
                    [
                        'label'     => esc_html__('Button Background Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} ul.products li.product .woocommerce-loop-product__wrapper .attachment-woocommerce_wrapper .product-buttons-wrapper a.button:after, {{WRAPPER}} ul.products li.product .woocommerce-loop-product__wrapper .attachment-woocommerce_wrapper .product-buttons-wrapper a.added_to_cart:after' => 'background-color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'button_bd_color',
                    [
                        'label'     => esc_html__('Button Border Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} ul.products li.product .woocommerce-loop-product__wrapper .attachment-woocommerce_wrapper .product-buttons-wrapper a.button, {{WRAPPER}} ul.products li.product .woocommerce-loop-product__wrapper .attachment-woocommerce_wrapper .product-buttons-wrapper a.added_to_cart' => 'border-color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();

            // ----------------------- //
            // ------ Hover Tab ------ //
            // ----------------------- //
            $this->start_controls_tab(
                'tab_button_hover',
                [
                    'label' => esc_html__('Hover', 'agrarium_plugin')
                ]
            );

                $this->add_control(
                    'button_hover_color',
                    [
                        'label'     => esc_html__('Button Text Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} ul.products li.product .woocommerce-loop-product__wrapper .attachment-woocommerce_wrapper .product-buttons-wrapper a.button:hover, {{WRAPPER}} ul.products li.product .woocommerce-loop-product__wrapper .attachment-woocommerce_wrapper .product-buttons-wrapper a.added_to_cart:hover' => 'color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'button_hover_bg_color',
                    [
                        'label'     => esc_html__('Button Background Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} ul.products li.product .woocommerce-loop-product__wrapper .attachment-woocommerce_wrapper .product-buttons-wrapper a.button:hover:after, {{WRAPPER}} ul.products li.product .woocommerce-loop-product__wrapper .attachment-woocommerce_wrapper .product-buttons-wrapper a.added_to_cart:hover:after' => 'background-color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'button_hover_bd_color',
                    [
                        'label'     => esc_html__('Button Border Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} ul.products li.product .woocommerce-loop-product__wrapper .attachment-woocommerce_wrapper .product-buttons-wrapper a.button:hover, {{WRAPPER}} ul.products li.product .woocommerce-loop-product__wrapper .attachment-woocommerce_wrapper .product-buttons-wrapper a.added_to_cart:hover' => 'border-color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render() {
        $settings       = $this->get_settings();
        $view_style     = $settings['view_style'];

        $products_type = $settings['products_type'];

        $limit      = $settings['limit'];
        $columns    = $settings['columns'];
        $paginate   = $settings['paginate'];
        $orderby    = $settings['orderby'];
        $order      = $settings['order'];
        $category   = (!empty($settings['category']) ? implode(',', $settings['category']) : '');
        $skus       = $settings['skus'];
        $tag        = $settings['tag'];

        $classes    = (!empty($view_style) ? ' view-type-' . esc_attr($view_style) : '');

        // ------------------------------------ //
        // ---------- Widget Content ---------- //
        // ------------------------------------ //
        ?>
        <div class="products-widget<?php echo esc_attr($classes); ?>">
            <?php
                $atts = array(
                    'limit'          => $limit,
                    'columns'        => $columns,
                    'orderby'        => $orderby,
                    'order'          => $order,
                    'skus'           => $skus,
                    'category'       => $category,
                    'tag'            => $tag,
                    'visibility'     => 'visible',
                    'class'          => 'agrarium_shop_loop',
                    'page'           => 1,
                    'paginate'       => $paginate
                );

                $type = 'products';
                if ( $products_type == 'on_sale' ) {
                    $atts['on_sale'] = 'true';
                    $type = 'sale_products';
                } elseif ( $products_type == 'best_selling' ) {
                    $atts['best_selling'] = 'true';
                    $type = 'best_selling_products';
                } elseif ( $products_type == 'top_rated' ) {
                    $atts['top_rated'] = 'true';
                    $type = 'top_rated_products';
                }

                $shortcode = new \WC_Shortcode_Products( $atts, $type );

                echo $shortcode->get_content();
            ?>
        </div>
        <?php
    }

    protected function content_template() {}

    public function render_plain_content() {}
}
