<?php
/*
 * Created by Artureanec
*/

namespace AgrariUm\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\REPEATER;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class AgrariUm_Services_Listing_Widget extends Widget_Base {

    public function get_name() {
        return 'agrarium_services_listing';
    }

    public function get_title() {
        return esc_html__('Services Listing', 'agrarium_plugin');
    }

    public function get_icon() {
        return 'eicon-icon-box';
    }

    public function get_categories() {
        return ['agrarium_widgets'];
    }

    public function get_script_depends() {
        return ['elementor_widgets'];
    }

    protected function register_controls() {

        // ----------------------------- //
        // ---------- Content ---------- //
        // ----------------------------- //
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Services Listing', 'agrarium_plugin')
            ]
        );

        $this->add_control(
            'columns_number',
            [
                'label'     => esc_html__('Columns Number', 'agrarium_plugin'),
                'type'      => Controls_Manager::NUMBER,
                'default'   => 3,
                'min'       => 2,
                'max'       => 4
            ]
        );

        $this->add_control(
            'excerpt_length',
            [
                'label'     => esc_html__('Excerpt Length', 'agrarium_plugin'),
                'type'      => Controls_Manager::NUMBER,
                'default'   => 50,
                'min'       => 0
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'service_item',
            [
                'label'         => esc_html__('Choose Services', 'agrarium_plugin'),
                'type'          => Controls_Manager::SELECT2,
                'options'       => agrarium_get_all_post_list('agrarium_service'),
                'label_block'   => true,
                'multiple'      => false
            ]
        );

        $this->add_control(
            'services',
            [
                'label'         => esc_html__('Select Services', 'agrarium_plugin'),
                'type'          => Controls_Manager::REPEATER,
                'fields'        => $repeater->get_controls(),
                'prevent_empty' => false,
                'separator'     => 'before'
            ]
        );

        $this->add_responsive_control(
            'services_align',
            [
                'label'         => esc_html__('Alignment', 'agrarium_plugin'),
                'type'          => Controls_Manager::CHOOSE,
                'options'       => [
                    'left'          => [
                        'title'         => esc_html__('Left', 'agrarium_plugin'),
                        'icon'          => 'fa fa-align-left',
                    ],
                    'center'        => [
                        'title'         => esc_html__('Center', 'agrarium_plugin'),
                        'icon'          => 'fa fa-align-center',
                    ],
                    'right'         => [
                        'title'         => esc_html__('Right', 'agrarium_plugin'),
                        'icon'          => 'fa fa-align-right',
                    ]
                ],
                'default'       => 'left',
                'selectors'     => [
                    '{{WRAPPER}} .service-item' => 'text-align: {{VALUE}};',
                ],
                'separator'     => 'before'
            ]
        );

        $this->end_controls_section();


        // ------------------------------------ //
        // ---------- Style Settings ---------- //
        // ------------------------------------ //
        $this->start_controls_section(
            'style_settings_section',
            [
                'label' => esc_html__('Style Settings', 'agrarium_plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'title_typography',
                'label'     => esc_html__('Title Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .service-item .service-post-title'
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'excerpt_typography',
                'label'     => esc_html__('Excerpt Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .service-item .service-item-excerpt'
            ]
        );

        $this->add_responsive_control(
            'service_icon_size',
            [
                'label'     => esc_html__('Icon Size', 'agrarium_plugin'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px'        => [
                        'min'       => 10,
                        'max'       => 280
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-item .service-icon' => 'font-size: {{SIZE}}{{UNIT}};'
                ],
                'separator' => 'before'
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'color_settings_section',
            [
                'label' => esc_html__('Color Settings', 'agrarium_plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->start_controls_tabs('style_colors_tabs');
            // ------ Normal Tab ------ //
            $this->start_controls_tab(
                'tab_style_colors_normal',
                [
                    'label' => esc_html__('Normal', 'agrarium_plugin')
                ]
            );

                $this->add_control(
                    'service_border_color',
                    [
                        'label'     => esc_html__('Border Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .service-item' => 'border-color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'service_background_color',
                    [
                        'label'     => esc_html__('Background Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .service-item' => 'background-color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'service_title_color',
                    [
                        'label'     => esc_html__('Title Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .service-item .service-post-title a' => 'color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'service_excerpt_color',
                    [
                        'label'     => esc_html__('Excerpt Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .service-item .service-item-excerpt' => 'color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                        'name'      => 'service_shadow',
                        'label'     => esc_html__('Item Shadow', 'agrarium_plugin'),
                        'selector'  => '{{WRAPPER}} .service-item'
                    ]
                );

            $this->end_controls_tab();

            // ------ Hover Tab ------ //
            $this->start_controls_tab(
                'tab_style_colors_hover',
                [
                    'label' => esc_html__('Hover', 'agrarium_plugin')
                ]
            );

                $this->add_control(
                    'service_border_hover',
                    [
                        'label'     => esc_html__('Border Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .service-item:hover' => 'border-color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'service_background_hover',
                    [
                        'label'     => esc_html__('Background Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .service-item:hover' => 'background-color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'service_title_hover',
                    [
                        'label'     => esc_html__('Title Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .service-item:hover .service-post-title a' => 'color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'service_excerpt_hover',
                    [
                        'label'     => esc_html__('Excerpt Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .service-item:hover .service-item-excerpt' => 'color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                        'name'      => 'service_hover_shadow',
                        'label'     => esc_html__('Item Shadow', 'agrarium_plugin'),
                        'selector'  => '{{WRAPPER}} .service-item:hover'
                    ]
                );

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render() {
        $settings       = $this->get_settings();

        $columns_number     = $settings['columns_number'];
        $excerpt_length     = $settings['excerpt_length'];
        $selected_services  = $settings['services'];
        $services_ids       = [];

        foreach ( $selected_services as $item ) {
            $services_ids[] = $item['service_item'];
        }

        $query = new \WP_Query( [
            'post_type'             => 'agrarium_service',
            'post__in'              => $services_ids,
            'posts_per_page'        => -1,
            'ignore_sticky_posts'   => true,
            'suppress_filters'      => true
        ] );

        // ------------------------------------ //
        // ---------- Widget Content ---------- //
        // ------------------------------------ //
        ?>
            <div class="archive-listing">
                <div class="archive-listing-wrapper service-listing-wrapper service-grid-listing columns-<?php echo esc_attr($columns_number); ?>">
                    <?php
                        while( $query->have_posts() ){
                            $query->the_post();
                            get_template_part('content', 'agrarium_service', array('excerpt_length' => $excerpt_length));
                        };
                        wp_reset_postdata();
                    ?>
                </div>
            </div>
        <?php
    }

    protected function content_template() {}

    public function render_plain_content() {}
}