<?php
/*
 * Created by Artureanec
*/

namespace AgrariUm\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\REPEATER;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class AgrariUm_Testimonial_Carousel_Widget extends Widget_Base {

    public function get_name() {
        return 'agrarium_testimonial_carousel';
    }

    public function get_title() {
        return esc_html__('Testimonial Carousel', 'agrarium_plugin');
    }

    public function get_icon() {
        return 'eicon-testimonial-carousel';
    }

    public function get_categories() {
        return ['agrarium_widgets'];
    }

    public function get_script_depends() {
        return ['elementor_widgets'];
    }

    protected function register_controls() {

        // ----------------------------- //
        // ---------- Content ---------- //
        // ----------------------------- //
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Testimonial Carousel', 'agrarium_plugin')
            ]
        );

//        $this->add_control(
//            'view_type',
//            [
//                'label'     => esc_html__('View Type', 'agrarium_plugin'),
//                'type'      => Controls_Manager::SELECT,
//                'default'   => 'type-1',
//                'options'   => [
//                    'type-1'    => esc_html__('Type 1', 'agrarium_plugin'),
//                    'type-2'    => esc_html__('Type 2', 'agrarium_plugin'),
//                    'type-3'    => esc_html__('Type 3', 'agrarium_plugin'),
//                    'type-4'    => esc_html__('Type 4', 'agrarium_plugin')
//                ]
//            ]
//        );

//        $this->add_control(
//            'title',
//            [
//                'label'         => esc_html__('Carousel Title', 'agrarium_plugin'),
//                'type'          => Controls_Manager::TEXT,
//                'placeholder'   => esc_html__('Enter Title', 'agrarium_plugin'),
//                'default'       => '',
//                'condition'     => [
//                    'view_type'     => ['type-2', 'type-3', 'type-4']
//                ]
//            ]
//        );

//        $this->add_control(
//            'subtitle',
//            [
//                'label'         => esc_html__('Carousel Subtitle', 'agrarium_plugin'),
//                'type'          => Controls_Manager::TEXT,
//                'placeholder'   => esc_html__('Enter Subtitle', 'agrarium_plugin'),
//                'default'       => '',
//                'condition'     => [
//                    'view_type'     => ['type-3', 'type-4']
//                ]
//            ]
//        );

        $repeater = new Repeater();

        $repeater->add_control(
            'testimonial',
            [
                'label'         => esc_html__('Testimonial Text', 'agrarium_plugin'),
                'type'          => Controls_Manager::WYSIWYG,
                'rows'          => '10',
                'default'       => '',
                'placeholder'   => esc_html__('Enter Testimonial Text', 'agrarium_plugin'),
                'separator'     => 'before'
            ]
        );

        $repeater->add_control(
            'photo',
            [
                'label'     => esc_html__( 'Choose Author Photo', 'agrarium_plugin' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic'   => [
                    'active'    => true,
                ],
            ]
        );

        $repeater->add_control(
            'name',
            [
                'label'         => esc_html__('Author Name', 'agrarium_plugin'),
                'type'          => Controls_Manager::TEXT,
                'label_block'   => true,
                'default'       => ''
            ]
        );

        $repeater->add_control(
            'position',
            [
                'label'         => esc_html__('Author Position', 'agrarium_plugin'),
                'type'          => Controls_Manager::TEXT,
                'label_block'   => true,
                'default'       => ''
            ]
        );

        $this->add_control(
            'testimonials_items',
            [
                'label'         => esc_html__('Testimonials', 'agrarium_plugin'),
                'type'          => Controls_Manager::REPEATER,
                'fields'        => $repeater->get_controls(),
                'title_field'   => '{{{name}}}',
                'prevent_empty' => false,
                'separator'     => 'before'
            ]
        );

        $this->end_controls_section();

        // ---------------------------- //
        // ---------- Slider ---------- //
        // ---------------------------- //
        $this->start_controls_section(
            'section_slider',
            [
                'label' => esc_html__('Slider Settings', 'agrarium_plugin')
            ]
        );

        $this->add_control(
            'columns_number',
            [
                'label'     => esc_html__('Columns Number', 'agrarium_plugin'),
                'type'      => Controls_Manager::NUMBER,
                'default'   => 3,
                'min'       => 1,
                'max'       => 6
            ]
        );

        $this->add_control(
            'speed',
            [
                'label'     => esc_html__('Animation Speed', 'agrarium_plugin'),
                'type'      => Controls_Manager::NUMBER,
                'default'   => 500,
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'infinite',
            [
                'label'     => esc_html__('Infinite Loop', 'agrarium_plugin'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'yes',
                'options'   => [
                    'yes'       => esc_html__('Yes', 'agrarium_plugin'),
                    'no'        => esc_html__('No', 'agrarium_plugin'),
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label'     => esc_html__('Autoplay', 'agrarium_plugin'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'yes',
                'options'   => [
                    'yes'       => esc_html__('Yes', 'agrarium_plugin'),
                    'no'        => esc_html__('No', 'agrarium_plugin'),
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'autoplay_speed',
            [
                'label'     => esc_html__('Autoplay Speed', 'agrarium_plugin'),
                'type'      => Controls_Manager::NUMBER,
                'default'   => 300,
                'step'      => 100,
                'condition' => [
                    'autoplay'  => 'yes'
                ]
            ]
        );

        $this->add_control(
            'autoplay_timeout',
            [
                'label'     => esc_html__('Autoplay Timeout', 'agrarium_plugin'),
                'type'      => Controls_Manager::NUMBER,
                'default'   => 5000,
                'step'      => 100,
                'condition' => [
                    'autoplay'  => 'yes'
                ]
            ]
        );

        $this->add_control(
            'pause_on_hover',
            [
                'label'     => esc_html__('Pause on Hover', 'agrarium_plugin'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'yes',
                'options'   => [
                    'yes'       => esc_html__('Yes', 'agrarium_plugin'),
                    'no'        => esc_html__('No', 'agrarium_plugin'),
                ],
                'condition' => [
                    'autoplay'  => 'yes'
                ]
            ]
        );

        $this->end_controls_section();

        // ----------------------------------------- //
        // ---------- Pagination Settings ---------- //
        // ----------------------------------------- //
        $this->start_controls_section(
            'section_pagination_settings',
            [
                'label' => esc_html__('Pagination Settings', 'agrarium_plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->start_controls_tabs('button_settings_tabs');

            // ------------------------ //
            // ------ Normal Tab ------ //
            // ------------------------ //
            $this->start_controls_tab(
                'pagination_normal',
                [
                    'label' => esc_html__('Normal', 'agrarium_plugin')
                ]
            );

                $this->add_control(
                    'dot_color',
                    [
                        'label'     => esc_html__('Pagination Dot Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .owl-dots .owl-dot span:after' => 'border-color: {{VALUE}}; background-color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'dot_border',
                    [
                        'label'     => esc_html__('Pagination Dot Border', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .owl-dots .owl-dot span' => 'border-color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();

            // ------------------------ //
            // ------ Active Tab ------ //
            // ------------------------ //
            $this->start_controls_tab(
                'pagination_active',
                [
                    'label' => esc_html__('Active', 'agrarium_plugin')
                ]
            );

                $this->add_control(
                    'dot_active',
                    [
                        'label'     => esc_html__('Pagination Active Dot Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .owl-dots .owl-dot.active span:after' => 'border-color: {{VALUE}}; background-color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'dot_border_active',
                    [
                        'label'     => esc_html__('Pagination Active Dot Border', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .owl-dots .owl-dot.active span' => 'border-color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        // -------------------------------------- //
        // ---------- Content Settings ---------- //
        // -------------------------------------- //
        $this->start_controls_section(
            'section_content_settings',
            [
                'label' => esc_html__('Content Settings', 'agrarium_plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'text_typography',
                'label'     => esc_html__('Testimonial Text Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .testimonial-item .testimonial',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label'     => esc_html__('Testimonial Text Color', 'agrarium_plugin'),
                'type'      => Controls_Manager::COLOR,
                'separator' => 'after',
                'selectors' => [
                    '{{WRAPPER}} .testimonial-item .testimonial' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'author_typography',
                'label'     => esc_html__('Author Name Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .author-name',
            ]
        );

        $this->add_control(
            'author_color',
            [
                'label'     => esc_html__('Author Name Color', 'agrarium_plugin'),
                'type'      => Controls_Manager::COLOR,
                'separator' => 'after',
                'selectors' => [
                    '{{WRAPPER}} .author-name' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'position_typography',
                'label'     => esc_html__('Author Position Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .author-position',
            ]
        );

        $this->add_control(
            'position_color',
            [
                'label'     => esc_html__('Author Position Color', 'agrarium_plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .author-position' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings           = $this->get_settings();

        $columns_number     = $settings['columns_number'];
        $testimonials_items = $settings['testimonials_items'];
        $widget_id          = $this->get_id();

        $slider_options = [
            'items'                 => !empty($columns_number) ? (int)$columns_number : 1,
            'autoplayHoverPause'    => ('yes' === $settings['pause_on_hover']),
            'autoplay'              => ('yes' === $settings['autoplay']),
            'autoplaySpeed'         => absint($settings['autoplay_speed']),
            'autoplayTimeout'       => absint($settings['autoplay_timeout']),
            'loop'                  => ('yes' === $settings['infinite']),
            'speed'                 => absint($settings['speed']),
            'dotsContainer'         => !empty($widget_id) ? '.owl-dots-' . esc_attr($widget_id) : false
        ];

        // ------------------------------------ //
        // ---------- Widget Content ---------- //
        // ------------------------------------ //
        ?>

        <div class="agrarium-testimonial-carousel-widget">
            <div class="testimonial-carousel-wrapper">

                <div class="testimonials-slider-container">
                    <div class="testimonials-slider owl-carousel owl-theme" data-slider-options="<?php echo esc_attr(wp_json_encode($slider_options)); ?>">
                        <?php

                            foreach ($testimonials_items as $item) {
                                $image_src = wp_get_attachment_image_url($item['photo']['id'], array(133, 215));
                                $image_alt_text = get_post_meta(get_post_thumbnail_id($item['photo']['id']), '_wp_attachment_image_alt', true);

                                $image = '<img src="' . esc_url($image_src) . '" alt="' . esc_attr($image_alt_text) . '" >';

                                echo '<div class="testimonial-item slider-item">';
                                    echo '<div class="author-container">';
                                        if ( !empty($item['photo']['url']) && !empty($image) ) {
                                            echo '<div class="testimonial-photo">';
                                                echo wp_kses($image, array(
                                                    'img' => array(
                                                        'src' => true,
                                                        'alt' => true
                                                    )
                                                ));
                                            echo '</div>';
                                        }                                        
                                    echo '</div>';
                                        echo '<div class="testimonial-wrapper">';
                                        echo ( !empty($item['testimonial']) ? '<div class="testimonial">' . agrarium_output_code($item['testimonial']) . '</div>' : '' );
                                        echo '<div class="author-info">';
                                            echo ( !empty($item['name']) ? '<div class="author-name">' . esc_html($item['name']) . '</div>' : '' );
                                            echo ( !empty($item['position']) ? ',&nbsp;<div class="author-position">' . esc_html($item['position']) . '</div>' : '' );
                                        echo '</div>';
                                    echo '</div>';
                                echo '</div>';
                            }
                        ?>
                    </div>
                </div>
                <?php
                    echo '<div class="owl-dots' . ( !empty($widget_id) ? ' owl-dots-' . esc_attr($widget_id) : '' ) . '"></div>';
                ?>
            </div>
        </div>

        <?php
    }

    protected function content_template() {}

    public function render_plain_content() {}
}