<?php

/*
 * Created by Artureanec
*/

namespace AgrariUm\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class AgrariUm_Video_Button_Widget extends Widget_Base {

    public function get_name() {
        return 'agrarium_video_button';
    }

    public function get_title() {
        return esc_html__('Video Button', 'agrarium_plugin');
    }

    public function get_icon() {
        return 'eicon-play';
    }

    public function get_categories() {
        return ['agrarium_widgets'];
    }

    public function get_script_depends() {
        return ['video_widget'];
    }

    protected function register_controls() {

        // ----------------------------- //
        // ---------- Content ---------- //
        // ----------------------------- //
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Video', 'agrarium_plugin')
            ]
        );
        $this->add_control(
            'video_type',
            [
                'label' => esc_html__( 'Source', 'agrarium_plugin' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'youtube',
                'options' => [
                    'youtube' => esc_html__( 'YouTube', 'elementor' ),
                    'hosted' => esc_html__( 'Self Hosted', 'elementor' ),
                ],
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'youtube_url',
            [
                'label' => esc_html__('Enter YouTube Link(Embed)', 'agrarium_plugin'),
                'type' => Controls_Manager::TEXT,
                'placeholder' => '',
                'default' => 'https://www.youtube.com/embed/XHOmBV4js_E',                
                'condition' => [
                    'video_type' => 'youtube',
                ],
            ]
        );
        $this->add_control(
            'insert_url',
            [
                'label' => esc_html__( 'External URL', 'elementor' ),
                'type' => Controls_Manager::SWITCHER,
                'condition' => [
                    'video_type' => 'hosted',
                ],
            ]
        );

        $this->add_control(
            'hosted_url',
            [
                'label' => esc_html__( 'Choose File', 'elementor' ),
                'type' => Controls_Manager::MEDIA,
                'media_type' => 'video',
                'condition' => [
                    'video_type' => 'hosted',
                    'insert_url' => '',
                ],
            ]
        );

        $this->add_control(
            'external_url',
            [
                'label' => esc_html__( 'URL', 'elementor' ),
                'type' => Controls_Manager::URL,
                'autocomplete' => false,
                'options' => false,
                'label_block' => true,
                'show_label' => false,
                'media_type' => 'video',
                'placeholder' => esc_html__( 'Enter your URL', 'elementor' ),
                'condition' => [
                    'video_type' => 'hosted',
                    'insert_url' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'button_text',
            [
                'label' => esc_html__('Play Button Text', 'agrarium_plugin'),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__('Enter Play Button Text', 'agrarium_plugin'),
                'default' => esc_html__('Watch Our Video', 'agrarium_plugin'),
            ]
        );
        
        $this->add_responsive_control(
            'button_align',
            [
                'label'     => esc_html__('Button Alignment', 'agrarium_plugin'),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'      => [
                        'title'     => esc_html__('Left', 'agrarium_plugin'),
                        'icon'      => 'fa fa-align-left',
                    ],
                    'center'    => [
                        'title'     => esc_html__('Center', 'agrarium_plugin'),
                        'icon'      => 'fa fa-align-center',
                    ],
                    'right'     => [
                        'title'     => esc_html__('Right', 'agrarium_plugin'),
                        'icon'      => 'fa fa-align-right',
                    ]
                ],
                'default'   => 'left',
                'selectors' => [
                    '{{WRAPPER}} .agrarium_preview_container' => 'text-align: {{VALUE}};',
                ]
            ]
        );

        $this->end_controls_section();

        // ------------------------------------ //
        // ---------- Video Settings ---------- //
        // ------------------------------------ //
        $this->start_controls_section(
            'section_settings',
            [
                'label' => esc_html__('Video Widget Settings', 'agrarium_plugin'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_control(
            'button_padding',
            [
                'label'         => esc_html__('Button Padding', 'agrarium_plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', '%'],
                'selectors'     => [
                    '{{WRAPPER}} .agrarium_video_trigger_button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_control(
            'icon_button_size',
            [
                'label' => esc_html__('Trigger Button Size', 'agrarium_plugin'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .agrarium_button_icon' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .agrarium_button_icon i' => 'line-height: {{SIZE}}{{UNIT}};'
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'icon_size',
            [
                'label' => esc_html__('Icon Size', 'agrarium_plugin'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 5,
                        'max' => 50,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .agrarium_button_icon i' => 'font-size: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'label' => esc_html__('Button Text Typography', 'agrarium_plugin'),
                'selector' => '{{WRAPPER}} .agrarium_button_text'
            ]
        );
        $this->add_control(
            'button_radius',
            [
                'label'         => esc_html__('Border Radius', 'agrarium_plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', '%'],
                'selectors'     => [
                    '{{WRAPPER}} .agrarium_video_trigger_button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->start_controls_tabs('button_settings_tabs');

            // ------------------------ //
            // ------ Normal Tab ------ //
            // ------------------------ //
            $this->start_controls_tab(
                'tab_button_normal',
                [
                    'label' => esc_html__('Normal', 'agrarium_plugin')
                ]
            );

                $this->add_control(
                    'icon_color',
                    [
                        'label' => esc_html__('Icon Color', 'agrarium_plugin'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .agrarium_video_trigger_button .agrarium_button_icon' => 'color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'icon_bg',
                    [
                        'label' => esc_html__('Icon Background', 'agrarium_plugin'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .agrarium_video_trigger_button .agrarium_button_icon' => 'background: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'button_text_color',
                    [
                        'label' => esc_html__('Button Text Color', 'agrarium_plugin'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .agrarium_video_trigger_button .agrarium_button_text' => 'color: {{VALUE}};'
                        ]
                    ]
                );
                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name'      => 'button_bg',
                        'label'     => esc_html__( 'Button Background', 'agrarium_plugin' ),
                        'types'     => [ 'classic', 'gradient' ],
                        'selector'  => '{{WRAPPER}} .agrarium_video_trigger_button'
                    ]
                );

            $this->end_controls_tab();

            // ----------------------- //
            // ------ Hover Tab ------ //
            // ----------------------- //
            $this->start_controls_tab(
                'tab_button_hover',
                [
                    'label' => esc_html__('Hover', 'agrarium_plugin')
                ]
            );

                $this->add_control(
                    'icon_hover',
                    [
                        'label' => esc_html__('Icon Hover', 'agrarium_plugin'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .agrarium_video_trigger_button:hover .agrarium_button_icon' => 'color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'icon_bg_hover',
                    [
                        'label' => esc_html__('Icon Background Hover', 'agrarium_plugin'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .agrarium_video_trigger_button:hover .agrarium_button_icon' => 'background: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'button_text_hover',
                    [
                        'label' => esc_html__('Button Text Hover', 'agrarium_plugin'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .agrarium_video_trigger_button:hover .agrarium_button_text' => 'color: {{VALUE}};'
                        ]
                    ]
                );
                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name'      => 'button_bg_hover',
                        'label'     => esc_html__( 'Button Background Hover', 'agrarium_plugin' ),
                        'types'     => [ 'classic', 'gradient' ],
                        'selector'  => '{{WRAPPER}} .agrarium_video_trigger_button:hover'
                    ]
                );

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings();

        $video_link = '';
        $youtube_url = $settings['youtube_url'];
        $video_type = $settings['video_type'];
        $insert_url = $settings['insert_url'];        
        $hosted_url = $settings['hosted_url'];
        $external_url = $settings['external_url'];
        $button_text = $settings['button_text'];  
        if($video_type == 'youtube') {
            $video_link = $youtube_url;
        }
        elseif($video_type == 'hosted' && !empty($insert_url)) {
            $video_link = $external_url['url'];
        } elseif ($video_type == 'hosted' && empty($insert_url)) {
            $video_link = $hosted_url['url'];
        }

        // ------------------------------------ //
        // ---------- Widget Content ---------- //
        // ------------------------------------ //
        ?>

        <div class="agrarium_video_widget">
            <div class="agrarium_preview_container">   
                <a class="agrarium_video_trigger_button" href="<?php echo esc_js('javascript:void(0)'); ?>">
                    <span class="agrarium_button_icon"><i class="icomoon-play"></i></span>
                    <?php
                    if ($button_text !== '') {
                        ?>
                        <span class="agrarium_button_text"><?php echo esc_html($button_text); ?></span>
                        <?php
                    }
                    ?>
                </a>
            </div>

            <?php
            if ($video_link !== '') {
                ?>
                <div class="agrarium_video_container">
                    <div class="agrarium_close_popup_layer">
                        <div class="agrarium_close_button">
                            <svg viewBox="0 0 40 40"><path d="M10,10 L30,30 M30,10 L10,30"></path></svg>
                        </div>
                    </div>
                    <div class="agrarium_video_wrapper" data-src="<?php echo esc_url($video_link); ?>"></div>
                </div>
                <?php
            }
            ?>
        </div>
        <?php
    }

    protected function content_template() {}

    public function render_plain_content() {}
}
