<?php
/*
 * Created by Artureanec
*/

require_once(get_template_directory() . "/core/customizer/customizer-sanitize-functions.php");
require_once(get_template_directory() . "/core/customizer/customizer-defaults.php");
require_once(get_template_directory() . "/core/customizer/customizer-controls.php");

# Register Customizer
add_action('customize_register', 'agrarium_customizer_register');
if (!function_exists('agrarium_customizer_register')) {
    function agrarium_customizer_register($wp_customize) {
        global $agrarium_customizer_default_values;

        // -------------------------------------------- //
        // ---------- Top Bar Settings Panel ---------- //
        // -------------------------------------------- //
        $wp_customize->add_panel('agrarium_top_bar_settings',
            array(
                'title'     => esc_html__('Top Bar Settings', 'agrarium'),
                'priority'  => 130
            )
        );

        // ---#######################--- //
        // ---### Top Bar General ###--- //
        // ---#######################--- //
        $wp_customize->add_section('agrarium_top_bar_general',
            array(
                'title' => esc_html__('General', 'agrarium'),
                'panel' => 'agrarium_top_bar_settings'
            )
        );

        // ---------------------- //
        // --- Top Bar Status --- //
        // ---------------------- //
        $wp_setting_name = 'top_bar_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Top Bar', 'agrarium'),
                'section'   => 'agrarium_top_bar_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ------------------------- //
        // --- Top Bar Customize --- //
        // ------------------------- //
        $wp_setting_name = 'top_bar_customize';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Customize', 'agrarium'),
                'section'   => 'agrarium_top_bar_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ---------------------------------- //
        // --- Top Bar Default Text Color --- //
        // ---------------------------------- //
        $wp_setting_name = 'top_bar_default_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Default Text Color', 'agrarium'),
                'section'       => 'agrarium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ------------------------------- //
        // --- Top Bar Dark Text Color --- //
        // ------------------------------- //
        $wp_setting_name = 'top_bar_dark_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Dark Text Color', 'agrarium'),
                'section'       => 'agrarium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- Top Bar Light Text Color --- //
        // -------------------------------- //
        $wp_setting_name = 'top_bar_light_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Light Text Color', 'agrarium'),
                'section'       => 'agrarium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------------- //
        // --- Top Bar Accent Text Color --- //
        // --------------------------------- //
        $wp_setting_name = 'top_bar_accent_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Accent Text Color', 'agrarium'),
                'section'       => 'agrarium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---------------------------- //
        // --- Top Bar Border Color --- //
        // ---------------------------- //
        $wp_setting_name = 'top_bar_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Border Color', 'agrarium'),
                'section'       => 'agrarium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ------------------------------------ //
        // --- Top Bar Hovered Border Color --- //
        // ------------------------------------ //
        $wp_setting_name = 'top_bar_border_hover_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Hovered Border Color', 'agrarium'),
                'section'       => 'agrarium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- Top Bar Background Color --- //
        // -------------------------------- //
        $wp_setting_name = 'top_bar_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Color', 'agrarium'),
                'section'       => 'agrarium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // -------------------------------------------- //
        // --- Top Bar Alternative Background Color --- //
        // -------------------------------------------- //
        $wp_setting_name = 'top_bar_background_alter_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Alternative Background Color', 'agrarium'),
                'section'       => 'agrarium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------------- //
        // --- Top Bar Button Text Color --- //
        // --------------------------------- //
        $wp_setting_name = 'top_bar_button_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Color', 'agrarium'),
                'section'       => 'agrarium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ----------------------------------- //
        // --- Top Bar Button Border Color --- //
        // ----------------------------------- //
        $wp_setting_name = 'top_bar_button_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Color', 'agrarium'),
                'section'       => 'agrarium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------------------- //
        // --- Top Bar Button Background Color --- //
        // --------------------------------------- //
        $wp_setting_name = 'top_bar_button_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Color', 'agrarium'),
                'section'       => 'agrarium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------------- //
        // --- Top Bar Button Text Hover --- //
        // --------------------------------- //
        $wp_setting_name = 'top_bar_button_text_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Hover', 'agrarium'),
                'section'       => 'agrarium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------------------- //
        // --- Top Bar Button Border Hover --- //
        // ----------------------------------- //
        $wp_setting_name = 'top_bar_button_border_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Hover', 'agrarium'),
                'section'       => 'agrarium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------------------- //
        // --- Top Bar Button Background Hover --- //
        // --------------------------------------- //
        $wp_setting_name = 'top_bar_button_background_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Hover', 'agrarium'),
                'section'       => 'agrarium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---##############################--- //
        // ---### Top Bar Menu ###--- //
        // ---##############################--- //
        $wp_customize->add_section('agrarium_top_bar_menu',
            array(
                'title' => esc_html__('Top Bar Menu', 'agrarium'),
                'panel' => 'agrarium_top_bar_settings'
            )
        );

        // ------------------------------ //
        // --- Top Bar Menu Status --- //
        // ------------------------------ //
        $wp_setting_name = 'top_bar_menu_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Menu', 'agrarium'),
                'section'   => 'agrarium_top_bar_menu',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ------------------------------ //
        // --- Top Bar Menu Select --- //
        // ------------------------------ //
        $wp_setting_name = 'top_bar_menu_select';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Select Menu', 'agrarium'),
                'section'   => 'agrarium_top_bar_menu',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => agrarium_get_all_menu_list()
            )
        ));


        // ---##############################--- //
        // ---### Top Bar Social Buttons ###--- //
        // ---##############################--- //
        $wp_customize->add_section('agrarium_top_bar_socials',
            array(
                'title' => esc_html__('Social Buttons', 'agrarium'),
                'panel' => 'agrarium_top_bar_settings'
            )
        );

        // ------------------------------ //
        // --- Top Bar Socials Status --- //
        // ------------------------------ //
        $wp_setting_name = 'top_bar_socials_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Social Buttons', 'agrarium'),
                'section'   => 'agrarium_top_bar_socials',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));


        // ---###############################--- //
        // ---### Top Bar Additional Text ###--- //
        // ---###############################--- //
        $wp_customize->add_section('agrarium_top_bar_additional_text',
            array(
                'title' => esc_html__('Additional Text', 'agrarium'),
                'panel' => 'agrarium_top_bar_settings'
            )
        );

        // -------------------------------------- //
        // --- Top Bar Additional Text Status --- //
        // -------------------------------------- //
        $wp_setting_name = 'top_bar_additional_text_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Additional Text', 'agrarium'),
                'section'   => 'agrarium_top_bar_additional_text',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ------------------------------------- //
        // --- Top Bar Additional Text Title --- //
        // ------------------------------------- //
        $wp_setting_name = 'top_bar_additional_text_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'wp_kses_post'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Additional Text Title', 'agrarium'),
                'section'       => 'agrarium_top_bar_additional_text',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_additional_text_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------- //
        // --- Top Bar Additional Text --- //
        // ------------------------------- //
        $wp_setting_name = 'top_bar_additional_text';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'wp_kses_post'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Additional Text', 'agrarium'),
                'section'       => 'agrarium_top_bar_additional_text',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_additional_text_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));


        // ---########################--- //
        // ---### Top Bar Contacts ###--- //
        // ---########################--- //
        $wp_customize->add_section('agrarium_top_bar_contacts',
            array(
                'title' => esc_html__('Contacts', 'agrarium'),
                'panel' => 'agrarium_top_bar_settings'
            )
        );

        // ------------------------------------ //
        // --- Top Bar Email Address Status --- //
        // ------------------------------------ //
        $wp_setting_name = 'top_bar_contacts_email_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Email Address', 'agrarium'),
                'section'   => 'agrarium_top_bar_contacts',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));
        
        // ---------------------------- //
        // --- Top Bar Email Title --- //
        // ---------------------------- //
        $wp_setting_name = 'top_bar_contacts_email_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Email Title', 'agrarium'),
                'section'       => 'agrarium_top_bar_contacts',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_contacts_email_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------------- //
        // --- Top Bar Email Address --- //
        // ----------------------------- //
        $wp_setting_name = 'top_bar_contacts_email';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_email'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Email Address', 'agrarium'),
                'section'       => 'agrarium_top_bar_contacts',
                'type'          => 'email',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_contacts_email_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------------------- //
        // --- Top Bar Phone Number Status --- //
        // ----------------------------------- //
        $wp_setting_name = 'top_bar_contacts_phone_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Phone Number', 'agrarium'),
                'section'   => 'agrarium_top_bar_contacts',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ---------------------------- //
        // --- Top Bar Phone Title --- //
        // ---------------------------- //
        $wp_setting_name = 'top_bar_contacts_phone_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Phone Title', 'agrarium'),
                'section'       => 'agrarium_top_bar_contacts',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_contacts_phone_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));
        
        // ---------------------------- //
        // --- Top Bar Phone Number --- //
        // ---------------------------- //
        $wp_setting_name = 'top_bar_contacts_phone';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Phone Number', 'agrarium'),
                'section'       => 'agrarium_top_bar_contacts',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_contacts_phone_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------ //
        // --- Top Bar Address Status --- //
        // ------------------------------ //
        $wp_setting_name = 'top_bar_contacts_address_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Address', 'agrarium'),
                'section'   => 'agrarium_top_bar_contacts',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ------------------------- //
        // --- Top Address Title --- //
        // ------------------------- //
        $wp_setting_name = 'top_bar_contacts_address_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Address Title', 'agrarium'),
                'section'       => 'agrarium_top_bar_contacts',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_contacts_address_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------- //
        // --- Top Bar Address --- //
        // ----------------------- //
        $wp_setting_name = 'top_bar_contacts_address';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Address', 'agrarium'),
                'section'       => 'agrarium_top_bar_contacts',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_contacts_address_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));


        // ------------------------------------------- //
        // ---------- Header Settings Panel ---------- //
        // ------------------------------------------- //
        $wp_customize->add_panel('agrarium_header_settings',
            array(
                'title'     => esc_html__('Header Settings', 'agrarium'),
                'priority'  => 130
            )
        );

        // ---######################--- //
        // ---### Header General ###--- //
        // ---######################--- //
        $wp_customize->add_section('agrarium_header_general',
            array(
                'title' => esc_html__('General', 'agrarium'),
                'panel' => 'agrarium_header_settings'
            )
        );

        // --------------------- //
        // --- Header Status --- //
        // --------------------- //
        $wp_setting_name = 'header_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Header', 'agrarium'),
                'section'   => 'agrarium_header_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ------------------- //
        // --- Header Type --- //
        // ------------------- //
        $wp_setting_name = 'header_style';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Header Style', 'agrarium'),
                'section'   => 'agrarium_header_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'type-1'    => esc_html__('Style Type 1', 'agrarium'),
                    'type-2'    => esc_html__('Style Type 2', 'agrarium'),
                    'type-3'    => esc_html__('Style Type 3', 'agrarium')
                )
            )
        ));

        // ----------------------- //
        // --- Header Position --- //
        // ----------------------- //
        $wp_setting_name = 'header_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Header Position', 'agrarium'),
                'section'   => 'agrarium_header_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'above'     => esc_html__('Above', 'agrarium'),
                    'over'      => esc_html__('Over', 'agrarium')
                )
            )
        ));

        // --------------------- //
        // --- Header Phone --- //
        // --------------------- //

        $wp_setting_name = 'header_phone_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Header Phone', 'agrarium'),
                'section'   => 'agrarium_header_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                ),
                'dependency' => [
                    [
                        'control'   => 'header_style',
                        'operator'  => '==',
                        'value'     => 'type-3'
                    ]
                ]
            )
        ));

        $wp_setting_name = 'header_phone_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Header Phone Title', 'agrarium'),
                'section'   => 'agrarium_header_general',
                'type'      => 'text',
                'settings'  => $wp_setting_name,
                'dependency' => [
                    [
                        'control'   => 'header_phone_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ],
                    [
                        'control'   => 'header_style',
                        'operator'  => '==',
                        'value'     => 'type-3'
                    ]
                ]
            )
        ));   

        $wp_setting_name = 'header_phone_number';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Header Phone Number', 'agrarium'),
                'section'   => 'agrarium_header_general',
                'type'      => 'text',
                'settings'  => $wp_setting_name,
                'dependency' => [
                    [
                        'control'   => 'header_phone_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ],
                    [
                        'control'   => 'header_style',
                        'operator'  => '==',
                        'value'     => 'type-3'
                    ]
                ]
            )
        ));     
        $wp_setting_name = 'header_overlay_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'esc_attr'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Overlay Image', 'agrarium'),
                'section'   => 'agrarium_header_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                ),
                'dependency' => [
                    [
                        'control'   => 'header_style',
                        'operator'  => '==',
                        'value'     => 'type-3'
                    ]
                ]
            )
        ));          

        // ------------------------ //
        // --- Header Customize --- //
        // ------------------------ //
        $wp_setting_name = 'header_customize';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Customize', 'agrarium'),
                'section'   => 'agrarium_header_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ------------------------------------ //
        // --- Header Logo Background Color --- //
        // ------------------------------------ //
        $wp_setting_name = 'header_logo_bg_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Logo Background Color', 'agrarium'),
                'section'       => 'agrarium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ],
                    [
                        'control'   => 'header_style',
                        'operator'  => '==',
                        'value'     => 'type-3'
                    ]
                ],
                'separator'     => 'before'
            )
        ));        

        // --------------------------------- //
        // --- Header Default Text Color --- //
        // --------------------------------- //
        $wp_setting_name = 'header_default_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Default text color', 'agrarium'),
                'section'       => 'agrarium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ------------------------------ //
        // --- Header Dark Text Color --- //
        // ------------------------------ //
        $wp_setting_name = 'header_dark_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Dark text color', 'agrarium'),
                'section'       => 'agrarium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------- //
        // --- Header Light Text Color --- //
        // ------------------------------- //
        $wp_setting_name = 'header_light_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Light text color', 'agrarium'),
                'section'       => 'agrarium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- Header Accent Text Color --- //
        // -------------------------------- //
        $wp_setting_name = 'header_accent_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Accent text color', 'agrarium'),
                'section'       => 'agrarium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------- //
        // --- Header Border Color --- //
        // --------------------------- //
        $wp_setting_name = 'header_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Border color', 'agrarium'),
                'section'       => 'agrarium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ----------------------------------- //
        // --- Header Hovered Border Color --- //
        // ----------------------------------- //
        $wp_setting_name = 'header_border_hover_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Hovered Border color', 'agrarium'),
                'section'       => 'agrarium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------- //
        // --- Header Background Color --- //
        // ------------------------------- //
        $wp_setting_name = 'header_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background color', 'agrarium'),
                'section'       => 'agrarium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ------------------------------------------- //
        // --- Header Background Alternative Color --- //
        // ------------------------------------------- //
        $wp_setting_name = 'header_background_alter_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Alternative background color', 'agrarium'),
                'section'       => 'agrarium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- Header Button Text Color --- //
        // -------------------------------- //
        $wp_setting_name = 'header_button_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text color', 'agrarium'),
                'section'       => 'agrarium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ---------------------------------- //
        // --- Header Button Border Color --- //
        // ---------------------------------- //
        $wp_setting_name = 'header_button_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border color', 'agrarium'),
                'section'       => 'agrarium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------------- //
        // --- Header Button Background Color --- //
        // -------------------------------------- //
        $wp_setting_name = 'header_button_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Color', 'agrarium'),
                'section'       => 'agrarium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- Header Button Text Hover --- //
        // -------------------------------- //
        $wp_setting_name = 'header_button_text_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Hover', 'agrarium'),
                'section'       => 'agrarium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---------------------------------- //
        // --- Header Button Border Hover --- //
        // ---------------------------------- //
        $wp_setting_name = 'header_button_border_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Hover', 'agrarium'),
                'section'       => 'agrarium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------------- //
        // --- Header Button Background Hover --- //
        // -------------------------------------- //
        $wp_setting_name = 'header_button_background_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Hover', 'agrarium'),
                'section'       => 'agrarium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---#####################--- //
        // ---### Sticky Header ###--- //
        // ---#####################--- //
        $wp_customize->add_section('agrarium_header_sticky',
            array(
                'title' => esc_html__('Sticky Header', 'agrarium'),
                'panel' => 'agrarium_header_settings'
            )
        );


        // --------------------- //
        // --- Sticky Header --- //
        // --------------------- //
        $wp_setting_name = 'sticky_header_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Sticky Header', 'agrarium'),
                'section'   => 'agrarium_header_sticky',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));


        // ---#####################--- //
        // ---### Logo Settings ###--- //
        // ---#####################--- //
        $wp_customize->add_section('agrarium_header_logo',
            array(
                'title' => esc_html__('Logo', 'agrarium'),
                'panel' => 'agrarium_header_settings'
            )
        );

        // -------------------------- //
        // --- Header Logo Status --- //
        // -------------------------- //
        $wp_setting_name = 'header_logo_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Logo', 'agrarium'),
                'section'   => 'agrarium_header_logo',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ----------------------------- //
        // --- Header Logo Customize --- //
        // ----------------------------- //
        $wp_setting_name = 'header_logo_customize';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Customize', 'agrarium'),
                'section'   => 'agrarium_header_logo',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ------------------- //
        // --- Header Logo --- //
        // ------------------- //
        $wp_setting_name = 'header_logo_image';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'esc_url_raw'
            )
        );
        $wp_customize->add_control(new Agrarium_Image_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Logo Image', 'agrarium'),
                'section'       => 'agrarium_header_logo',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_logo_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------- //
        // --- Logo Retina --- //
        // ------------------- //
        $wp_setting_name = 'header_logo_retina';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_checkbox'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Logo Retina', 'agrarium'),
                'section'       => 'agrarium_header_logo',
                'type'          => 'checkbox',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_logo_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------- //
        // --- Mobile Header Logo --- //
        // -------------------------- //
        $wp_setting_name = 'header_logo_mobile_image';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'esc_url_raw'
            )
        );
        $wp_customize->add_control(new Agrarium_Image_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Mobile Logo Image', 'agrarium'),
                'section'       => 'agrarium_header_logo',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_logo_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // -------------------------- //
        // --- Mobile Logo Retina --- //
        // -------------------------- //
        $wp_setting_name = 'header_logo_mobile_retina';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_checkbox'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Mobile Logo Retina', 'agrarium'),
                'section'       => 'agrarium_header_logo',
                'type'          => 'checkbox',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_logo_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));


        // ---#####################--- //
        // ---### Header Button ###--- //
        // ---#####################--- //
        $wp_customize->add_section('agrarium_header_button',
            array(
                'title' => esc_html__('Header Button', 'agrarium'),
                'panel' => 'agrarium_header_settings'
            )
        );

        // --------------------- //
        // --- Header Button --- //
        // --------------------- //
        $wp_setting_name = 'header_button_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show header button', 'agrarium'),
                'section'   => 'agrarium_header_button',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // -------------------------- //
        // --- Header Button Text --- //
        // -------------------------- //
        $wp_setting_name = 'header_button_text';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Header button text', 'agrarium'),
                'section'       => 'agrarium_header_button',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_button_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------- //
        // --- Header Button URL ---- //
        // -------------------------- //
        $wp_setting_name = 'header_button_url';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'esc_url_raw'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Header button link', 'agrarium'),
                'section'       => 'agrarium_header_button',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_button_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));


        // ---############################--- //
        // ---### Header Menu Settings ###--- //
        // ---############################--- //
        $wp_customize->add_section('agrarium_header_menu',
            array(
                'title' => esc_html__('Header Menu', 'agrarium'),
                'panel' => 'agrarium_header_settings'
            )
        );

        // -------------------------- //
        // --- Header Menu Status --- //
        // -------------------------- //
        $wp_setting_name = 'header_menu_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show header menu', 'agrarium'),
                'section'   => 'agrarium_header_menu',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // -------------------------- //
        // --- Header Menu Select --- //
        // -------------------------- //
        $wp_setting_name = 'header_menu_select';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Select Menu', 'agrarium'),
                'section'       => 'agrarium_header_menu',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => agrarium_get_all_menu_list()
            )
        ));

        // ----------------------------- //
        // --- Header Menu Customize --- //
        // ----------------------------- //
        $wp_setting_name = 'header_menu_customize';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Customize', 'agrarium'),
                'section'   => 'agrarium_header_menu',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ------------------- //
        // --- Header Font --- //
        // ------------------- //
        $wp_setting_name = 'header_menu_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Menu Font', 'agrarium'),
                'section'       => 'agrarium_header_menu',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_family'       => true,
                    'font_backup'       => true,
                    'font_styles'       => true,
                    'font_subset'       => true,
                    'font_size'         => true,
                    'line_height'       => true,
                    'text_transform'    => true,
                    'letter_spacing'    => true,
                    'word_spacing'      => true,
                    'font_style'        => true,
                    'font_weight'       => true
                ],
                'dependency'            => [
                    [
                        'control'           => 'header_menu_customize',
                        'operator'          => '==',
                        'value'             => 'on'
                    ]
                ]
            )
        ));

        // --------------------- //
        // --- Sub Menu Font --- //
        // --------------------- //
        $wp_setting_name = 'header_sub_menu_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Sub Menu Font', 'agrarium'),
                'section'       => 'agrarium_header_menu',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_family'       => true,
                    'font_backup'       => true,
                    'font_styles'       => true,
                    'font_subset'       => true,
                    'font_size'         => true,
                    'line_height'       => true,
                    'text_transform'    => true,
                    'letter_spacing'    => true,
                    'word_spacing'      => true,
                    'font_style'        => true,
                    'font_weight'       => true
                ],
                'separator'     => 'before',
                'dependency'    => [
                    [
                        'control'           => 'header_menu_customize',
                        'operator'          => '==',
                        'value'             => 'on'
                    ]
                ]
            )
        ));


        // ---####################--- //
        // ---### Header Icons ###--- //
        // ---####################--- //
        $wp_customize->add_section('header_icons',
            array(
                'title' => esc_html__('Header Icons', 'agrarium'),
                'panel' => 'agrarium_header_settings'
            )
        );

        // ------------------------- //
        // --- Header Side Panel --- //
        // ------------------------- //
        $wp_setting_name = 'side_panel_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show side panel trigger', 'agrarium'),
                'section'   => 'header_icons',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));
        $wp_setting_name = 'side_panel_on_mobile_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show side panel trigger on mobile', 'agrarium'),
                'section'   => 'header_icons',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));        

        // --------------------- //
        // --- Header Search --- //
        // --------------------- //
        $wp_setting_name = 'header_search_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show header search', 'agrarium'),
                'section'   => 'header_icons',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));


        if ( class_exists('WooCommerce') ) {
            // ------------------------ //
            // --- Header Mini Cart --- //
            // ------------------------ //
            $wp_setting_name = 'header_minicart_status';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                    'sanitize_callback'	=> 'agrarium_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Agrarium_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show product cart', 'agrarium'),
                    'section'   => 'header_icons',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'agrarium'),
                        'off'       => esc_html__('No', 'agrarium')
                    )
                )
            ));
        }              


        // ------------------------------- //
        // ---------- Page Tile ---------- //
        // ------------------------------- //
        $wp_customize->add_panel('agrarium_page_title_settings',
            array(
                'title'     => esc_html__('Page Title Settings', 'agrarium'),
                'priority'  => 140
            )
        );

        // ---########################--- //
        // ---### General Settings ###--- //
        // ---########################--- //
        $wp_customize->add_section('agrarium_page_title_general',
            array(
                'title' => esc_html__('General', 'agrarium'),
                'panel' => 'agrarium_page_title_settings'
            )
        );

        // ------------------------- //
        // --- Page Title Status --- //
        // ------------------------- //
        $wp_setting_name = 'page_title_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show page title', 'agrarium'),
                'section'   => 'agrarium_page_title_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));
        

        // -------------------------- //
        // --- Page Title Overlay --- //
        // -------------------------- //
        $wp_setting_name = 'page_title_overlay_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show overlay', 'agrarium'),
                'section'   => 'agrarium_page_title_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // --------------------------------- //
        // --- Page Title Bottom Overlay --- //
        // --------------------------------- //
        $wp_setting_name = 'page_title_bottom_overlay_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show bottom overlay', 'agrarium'),
                'section'   => 'agrarium_page_title_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // -------------------------------- //
        // --- Page Title Overlay Color --- //
        // -------------------------------- //
        $wp_setting_name = 'page_title_overlay_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Overlay color', 'agrarium'),
                'section'       => 'agrarium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_overlay_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------------------- //
        // --- Page Title Image Decoration --- //
        // ----------------------------------- //
        $wp_setting_name = 'page_title_image_decoration_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show image decoration', 'agrarium'),
                'section'   => 'agrarium_page_title_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ----------------------------------- //
        // --- Page Title Decoration Image --- //
        // ----------------------------------- //
        $wp_setting_name = 'page_title_decoration_image';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'esc_url_raw'
            )
        );
        $wp_customize->add_control(new Agrarium_Image_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Decoration Image', 'agrarium'),
                'section'       => 'agrarium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_image_decoration_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ---------------------------- //
        // --- Page Title Customize --- //
        // ---------------------------- //
        $wp_setting_name = 'page_title_customize';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Customize', 'agrarium'),
                'section'   => 'agrarium_page_title_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                ),
                'separator' => 'before'
            )
        ));

        // ------------------------------- //
        // --- Page Title Block Height --- //
        // ------------------------------- //
        $wp_setting_name = 'page_title_height';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Page title height, in px', 'agrarium'),
                'section'       => 'agrarium_page_title_general',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------------- //
        // --- Page Title Default Text Color --- //
        // ------------------------------------- //
        $wp_setting_name = 'page_title_default_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Default text color', 'agrarium'),
                'section'       => 'agrarium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ---------------------------------- //
        // --- Page Title Dark Text Color --- //
        // ---------------------------------- //
        $wp_setting_name = 'page_title_dark_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Dark text color', 'agrarium'),
                'section'       => 'agrarium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------------------- //
        // --- Page Title Light Text Color --- //
        // ----------------------------------- //
        $wp_setting_name = 'page_title_light_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Light text color', 'agrarium'),
                'section'       => 'agrarium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------------ //
        // --- Page Title Accent Text Color --- //
        // ------------------------------------ //
        $wp_setting_name = 'page_title_accent_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Accent text color', 'agrarium'),
                'section'       => 'agrarium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------- //
        // --- Page Title Border Color --- //
        // ------------------------------- //
        $wp_setting_name = 'page_title_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Border color', 'agrarium'),
                'section'       => 'agrarium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // --------------------------------------- //
        // --- Page Title Hovered Border Color --- //
        // --------------------------------------- //
        $wp_setting_name = 'page_title_border_hover_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Hovered border color', 'agrarium'),
                'section'       => 'agrarium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------------------- //
        // --- Page Title Background Color --- //
        // ----------------------------------- //
        $wp_setting_name = 'page_title_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background color', 'agrarium'),
                'section'       => 'agrarium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ----------------------------------------------- //
        // --- Page Title Alternative Background Color --- //
        // ----------------------------------------------- //
        $wp_setting_name = 'page_title_background_alter_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Alternative background color', 'agrarium'),
                'section'       => 'agrarium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------------ //
        // --- Page Title Button Text Color --- //
        // ------------------------------------ //
        $wp_setting_name = 'page_title_button_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Color', 'agrarium'),
                'section'       => 'agrarium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // -------------------------------------- //
        // --- Page Title Button Border Color --- //
        // -------------------------------------- //
        $wp_setting_name = 'page_title_button_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Color', 'agrarium'),
                'section'       => 'agrarium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------------------ //
        // --- Page Title Button Background Color --- //
        // ------------------------------------------ //
        $wp_setting_name = 'page_title_button_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Color', 'agrarium'),
                'section'       => 'agrarium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------------ //
        // --- Page Title Button Text Hover --- //
        // ------------------------------------ //
        $wp_setting_name = 'page_title_button_text_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Hover', 'agrarium'),
                'section'       => 'agrarium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------------- //
        // --- Page Title Button Border Hover --- //
        // -------------------------------------- //
        $wp_setting_name = 'page_title_button_border_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Hover', 'agrarium'),
                'section'       => 'agrarium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------------------ //
        // --- Page Title Button Background Hover --- //
        // ------------------------------------------ //
        $wp_setting_name = 'page_title_button_background_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Hover', 'agrarium'),
                'section'       => 'agrarium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------------------- //
        // --- Page Title Background Image --- //
        // ----------------------------------- //
        $wp_setting_name = 'page_title_background_image';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'esc_url_raw'
            )
        );
        $wp_customize->add_control(new Agrarium_Image_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Image', 'agrarium'),
                'section'       => 'agrarium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // -------------------------------------- //
        // --- Page Title Background Position --- //
        // -------------------------------------- //
        $wp_setting_name = 'page_title_background_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Position', 'agrarium'),
                'section'       => 'agrarium_page_title_general',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => agrarium_get_background_position_options(),
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------------ //
        // --- Page Title Background Repeat --- //
        // ------------------------------------ //
        $wp_setting_name = 'page_title_background_repeat';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Repeat', 'agrarium'),
                'section'       => 'agrarium_page_title_general',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => agrarium_get_background_repeat_options(),
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---------------------------------- //
        // --- Page Title Background Size --- //
        // ---------------------------------- //
        $wp_setting_name = 'page_title_background_size';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Size', 'agrarium'),
                'section'       => 'agrarium_page_title_general',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => agrarium_get_background_size_options(),
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---------------------------------------------------- //
        // --- Hide Page Title Background on Mobile Devices --- //
        // ---------------------------------------------------- //
        $wp_setting_name = 'hide_page_title_background_mobile';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_checkbox'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Hide Background Image on Mobile Devices', 'agrarium'),
                'section'       => 'agrarium_page_title_general',
                'type'          => 'checkbox',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));


        // ---########################--- //
        // ---### Heading Settings ###--- //
        // ---########################--- //
        $wp_customize->add_section('agrarium_page_title_heading',
            array(
                'title' => esc_html__('Heading', 'agrarium'),
                'panel' => 'agrarium_page_title_settings'
            )
        );

        // ------------------------------------ //
        // --- Page Title Heading Customize --- //
        // ------------------------------------ //
        $wp_setting_name = 'page_title_heading_customize';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Customize', 'agrarium'),
                'section'       => 'agrarium_page_title_heading',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ------------------------------- //
        // --- Page Title Heading Font --- //
        // ------------------------------- //
        $wp_setting_name = 'page_title_heading_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Heading Font', 'agrarium'),
                'section'       => 'agrarium_page_title_heading',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_family'       => true,
                    'font_backup'       => true,
                    'font_styles'       => true,
                    'font_subset'       => true,
                    'font_size'         => true,
                    'line_height'       => true,
                    'text_transform'    => true,
                    'letter_spacing'    => true,
                    'word_spacing'      => true,
                    'font_style'        => true,
                    'font_weight'       => true
                ],
                'dependency'            => [
                    [
                        'control'           => 'page_title_heading_customize',
                        'operator'          => '==',
                        'value'             => 'on'
                    ]
                ]
            )
        ));


        // ---###########################--- //
        // ---### Subheading Settings ###--- //
        // ---###########################--- //
        $wp_customize->add_section('agrarium_page_title_breadcrumbs',
            array(
                'title' => esc_html__('Breadcrumbs', 'agrarium'),
                'panel' => 'agrarium_page_title_settings'
            )
        );

        // ------------------------------------- //
        // --- Page Title Breadcrumbs Status --- //
        // ------------------------------------- //
        $wp_setting_name = 'page_title_breadcrumbs_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show page title breadcrumbs', 'agrarium'),
                'section'   => 'agrarium_page_title_breadcrumbs',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ---------------------------------------- //
        // --- Page Title Breadcrumbs Customize --- //
        // ---------------------------------------- //
        $wp_setting_name = 'page_title_breadcrumbs_customize';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Customize', 'agrarium'),
                'section'   => 'agrarium_page_title_breadcrumbs',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ----------------------------------- //
        // --- Page Title Breadcrumbs Font --- //
        // ----------------------------------- //
        $wp_setting_name = 'page_title_breadcrumbs_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Breadcrumbs Font', 'agrarium'),
                'section'       => 'agrarium_page_title_breadcrumbs',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_family'       => true,
                    'font_backup'       => true,
                    'font_styles'       => true,
                    'font_subset'       => true,
                    'font_size'         => true,
                    'line_height'       => true,
                    'text_transform'    => true,
                    'letter_spacing'    => true,
                    'word_spacing'      => true,
                    'font_style'        => true,
                    'font_weight'       => true
                ],
                'dependency'            => [
                    [
                        'control'           => 'page_title_breadcrumbs_customize',
                        'operator'          => '==',
                        'value'             => 'on'
                    ]
                ]
            )
        ));


        // ---################################--- //
        // ---### Additional Text Settings ###--- //
        // ---################################--- //
        $wp_customize->add_section('agrarium_page_title_additional',
            array(
                'title' => esc_html__('Heading Additional Text', 'agrarium'),
                'panel' => 'agrarium_page_title_settings'
            )
        );

        // ----------------------- //
        // --- Additional Text --- //
        // ----------------------- //       
        $wp_setting_name = 'page_title_additional_text_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Additional Text', 'agrarium'),
                'section'   => 'agrarium_page_title_additional',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));


        $wp_setting_name = 'page_title_additional_text';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Additional Text', 'agrarium'),
                'section'       => 'agrarium_page_title_additional',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'            => [
                    [
                        'control'           => 'page_title_additional_text_status',
                        'operator'          => '==',
                        'value'             => 'on'
                    ]
                ]
            )
        ));

        // ----------------------------- //
        // --- Additional Text Color --- //
        // ----------------------------- //
        $wp_setting_name = 'page_title_additional_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Additional Text Color', 'agrarium'),
                'section'       => 'agrarium_page_title_additional',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'           => 'page_title_additional_text_status',
                        'operator'          => '==',
                        'value'             => 'on'
                    ]
                ]
            )
        ));
        // -------------------------------- //
        // --- Additional Text Position --- //
        // -------------------------------- //
        $wp_setting_name = 'page_title_additional_text_right_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Additional Text Offset Right, in %', 'agrarium'),
                'section'       => 'agrarium_page_title_additional',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'           => 'page_title_additional_text_status',
                        'operator'          => '==',
                        'value'             => 'on'
                    ]
                ]
            )
        ));

        $wp_setting_name = 'page_title_additional_text_bottom_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Additional Text Offset Bottom, in px', 'agrarium'),
                'section'       => 'agrarium_page_title_additional',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'           => 'page_title_additional_text_status',
                        'operator'          => '==',
                        'value'             => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // ---------- Typography ---------- //
        // -------------------------------- //
        $wp_customize->add_panel('agrarium_typography_settings',
            array(
                'title'     => esc_html__('Typography Settings', 'agrarium'),
                'priority'  => 140
            )
        );

        // ---#################--- //
        // ---### Main Font ###--- //
        // ---#################--- //
        $wp_customize->add_section('agrarium_typography_main_font',
            array(
                'title' => esc_html__('Main Font', 'agrarium'),
                'panel' => 'agrarium_typography_settings'
            )
        );

        // ----------------- //
        // --- Main Font --- //
        // ----------------- //
        $wp_setting_name = 'main_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Main Font', 'agrarium'),
                'section'       => 'agrarium_typography_main_font',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_family'       => true,
                    'font_backup'       => true,
                    'font_styles'       => true,
                    'font_subset'       => true,
                    'font_size'         => true,
                    'line_height'       => true,
                    'text_transform'    => true,
                    'letter_spacing'    => true,
                    'word_spacing'      => true,
                    'font_style'        => true,
                    'font_weight'       => true
                ]
            )
        ));

        // ---#######################--- //
        // ---### Additional Font ###--- //
        // ---#######################--- //
        $wp_customize->add_section('agrarium_typography_additional_font',
            array(
                'title' => esc_html__('Additional Font', 'agrarium'),
                'panel' => 'agrarium_typography_settings'
            )
        );

        // ----------------------- //
        // --- Additional Font --- //
        // ----------------------- //
        $wp_setting_name = 'additional_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Additional Font', 'agrarium'),
                'section'       => 'agrarium_typography_additional_font',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_family'       => true,
                    'font_backup'       => true,
                    'font_styles'       => true,
                    'font_subset'       => true,
                    'font_weight'       => true
                ]
            )
        ));

        // ---################--- //
        // ---### Headings ###--- //
        // ---################--- //
        $wp_customize->add_section('agrarium_typography_headings',
            array(
                'title' => esc_html__('Headings', 'agrarium'),
                'panel' => 'agrarium_typography_settings'
            )
        );

        // --------------------- //
        // --- Headings Font --- //
        // --------------------- //
        $wp_setting_name = 'headings_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Headings Font', 'agrarium'),
                'section'       => 'agrarium_typography_headings',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_family'       => true,
                    'font_backup'       => true,
                    'font_styles'       => true,
                    'font_subset'       => true,
                    'text_transform'    => true,
                    'font_style'        => true
                ]
            )
        ));

        // --------------- //
        // --- H1 Font --- //
        // --------------- //
        $wp_setting_name = 'h1_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('H1 Font', 'agrarium'),
                'section'       => 'agrarium_typography_headings',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_size'         => true,
                    'line_height'       => true,
                    'letter_spacing'    => true,
                    'word_spacing'      => true,
                    'font_weight'       => true
                ],
                'separator'             => 'before'
            )
        ));

        // --------------- //
        // --- H2 Font --- //
        // --------------- //
        $wp_setting_name = 'h2_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('H2 Font', 'agrarium'),
                'section'       => 'agrarium_typography_headings',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_size'         => true,
                    'line_height'       => true,
                    'letter_spacing'    => true,
                    'word_spacing'      => true,
                    'font_weight'       => true
                ],
                'separator'             => 'before'
            )
        ));

        // --------------- //
        // --- H3 Font --- //
        // --------------- //
        $wp_setting_name = 'h3_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('H3 Font', 'agrarium'),
                'section'       => 'agrarium_typography_headings',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_size'         => true,
                    'line_height'       => true,
                    'letter_spacing'    => true,
                    'word_spacing'      => true,
                    'font_weight'       => true
                ],
                'separator'             => 'before'
            )
        ));

        // --------------- //
        // --- H4 Font --- //
        // --------------- //
        $wp_setting_name = 'h4_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('H4 Font', 'agrarium'),
                'section'       => 'agrarium_typography_headings',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_size'         => true,
                    'line_height'       => true,
                    'letter_spacing'    => true,
                    'word_spacing'      => true,
                    'font_weight'       => true
                ],
                'separator'             => 'before'
            )
        ));

        // --------------- //
        // --- H5 Font --- //
        // --------------- //
        $wp_setting_name = 'h5_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('H5 Font', 'agrarium'),
                'section'       => 'agrarium_typography_headings',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_size'         => true,
                    'line_height'       => true,
                    'letter_spacing'    => true,
                    'word_spacing'      => true,
                    'font_weight'       => true
                ],
                'separator'             => 'before'
            )
        ));

        // --------------- //
        // --- H6 Font --- //
        // --------------- //
        $wp_setting_name = 'h6_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('H6 Font', 'agrarium'),
                'section'       => 'agrarium_typography_headings',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_size'         => true,
                    'line_height'       => true,
                    'letter_spacing'    => true,
                    'word_spacing'      => true,
                    'font_weight'       => true
                ],
                'separator'             => 'before'
            )
        ));

        // ---###############--- //
        // ---### Buttons ###--- //
        // ---###############--- //
        $wp_customize->add_section('agrarium_typography_buttons',
            array(
                'title' => esc_html__('Buttons', 'agrarium'),
                'panel' => 'agrarium_typography_settings'
            )
        );

        // --------------------------- //
        // --- Buttons Font Family --- //
        // --------------------------- //
        $wp_setting_name = 'buttons_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Buttons Font', 'agrarium'),
                'section'       => 'agrarium_typography_buttons',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_family'       => true,
                    'font_backup'       => true,
                    'font_styles'       => true,
                    'font_subset'       => true,
                    'font_size'         => true,
                    'text_transform'    => true,
                    'letter_spacing'    => true,
                    'word_spacing'      => true,
                    'font_style'        => true,
                    'font_weight'       => true
                ]
            )
        ));


        // ---------------------------------- //
        // ---------- Social Links ---------- //
        // ---------------------------------- //
        $wp_customize->add_section('agrarium_socials_settings',
            array(
                'title'     => esc_html__('Social Links', 'agrarium'),
                'priority'  => 145
            )
        );

        // ---------------------- //
        // --- Socials Target --- //
        // ---------------------- //
        $wp_setting_name = 'socials_target';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_checkbox'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Open Socials in New Tab', 'agrarium'),
                'section'       => 'agrarium_socials_settings',
                'type'          => 'checkbox',
                'settings'      => $wp_setting_name
            )
        ));

        // ---------------------- //
        // --- Social Buttons --- //
        // ---------------------- //
        $wp_setting_name = 'social_buttons';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'sanitize_callback' => 'agrarium_sanitize_repeater'
            )
        );
        $wp_customize->add_control( new Agrarium_Customize_Socials_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'                 => esc_html__('Social Buttons', 'agrarium'),
                'section'               => 'agrarium_socials_settings',
                'separator'             => 'before'
            )
        ));


        // ------------------------------------ //
        // ---------- Color Settings ---------- //
        // ------------------------------------ //
        $wp_customize->add_panel('agrarium_color_settings',
            array(
                'title'     => esc_html__('Color Settings', 'agrarium'),
                'priority'  => 150
            )
        );

        // ---################--- //
        // ---### STANDARD ###--- //
        // ---################--- //
        $wp_customize->add_section('agrarium_standard_colors',
            array(
                'title' => esc_html__('Standard Colors', 'agrarium'),
                'panel' => 'agrarium_color_settings'
            )
        );

        // ----------------------------------- //
        // --- Standard Default Text Color --- //
        // ----------------------------------- //
        $wp_setting_name = 'standard_default_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Default Text Color', 'agrarium'),
                'section'       => 'agrarium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette()
            )
        ));

        // -------------------------------- //
        // --- Standard Dark Text Color --- //
        // -------------------------------- //
        $wp_setting_name = 'standard_dark_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Dark Text Color', 'agrarium'),
                'section'       => 'agrarium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette()
            )
        ));

        // --------------------------------- //
        // --- Standard Light Text Color --- //
        // --------------------------------- //
        $wp_setting_name = 'standard_light_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Light Text Color', 'agrarium'),
                'section'       => 'agrarium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette()
            )
        ));

        // ---------------------------------- //
        // --- Standard Accent Text Color --- //
        // ---------------------------------- //
        $wp_setting_name = 'standard_accent_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Accent Text Color', 'agrarium'),
                'section'       => 'agrarium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette()
            )
        ));

        // ----------------------------- //
        // --- Standard Border Color --- //
        // ----------------------------- //
        $wp_setting_name = 'standard_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Border Color', 'agrarium'),
                'section'       => 'agrarium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette(),
                'separator'     => 'before'
            )
        ));

        // ----------------------------------- //
        // --- Standard Border Hover Color --- //
        // ----------------------------------- //
        $wp_setting_name = 'standard_border_hover_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Border Hover Color', 'agrarium'),
                'section'       => 'agrarium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette()
            )
        ));

        // --------------------------------- //
        // --- Standard Background Color --- //
        // --------------------------------- //
        $wp_setting_name = 'standard_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Color', 'agrarium'),
                'section'       => 'agrarium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette(),
                'separator'     => 'before'
            )
        ));

        // --------------------------------------- //
        // --- Standard Background Alter Color --- //
        // --------------------------------------- //
        $wp_setting_name = 'standard_background_alter_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Alternative Background Color', 'agrarium'),
                'section'       => 'agrarium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette()
            )
        ));

        // ---------------------------------- //
        // --- Standard Button Text Color --- //
        // ---------------------------------- //
        $wp_setting_name = 'standard_button_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Color', 'agrarium'),
                'section'       => 'agrarium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette(),
                'separator'     => 'before'
            )
        ));

        // ------------------------------------ //
        // --- Standard Button Border Color --- //
        // ------------------------------------ //
        $wp_setting_name = 'standard_button_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Color', 'agrarium'),
                'section'       => 'agrarium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette()
            )
        ));

        // ---------------------------------------- //
        // --- Standard Button Background Color --- //
        // ---------------------------------------- //
        $wp_setting_name = 'standard_button_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Color', 'agrarium'),
                'section'       => 'agrarium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette()
            )
        ));

        // ---------------------------------- //
        // --- Standard Button Text Hover --- //
        // ---------------------------------- //
        $wp_setting_name = 'standard_button_text_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Hover', 'agrarium'),
                'section'       => 'agrarium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette()
            )
        ));

        // ------------------------------------ //
        // --- Standard Button Border Hover --- //
        // ------------------------------------ //
        $wp_setting_name = 'standard_button_border_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Hover', 'agrarium'),
                'section'       => 'agrarium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette()
            )
        ));

        // ---------------------------------------- //
        // --- Standard Button Background Hover --- //
        // ---------------------------------------- //
        $wp_setting_name = 'standard_button_background_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Hover', 'agrarium'),
                'section'       => 'agrarium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette()
            )
        ));

        // ---################--- //
        // ---### CONTRAST ###--- //
        // ---################--- //
        $wp_customize->add_section('agrarium_contrast_colors',
            array(
                'title' => esc_html__('Contrast Colors', 'agrarium'),
                'panel' => 'agrarium_color_settings'
            )
        );

        // ----------------------------------- //
        // --- Contrast Default Text Color --- //
        // ----------------------------------- //
        $wp_setting_name = 'contrast_default_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Default Text Color', 'agrarium'),
                'section'       => 'agrarium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette()
            )
        ));

        // -------------------------------- //
        // --- Contrast Dark Text Color --- //
        // -------------------------------- //
        $wp_setting_name = 'contrast_dark_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Dark Text Color', 'agrarium'),
                'section'       => 'agrarium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette()
            )
        ));

        // --------------------------------- //
        // --- Contrast Light Text Color --- //
        // --------------------------------- //
        $wp_setting_name = 'contrast_light_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Light Text Color', 'agrarium'),
                'section'       => 'agrarium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette()
            )
        ));

        // ---------------------------------- //
        // --- Contrast Accent Text Color --- //
        // ---------------------------------- //
        $wp_setting_name = 'contrast_accent_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Accent Text Color', 'agrarium'),
                'section'       => 'agrarium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette()
            )
        ));

        // ----------------------------- //
        // --- Contrast Border Color --- //
        // ----------------------------- //
        $wp_setting_name = 'contrast_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Border Color', 'agrarium'),
                'section'       => 'agrarium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette(),
                'separator'     => 'before'
            )
        ));

        // ----------------------------------- //
        // --- Contrast Border Hover Color --- //
        // ----------------------------------- //
        $wp_setting_name = 'contrast_border_hover_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Border Hover Color', 'agrarium'),
                'section'       => 'agrarium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette()
            )
        ));

        // --------------------------------- //
        // --- Contrast Background Color --- //
        // --------------------------------- //
        $wp_setting_name = 'contrast_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Color', 'agrarium'),
                'section'       => 'agrarium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette(),
                'separator'     => 'before'
            )
        ));

        // --------------------------------------- //
        // --- Contrast Background Alter Color --- //
        // --------------------------------------- //
        $wp_setting_name = 'contrast_background_alter_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Alternative Background Color', 'agrarium'),
                'section'       => 'agrarium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette()
            )
        ));

        // ---------------------------------- //
        // --- Contrast Button Text Color --- //
        // ---------------------------------- //
        $wp_setting_name = 'contrast_button_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Color', 'agrarium'),
                'section'       => 'agrarium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette(),
                'separator'     => 'before'
            )
        ));

        // ------------------------------------ //
        // --- Contrast Button Border Color --- //
        // ------------------------------------ //
        $wp_setting_name = 'contrast_button_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Color', 'agrarium'),
                'section'       => 'agrarium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette()
            )
        ));

        // ---------------------------------------- //
        // --- Contrast Button Background Color --- //
        // ---------------------------------------- //
        $wp_setting_name = 'contrast_button_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Color', 'agrarium'),
                'section'       => 'agrarium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette()
            )
        ));

        // ---------------------------------- //
        // --- Contrast Button Text Hover --- //
        // ---------------------------------- //
        $wp_setting_name = 'contrast_button_text_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Hover', 'agrarium'),
                'section'       => 'agrarium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette()
            )
        ));

        // ------------------------------------ //
        // --- Contrast Button Border Hover --- //
        // ------------------------------------ //
        $wp_setting_name = 'contrast_button_border_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Hover', 'agrarium'),
                'section'       => 'agrarium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette()
            )
        ));

        // ---------------------------------------- //
        // --- Contrast Button Background Hover --- //
        // ---------------------------------------- //
        $wp_setting_name = 'contrast_button_background_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Hover', 'agrarium'),
                'section'       => 'agrarium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette()
            )
        ));

        // --------------------------------------------------- //
        // ---------- Bottom Section Settings Panel ---------- //
        // --------------------------------------------------- //
         $wp_customize->add_section('agrarium_bottom_background_section',
            array(
                'title'     => esc_html__('Bottom Section Settings', 'agrarium'),
                'priority'  => 160
            )
        );
         // ---------------------------- //
        // --- Bottom Section Status --- //
        // ----------------------------- //
        $wp_setting_name = 'bottom_section_background_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Bottom Background', 'agrarium'),
                'section'   => 'agrarium_bottom_background_section',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));
        $wp_setting_name = 'bottom_section_background_height';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Bottom Background Section height, in px', 'agrarium'),
                'section'       => 'agrarium_bottom_background_section',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'bottom_section_background_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));
        $wp_setting_name = 'bottom_section_background_margin_top';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Bottom Background Section margin top, in px', 'agrarium'),
                'section'       => 'agrarium_bottom_background_section',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'bottom_section_background_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));
        
        // --------------------------------------- //
        // --- Bottom Section Background Image --- //
        // --------------------------------------- //
        $wp_setting_name = 'bottom_section_background_image';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'esc_url_raw'
            )
        );
        $wp_customize->add_control(new Agrarium_Image_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Image', 'agrarium'),
                'section'       => 'agrarium_bottom_background_section',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'bottom_section_background_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // -------------------------------------- //
        // --- Bottom Section Background Position --- //
        // -------------------------------------- //
        $wp_setting_name = 'bottom_section_background_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Position', 'agrarium'),
                'section'       => 'agrarium_bottom_background_section',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => agrarium_get_background_position_options(),
                'dependency'    => [
                    [
                        'control'   => 'bottom_section_background_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------------ //
        // --- Bottom Section Background Repeat --- //
        // ------------------------------------ //
        $wp_setting_name = 'bottom_section_background_repeat';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Repeat', 'agrarium'),
                'section'       => 'agrarium_bottom_background_section',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => agrarium_get_background_repeat_options(),
                'dependency'    => [
                    [
                        'control'   => 'bottom_section_background_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---------------------------------- //
        // --- Bottom Section Background Size --- //
        // ---------------------------------- //
        $wp_setting_name = 'bottom_section_background_size';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Size', 'agrarium'),
                'section'       => 'agrarium_bottom_background_section',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => agrarium_get_background_size_options(),
                'dependency'    => [
                    [
                        'control'   => 'bottom_section_background_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------------------------------------- //
        // --- Hide Bottom Section Background on Mobile Devices --- //
        // -------------------------------------------------------- //
        $wp_setting_name = 'hide_bottom_section_background_mobile';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Hide Background Section on Mobile Devices', 'agrarium'),
                'section'       => 'agrarium_bottom_background_section',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium'),
                ),
                'dependency'    => [
                    [
                        'control'   => 'bottom_section_background_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------------------- //
        // ---------- Footer Settings Panel ---------- //
        // ------------------------------------------- //
        $wp_customize->add_panel('agrarium_footer_settings',
            array(
                'title'     => esc_html__('Footer Settings', 'agrarium'),
                'priority'  => 160
            )
        );

        // ---###############--- //
        // ---### General ###--- //
        // ---###############--- //
        $wp_customize->add_section('agrarium_footer_general',
            array(
                'title' => esc_html__('General', 'agrarium'),
                'panel' => 'agrarium_footer_settings'
            )
        );

        // --------------------- //
        // --- Footer Status --- //
        // --------------------- //
        $wp_setting_name = 'footer_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Footer', 'agrarium'),
                'section'   => 'agrarium_footer_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // -------------------- //
        // --- Footer Style --- //
        // -------------------- //
        $wp_setting_name = 'footer_style';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Footer Style', 'agrarium'),
                'section'       => 'agrarium_footer_general',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'type-1'        => esc_html__('Style 1', 'agrarium'),
                    'type-2'        => esc_html__('Style 2', 'agrarium'),
                    'type-3'        => esc_html__('Style 3', 'agrarium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'footer_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------ //
        // --- Footer Customize --- //
        // ------------------------ //
        $wp_setting_name = 'footer_customize';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Customize', 'agrarium'),
                'section'   => 'agrarium_footer_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // --------------------------------- //
        // --- Footer Default Text Color --- //
        // --------------------------------- //
        $wp_setting_name = 'footer_default_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Default Text Color', 'agrarium'),
                'section'       => 'agrarium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ------------------------------ //
        // --- Footer Dark Text Color --- //
        // ------------------------------ //
        $wp_setting_name = 'footer_dark_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Dark Text Color', 'agrarium'),
                'section'       => 'agrarium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------- //
        // --- Footer Light Text Color --- //
        // ------------------------------- //
        $wp_setting_name = 'footer_light_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Light Text Color', 'agrarium'),
                'section'       => 'agrarium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- Footer Accent Text Color --- //
        // -------------------------------- //
        $wp_setting_name = 'footer_accent_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Accent Text Color', 'agrarium'),
                'section'       => 'agrarium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- Footer Border Text Color --- //
        // -------------------------------- //
        $wp_setting_name = 'footer_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Border Color', 'agrarium'),
                'section'       => 'agrarium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ---------------------------------------- //
        // --- Footer Hovered Border Text Color --- //
        // ---------------------------------------- //
        $wp_setting_name = 'footer_border_hover_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Hovered Border Color', 'agrarium'),
                'section'       => 'agrarium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------- //
        // --- Footer Background Color --- //
        // ------------------------------- //
        $wp_setting_name = 'footer_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Color', 'agrarium'),
                'section'       => 'agrarium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ------------------------------------------- //
        // --- Footer Alternative Background Color --- //
        // ------------------------------------------- //
        $wp_setting_name = 'footer_background_alter_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Alternative Background Color', 'agrarium'),
                'section'       => 'agrarium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------------ //
        // --- Page Title Button Text Color --- //
        // ------------------------------------ //
        $wp_setting_name = 'page_title_button_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Color', 'agrarium'),
                'section'       => 'agrarium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ---------------------------------- //
        // --- Footer Button Border Color --- //
        // ---------------------------------- //
        $wp_setting_name = 'footer_button_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Color', 'agrarium'),
                'section'       => 'agrarium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------------- //
        // --- Footer Button Background Color --- //
        // -------------------------------------- //
        $wp_setting_name = 'footer_button_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Color', 'agrarium'),
                'section'       => 'agrarium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- Footer Button Text Hover --- //
        // -------------------------------- //
        $wp_setting_name = 'footer_button_text_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Hover', 'agrarium'),
                'section'       => 'agrarium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---------------------------------- //
        // --- Footer Button Border Hover --- //
        // ---------------------------------- //
        $wp_setting_name = 'footer_button_border_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Hover', 'agrarium'),
                'section'       => 'agrarium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------------- //
        // --- Footer Button Background Hover --- //
        // -------------------------------------- //
        $wp_setting_name = 'footer_button_background_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Hover', 'agrarium'),
                'section'       => 'agrarium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------- //
        // --- Footer Background Image --- //
        // ------------------------------- //
        $wp_setting_name = 'footer_background_image';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'esc_url_raw'
            )
        );
        $wp_customize->add_control(new Agrarium_Image_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Bottom Image', 'agrarium'),
                'section'       => 'agrarium_footer_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ---------------------------------- //
        // --- Footer Background Position --- //
        // ---------------------------------- //
        $wp_setting_name = 'footer_background_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Position', 'agrarium'),
                'section'       => 'agrarium_footer_general',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => agrarium_get_background_position_options(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- Footer Background Repeat --- //
        // -------------------------------- //
        $wp_setting_name = 'footer_background_repeat';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Repeat', 'agrarium'),
                'section'       => 'agrarium_footer_general',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => agrarium_get_background_repeat_options(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------ //
        // --- Footer Background Size --- //
        // ------------------------------ //
        $wp_setting_name = 'footer_background_size';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Size', 'agrarium'),
                'section'       => 'agrarium_footer_general',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => agrarium_get_background_size_options(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));


        // ---######################--- //
        // ---### Footer Widgets ###--- //
        // ---######################--- //
        $wp_customize->add_section('agrarium_footer_sidebar',
            array(
                'title' => esc_html__('Footer Sidebar', 'agrarium'),
                'panel' => 'agrarium_footer_settings'
            )
        );

        // ----------------------------- //
        // --- Footer Widgets Status --- //
        // ----------------------------- //
        $wp_setting_name = 'footer_sidebar_top_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Top Footer Widgets', 'agrarium'),
                'section'   => 'agrarium_footer_sidebar',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ----------------------------- //
        // --- Footer Sidebar Select --- //
        // ----------------------------- //
        $wp_setting_name = 'footer_sidebar_top_select';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Select Top Sidebar', 'agrarium'),
                'section'       => 'agrarium_footer_sidebar',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => agrarium_get_all_sidebar_list(),
                'dependency'    => [
                    [
                        'control'   => 'footer_sidebar_top_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        $wp_setting_name = 'footer_sidebar_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Footer Widgets', 'agrarium'),
                'section'   => 'agrarium_footer_sidebar',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ----------------------------- //
        // --- Footer Sidebar Select --- //
        // ----------------------------- //
        $wp_setting_name = 'footer_sidebar_select';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Select Sidebar', 'agrarium'),
                'section'       => 'agrarium_footer_sidebar',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => agrarium_get_all_sidebar_list(),
                'dependency'    => [
                    [
                        'control'   => 'footer_sidebar_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));


        // ---#################--- //
        // ---### Copyright ###--- //
        // ---#################--- //
        $wp_customize->add_section('agrarium_footer_copyright',
            array(
                'title' => esc_html__('Copyright', 'agrarium'),
                'panel' => 'agrarium_footer_settings'
            )
        );

        // ------------------------ //
        // --- Copyright Status --- //
        // ------------------------ //
        $wp_setting_name = 'footer_copyright_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Copyright', 'agrarium'),
                'section'   => 'agrarium_footer_copyright',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ---------------------- //
        // --- Copyright Text --- //
        // ---------------------- //
        $wp_setting_name = 'footer_copyright_text';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Copyright Text', 'agrarium'),
                'section'       => 'agrarium_footer_copyright',
                'type'          => 'text',
                'settings'      => $wp_setting_name
            )
        ));

        // ---###################--- //
        // ---### Footer Menu ###--- //
        // ---###################--- //
        $wp_customize->add_section('agrarium_footer_menu',
            array(
                'title' => esc_html__('Footer Menu', 'agrarium'),
                'panel' => 'agrarium_footer_settings'
            )
        );

        // -------------------------- //
        // --- Footer Menu Status --- //
        // -------------------------- //
        $wp_setting_name = 'footer_menu_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Footer Menu', 'agrarium'),
                'section'   => 'agrarium_footer_menu',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // -------------------------- //
        // --- Footer Menu Select --- //
        // -------------------------- //
        $wp_setting_name = 'footer_menu_select';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Select Menu', 'agrarium'),
                'section'   => 'agrarium_footer_menu',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => agrarium_get_all_menu_list()
            )
        ));

        // ---##############################--- //
        // ---### Footer Additional Menu ###--- //
        // ---##############################--- //
        $wp_customize->add_section('agrarium_footer_additional_menu',
            array(
                'title' => esc_html__('Footer Additional Menu', 'agrarium'),
                'panel' => 'agrarium_footer_settings'
            )
        );

        // ------------------------------------- //
        // --- Footer Additional Menu Status --- //
        // ------------------------------------- //
        $wp_setting_name = 'footer_additional_menu_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Additional Footer Menu', 'agrarium'),
                'section'   => 'agrarium_footer_additional_menu',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ------------------------------------- //
        // --- Footer Additional Menu Select --- //
        // ------------------------------------- //
        $wp_setting_name = 'footer_additional_menu_select';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Select Menu', 'agrarium'),
                'section'   => 'agrarium_footer_additional_menu',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => agrarium_get_all_menu_list()
            )
        ));


        // ---#############################--- //
        // ---### Footer Social Buttons ###--- //
        // ---#############################--- //
        $wp_customize->add_section('agrarium_footer_socials',
            array(
                'title' => esc_html__('Social Buttons Settings', 'agrarium'),
                'panel' => 'agrarium_footer_settings'
            )
        );
        // ----------------------------- //
        // --- Footer Social Buttons --- //
        // ----------------------------- //
        $wp_setting_name = 'footer_socials_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Social Buttons', 'agrarium'),
                'section'   => 'agrarium_footer_socials',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));


        // ------------------------------ //
        // ---------- Sidebars ---------- //
        // ------------------------------ //
        $wp_customize->add_section('agrarium_sidebar_settings',
            array(
                'title'     => esc_html__('Sidebars', 'agrarium'),
                'priority'  => 190
            )
        );

        // ----------------------------- //
        // --- Page Sidebar Position --- //
        // ----------------------------- //
        $wp_setting_name = 'sidebar_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Page Sidebar Position', 'agrarium'),
                'section'   => 'agrarium_sidebar_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'left'      => esc_html__('Left', 'agrarium'),
                    'right'     => esc_html__('Right', 'agrarium'),
                    'none'      => esc_html__('None', 'agrarium')
                )
            )
        ));

        // -------------------------------- //
        // --- Archive Sidebar Position --- //
        // -------------------------------- //
        $wp_setting_name = 'archive_sidebar_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Archive Sidebar Position', 'agrarium'),
                'section'   => 'agrarium_sidebar_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'left'      => esc_html__('Left', 'agrarium'),
                    'right'     => esc_html__('Right', 'agrarium'),
                    'none'      => esc_html__('None', 'agrarium')
                )
            )
        ));

        // ------------------------------------ //
        // --- Single Post Sidebar Position --- //
        // ------------------------------------ //
        $wp_setting_name = 'post_sidebar_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Single Post Sidebar Position', 'agrarium'),
                'section'   => 'agrarium_sidebar_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'left'      => esc_html__('Left', 'agrarium'),
                    'right'     => esc_html__('Right', 'agrarium'),
                    'none'      => esc_html__('None', 'agrarium')
                )
            )
        ));

        // -------------------------------- //
        // --- Service Sidebar Position --- //
        // -------------------------------- //
        $wp_setting_name = 'service_sidebar_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Service Sidebar Position', 'agrarium'),
                'section'   => 'agrarium_sidebar_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'left'      => esc_html__('Left', 'agrarium'),
                    'right'     => esc_html__('Right', 'agrarium'),
                    'none'      => esc_html__('None', 'agrarium')
                )
            )
        ));

        if ( class_exists('WooCommerce')) {
            // -------------------------------------------- //
            // --- WooCommerce Catalog Sidebar Position --- //
            // -------------------------------------------- //
            $wp_setting_name = 'catalog_sidebar_position';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                    'sanitize_callback'	=> 'agrarium_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Agrarium_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Catalog Sidebar Position', 'agrarium'),
                    'section'   => 'agrarium_sidebar_settings',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'left'      => esc_html__('Left', 'agrarium'),
                        'right'     => esc_html__('Right', 'agrarium'),
                        'none'      => esc_html__('None', 'agrarium')
                    )
                )
            ));
        }

        // --------------------------------- //
        // ---------- Single Post ---------- //
        // --------------------------------- //
        $wp_customize->add_section('agrarium_single_post_settings',
            array(
                'title'     => esc_html__('Single Post', 'agrarium'),
                'priority'  => 200
            )
        );

        // ------------------------------ //
        // --- Single Post Page Title --- //
        // ------------------------------ //
        $wp_setting_name = 'post_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($agrarium_customizer_default_values[$wp_setting_name]),
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Single Post Page Title', 'agrarium'),
                'section'       => 'agrarium_single_post_settings',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post name', 'agrarium')
            )
        ));

        // ------------------------------- //
        // --- Post Media Image Status --- //
        // ------------------------------- //
        $wp_setting_name = 'post_media_image_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Media Image', 'agrarium'),
                'section'   => 'agrarium_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ---------------------------- //
        // --- Post Category Status --- //
        // ---------------------------- //
        $wp_setting_name = 'post_category_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Post Categories', 'agrarium'),
                'section'   => 'agrarium_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ------------------------ //
        // --- Post Date Status --- //
        // ------------------------ //
        $wp_setting_name = 'post_date_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Post Date', 'agrarium'),
                'section'   => 'agrarium_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // -------------------------- //
        // --- Post Author Status --- //
        // -------------------------- //
        $wp_setting_name = 'post_author_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Post Author', 'agrarium'),
                'section'   => 'agrarium_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ------------------------- //
        // --- Post Title Status --- //
        // ------------------------- //
        $wp_setting_name = 'post_title_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Post Title', 'agrarium'),
                'section'   => 'agrarium_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ------------------------ //
        // --- Post Tags Status --- //
        // ------------------------ //
        $wp_setting_name = 'post_tags_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Post Tags', 'agrarium'),
                'section'   => 'agrarium_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // --------------------------- //
        // --- Post Socials Status --- //
        // --------------------------- //
        $wp_setting_name = 'post_socials_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Post Social Buttons', 'agrarium'),
                'section'   => 'agrarium_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // --------------------------- //
        // --- Recent Posts Status --- //
        // --------------------------- //
        $wp_setting_name = 'recent_posts_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Recent Posts', 'agrarium'),
                'section'   => 'agrarium_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ------------------------------ //
        // --- Recent Posts Customize --- //
        // ------------------------------ //
        $wp_setting_name = 'recent_posts_customize';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Customize', 'agrarium'),
                'section'   => 'agrarium_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                ),
                'separator' => 'before'
            )
        ));

        // ---------------------------- //
        // --- Recent Posts Heading --- //
        // ---------------------------- //
        $wp_setting_name = 'recent_posts_section_heading';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Section Title', 'agrarium'),
                'section'       => 'agrarium_single_post_settings',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------- //
        // --- Number of Posts --- //
        // ----------------------- //
        $wp_setting_name = 'recent_posts_number';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Number of Posts', 'agrarium'),
                'section'       => 'agrarium_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    '2'         => esc_html__('2 Items', 'agrarium'),
                    '3'         => esc_html__('3 Items', 'agrarium'),
                    '4'         => esc_html__('4 Items', 'agrarium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---------------- //
        // --- Order By --- //
        // ---------------- //
        $wp_setting_name = 'recent_posts_order_by';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Order By', 'agrarium'),
                'section'       => 'agrarium_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'random'        => esc_html__('Random', 'agrarium'),
                    'date'          => esc_html__('Date', 'agrarium'),
                    'name'          => esc_html__('Name', 'agrarium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------ //
        // --- Sort Order --- //
        // ------------------ //
        $wp_setting_name = 'recent_posts_order';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Sort Order', 'agrarium'),
                'section'       => 'agrarium_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'desc'  => esc_html__('Descending', 'agrarium'),
                    'asc'   => esc_html__('Ascending', 'agrarium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------ //
        // --- Show Recent Post Image --- //
        // ------------------------------ //
        $wp_setting_name = 'recent_posts_image';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Featured Image', 'agrarium'),
                'section'       => 'agrarium_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Show', 'agrarium'),
                    'off'   => esc_html__('Hide', 'agrarium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------------- //
        // --- Show Recent Post Category --- //
        // --------------------------------- //
        $wp_setting_name = 'recent_posts_category';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Categories', 'agrarium'),
                'section'       => 'agrarium_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Show', 'agrarium'),
                    'off'   => esc_html__('Hide', 'agrarium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------------- //
        // --- Show Recent Post Date --- //
        // ----------------------------- //
        $wp_setting_name = 'recent_posts_date';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Date', 'agrarium'),
                'section'       => 'agrarium_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Show', 'agrarium'),
                    'off'   => esc_html__('Hide', 'agrarium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------- //
        // --- Show Recent Post Author --- //
        // ------------------------------- //
        $wp_setting_name = 'recent_posts_author';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Author', 'agrarium'),
                'section'       => 'agrarium_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Show', 'agrarium'),
                    'off'   => esc_html__('Hide', 'agrarium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------ //
        // --- Show Recent Post Title --- //
        // ------------------------------ //
        $wp_setting_name = 'recent_posts_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Title', 'agrarium'),
                'section'       => 'agrarium_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Show', 'agrarium'),
                    'off'   => esc_html__('Hide', 'agrarium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- Show Recent Post Excerpt --- //
        // -------------------------------- //
        $wp_setting_name = 'recent_posts_excerpt';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Excerpt', 'agrarium'),
                'section'       => 'agrarium_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Show', 'agrarium'),
                    'off'   => esc_html__('Hide', 'agrarium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------------------- //
        // --- Show Recent Post Excerpt Length --- //
        // --------------------------------------- //
        $wp_setting_name = 'recent_posts_excerpt_length';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Excerpt Length', 'agrarium'),
                'section'       => 'agrarium_single_post_settings',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'input_attrs' => [
                    'min'   => 0,
                    'step'  => 1
                ]
            )
        ));

        // ----------------------------- //
        // --- Show Recent Post Tags --- //
        // ----------------------------- //
        $wp_setting_name = 'recent_posts_tags';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Tags', 'agrarium'),
                'section'       => 'agrarium_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Show', 'agrarium'),
                    'off'   => esc_html__('Hide', 'agrarium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------------------------- //
        // --- Show Recent Post Read More Button --- //
        // ----------------------------------------- //
        $wp_setting_name = 'recent_posts_more';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts \'Read More\' Button', 'agrarium'),
                'section'       => 'agrarium_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Show', 'agrarium'),
                    'off'   => esc_html__('Hide', 'agrarium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------------- //
        // --- Recent Post Read More Button Title --- //
        // ------------------------------------- //
        $wp_setting_name = 'recent_posts_more_text';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts \'Read More\' Button Title', 'agrarium'),
                'section'       => 'agrarium_single_post_settings',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------------- //
        // ---------- Portfolio Panel ---------- //
        // ------------------------------------- //
        $wp_customize->add_panel('agrarium_portfolio_settings',
            array(
                'title'     => esc_html__('Portfolio', 'agrarium'),
                'priority'  => 205
            )
        );

        // ---#########################--- //
        // ---### Portfolio Archive ###--- //
        // ---#########################--- //
        $wp_customize->add_section('agrarium_portfolio_archive',
            array(
                'title' => esc_html__('Archive Settings', 'agrarium'),
                'panel' => 'agrarium_portfolio_settings'
            )
        );

        // ------------------------------------ //
        // --- Portfolio Archive Page Title --- //
        // ------------------------------------ //
        $wp_setting_name = 'portfolio_archive_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($agrarium_customizer_default_values[$wp_setting_name]),
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Portfolio Archive Page Title', 'agrarium'),
                'section'       => 'agrarium_portfolio_archive',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post type name', 'agrarium')
            )
        ));

        // ---------------------------------------- //
        // --- Portfolio Archive Columns Number --- //
        // ---------------------------------------- //
        $wp_setting_name = 'portfolio_archive_columns_number';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Portfolio Archive Columns Number', 'agrarium'),
                'section'       => 'agrarium_portfolio_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 1,
                    'max'   => 4,
                    'step'  => 1
                ]
            )
        ));

        // ---------------------------------------- //
        // --- Portfolio Archive Posts per Page --- //
        // ---------------------------------------- //
        $wp_setting_name = 'portfolio_archive_posts_per_page';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Portfolio Posts Per Page', 'agrarium'),
                'section'       => 'agrarium_portfolio_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 1,
                    'step'  => 1
                ]
            )
        ));

        // ---########################--- //
        // ---### Portfolio Single ###--- //
        // ---########################--- //
        $wp_customize->add_section('agrarium_portfolio_single',
            array(
                'title' => esc_html__('Single Page Settings', 'agrarium'),
                'panel' => 'agrarium_portfolio_settings'
            )
        );

        // ------------------------------------ //
        // --- Portfolio Single Page Title --- //
        // ------------------------------------ //
        $wp_setting_name = 'portfolio_single_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($agrarium_customizer_default_values[$wp_setting_name]),
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Portfolio Single Page Title', 'agrarium'),
                'section'       => 'agrarium_portfolio_single',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post name', 'agrarium')
            )
        ));

        // ---------------------------------------- //
        // ---------- Team Members Panel ---------- //
        // ---------------------------------------- //
        $wp_customize->add_panel('agrarium_team_settings',
            array(
                'title'     => esc_html__('Team Members', 'agrarium'),
                'priority'  => 208
            )
        );

        // ---############################--- //
        // ---### Team Members Archive ###--- //
        // ---############################--- //
        $wp_customize->add_section('agrarium_team_archive',
            array(
                'title' => esc_html__('Archive Settings', 'agrarium'),
                'panel' => 'agrarium_team_settings'
            )
        );

        // --------------------------------------- //
        // --- Team Members Archive Page Title --- //
        // --------------------------------------- //
        $wp_setting_name = 'team_archive_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($agrarium_customizer_default_values[$wp_setting_name]),
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Team Members Archive Page Title', 'agrarium'),
                'section'       => 'agrarium_team_archive',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post type name', 'agrarium')
            )
        ));

        // ------------------------------------------- //
        // --- Team Members Archive Columns Number --- //
        // ------------------------------------------- //
        $wp_setting_name = 'team_archive_columns_number';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Team Members Archive Columns Number', 'agrarium'),
                'section'       => 'agrarium_team_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 1,
                    'max'   => 4,
                    'step'  => 1
                ]
            )
        ));

        // ------------------------------------------- //
        // --- Team Members Archive Posts per Page --- //
        // ------------------------------------------- //
        $wp_setting_name = 'team_archive_posts_per_page';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Team Members Posts Per Page', 'agrarium'),
                'section'       => 'agrarium_team_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 1,
                    'step'  => 1
                ]
            )
        ));

        // ---##########################--- //
        // ---### Team Member Single ###--- //
        // ---##########################--- //
        $wp_customize->add_section('agrarium_team_single',
            array(
                'title' => esc_html__('Single Page Settings', 'agrarium'),
                'panel' => 'agrarium_team_settings'
            )
        );

        // ------------------------------------- //
        // --- Team Member Single Page Title --- //
        // ------------------------------------- //
        $wp_setting_name = 'team_single_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($agrarium_customizer_default_values[$wp_setting_name]),
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Team Member Single Page Title', 'agrarium'),
                'section'       => 'agrarium_team_single',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post name', 'agrarium')
            )
        ));

        // ------------------------------------ //
        // ---------- Services Panel ---------- //
        // ------------------------------------ //
        $wp_customize->add_panel('agrarium_services_settings',
            array(
                'title'     => esc_html__('Services', 'agrarium'),
                'priority'  => 210
            )
        );

        // ---########################--- //
        // ---### Services Archive ###--- //
        // ---########################--- //
        $wp_customize->add_section('agrarium_service_archive',
            array(
                'title' => esc_html__('Archive Settings', 'agrarium'),
                'panel' => 'agrarium_services_settings'
            )
        );

        // ----------------------------------- //
        // --- Services Archive Page Title --- //
        // ----------------------------------- //
        $wp_setting_name = 'service_archive_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($agrarium_customizer_default_values[$wp_setting_name]),
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Services Archive Page Title', 'agrarium'),
                'section'       => 'agrarium_service_archive',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post type name', 'agrarium')
            )
        ));

        // --------------------------------------- //
        // --- Services Archive Excerpt Length --- //
        // --------------------------------------- //
        $wp_setting_name = 'service_archive_excerpt_length';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Services Excerpt Length', 'agrarium'),
                'section'       => 'agrarium_service_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 0,
                    'step'  => 1
                ]
            )
        ));

        // -------------------------------------- //
        // --- Service Archive Columns Number --- //
        // -------------------------------------- //
        $wp_setting_name = 'service_archive_columns_number';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Service Archive Columns Number', 'agrarium'),
                'section'       => 'agrarium_service_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 1,
                    'max'   => 4,
                    'step'  => 1
                ]
            )
        ));

        // --------------------------------------- //
        // --- Services Archive Posts per Page --- //
        // --------------------------------------- //
        $wp_setting_name = 'service_archive_posts_per_page';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Service Posts Per Page', 'agrarium'),
                'section'       => 'agrarium_service_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 1,
                    'step'  => 1
                ]
            )
        ));

        // ---######################--- //
        // ---### Service Single ###--- //
        // ---######################--- //
        $wp_customize->add_section('agrarium_service_single',
            array(
                'title' => esc_html__('Single Page Settings', 'agrarium'),
                'panel' => 'agrarium_services_settings'
            )
        );

        // ---------------------------------- //
        // --- Services Single Page Title --- //
        // ---------------------------------- //
        $wp_setting_name = 'service_single_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($agrarium_customizer_default_values[$wp_setting_name]),
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Service Single Page Title', 'agrarium'),
                'section'       => 'agrarium_service_single',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post name', 'agrarium')
            )
        ));

        // ------------------------------------- //
        // ---------- Production Panel ---------- //
        // ------------------------------------- //
        $wp_customize->add_panel('agrarium_production_settings',
            array(
                'title'     => esc_html__('Production', 'agrarium'),
                'priority'  => 211
            )
        );

        // ---#########################--- //
        // ---### Production Archive ###--- //
        // ---#########################--- //
        $wp_customize->add_section('agrarium_production_archive',
            array(
                'title' => esc_html__('Archive Settings', 'agrarium'),
                'panel' => 'agrarium_production_settings'
            )
        );

        // ------------------------------------ //
        // --- Production Archive Page Title --- //
        // ------------------------------------ //
        $wp_setting_name = 'production_archive_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($agrarium_customizer_default_values[$wp_setting_name]),
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Production Archive Page Title', 'agrarium'),
                'section'       => 'agrarium_production_archive',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post type name', 'agrarium')
            )
        ));

        // ---------------------------------------- //
        // --- Production Archive Posts per Page --- //
        // ---------------------------------------- //
        $wp_setting_name = 'production_archive_posts_per_page';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Production Posts Per Page', 'agrarium'),
                'section'       => 'agrarium_production_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 1,
                    'step'  => 1
                ]
            )
        ));

        // ---########################--- //
        // ---### Production Single ###--- //
        // ---########################--- //
        $wp_customize->add_section('agrarium_production_single',
            array(
                'title' => esc_html__('Single Page Settings', 'agrarium'),
                'panel' => 'agrarium_production_settings'
            )
        );

        // ------------------------------------ //
        // --- Production Single Page Title --- //
        // ------------------------------------ //
        $wp_setting_name = 'production_single_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($agrarium_customizer_default_values[$wp_setting_name]),
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Production Single Page Title', 'agrarium'),
                'section'       => 'agrarium_production_single',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post name', 'agrarium')
            )
        ));

        // ------------------------------ //
        // ------- 404 Error Page ------- //
        // ------------------------------ //
        $wp_customize->add_section('agrarium_error_page_settings',
            array(
                'title'     => esc_html__('Error 404 Page', 'agrarium'),
                'priority'  => 212
            )
        );

        // ----------------------- //
        // --- 404 Error Title --- //
        // ----------------------- //
        $wp_setting_name = 'error_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'wp_kses_post'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('404 Error Title', 'agrarium'),
                'section'       => 'agrarium_error_page_settings',
                'type'          => 'textarea',
                'settings'      => $wp_setting_name
            )
        ));

        // ---------------------- //
        // --- 404 Error Text --- //
        // ---------------------- //
        $wp_setting_name = 'error_text';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'wp_kses_post'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('404 Error Info Text', 'agrarium'),
                'section'       => 'agrarium_error_page_settings',
                'type'          => 'textarea',
                'settings'      => $wp_setting_name
            )
        ));

        // ----------------------------- //
        // --- 404 Error Logo Status --- //
        // ----------------------------- //
        $wp_setting_name = 'error_logo_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Show Header Logo', 'agrarium'),
                'section'       => 'agrarium_error_page_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Yes', 'agrarium'),
                    'off'   => esc_html__('No', 'agrarium')
                ),
                'description'   => esc_html__('Works only if the logo image is set in "Header Settings"', 'agrarium')
            )
        ));

        // -------------------------------- //
        // --- 404 Error Socials Status --- //
        // -------------------------------- //
        $wp_setting_name = 'error_socials_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Footer Social Buttons', 'agrarium'),
                'section'   => 'agrarium_error_page_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ------------------------------------ //
        // --- 404 Error Home Button Status --- //
        // ------------------------------------ //
        $wp_setting_name = 'error_button_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Home Button', 'agrarium'),
                'section'   => 'agrarium_error_page_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ----------------------------- //
        // --- 404 Error Button Text --- //
        // ----------------------------- //
        $wp_setting_name = 'error_button_text';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Home Button Text', 'agrarium'),
                'section'       => 'agrarium_error_page_settings',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'error_button_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------------- //
        // --- 404 Error Background Customize --- //
        // -------------------------------------- //
        $wp_setting_name = 'error_background_customize';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Customize Background', 'agrarium'),
                'section'   => 'agrarium_error_page_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // --------------------------------- //
        // --- 404 Page Background Color --- //
        // --------------------------------- //
        $wp_setting_name = 'error_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Color', 'agrarium'),
                'section'       => 'agrarium_error_page_settings',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'error_background_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------------- //
        // --- 404 Page Background Image --- //
        // --------------------------------- //
        $wp_setting_name = 'error_background_image';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'esc_url_raw'
            )
        );
        $wp_customize->add_control(new Agrarium_Image_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Image', 'agrarium'),
                'section'       => 'agrarium_error_page_settings',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'error_background_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------------ //
        // --- 404 Page Background Position --- //
        // ------------------------------------ //
        $wp_setting_name = 'error_background_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Position', 'agrarium'),
                'section'       => 'agrarium_error_page_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => agrarium_get_background_position_options(),
                'dependency'    => [
                    [
                        'control'   => 'error_background_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---------------------------------- //
        // --- 404 Page Background Repeat --- //
        // ---------------------------------- //
        $wp_setting_name = 'error_background_repeat';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Repeat', 'agrarium'),
                'section'       => 'agrarium_error_page_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => agrarium_get_background_repeat_options(),
                'dependency'    => [
                    [
                        'control'   => 'error_background_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- 404 Page Background Size --- //
        // -------------------------------- //
        $wp_setting_name = 'error_background_size';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Size', 'agrarium'),
                'section'       => 'agrarium_error_page_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => agrarium_get_background_size_options(),
                'dependency'    => [
                    [
                        'control'   => 'error_background_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------------- //
        // --- 404 Page Image --- //
        // --------------------------------- //
        $wp_setting_name = 'error_image';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'esc_url_raw'
            )
        );
        $wp_customize->add_control(new Agrarium_Image_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Image', 'agrarium'),
                'section'       => 'agrarium_error_page_settings',
                'settings'      => $wp_setting_name
            )
        ));

        // ------------------------------------------- //
        // --- 404 Error Additional Text Customize --- //
        // ------------------------------------------- //
        $wp_setting_name = 'error_additional_text_customize';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Customize Additional Text', 'agrarium'),
                'section'   => 'agrarium_error_page_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // --------------------------------- //
        // --- 404 Page Background Color --- //
        // --------------------------------- //
        $wp_setting_name = 'error_additional_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Agrarium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Text Color', 'agrarium'),
                'section'       => 'agrarium_error_page_settings',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => agrarium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'error_additional_text_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------------------ //
        // --- 404 Error Additional Text Top Left --- //
        // ------------------------------------------ //
        $wp_setting_name = 'error_additional_text_top_left';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Text, First Part', 'agrarium'),
                'section'       => 'agrarium_error_page_settings',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'error_additional_text_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---------------------------------------------- //
        // --- 404 Error Additional Text Bottom Right --- //
        // ---------------------------------------------- //
        $wp_setting_name = 'error_additional_text_bottom_right';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Text, Second Part', 'agrarium'),
                'section'       => 'agrarium_error_page_settings',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'error_additional_text_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        if ( class_exists('WooCommerce') ) {

            // ------------------------------------------ //
            // ---------- WooCommerce Settings ---------- //
            // ------------------------------------------ //

            // ---######################--- //
            // ---### Single Product ###--- //
            // ---######################--- //
            $wp_customize->add_section('agrarium_woocommerce_single_product',
                array(
                    'title' => esc_html__('Single Product', 'agrarium'),
                    'panel' => 'woocommerce'
                )
            );

            // ----------------------------------------------- //
            // --- Single Product Related Products Section --- //
            // ----------------------------------------------- //
            $wp_setting_name = 'woo_single_product_show_related_section';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                    'sanitize_callback'	=> 'agrarium_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Agrarium_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show Related Products', 'agrarium'),
                    'section'   => 'agrarium_woocommerce_single_product',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'agrarium'),
                        'off'       => esc_html__('No', 'agrarium')
                    )
                )
            ));

            // -------------------------------- //
            // --- Related Products Heading --- //
            // -------------------------------- //
            $wp_setting_name = 'woo_related_title';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                    'sanitize_callback'	=> 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Agrarium_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Related Products Section Title', 'agrarium'),
                    'section'       => 'agrarium_woocommerce_single_product',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'woo_single_product_show_related_section',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // --------------------------------- //
            // --- Single Product Page Title --- //
            // --------------------------------- //
            $wp_setting_name = 'woo_single_product_title';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => stripslashes($agrarium_customizer_default_values[$wp_setting_name]),
                    'sanitize_callback'	=> 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Agrarium_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Single Product Page Title', 'agrarium'),
                    'section'       => 'agrarium_woocommerce_single_product',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name,
                    'description'   => esc_html__('Use variable \'%s\' for display Product title', 'agrarium')
                )
            ));

            // ------------------------- //
            // --- Show Product Name --- //
            // ------------------------- //
            $wp_setting_name = 'woo_single_product_show_name';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'agrarium_sanitize_checkbox'
                )
            );
            $wp_customize->add_control(new Agrarium_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Show Product name above the Price', 'agrarium'),
                    'section'       => 'agrarium_woocommerce_single_product',
                    'type'          => 'checkbox',
                    'settings'      => $wp_setting_name
                )
            ));

            // --------------------------------- //
            // --- Up-sells Products Heading --- //
            // --------------------------------- //
            $wp_setting_name = 'woo_upsells_title';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => stripslashes($agrarium_customizer_default_values[$wp_setting_name]),
                    'sanitize_callback'	=> 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Agrarium_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Up-sells Section Title', 'agrarium'),
                    'section'       => 'agrarium_woocommerce_single_product',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name
                )
            ));

            // ---##########################--- //
            // ---### Product Categories ###--- //
            // ---##########################--- //
            $wp_customize->add_section('agrarium_woocommerce_product_archive',
                array(
                    'title' => esc_html__('Product Archive', 'agrarium'),
                    'panel' => 'woocommerce'
                )
            );

            // -------------------------------- //
            // --- Product Categories Title --- //
            // -------------------------------- //
            $wp_setting_name = 'woo_product_categories_title';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => stripslashes($agrarium_customizer_default_values[$wp_setting_name]),
                    'sanitize_callback'	=> 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Agrarium_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Product Category Page Title', 'agrarium'),
                    'section'       => 'agrarium_woocommerce_product_archive',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name,
                    'description'   => esc_html__('Use variable \'%s\' for display Product category name', 'agrarium')
                )
            ));

            // -------------------------- //
            // --- Product Tags Title --- //
            // -------------------------- //
            $wp_setting_name = 'woo_product_tags_title';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => stripslashes($agrarium_customizer_default_values[$wp_setting_name]),
                    'sanitize_callback'	=> 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Agrarium_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Product Tag Page Title', 'agrarium'),
                    'section'       => 'agrarium_woocommerce_product_archive',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name,
                    'description'   => esc_html__('Use variable \'%s\' for display Product tag name', 'agrarium')
                )
            ));

        }

        // ----------------------------------------------- //
        // ---------- Additional Settings Panel ---------- //
        // ----------------------------------------------- //
        $wp_customize->add_panel('agrarium_additional_settings',
            array(
                'title'     => esc_html__('Additional Settings', 'agrarium'),
                'priority'  => 220
            )
        );

        // ---###################--- //
        // ---### Page Loader ###--- //
        // ---###################--- //
        $wp_customize->add_section('agrarium_page_loader',
            array(
                'title' => esc_html__('Page Loader', 'agrarium'),
                'panel' => 'agrarium_additional_settings'
            )
        );

        // -------------------------- //
        // --- Page Loader Status --- //
        // -------------------------- //
        $wp_setting_name = 'page_loader_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'agrarium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Agrarium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Page Loader', 'agrarium'),
                'section'   => 'agrarium_page_loader',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'agrarium'),
                    'off'       => esc_html__('No', 'agrarium')
                )
            )
        ));

        // ------------------------- //
        // --- Page Loader Image --- //
        // ------------------------- //
        $wp_setting_name = 'page_loader_image';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $agrarium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'esc_url_raw'
            )
        );
        $wp_customize->add_control(new Agrarium_Image_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Page Loader Image', 'agrarium'),
                'section'       => 'agrarium_page_loader',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Maximum 100x100px', 'agrarium'),
                'dependency'    => [
                    [
                        'control'   => 'page_loader_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

    }
}
