<?php
# One Click Demo Content Import
if (!function_exists('agrarium_ocdi_import_files')) {
    function agrarium_ocdi_import_files() {
        return array(
            array(
                'import_file_name'              => 'Agrarium',
                'categories'                    => array('With Images'),
                'import_file_url'               => trailingslashit(get_template_directory_uri()) . 'core/import/import.xml',
                'import_widget_file_url'        => trailingslashit(get_template_directory_uri()) . 'core/import/widgets.xml',
                'import_customizer_file_url'    => trailingslashit(get_template_directory_uri()) . 'core/import/customizer.xml',
                'import_preview_image_url'      => trailingslashit(get_template_directory_uri()) . 'screenshot.png',
                'preview_url'                   => 'https://demo.artureanec.com/themes/agrarium',
            ),
        );
    }
}
add_filter( 'pt-ocdi/import_files', 'agrarium_ocdi_import_files' );

# Remove Branding Message
add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );

# Disable Regenerate for Thumbs
//add_filter( 'pt-ocdi/regenerate_thumbnails_in_content_import', '__return_false' ); // This will greatly improve the time needed to import the content (images), but only the original sized images will be imported.

if (!function_exists('agrarium_after_activation')) {
    function agrarium_after_activation() {
        function agrarium_after_switch_theme_message() {
            echo '<div class="updated notice is-dismissible"><p>' . esc_html__('After activating all the recommended plugins, you can import all demo content in one-touch. Appearance > Import Demo Data.', 'agrarium') . '</p></div>';
        }
        add_action('admin_notices', 'agrarium_after_switch_theme_message');
    }
}
add_action('after_switch_theme', 'agrarium_after_activation', 10 , 2);

# Remove all posts, pages and products before content import
if ( !function_exists('agrarium_ocdi_before_content_import') ) {
    function agrarium_ocdi_before_content_import() {
        $allposts= get_posts( array(
            'post_type'     => array('post', 'page', 'products', 'attachment', ''),
            'numberposts'   => -1
        ) );
        foreach ($allposts as $eachpost) {
            wp_delete_post( $eachpost->ID, true );
        }
    }
}
add_action( 'pt-ocdi/before_content_import', 'agrarium_ocdi_before_content_import' );

# Clear sidebars before the widgets get imported
if ( !function_exists('agrarium_ocdi_before_widgets_import') ) {
    function agrarium_ocdi_before_widgets_import() {
        update_option( 'sidebars_widgets', array() );
    }
}
add_action( 'pt-ocdi/before_widgets_import', 'agrarium_ocdi_before_widgets_import' );


if (!function_exists('agrarium_ocdi_after_import_setup')) {
    function agrarium_ocdi_after_import_setup() {
        // Assign menus to their locations.
        $main_menu              = get_term_by('name', 'Main Menu', 'nav_menu');
        $top_bar_user_menu      = get_term_by('name', 'Top Bar Menu', 'nav_menu');
        $footer_menu            = get_term_by('name', 'Footer Menu', 'nav_menu');
        $footer_additional_menu = get_term_by('name', 'Footer Additional Menu', 'nav_menu');

        set_theme_mod('nav_menu_locations', array(
            'main'              => $main_menu->term_id,
            'top_bar_user_menu' => $top_bar_user_menu->term_id,
            'footer_menu'       => $footer_menu->term_id,
            'footer_add_menu'   => $footer_additional_menu->term_id,
        ));

        // Assign front page and posts page (blog page).
        $front_page_id = get_page_by_title('Agriculture');
        # $blog_page_id  = get_page_by_title( 'Blog' );
        update_option('show_on_front', 'page');
        update_option('page_on_front', $front_page_id->ID);
        // update_option( 'page_for_posts', $blog_page_id->ID );

        // Set Mailchimp for WP options
        if ( function_exists( 'mc4wp' ) ) {
            $has_forms = get_posts(
                array(
                    'post_type'   => 'mc4wp-form',
                    'post_status' => 'publish',
                    'numberposts' => 1,
                )
            );
            update_option( 'mc4wp_default_form_id', $has_forms[0]->ID );
        }

        // Set WooCommerce options
        if ( class_exists('WooCommerce') ) {
            if (!wc_update_product_lookup_tables_is_running()) {
                wc_update_product_lookup_tables();
            }
            $args = array(
                'post_type'     => 'product',
                'post_status'   => 'publish',
                'orderby'       => 'date',
                'order'         => 'ASC'
            );
            $loop = new WP_Query($args);
            while ($loop->have_posts()) {
                $loop->the_post();
                global $product;
                wc_delete_product_transients($product->get_id());
            }

            $shop_page_id       = get_page_by_title('Product List');
            $cart_page_id       = get_page_by_title('Cart');
            $checkout_page_id   = get_page_by_title('Checkout');
            $account_page_id    = get_page_by_title('My Account');
            update_option( 'woocommerce_shop_page_id', $shop_page_id->ID );
            update_option( 'woocommerce_cart_page_id', $cart_page_id->ID );
            update_option( 'woocommerce_checkout_page_id', $checkout_page_id->ID );
            update_option( 'woocommerce_myaccount_page_id', $account_page_id->ID );
            update_option( 'permalink_structure', '/%postname%/' );
        }

        // Set Elementor options
        if ( did_action('elementor/loaded') ) {
            update_option('elementor_disable_color_schemes', 'yes');
            update_option('elementor_disable_typography_schemes', 'yes');

            update_option('elementor_experiment-e_dom_optimization', 'inactive');
            update_option('elementor_experiment-e_optimized_css_loading', 'inactive');
            update_option('elementor_experiment-container_grid', 'inactive');
            update_option('elementor_experiment-container', 'inactive');
            update_option('elementor_experiment-block_editor_assets_optimize', 'inactive');

            $kit = \Elementor\Plugin::$instance->kits_manager->get_active_kit_for_frontend();
            $kit->update_settings(
                [
                    'container_width' => [
                        'unit'  => 'px',
                        'size'  => 1170,
                        'sizes' => []
                    ],
                ]
            );
            $kit->update_settings(
                [
                    'space_between_widgets' => [
                        'unit'  => 'px',
                        'size'  => 20,
                        'sizes' => []
                    ],
                ]
            );
            $kit->update_settings(
                [
                    'viewport_lg' => 992,
                    'viewport_laptop' => 1279,
                    'viewport_tablet' => 991,
                    'viewport_widescreen' => 1921
                ]
            );
            $kit->update_settings(
                [
                    'active_breakpoints' => [
                    	'viewport_mobile',
                    	'viewport_tablet',
                    	'viewport_laptop',
                    	'viewport_widescreen'
                    ]
                ]
            );
            $kit->update_settings(
                [
                    'system_colors'         => [
                        0   => [
                            '_id'   => 'primary',
                            'title' => esc_html__('Primary', 'agrarium'),
                            'color' => '#2C2C2C'
                        ],
                        1   => [
                            '_id'   => 'secondary',
                            'title' => esc_html__('Secondary', 'agrarium'),
                            'color' => '#1F1E17'
                        ],
                        2   => [
                            '_id'   => 'text',
                            'title' => esc_html__('Text', 'agrarium'),
                            'color' => '#767676'
                        ],
                        3   => [
                            '_id'   => 'accent',
                            'title' => esc_html__('Accent', 'agrarium'),
                            'color' => '#EECE38'
                        ]
                    ],
                    'custom_colors'         => [
                        0   => [
                            '_id'   => '1caf227',
                            'title' => esc_html__('Alt Background', 'agrarium'),
                            'color' => '#F7F5EA'
                        ]
                    ]
                ]
            );
            $kit->update_settings(
                [
                    'system_typography'         => [
                        0   => [
                            '_id'   => 'primary',
                            'title' => esc_html__('Primary', 'agrarium'),
                            'typography_font_family' => 'Manrope',
                            'typography_font_weight' => '400',
                            'typography_typography' => 'custom'
                        ],
                        1   => [
                            '_id'   => 'secondary',
                            'title' => esc_html__('Secondary', 'agrarium'),
                            'typography_font_family' => 'Herbarium',
                            'typography_font_weight' => '400',
                            'typography_typography' => 'custom'
                        ],
                        2   => [
                            '_id'   => 'text',
                            'title' => esc_html__('Text', 'agrarium'),
                            'typography_font_family' => 'Manrope',
                            'typography_font_weight' => '400',
                            'typography_typography' => 'custom',
                            'typography_font_size' => [
                            	'unit' => 'px',
                            	'size' => 16                            	
                            ]
                        ],
                        3   => [
                            '_id'   => 'accent',
                            'title' => esc_html__('Accent', 'agrarium'),
                            'typography_font_weight' => '500',
                            'typography_typography' => 'custom',
                            'typography_font_size' => [
                            	'unit' => 'px',
                            	'size' => 16                            	
                            ]
                        ]
                    ]
                ]
            );
        }

        // Import forms
        if ( function_exists('wpforms') ) {
            $title = esc_html__('Contact Form', 'agrarium');
            $form_id = wpforms()->form->add($title);
            $form_id = wpforms()->form->update(
                $form_id,
                array(
                    'id'        => 7966,
                    'field_id'  => 6,
                    'fields'    => array(
                        '0'                         => array(
                            'id'                        => '0',
                            'type'                      => 'text',
                            'label'                     => esc_html__('Name', 'agrarium'),
                            'description'               => '',
                            'required'                  => '1',
                            'size'                      => 'large',
                            'placeholder'               => esc_attr__('Name *', 'agrarium'),
                            'label_hide'                => '1',
                            'default_value'             => '',
                            'css'                       => '',
                            'input_mask'                => '',
                        ),
                        '1'                         => array(
                            'id'                        => '1',
                            'type'                      => 'email',
                            'label'                     => esc_html__('Email', 'agrarium'),
                            'description'               => '',
                            'required'                  => '1',
                            'size'                      => 'large',
                            'placeholder'               => esc_attr__('Email *', 'agrarium'),
                            'confirmation_placeholder'  => '',
                            'label_hide'                => '1',
                            'default_value'             => '',
                            'css'                       => '',
                            'filter_type'               => '',
                            'allowlist'                 => '',
                            'denylist'                  => '',
                        ),
                        '3'                         => array(
                            'id'                        => '3',
                            'type'                      => 'text',
                            'label'                     => esc_html__('Subject', 'agrarium'),
                            'description'               => '',
                            'size'                      => 'large',
                            'placeholder'               => esc_attr__('Subject', 'agrarium'),
                            'label_hide'                => '1',
                            'default_value'             => '',
                            'css'                       => '',
                            'input_mask'                => '',
                        ),
                        '2'                         => array(
                            'id'                        => '2',
                            'type'                      => 'textarea',
                            'label'                     => esc_html__('Message', 'agrarium'),
                            'description'               => '',
                            'size'                      => 'small',
                            'placeholder'               => esc_attr__('Message...', 'agrarium'),
                            'label_hide'                => '1',
                            'default_value'             => '',
                            'css'                       => '',
                        ),
                    ),
                    'settings' => array(
                        'form_title'                => $title,
                        'form_desc'                 => '',
                        'form_class'                => '',
                        'submit_text'               => esc_html__('Send a Message', 'agrarium'),
                        'submit_text_processing'    => esc_html__('Sending...', 'agrarium'),
                        'submit_class'              => 'fullwidth',
                        'ajax_submit'               => '1',
                        'antispam'                  => '1',
                        'notification_enable'       => '1',
                        'notifications'             => array(
                            '1'                         => array(
                                'email'                     => '{admin_email}',
                                'subject'                   => esc_html__('New Entry: Contact Form', 'agrarium'),
                                'sender_name'               => 'Agrarium',
                                'sender_address'            => '{admin_email}',
                                'replyto'                   => '{field_id="1"}',
                                'message'                   => '{all_fields}',
                            ),
                        ),
                        'confirmations'             => array(
                            '1'                         => array(
                                'type'                      => 'message',
                                'message'                   => '<p>' . esc_html__('Thanks for contacting us! We will be in touch with you shortly.', 'agrarium') . '</p>',
                                'message_scroll'            => '1',
                                'page'                      => '172',
                                'redirect'                  => '',
                            ),
                        ),
                    ),
                    'meta'                      => array(
                        'template'                  => 'blank',
                    ),
                )
            );
            wp_update_post(
                array(
                    'ID'         => $form_id,
                    'post_title' => $title,
                )
            );

            $title2 = esc_html__('Livestock Contact Form', 'agrarium');
            $form_id2 = wpforms()->form->add($title2);
            $form_id2 = wpforms()->form->update(
                $form_id2,
                array(
                    'id'        => 11687,
                    'field_id'  => 5,
                    'fields'    => array(
                        '0'                         => array(
                            'id'                        => '0',
                            'type'                      => 'text',
                            'label'                     => esc_html__('Full name', 'agrarium'),
                            'description'               => '',
                            'required'                  => '1',
                            'size'                      => 'large',
                            'placeholder'               => esc_attr__('Full name', 'agrarium'),
                            'label_hide'                => '1',
                            'default_value'             => '',
                            'css'                       => 'wpforms-one-half wpforms-first',
                            'input_mask'                => '',
                        ),
                        '1'                         => array(
                            'id'                        => '1',
                            'type'                      => 'email',
                            'label'                     => esc_html__('Email', 'agrarium'),
                            'description'               => '',
                            'required'                  => '1',
                            'size'                      => 'large',
                            'placeholder'               => esc_attr__('Email', 'agrarium'),
                            'confirmation_placeholder'  => '',
                            'label_hide'                => '1',
                            'default_value'             => '',
                            'css'                       => 'wpforms-one-half',
                            'filter_type'               => '',
                            'allowlist'                 => '',
                            'denylist'                  => '',
                        ),
                        '6'                         => array(
                            'id'                        => '6',
                            'type'                      => 'text',
                            'label'                     => esc_html__('Subject', 'agrarium'),
                            'description'               => '',
                            'size'                      => 'large',
                            'placeholder'               => esc_attr__('Subject', 'agrarium'),
                            'label_hide'                => '1',
                            'default_value'             => '',
                            'css'                       => '',
                            'input_mask'                => '',
                        ),
                        '2'                         => array(
                            'id'                        => '2',
                            'type'                      => 'textarea',
                            'label'                     => esc_html__('Comment', 'agrarium'),
                            'description'               => '',
                            'size'                      => 'medium',
                            'placeholder'               => esc_attr__('Comment', 'agrarium'),
                            'label_hide'                => '1',
                            'default_value'             => '',
                            'css'                       => '',
                        ),
                    ),
                    'settings' => array(
                        'form_title'                => $title2,
                        'form_desc'                 => '',
                        'form_class'                => '',
                        'submit_text'               => esc_html__('Send Message', 'agrarium'),
                        'submit_text_processing'    => esc_html__('Sending...', 'agrarium'),
                        'submit_class'              => '',
                        'ajax_submit'               => '1',
                        'antispam'                  => '1',
                        'notification_enable'       => '1',
                        'notifications'             => array(
                            '1'                         => array(
                                'email'                     => '{admin_email}',
                                'subject'                   => esc_html__('New Entry: Livestock Contact Form', 'agrarium'),
                                'sender_name'               => 'Agrarium',
                                'sender_address'            => '{admin_email}',
                                'replyto'                   => '{field_id="1"}',
                                'message'                   => '{all_fields}',
                            ),
                        ),
                        'confirmations'             => array(
                            '1'                         => array(
                                'type'                      => 'message',
                                'message'                   => '<p>' . esc_html__('Thanks for contacting us! We will be in touch with you shortly.', 'agrarium') . '</p>',
                                'message_scroll'            => '1',
                                'page'                      => '172',
                                'redirect'                  => '',
                            ),
                        ),
                    ),
                    'meta'                      => array(
                        'template'                  => 'blank',
                    ),
                )
            );
            wp_update_post(
                array(
                    'ID'         => $form_id2,
                    'post_title' => $title2,
                )
            );
        }

    }
}
add_action( 'pt-ocdi/after_import', 'agrarium_ocdi_after_import_setup' );