<?php
/*
 * Created by Artureanec
*/

# General
add_theme_support('title-tag');
add_theme_support('automatic-feed-links');
add_theme_support('post-formats', array('image', 'video', 'gallery', 'quote'));
add_theme_support('html5', array( 'comment-list', 'comment-form', 'search-form', 'gallery', 'caption' ) );

if ( ! isset( $content_width ) ) {
    $content_width = 1170;
}

# ADD Localization Folder
add_action('after_setup_theme', 'agrarium_pomo');
if (!function_exists('agrarium_pomo')) {
    function agrarium_pomo() {
        load_theme_textdomain('agrarium', get_template_directory() . '/languages');
    }
}

require_once(get_template_directory() . '/core/helper-functions.php');
require_once(get_template_directory() . '/core/layout-functions.php');
require_once(get_template_directory() . '/core/init.php');

# Register CSS/JS
add_action('wp_enqueue_scripts', 'agrarium_css_js');
if (!function_exists('agrarium_css_js')) {
    function agrarium_css_js() {
        # CSS
        wp_enqueue_style('agrarium-theme', get_template_directory_uri() . '/css/theme.css');

        if (class_exists('WooCommerce')) {
            wp_enqueue_style('agrarium-woocommerce', get_template_directory_uri() . '/css/woocommerce.css');
            wp_enqueue_style('agrarium-style', get_template_directory_uri() . '/style.css', array('agrarium-theme', 'agrarium-woocommerce'), wp_get_theme()->get('Version') );
        } else {
            wp_enqueue_style('agrarium-style', get_template_directory_uri() . '/style.css', array('agrarium-theme'), wp_get_theme()->get('Version') );
        }

        # JS
        wp_enqueue_script('jquery-cookie', get_template_directory_uri() . '/js/jquery.cookie.min.js', array('jquery'), false, true);
        wp_enqueue_script('owl-carousel', get_template_directory_uri() . '/js/owl.carousel.min.js', true, false, true);
        wp_enqueue_script('isotope', get_template_directory_uri() . '/js/isotope.min.js', array('imagesloaded'), false, true );

        wp_register_script('agrarium-theme', get_template_directory_uri() . '/js/theme.js', array('jquery', 'isotope'), false, true);
        wp_localize_script( 'agrarium-theme', 'ajax_params', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
        wp_enqueue_script('agrarium-theme');


        if (is_singular() && comments_open()) {
            wp_enqueue_script('comment-reply');
        }

        wp_localize_script('agrarium-theme', 'agrarium_ajaxurl',
            array(
                'url' => esc_url(admin_url('admin-ajax.php'))
            )
        );

        # Colors
        require_once(get_template_directory() . "/css/custom.php");

        global $agrarium_custom_css;
        wp_add_inline_style('agrarium-theme', $agrarium_custom_css);
    }
}

# Register CSS/JS for Admin Settings
add_action('admin_enqueue_scripts', 'agrarium_admin_css_js');
if (!function_exists('agrarium_admin_css_js')) {
    function agrarium_admin_css_js() {
        # CSS
        wp_enqueue_style('agrarium-admin', get_template_directory_uri() . '/css/admin.css');
        wp_enqueue_style('agrarium-admin-fontawesome', get_template_directory_uri() . '/css/fontawesome.css');
        # JS
        wp_enqueue_script('agrarium-admin', get_template_directory_uri() . '/js/admin.js', array('jquery', 'jquery-ui-core', 'jquery-ui-sortable'), false, true);
    }
}

# Register CSS for Gutenberg Editor

add_action('enqueue_block_editor_assets', 'agrarium_gutenberg_css', 1, 1);
add_action('enqueue_block_editor_assets', 'agrarium_register_theme_fonts', 1, 1);
if (!function_exists('agrarium_gutenberg_css')) {
    function agrarium_gutenberg_css() {
//        wp_enqueue_style('agrarium-block-editor-styles', get_template_directory_uri() . '/css/gutenberg-editor.css');

        add_theme_support( 'editor-styles' );
        add_editor_style( 'css/gutenberg-editor.css' );

        require_once(get_template_directory() . "/css/custom.php");
        global $agrarium_custom_css;
        wp_enqueue_style('agrarium-admin', get_template_directory_uri() . '/css/admin.css');
        wp_add_inline_style('agrarium-admin', $agrarium_custom_css);
    }
}

# Register Google Fonts
add_action('wp_enqueue_scripts', 'agrarium_register_theme_fonts');
if (!function_exists('agrarium_register_theme_fonts')) {
    function agrarium_register_theme_fonts() {
        $font_control_list      = !empty(get_theme_mod('current_fonts')) ? get_theme_mod('current_fonts') : array();
        $current_fonts_array    = array();
        $families               = array();
        $result                 = array();
        foreach ( $font_control_list as $control ) {
            $values = agrarium_get_theme_mod($control);
            $values = json_decode($values, true);
            if ( isset($values['font_family']) && !empty($values['font_family']) ) {
                $current_font = array();
                $current_font['font_family'] = $values['font_family'];
                $current_font['font_styles'] = $values['font_styles'];
                $current_font['font_subset'] = $values['font_subset'];
                $current_fonts_array[$control] = $current_font;
            }
        }

        if ( !empty($current_fonts_array) && is_array($current_fonts_array) ) {
            foreach ( $current_fonts_array as $item ) {
                if ( !in_array($item['font_family'], $families) ) {
                    $families[] = $item['font_family'];
                }
            }
            foreach ( $families as $variant ) {
                foreach ( $current_fonts_array as $key => $item ) {
                    if ( $variant == $item['font_family'] ) {
                        $result[$variant]['font_styles'] = empty($result[$variant]['font_styles']) ? $item['font_styles'] : $result[$variant]['font_styles'] . ',' . $item['font_styles'];
                        $result[$variant]['font_subset'] = empty($result[$variant]['font_subset']) ? $item['font_subset'] : $result[$variant]['font_subset'] . ',' . $item['font_subset'];
                    }
                }
            }
            foreach ( $result as $key => $value ) {
                $styles = array_unique(explode(',', $result[$key]['font_styles']));
                asort($styles, SORT_NUMERIC );
                $subset = array_unique(explode(',', $result[$key]['font_subset']));
                asort($subset, SORT_NUMERIC );
                $result[$key]['font_styles'] = implode( ',', $styles );
                $result[$key]['font_subset'] = implode( ',', $subset );
            }
            if ( !empty($result) && is_array($result) ) {
                $fonts = array();
                foreach ( $result as $font_name => $font_params ) {
                    if ( $font_name != 'Herbarium' && $font_name != 'Herbarium Alt' && $font_name != 'Herbarium Extras' ) {
                        $fonts[] = $font_name . ':' . $font_params['font_styles'] . '&subset=' . $font_params['font_subset'];
                    }
                }
                $fonts_url = '//fonts.googleapis.com/css?family=' . urlencode( implode('|', $fonts) );
                wp_enqueue_style('agrarium-fonts', $fonts_url);
            }
        }
    }
}



# WP Footer
add_action('wp_footer', 'agrarium_wp_footer');
if (!function_exists('agrarium_wp_footer')) {
    function agrarium_wp_footer() {
        AgrariUm_Helper::getInstance()->echoFooter();
    }
}

# Register Menu
add_action('init', 'agrarium_register_menu');
if (!function_exists('agrarium_register_menu')) {
    function agrarium_register_menu() {
        register_nav_menus(
            [
                'main'              => esc_html__('Main menu', 'agrarium'),
                'top_bar_user_menu' => esc_html__('Top bar menu', 'agrarium'),
                'footer_menu'       => esc_html__('Footer Menu', 'agrarium'),
                'footer_add_menu'   => esc_html__('Footer Additional Menu', 'agrarium')
            ]
        );
    }
}


# Register Sidebars
add_action('widgets_init', 'agrarium_widgets_init');
if (!function_exists('agrarium_widgets_init')) {
    function agrarium_widgets_init() {
        register_sidebar(
            array(
                'name'          => esc_html__('Page Sidebar', 'agrarium'),
                'id'            => 'sidebar-page',
                'description'   => esc_html__('Widgets in this area will be shown on all pages.', 'agrarium'),
                'before_widget' => '<div id="%1$s" class="widget %2$s"><div class="widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h5 class="widget-title"><span>',
                'after_title'   => '</span></h5>',
            )
        );

        register_sidebar(
            array(
                'name'          => esc_html__('Post Sidebar', 'agrarium'),
                'id'            => 'sidebar-post',
                'description'   => esc_html__('Widgets in this area will be shown on all posts.', 'agrarium'),
                'before_widget' => '<div id="%1$s" class="widget %2$s"><div class="widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h5 class="widget-title"><span>',
                'after_title'   => '</span></h5>',
            )
        );

        register_sidebar(
            array(
                'name'          => esc_html__('F.A.Q. Sidebar', 'agrarium'),
                'id'            => 'sidebar-faq',
                'description'   => esc_html__('Widgets in this area will be shown on F.A.Q. page.', 'agrarium'),
                'before_widget' => '<div id="%1$s" class="widget %2$s"><div class="widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h5 class="widget-title"><span>',
                'after_title'   => '</span></h5>',
            )
        );

        register_sidebar(
            array(
                'name'          => esc_html__('Service Sidebar', 'agrarium'),
                'id'            => 'sidebar-service',
                'description'   => esc_html__('Widgets in this area will be shown on all service pages.', 'agrarium'),
                'before_widget' => '<div id="%1$s" class="widget %2$s"><div class="widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h5 class="widget-title"><span>',
                'after_title'   => '</span></h5>',
            )
        );

        register_sidebar(
            array(
                'name'          => esc_html__('Archive Sidebar', 'agrarium'),
                'id'            => 'sidebar-archive',
                'description'   => esc_html__('Widgets in this area will be shown on all posts and archive pages.', 'agrarium'),
                'before_widget' => '<div id="%1$s" class="widget %2$s"><div class="widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h5 class="widget-title"><span>',
                'after_title'   => '</span></h5>',
            )
        );

        register_sidebar(
            array(
                'name'          => esc_html__('Side Panel Sidebar', 'agrarium'),
                'id'            => 'sidebar-side',
                'description'   => esc_html__('Widgets in this area will be shown on side panel.', 'agrarium'),
                'before_widget' => '<div id="%1$s" class="widget side-widget %2$s"><div class="widget-wrapper side-widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h3 class="widget-title side-widget-title">',
                'after_title'   => '</h3>',
            )
        );
        register_sidebar(
            array(
                'name'          => esc_html__('Footer Top Sidebar', 'agrarium'),
                'id'            => 'sidebar-footer-top',
                'description'   => esc_html__('Widgets in this area will be shown on footer top area.', 'agrarium'),
                'before_widget' => '<div id="%1$s" class="widget footer-widget %2$s"><div class="widget-wrapper footer-widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h5 class="widget-title footer-widget-title">',
                'after_title'   => '</h5>',
            )
        );

        register_sidebar(
            array(
                'name'          => esc_html__('Footer Sidebar (Style 1)', 'agrarium'),
                'id'            => 'sidebar-footer-style1',
                'description'   => esc_html__('Widgets in this area will be shown on footer area.', 'agrarium'),
                'before_widget' => '<div id="%1$s" class="widget footer-widget %2$s"><div class="widget-wrapper footer-widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h5 class="widget-title footer-widget-title">',
                'after_title'   => '</h5>',
            )
        );

        register_sidebar(
            array(
                'name'          => esc_html__('Footer Sidebar (Style 2)', 'agrarium'),
                'id'            => 'sidebar-footer-style2',
                'description'   => esc_html__('Widgets in this area will be shown on footer area.', 'agrarium'),
                'before_widget' => '<div id="%1$s" class="widget footer-widget %2$s"><div class="widget-wrapper footer-widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h5 class="widget-title footer-widget-title">',
                'after_title'   => '</h5>',
            )
        );

        register_sidebar(
            array(
                'name'          => esc_html__('Footer Sidebar (Style 3)', 'agrarium'),
                'id'            => 'sidebar-footer-style3',
                'description'   => esc_html__('Widgets in this area will be shown on footer area.', 'agrarium'),
                'before_widget' => '<div id="%1$s" class="widget footer-widget %2$s"><div class="widget-wrapper footer-widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h5 class="widget-title footer-widget-title">',
                'after_title'   => '</h5>',
            )
        );

        register_sidebar(
            array(
                'name'          => esc_html__('Footer Sidebar (Style 4)', 'agrarium'),
                'id'            => 'sidebar-footer-style4',
                'description'   => esc_html__('Widgets in this area will be shown on footer area.', 'agrarium'),
                'before_widget' => '<div id="%1$s" class="widget footer-widget %2$s"><div class="widget-wrapper footer-widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h5 class="widget-title footer-widget-title">',
                'after_title'   => '</h5>',
            )
        );

        register_sidebar(
            array(
                'name'          => esc_html__('Footer Sidebar (Style 5)', 'agrarium'),
                'id'            => 'sidebar-footer-style5',
                'description'   => esc_html__('Widgets in this area will be shown on footer area.', 'agrarium'),
                'before_widget' => '<div id="%1$s" class="widget footer-widget %2$s"><div class="widget-wrapper footer-widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h5 class="widget-title footer-widget-title">',
                'after_title'   => '</h5>',
            )
        );

        if (class_exists('WooCommerce')) {
            register_sidebar(
                array(
                    'name'          => esc_html__('Sidebar WooCommerce', 'agrarium'),
                    'id'            => 'sidebar-woocommerce',
                    'description'   => esc_html__('Widgets in this area will be shown on Woocommerce Pages.', 'agrarium'),
                    'before_widget' => '<div id="%1$s" class="widget wooсommerce-widget %2$s"><div class="widget-wrapper">',
                    'after_widget'  => '</div></div>',
                    'before_title'  => '<h5 class="widget-title"><span>',
                    'after_title'   => '</span></h5>',
                )
            );
        }
    }
}

// Init Custom Widgets
if ( function_exists('agrarium_add_custom_widget') ) {
    agrarium_add_custom_widget('Agrarium_Contacts_Widget');
    agrarium_add_custom_widget('Agrarium_Featured_Posts_Widget');
    agrarium_add_custom_widget('Agrarium_Banner_Widget');
    agrarium_add_custom_widget('Agrarium_Nav_Menu_Widget');
    agrarium_add_custom_widget('Agrarium_Quote_Widget');
}

// Register Elementor Editor Styles
add_action('elementor/editor/before_enqueue_styles', function () {
    wp_register_style('agrarium_elementor_admin_fontawesome', get_template_directory_uri() . '/css/fontawesome.css');
    wp_enqueue_style('agrarium_elementor_admin_fontawesome');
});

// Init Elementor for Custom Post Types
if (!function_exists('agrarium_init_elementor_for_team_post_type')) {
    function agrarium_init_elementor_for_team_post_type() {
        add_post_type_support('agrarium-team', 'elementor');
    }
}
add_action('init', 'agrarium_init_elementor_for_team_post_type');

if (!function_exists('agrarium_init_elementor_for_portfolio_post_type')) {
    function agrarium_init_elementor_for_portfolio_post_type() {
        add_post_type_support('agrarium-portfolio', 'elementor');
    }
}
add_action('init', 'agrarium_init_elementor_for_portfolio_post_type');

if (!function_exists('agrarium_init_elementor_for_production_post_type')) {
    function agrarium_init_elementor_for_production_post_type() {
        add_post_type_support('agrarium-production', 'elementor');
    }
}
add_action('init', 'agrarium_init_elementor_for_production_post_type');

// Image Animation for Elementor
if (!function_exists('custom_animation')) {
    function custom_animation() {
        return array(
            'Image Animation' => [
                'ta_under_strips' => 'Under Strips'               
            ],
            'Custom Animations' => [
                'agrariumFadeInUp'    => 'Fade In Up',
                'agrariumFadeInDown'  => 'Fade In Down',
                'agrariumFadeInLeft'  => 'Fade In Left',
                'agrariumFadeInRight' => 'Fade In Right',
                'agrariumSlideInUp'   => 'Slide In Up',
                'agrariumSlideInDown' => 'Slide In Down'
            ]
        );
    }
}
add_filter( 'elementor/controls/animations/additional_animations', 'custom_animation' );

if ( !function_exists( 'agrarium_remove_animation_styles' ) ) {
    function agrarium_remove_animation_styles() {
        $prefix = 'e-animation-';
        wp_dequeue_style($prefix . 'agrariumFadeInUp');
        wp_dequeue_style($prefix . 'agrariumFadeInDown');
        wp_dequeue_style($prefix . 'agrariumFadeInLeft');
        wp_dequeue_style($prefix . 'agrariumFadeInRight');
        wp_dequeue_style($prefix . 'agrariumSlideInUp');
        wp_dequeue_style($prefix . 'agrariumSlideInDown');
        wp_dequeue_style($prefix . 'ta_under_strips');
    }
}

add_action('wp_enqueue_scripts', 'agrarium_remove_animation_styles', 99);
add_action('elementor/frontend/after_enqueue_scripts', 'agrarium_remove_animation_styles', 99);

# WooCommerce
if (class_exists('WooCommerce')) {
    require_once( get_template_directory() . '/woocommerce/wooinit.php');
}

// Limit of Download Files Size //
add_filter( 'upload_size_limit', 'agrarium_pbp_increase_upload' );
if (!function_exists('agrarium_pbp_increase_upload')) {
    function agrarium_pbp_increase_upload($bytes) {
        return 5242880; // 1 megabyte
    }
}

// Remove standard WP gallery styles
add_filter( 'use_default_gallery_style', '__return_false' );

// Register custom image sizes
if ( function_exists( 'add_theme_support' ) ) {
    add_theme_support( 'post-thumbnails' );
    set_post_thumbnail_size( 1170, 471, true );
}
if ( function_exists( 'add_image_size' ) ) {
    add_image_size( 'agrarium_post_thumbnail_mobile', 535, 300, array('center', 'center') );
    add_image_size( 'agrarium_post_thumbnail_tablet', 951, 438, array('center', 'center') );
    add_image_size( 'agrarium_post_thumbnail_default', 870, 350, array('center', 'center') );
    add_image_size( 'agrarium_post_thumbnail_full', 1170, 471, array('center', 'center') );

    add_image_size( 'agrarium_post_grid_2_columns', 920, 780, array('center', 'center') );
    add_image_size( 'agrarium_post_grid_3_columns', 600, 470, array('center', 'center') );
    add_image_size( 'agrarium_post_grid_4_columns', 440, 374, array('center', 'center') );
    add_image_size( 'agrarium_post_grid_5_columns', 344, 292, array('center', 'center') );
    add_image_size( 'agrarium_post_grid_6_columns', 280, 238, array('center', 'center') );

    add_image_size( 'agrarium_portfolio_thumbnail', 900, 774, array('center', 'center') );    
    add_image_size( 'agrarium_portfolio_grid_1_columns', 1920, 1920, array('center', 'center') );
    add_image_size( 'agrarium_portfolio_grid_2_columns', 1280, 1280, array('center', 'center') );
    add_image_size( 'agrarium_portfolio_grid_3_columns', 640, 640, array('center', 'center') );
    add_image_size( 'agrarium_portfolio_grid_4_columns', 480, 480, array('center', 'center') );
    add_image_size( 'agrarium_portfolio_grid_5_columns', 384, 384, array('center', 'center') );
    add_image_size( 'agrarium_portfolio_grid_6_columns', 320, 320, array('center', 'center') );

    add_image_size( 'agrarium_portfolio_slider', 900, 1200, array('center', 'center') );
    add_image_size( 'agrarium_portfolio_slider_3_columns', 640, 854, array('center', 'center') );
    add_image_size( 'agrarium_portfolio_slider_4_columns', 480, 640, array('center', 'center') );

    add_image_size( 'agrarium_team_thumbnail', 572, 456, array('center', 'center') );

    add_image_size( 'agrarium_production_thumbnail', 518, 610, array('center', 'center') );
    add_image_size( 'agrarium_production_grid_1_columns', 1200, 960, array('center', 'center') );
    add_image_size( 'agrarium_production_grid_2_columns', 930, 744, array('center', 'center') );
    add_image_size( 'agrarium_production_grid_3_columns', 610, 488, array('center', 'center') );
    add_image_size( 'agrarium_production_grid_4_columns', 450, 360, array('center', 'center') );

    add_image_size( 'agrarium_service_thumbnail', 1170, 522, array('center', 'center') );
}
add_filter( 'image_size_names_choose', 'agrarium_image_size_names' );
if ( !function_exists( 'agrarium_image_size_names' ) ) {
    function agrarium_image_size_names($sizes) {
        return array_merge($sizes, array(
            'agrarium_post_thumbnail_default'    => esc_html__('Post Thumbnail (Default)', 'agrarium'),
            'agrarium_post_thumbnail_full'       => esc_html__('Post Thumbnail (Full)', 'agrarium'),
        ));
    }
}

// Media Upload
if (!function_exists('agrarium_enqueue_media')) {
    function agrarium_enqueue_media() {
        wp_enqueue_media();
    }
}
add_action( 'admin_enqueue_scripts', 'agrarium_enqueue_media' );

// Responsive video
add_filter('embed_oembed_html', 'agrarium_wrap_oembed_video', 99, 4);
if (!function_exists('agrarium_wrap_oembed_video')) {
    function agrarium_wrap_oembed_video($html, $url, $attr, $post_id) {
        return '<div class="video-embed">' . $html . '</div>';
    }
}

// Custom Search form
add_filter('get_search_form', 'agrarium_get_search_form', 10, 2);
if ( !function_exists('agrarium_get_search_form') ) {
    function agrarium_get_search_form($form, $args) {
        $search_rand = mt_rand(0, 999);
        $search_js = 'javascript:document.getElementById("search-' . esc_js($search_rand) . '").submit();';
        $placeholder = ( $args['aria_label'] == 'global' ? esc_attr__('Search', 'agrarium') : esc_attr__('Search...', 'agrarium') );

        $form = '<form name="search_form" method="get" action="' . esc_url(home_url('/')) . '" class="search-form" id="search-' . esc_attr($search_rand) . '">';
            $form .= '<span class="search-form-icon" onclick="' . esc_js($search_js) . '"></span>';
            $form .= '<input type="text" name="s" value="" placeholder="' . esc_attr($placeholder) . '" title="' . esc_attr__('Search', 'agrarium') . '" class="search-form-field">';
        $form .= '</form>';

        return $form;
    }
}

// Customize WP Archive Widget
add_filter('get_archives_link', 'agrarium_customize_archive_widget');
if ( !function_exists('agrarium_customize_archive_widget') ) {
   function agrarium_customize_archive_widget($output) {
       $output = str_replace('</a>&nbsp;(', '</a><span class="post-count">', $output);
       $output = str_replace(')', '</span>', $output);
       $output = str_replace('>(', '>', $output);

       return $output;
   }
}

// Customize WP Categories Widget
add_filter('wp_list_categories', 'agrarium_customize_categories_widget', 10, 2);
if ( !function_exists('agrarium_customize_categories_widget') ) {
    function agrarium_customize_categories_widget($output, $args) {
        $args['use_desc_for_title'] = false;
        $output = str_replace('</a> (', '</a><span class="post-count">', $output);
        $output = str_replace(')', '</span>', $output);
        $output = str_replace('>(', '>', $output);
        $output = str_replace('"cat-item', '"cat-item cat-item-hierarchical', $output);

        return $output;
    }
}

// Add 'Background color' button to Tiny MCE text editor
add_action( 'init', 'agrarium_tiny_mce_background_color' );
if ( !function_exists('agrarium_tiny_mce_background_color') ) {
    function agrarium_tiny_mce_background_color() {
        add_filter('mce_buttons_2', 'agrarium_tiny_mce_background_color_button', 999, 1);
    }
}
if ( !function_exists('agrarium_tiny_mce_background_color_button') ) {
    function agrarium_tiny_mce_background_color_button($buttons) {
        array_splice($buttons, 4, 0, 'backcolor');
        return $buttons;
    }
}

// Move Comment Message field in Comment form
add_filter( 'comment_form_fields', 'agrarium_move_comment_fields' );
if ( !function_exists('agrarium_move_comment_fields') ) {
    function agrarium_move_comment_fields($fields) {
        if ( !function_exists('is_product') || !is_product() ) {
            $comment_field = $fields['comment'];
            $cookies_field = $fields['cookies'];
            unset($fields['comment']);
            unset($fields['cookies']);
            $fields['comment'] = $comment_field;
            $fields['cookies'] = $cookies_field;
        }
        return $fields;
    }
}

// WPForms Plugin Dropdown Menu Fix
if ( function_exists( 'wpforms') ) {
    add_action( 'wpforms_display_field_select', 'agrarium_wpform_start_select_wrapper', 5, 1 );
    if ( !function_exists('agrarium_wpform_start_select_wrapper') ) {
        function agrarium_wpform_start_select_wrapper($field) {
            echo '<div class="select-wrap' . (!empty($field['size']) && isset($field['size']) ? ' wpforms-field-' . esc_attr($field['size']) : '') . '">';
        }
    }
    add_action( 'wpforms_display_field_select', 'agrarium_wpform_finish_select_wrapper', 15 );
    if ( !function_exists('agrarium_wpform_finish_select_wrapper') ) {
        function agrarium_wpform_finish_select_wrapper() {
            echo '</div>';
        }
    }
}

// Custom Password Form
add_filter( 'the_password_form', 'agrarium_password_form' );
if ( !function_exists('agrarium_password_form') ) {
    function agrarium_password_form() {
        global $post;
        $out = '<form action="' . esc_url(site_url('wp-login.php?action=postpass', 'login_post')) . '" class="post-password-form" method="post"><p>' . esc_html__('This content is password protected. To view it please enter your password below:', 'agrarium') . '</p><p><label for="password"><input name="post_password" id="password" type="password" placeholder="' . esc_attr__('Password', 'agrarium') . '" size="20" required /></label><button name="Submit">' . esc_html__('Enter', 'agrarium') . '</button></p></form>';
        return $out;
    }
}

// Set Elementor Features Default Values
add_action( 'elementor/experiments/feature-registered', 'agrarium_elementor_features_set_default', 10, 2 );
if ( !function_exists('agrarium_elementor_features_set_default') ) {
    function agrarium_elementor_features_set_default( Elementor\Core\Experiments\Manager $experiments_manager ) {
        $experiments_manager->set_feature_default_state('e_dom_optimization', 'inactive');
    }
}

// Set custom palette in customizer colorpicker
add_action( 'customize_controls_enqueue_scripts', 'agrarium_custom_color_palette' );
if ( !function_exists('agrarium_custom_color_palette') ) {
    function agrarium_custom_color_palette() {
        $color_palettes = json_encode(agrarium_get_custom_color_palette());
        wp_add_inline_script('wp-color-picker', 'jQuery.wp.wpColorPicker.prototype.options.palettes = ' . sprintf('%s', $color_palettes) . ';');
    }
}

// Filter for widgets
add_filter( 'dynamic_sidebar_params', 'agrarium_dynamic_sidebar_params' );
if (!function_exists('agrarium_dynamic_sidebar_params')) {
    function agrarium_dynamic_sidebar_params($sidebar_params) {
        if (is_admin()) {
            return $sidebar_params;
        }
        global $wp_registered_widgets;
        $widget_id = $sidebar_params[0]['widget_id'];
        $wp_registered_widgets[$widget_id]['original_callback'] = $wp_registered_widgets[$widget_id]['callback'];
        $wp_registered_widgets[$widget_id]['callback'] = 'agrarium_widget_callback_function';

        return $sidebar_params;
    }
}
add_filter( 'widget_output', 'agrarium_output_filter', 10, 3 );
if (!function_exists('agrarium_output_filter')) {
    function agrarium_output_filter($widget_output, $widget_id_base, $widget_id) {
        if ($widget_id_base != 'woocommerce_product_categories' && $widget_id_base != 'wpforms-widget') {
            $widget_output = str_replace('<select', '<div class="select-wrap"><select', $widget_output);
            $widget_output = str_replace('</select>', '</select></div>', $widget_output);
        }

        return $widget_output;
    }
}

// Admin Footer
add_filter('admin_footer', 'agrarium_admin_footer');
if (!function_exists('agrarium_admin_footer')) {
    function agrarium_admin_footer() {
        if (strlen(get_page_template_slug())>0) {
            echo "<input type='hidden' name='' value='" . (get_page_template_slug() ? get_page_template_slug() : '') . "' class='agrarium_this_template_file'>";
        }
    }
}

// Remove post format parameter
add_filter('preview_post_link', 'agrarium_remove_post_format_parameter', 9999);
if (!function_exists('agrarium_remove_post_format_parameter')) {
    function agrarium_remove_post_format_parameter($url) {
        $url = remove_query_arg('post_format', $url);
        return $url;
    }
}

// Post excerpt customize
add_filter( 'excerpt_length', function() {
    return 41;
} );
add_filter( 'excerpt_more', function(){
    return '...';
} );

// Wrap pagination links
add_filter( 'paginate_links_output', 'agrarium_wrap_pagination_links', 10, 2 );
if ( !function_exists('agrarium_wrap_pagination_links') ) {
    function agrarium_wrap_pagination_links($template, $args) {
        return '<div class="content-pagination">' .
                    '<nav class="navigation pagination" role="navigation">' .
                        '<h2 class="screen-reader-text">' . esc_html__('Pagination', 'agrarium') . '</h2>' .
                        '<div class="nav-links">' .
                            wp_kses($template, array(
                                'span'  => array(
                                    'class'         => true,
                                    'aria-current'  => true
                                ),
                                'div'  => array(
                                    'class'         => true
                                ),
                                'a'     => array(
                                    'class'         => true,
                                    'href'          => true
                                )
                            )) .
                        '</div>' .
                    '</nav>' .
                '</div>';
    }
}

//Add Ajax Actions
add_action('wp_ajax_pagination', 'ajax_pagination');
add_action('wp_ajax_nopriv_pagination', 'ajax_pagination');

//Construct Loop & Results
function ajax_pagination() {
    $query_data         = $_POST;

    $paged              = ( isset($query_data['paged']) ) ? intval($query_data['paged']) : 1;
    $filter_term        = ( isset($query_data['filter_term']) ) ? $query_data['filter_term'] : null;
    $filter_taxonomy    = ( isset($query_data['filter_taxonomy']) ) ? $query_data['filter_taxonomy'] : null;
    $args               = ( isset($query_data['args']) ) ? json_decode(stripslashes($query_data['args']), true) : array();
    $args               = array_merge($args, array( 'paged' => sanitize_key($paged) ));
    if ( !empty($filter_term) && !empty($filter_taxonomy) && $filter_term != 'all') {
        $args   = array_merge($args, array( sanitize_key($filter_taxonomy) => sanitize_key($filter_term) ));
    }
    $post_type          = isset($args['post_type']) ? $args['post_type'] : 'post';
    $widget             = ( isset($query_data['widget']) ) ? json_decode(stripslashes($query_data['widget']), true) : array();
    $query              = new WP_Query($args);

    $wrapper_class      = isset($query_data['classes']) ? $query_data['classes'] : '';
    $id                 = isset($query_data['id']) ? $query_data['id'] : '';
    $link_base          = isset($args['link_base']) ? $args['link_base'] : '';

    $is_isotope = strpos($wrapper_class, 'isotope-trigger') !== false;
    $is_portfolio_masonry = strpos($wrapper_class, 'portfolio-masonry-listing') !== false;
    echo '<div class="' . esc_attr($wrapper_class) . '">';
        if($is_isotope ){
            echo '<span class="grid-sizer"></span>';            
        }
        if($is_portfolio_masonry) {
            $i = 1;
            $item_class = $widget['item_class'];
        }        
        while ($query->have_posts()) {
            $query->the_post();
            if($is_portfolio_masonry && ($widget['columns_number'] == 3 || $widget['columns_number'] == 6)) {
                if($i == 2 || $i == 4) {
                    $widget['item_class'] = $item_class . ' portfolio-item-wide';
                } else {
                    $widget['item_class'] = $item_class;
                }
                get_template_part('content', $post_type, $widget);
                $i++;
                if($i > 6) {
                    $i = 1;
                }
            }            
            else {
                get_template_part('content', $post_type, $widget);
            }
        };
        wp_reset_postdata();
    echo '</div>';

    if($args['show_pagination'] == 'yes') {
        echo paginate_links( array(
            'base'      => $link_base . '/?' . esc_attr($id) . '-paged=%#%',
            'current'   => max( 1, $paged ),
            'total'     => $query->max_num_pages,
            'end_size'  => 2,
            'prev_text' => '<div class="button-icon"></div>',
            'next_text' => '<div class="button-icon"></div>',
            'add_args'  => false
        ) );
    }    

    die();
}