<?php
/**
 * The template for displaying single project item page
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage Agrarium
 * @since Agrarium 1.0
 */

the_post();
get_header();

$sidebar_args = agrarium_get_sidebar_args();
$sidebar_position = $sidebar_args['sidebar_position'];

$content_classes = 'content-wrapper';
$content_classes .= ' content-wrapper-sidebar-position-' . esc_attr($sidebar_position);
$content_classes .= ( agrarium_get_post_option('content_top_margin') == 'on' ? ' content-wrapper-remove-top-margin' : '' );

$additional_classes = 'content-wrapper content-wrapper-sidebar-position-none';
$content = apply_filters('the_content', get_the_content());
if ( empty($content) ) {
    $content_classes .= ( agrarium_get_post_option('content_bottom_margin') == 'on' ? ' content-wrapper-remove-bottom-margin' : '' );
} else {
    $additional_classes .= ( agrarium_get_post_option('content_bottom_margin') == 'on' ? ' content-wrapper-remove-bottom-margin' : '' );
};
?>

    <div class="<?php echo esc_attr($content_classes); ?>">

        <!-- Content Container -->
        <div class="content">

            <div id="service-<?php the_ID(); ?>" class="single-service">

                <div class="service-post-content">

                    <?php
                        if ( !empty(agrarium_service_media_output()) ) {
                            echo '<div class="post-media-wrapper">';
                                echo agrarium_service_media_output();
                            echo '</div>';
                        }

                        if ( !empty(get_the_title()) ) {
                            echo '<h2 class="post-title">' . get_the_title() . '</h2>';
                        }

                        if ( !empty(agrarium_get_post_option('service_description')) ) {
                            echo '<div class="service_description">';
                                echo do_shortcode( wpautop( wp_kses_post(agrarium_get_post_option('service_description')) ) );
                            echo '</div>';
                        }

                        // Benefits
                        if ( !empty(agrarium_get_post_option('service_benefit_items')) ) {
                            if ( !empty(agrarium_get_post_option('service_benefits_title')) ) {
                                echo '<h5 class="benefits_title">' . esc_attr(agrarium_get_post_option('service_benefits_title')) . '</h5>';
                            }
                            echo '<div class="benefits-wrapper">';
                                $benefits = agrarium_get_post_option('service_benefit_items');
                                foreach ($benefits as $benefit) {
                                    echo '<div class="benefit-item-wrapper">';
                                        echo '<div class="benefit-item">';
                                            if ( !empty($benefit[0]) ) {
                                                echo '<div class="benefit-item-icon">';
                                                    echo '<i class="' . esc_attr($benefit[0]) . '"' . (!empty($benefit[2]) ? ' style="color: ' . esc_attr($benefit[2]) . '"' : '') . '></i>';
                                                echo '</div>';
                                            }
                                            if ( !empty($benefit[1]) ) {
                                                echo '<div class="benefit-item-title">';
                                                    echo '<h6>' . wp_kses($benefit[1], array(
                                                        'br' => array(),
                                                        'strong' => array(),
                                                        'mark' => array(),
                                                        'b' => array(),
                                                        'i' => array(),
                                                        'em' => array(),
                                                        'span' => array()
                                                    )) . '</h6>';
                                                echo '</div>';
                                            }
                                        echo '</div>';
                                    echo '</div>';
                                }
                            echo '</div>';
                        }

                        // FAQ
                        if (!empty(agrarium_get_post_option('service_help_items'))) {
                            if ( !empty(agrarium_get_post_option('service_help_title')) ) {
                                echo '<h5>' . esc_html(agrarium_get_post_option('service_help_title')) . '</h5>';
                            }
                            echo '<div class="help-wrapper">';
                                $helps = agrarium_get_post_option('service_help_items');
                                foreach ($helps as $help) {
                                    echo '<div class="help-item">';
                                        if ( !empty($help[0]) ) {
                                            echo '<div class="help-item-title">';
                                                echo esc_html($help[0]);
                                            echo '</div>';
                                        }
                                    if ( !empty($help[1]) ) {
                                        echo '<div class="help-item-content">';
                                            echo esc_html($help[1]);
                                        echo '</div>';
                                    }
                                    echo '</div>';
                                }
                            echo '</div>';
                        }
                    ?>

                </div>
            </div>

        </div>

        <!-- Sidebar Container -->
        <?php get_sidebar(); ?>

    </div>

    <?php
    	$content = apply_filters('the_content', get_the_content());
        if ( !empty($content) ) {
            echo '<div class="' . esc_attr($additional_classes) . '">';
                echo '<div class="content">';
        }
        the_content();
        if ( !empty($content) ) {
                echo '</div>';
            echo '</div>';
        }
    ?>

<?php
get_footer();