<?php
    defined( 'ABSPATH' ) or die();
?>

<div class="header-row">

    <!-- Left Info Block -->
    <?php
        if (agrarium_get_prefered_option('header_logo_status') == 'on') {
            echo '<div class="header-icons-container header-logo-icons-container">';
                if ( agrarium_get_prefered_option('header_logo_status') == 'on' ) {
                    // Header Logo
                    echo '<div class="logo-container">' . agrarium_get_logo_output() . '</div>';
                }
            echo '</div>';
        }
    ?>

    <!-- Menu Block -->
    <?php
        if ( agrarium_get_prefered_option('header_menu_status') == 'on' ) {
            echo '<div class="header-menu-container">';
                echo '<nav>';
                    if ( !empty(agrarium_get_prefered_option('header_menu_select')) && agrarium_get_prefered_option('header_menu_select') != 'default' ) {
                        wp_nav_menu(
                            array(
                                'menu'          => agrarium_get_prefered_option('header_menu_select'),
                                'menu_class'    => 'main-menu',
                                'depth'         => 0,
                                'container'     => '',
                                'fallback_cb' => ''
                            )
                        );
                    } else {
                        $menu_locations = get_nav_menu_locations();
                        if ( isset($menu_locations['main']) && $menu_locations['main'] !== 0 ) {
                            wp_nav_menu(
                                array(
                                    'theme_location'    => 'main',
                                    'menu_class'        => 'main-menu',
                                    'depth'             => 0,
                                    'container'         => '',
                                    'fallback_cb' => ''
                                )
                            );
                        }
                    }
                echo '</nav>';
            echo '</div>';
        }
    ?>
    <!-- Phone Block -->
    <?php
        if ( agrarium_get_prefered_option('header_phone_status') == 'on' && 
            !empty(agrarium_get_prefered_option('header_phone_number')) ) { ?>               
            <div class="header-icons-container header-phone">
                <div class="header-icon header-phone-container">
                    <a href="tel:<?php echo esc_attr(agrarium_clear_phone(agrarium_get_prefered_option('header_phone_number')))?>">
                        <div class="header-phone-icon">                        
                            <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512.006 512.006" style="enable-background:new 0 0 512.006 512.006;" xml:space="preserve">
                                <g>
                                    <path d="M370.037,296.152c-12.527-1.647-24.883-4.719-36.693-9.122c-13.107-4.898-28.006-1.741-37.999,8.115l-12.774,12.74
                                        c-28.681-17.451-52.804-41.523-70.306-70.144l12.792-12.766c9.847-9.95,13.03-24.832,8.107-37.905
                                        c-4.42-11.819-7.501-24.141-9.156-36.719c-2.517-17.783-17.877-31.317-35.908-30.899h-41.19c-1.075,0-2.15,0.051-3.208,0.154
                                        c-9.574,0.853-18.236,5.393-24.397,12.757c-6.161,7.381-9.079,16.708-8.201,26.402c4.625,43.477,19.661,85.854,43.435,122.487
                                        c21.606,33.937,50.995,63.275,84.941,84.804c36.582,23.671,78.839,38.682,122.377,43.401c1.109,0.102,2.219,0.145,3.362,0.145
                                        c9.617-0.034,18.637-3.806,25.412-10.641c6.775-6.81,10.479-15.855,10.445-25.421V332.53
                                        C401.473,314.328,388.178,298.704,370.037,296.152z M384.023,332.453v41.139c0.017,5.035-1.929,9.779-5.487,13.363
                                        c-3.558,3.584-8.303,5.564-13.329,5.581c-0.614,0-1.229-0.026-1.673-0.06c-40.721-4.412-80.401-18.509-114.833-40.789
                                        c-31.906-20.233-59.486-47.761-79.795-79.65c-22.366-34.458-36.48-74.24-40.815-114.927c-0.461-5.018,1.075-9.916,4.309-13.781
                                        c3.243-3.874,7.799-6.255,12.851-6.707c0.555-0.051,1.109-0.085,1.664-0.085h41.276c0.051,0,0.12,0,0.179,0
                                        c9.387,0,17.425,6.946,18.748,16.162c1.818,13.773,5.205,27.358,10.086,40.397c2.577,6.869,0.913,14.677-4.224,19.857
                                        l-17.434,17.408c-2.731,2.714-3.294,6.921-1.391,10.266c20.301,35.627,49.894,65.161,85.581,85.41
                                        c3.337,1.886,7.526,1.331,10.24-1.382l17.408-17.365c5.239-5.163,13.065-6.852,19.994-4.241
                                        c13.03,4.855,26.641,8.235,40.371,10.044c9.515,1.34,16.512,9.574,16.273,19.157C384.023,332.308,384.023,332.385,384.023,332.453
                                        z"/>
                                </g>
                                <g>
                                    <path d="M256.006,0.003c-141.158,0-256,114.842-256,256c0,48.819,13.773,96.145,39.876,137.182L0.526,500.534
                                        c-1.135,3.072-0.401,6.528,1.886,8.875c1.638,1.69,3.857,2.594,6.127,2.594c0.905,0,1.818-0.145,2.697-0.435l111.352-37.111
                                        c40.158,24.567,86.195,37.547,133.419,37.547c141.158,0,256-114.842,256-256S397.164,0.003,256.006,0.003z M256.014,494.936
                                        c-45.346,0-89.523-12.817-127.744-37.06c-1.382-0.87-2.97-1.323-4.574-1.323c-0.913,0-1.818,0.145-2.697,0.444l-98.347,32.777
                                        l34.731-94.72c0.93-2.543,0.606-5.376-0.887-7.637c-25.788-39.057-39.415-84.497-39.415-131.413
                                        c0-131.746,107.187-238.933,238.933-238.933s238.933,107.187,238.933,238.933S387.76,494.936,256.014,494.936z"/>
                                </g>
                            </svg>
                        
                        </div>
                        <?php
                            if(!empty(agrarium_get_prefered_option('header_phone_number'))) { ?>
                                <div class="header-phone-text">
                                    <?php
                                        if(!empty(agrarium_get_prefered_option('header_phone_title'))) {
                                            echo '<span>' . esc_html(agrarium_get_prefered_option('header_phone_title'))  . '</span>';
                                        }
                                    ?>
                                    <span class="phone-number"><?php echo esc_html(agrarium_get_prefered_option('header_phone_number'))?></span>
                                </div>  
                            <?php }
                        ?>                        
                    </a>
                </div>
            </div>
        <?php }
    ?>

    <!-- Right Info Block -->
    <?php
        if (
            agrarium_get_prefered_option('side_panel_status') == 'on' || 
            agrarium_get_prefered_option('header_search_status') == 'on' ||
            (
                agrarium_get_prefered_option('header_button_status') == 'on' &&
                !empty(agrarium_get_prefered_option('header_button_text'))
            ) ||
            (
                class_exists('WooCommerce') && agrarium_get_prefered_option('header_minicart_status') == 'on'
            ) ||
            agrarium_get_prefered_option('header_login_status') == 'on'
        ) {
            echo '<div class="header-icons-container main-icons-container">';

                // Header Search
                if ( agrarium_get_prefered_option('header_search_status') == 'on' ) {
                    echo '<div class="header-icon search-trigger">';
                        echo '<span class="search-trigger-icon"></span>';
                    echo '</div>';
                }

                // Header Product Cart
                if ( class_exists('WooCommerce') && agrarium_get_prefered_option('header_minicart_status') == 'on' ) {
                    echo '<div class="header-icon mini-cart">';
                        echo '<a href="' . esc_url(wc_get_cart_url()) . '" class="mini-cart-trigger">';                            
                            echo '<span class="mini-cart_count">';
                                echo '<svg version="1.1" id="shopping-cart-icon" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                     viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
                                <g>
                                    <path d="M492,80H120V20c0-11-9-20-20-20H20C9,0,0,9,0,20s9,20,20,20h60v292c0,11,9,20,20,20h332.5c9.1,0,17.1-6.2,19.4-15l59.5-232
                                        C514.6,92.3,505,80,492,80L492,80z M417,312H120V120h346.2L417,312z M140,392c-33.1,0-60,26.9-60,60s26.9,60,60,60s60-26.9,60-60
                                        S173.1,392,140,392z M140,472c-11,0-20-9-20-20s9-20,20-20s20,9,20,20S151,472,140,472z M353.1,392c-33.1,0-60,26.9-60,60
                                        s26.9,60,60,60s60-26.9,60-60S386.2,392,353.1,392z M353.1,472c-11,0-20-9-20-20s9-20,20-20s20,9,20,20S364.1,472,353.1,472z"/>
                                </g>
                                </svg>';
                                echo '<span>' . WC()->cart->cart_contents_count . '</span>';
                            echo '</span>';
                        echo '</a>';
                        echo '<div class="mini-cart-panel woocommerce">';
                            woocommerce_mini_cart();
                        echo '</div>';
                    echo '</div>';
                }

                // Login/Logout
                if ( agrarium_get_prefered_option('header_login_status') == 'on' ) {
                    if ( class_exists('WooCommerce') ) {
                        echo '<div class="header-icon login-logout">';
                        if (is_user_logged_in()) {
                            echo '<a href="' . wp_logout_url(home_url()) . '" title="' . esc_attr__('Logout', 'agrarium') . '" class="link-logout"></a>';
                        } else {
                            echo '<a href="' . get_permalink(get_option('woocommerce_myaccount_page_id')) . '" title="' . esc_attr__('Login/Register', 'agrarium') . '" class="link-login"></a>';
                        };
                        echo '</div>';
                    } else {
                        echo '<div class="header-icon login-logout">';
                        if (is_user_logged_in()) {
                            echo '<a href="' . wp_logout_url(home_url()) . '" title="' . esc_attr__('Logout', 'agrarium') . '" class="link-logout"></a>';
                        } else {
                            echo '<a href="' . wp_login_url(get_permalink()) . '" title="' . esc_attr__('Login/Register', 'agrarium') . '" class="link-login"></a>';
                        };
                        echo '</div>';
                    }
                }

                // Header Button
                if ( agrarium_get_prefered_option('header_button_status') == 'on' && !empty(agrarium_get_prefered_option('header_button_text')) ) {
                    echo '<div class="header-icon header-button-container">';
                        echo '<a class="agrarium-button" href="' . ( !empty(agrarium_get_prefered_option('header_button_url')) ? esc_url(agrarium_get_prefered_option('header_button_url')) : esc_js('javascript:void(0);')) . '">';
                            echo esc_html(agrarium_get_prefered_option('header_button_text'));
                        echo '</a>';
                    echo '</div>';
                }
                // Header Side Panel
                if ( agrarium_get_prefered_option('side_panel_status') == 'on' && is_active_sidebar('sidebar-side') ) {
                    echo '<div class="header-icon dropdown-trigger">';
                        echo '<div class="dropdown-trigger-item"></div>';
                    echo '</div>';
                }

            echo '</div>';
        }
    ?>

</div>
<?php 
    if(agrarium_get_prefered_option('header_overlay_status') == 'on') {
        echo '<div class="header-background-overlay">';
            echo '<img src="'. esc_url(get_template_directory_uri() . '/img/header-overlay.png') . '" alt="header-overlay">';       
        echo '</div>';
    }
?>
