<?php
    defined( 'ABSPATH' ) or die();
    $header_classes = 'mobile-header-menu-container';
    if ( !empty(agrarium_get_prefered_option('header_style')) ) {
        $header_classes .= ' header-' . esc_attr(agrarium_get_prefered_option('header_style'));
    }
?>
    <div class="<?php echo esc_attr($header_classes); ?>">
        <div class="mobile-header-row">

            <!-- Icons Block -->
            <div class="header-icons-container">
                <?php
                // Close Button
                echo '<div class="header-icon menu-close">';
                    echo '<span class="menu-close-icon"></span>';
                echo '</div>';

                ?>
            </div>

        </div>
        <nav>
            <!-- Menu Block -->
            <?php
            if ( agrarium_get_prefered_option('header_menu_status') == 'on' ) {
                if ( !empty(agrarium_get_prefered_option('header_menu_select')) && agrarium_get_prefered_option('header_menu_select') != 'default' ) {
                    wp_nav_menu(
                        array(
                            'theme_location'=> 'main',
                            'menu'          => agrarium_get_prefered_option('header_menu_select'),
                            'menu_class'    => 'main-menu',
                            'depth'         => 0,
                            'container'     => '',
                            'fallback_cb' => ''
                        )
                    );
                } else {
                    $menu_locations = get_nav_menu_locations();
                    if ( isset($menu_locations['main']) && $menu_locations['main'] !== 0 ) {
                        wp_nav_menu(
                            array(
                                'theme_location'    => 'main',
                                'menu_class'        => 'main-menu',
                                'depth'             => 0,
                                'container'         => '',
                                'fallback_cb' => ''
                            )
                        );
                    }
                }
            }
            ?>
        </nav>

        <?php
        if (
            agrarium_get_prefered_option('top_bar_contacts_email_status') == 'on' ||
            agrarium_get_prefered_option('top_bar_contacts_phone_status') == 'on' ||
            agrarium_get_prefered_option('top_bar_contacts_address_status') == 'on'
        ) {
            echo '<div class="header-mobile-contacts">';
                if ( !empty(agrarium_get_prefered_option('top_bar_contacts_address')) && agrarium_get_prefered_option('top_bar_contacts_address_status') == 'on' ) {
                    echo '<div class="contact-item">';
                        echo '<p class="contact-item-title">' . esc_html__('Location', 'agrarium') . '</p>';
                        echo '<span>' . esc_html(agrarium_get_prefered_option('top_bar_contacts_address')) . '</span>';
                    echo '</div>';
                }
                if ( !empty(agrarium_get_prefered_option('top_bar_contacts_phone')) && agrarium_get_prefered_option('top_bar_contacts_phone_status') == 'on' ) {
                    echo '<div class="contact-item">';
                        echo '<p class="contact-item-title">' . esc_html__('Phone', 'agrarium') . '</p>';
                        echo '<a href="tel:' . agrarium_clear_phone(agrarium_get_prefered_option('top_bar_contacts_phone')) . '">';
                            echo esc_html(agrarium_get_prefered_option('top_bar_contacts_phone'));
                        echo '</a>';
                    echo '</div>';
                }
                if ( !empty(agrarium_get_prefered_option('top_bar_contacts_email')) && agrarium_get_prefered_option('top_bar_contacts_email_status') == 'on' ) {
                    echo '<div class="contact-item">';
                        echo '<p class="contact-item-title">' . esc_html__('Email', 'agrarium') . '</p>';
                        echo '<a href="mailto:' . esc_attr(agrarium_get_prefered_option('top_bar_contacts_email')) . '">';
                            echo esc_html(agrarium_get_prefered_option('top_bar_contacts_email'));
                        echo '</a>';
                    echo '</div>';
                }
            echo '</div>';
        }
        ?>

        <?php
        if (
            agrarium_get_prefered_option('top_bar_additional_text_status') == 'on' &&
            (
                !empty(agrarium_get_prefered_option('top_bar_additional_text_title')) ||
                !empty(agrarium_get_prefered_option('top_bar_additional_text'))
            )
        ) {
            echo '<div class="header-mobile-additional-text">';
                if ( !empty(agrarium_get_prefered_option('top_bar_additional_text_title')) ) {
                    echo '<span class="additional-text-title">';
                        echo wp_kses(agrarium_get_prefered_option('top_bar_additional_text_title'), array(
                            'mark' => array(),
                            'span' => array(
                                'class' => true
                            )
                        ));
                    echo '</span>';
                }
                if ( !empty(agrarium_get_prefered_option('top_bar_additional_text')) ) {
                    echo wp_kses(agrarium_get_prefered_option('top_bar_additional_text'), array(
                        'mark' => array(),
                        'span' => array(
                            'class' => true
                        )
                    ));
                }
            echo '</div>';
        }
        ?>

        <?php
        if (
            agrarium_get_prefered_option('top_bar_socials_status') == 'on'
        ) {
            echo '<div class="header-mobile-socials">';
                echo agrarium_socials_output('mobile-menu-socials wrapper-socials');
            echo '</div>';
        }
        ?>

        <?php
        if (
            agrarium_get_prefered_option('header_button_status') == 'on' &&
            !empty(agrarium_get_prefered_option('header_button_text'))
        ) {
            echo '<div class="header-mobile-button">';
                echo '<a class="agrarium-button" href="' . ( !empty(agrarium_get_prefered_option('header_button_url')) ? esc_url(agrarium_get_prefered_option('header_button_url')) : esc_js('javascript:void(0);')) . '">';
                    echo esc_html(agrarium_get_prefered_option('header_button_text'));
                echo '</a>';
            echo '</div>';
        }
        ?>

    </div>