<?php
    defined( 'ABSPATH' ) or die();
?>

    <div class="mobile-header-row">

        <!-- Logo Block -->
        <?php
            if ( agrarium_get_prefered_option('header_logo_status') == 'on' ) {
                echo '<div class="logo-container">' . agrarium_get_logo_output(true) . '</div>';
            }
        ?>

        <!-- Icons Block -->
        <?php
            if (
                agrarium_get_prefered_option('header_search_status') == 'on' ||
                agrarium_get_prefered_option('header_menu_status') == 'on' ||
                (
                    agrarium_get_prefered_option('side_panel_on_mobile_status') == 'on' &&
                    is_active_sidebar('sidebar-side')
                ) ||
                (
                    class_exists('WooCommerce') && agrarium_get_prefered_option('header_minicart_status') == 'on'
                ) ||
                agrarium_get_prefered_option('header_login_status') == 'on'
            ) {
                echo '<div class="header-icons-container">';

                    // Mini Cart Link
                    if ( class_exists('WooCommerce') && agrarium_get_prefered_option('header_minicart_status') == 'on' ) {
                        echo '<div class="header-icon mini-cart">';
                            echo '<a href="' . esc_url(wc_get_cart_url()) . '" class="mini-cart-trigger">';
                                echo '<span class="mini-cart_count">';
                                    echo '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                         viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
                                    <g>
                                        <path d="M492,80H120V20c0-11-9-20-20-20H20C9,0,0,9,0,20s9,20,20,20h60v292c0,11,9,20,20,20h332.5c9.1,0,17.1-6.2,19.4-15l59.5-232
                                            C514.6,92.3,505,80,492,80L492,80z M417,312H120V120h346.2L417,312z M140,392c-33.1,0-60,26.9-60,60s26.9,60,60,60s60-26.9,60-60
                                            S173.1,392,140,392z M140,472c-11,0-20-9-20-20s9-20,20-20s20,9,20,20S151,472,140,472z M353.1,392c-33.1,0-60,26.9-60,60
                                            s26.9,60,60,60s60-26.9,60-60S386.2,392,353.1,392z M353.1,472c-11,0-20-9-20-20s9-20,20-20s20,9,20,20S364.1,472,353.1,472z"/>
                                    </g>
                                    </svg>';
                                    echo '<span>' . WC()->cart->cart_contents_count . '</span>';
                                echo '</span>';
                            echo '</a>';
                        echo '</div>';
                    }

                    // Login/Logout
                    if ( agrarium_get_prefered_option('header_login_status') == 'on' ) {
                        if ( class_exists('WooCommerce') ) {
                            echo '<div class="header-icon login-logout">';
                                if (is_user_logged_in()) {
                                    echo '<a href="' . wp_logout_url(home_url()) . '" title="' . esc_attr__('Logout', 'agrarium') . '" class="link-logout"></a>';
                                } else {
                                    echo '<a href="' . get_permalink(get_option('woocommerce_myaccount_page_id')) . '" title="' . esc_attr__('Login/Register', 'agrarium') . '" class="link-login"></a>';
                                };
                            echo '</div>';
                        } else {
                            echo '<div class="header-icon login-logout">';
                                if (is_user_logged_in()) {
                                    echo '<a href="' . wp_logout_url(home_url()) . '" title="' . esc_attr__('Logout', 'agrarium') . '" class="link-logout"></a>';
                                } else {
                                    echo '<a href="' . wp_login_url(get_permalink()) . '" title="' . esc_attr__('Login/Register', 'agrarium') . '" class="link-login"></a>';
                                };
                            echo '</div>';
                        }
                    }

                    // Search Icon Trigger
                    if ( agrarium_get_prefered_option('header_search_status') == 'on' ) {
                        echo '<div class="header-icon search-trigger">';
                            echo '<span class="search-trigger-icon"></span>';
                        echo '</div>';
                    }

                    // Side Panel Trigger
                    if ( agrarium_get_prefered_option('side_panel_on_mobile_status') == 'on' && is_active_sidebar('sidebar-side') ) {
                        echo '<div class="header-icon dropdown-trigger">';
                            echo '<div class="dropdown-trigger-item"></div>';
                        echo '</div>';
                    }

                    // Burger Menu Trigger
                    if ( agrarium_get_prefered_option('header_menu_status') == 'on' ) { ?>
                        <div class="header-icon menu-trigger">
                            <span class="menu-trigger-icon">
                                <span class="hamburger">
                                    <span></span>
                                    <span></span>
                                    <span></span>
                                </span>
                            </span>
                        </div>
                    <?php }

                echo '</div>';
            }
        ?>

    </div>