<?php
/*
 * Created by Artureanec
*/

namespace AgrariUm\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\REPEATER;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class AgrariUm_Icon_Box_Widget extends Widget_Base {

    public function get_name() {
        return 'agrarium_icon_box';
    }

    public function get_title() {
        return esc_html__('Icon Box', 'agrarium_plugin');
    }

    public function get_icon() {
        return 'eicon-icon-box';
    }

    public function get_categories() {
        return ['agrarium_widgets'];
    }

    protected function register_controls() {

        // ----------------------------- //
        // ---------- Content ---------- //
        // ----------------------------- //
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Icon Box', 'agrarium_plugin')
            ]
        );

        $this->add_control(
            'icon_type',
            [
                'label'     => esc_html__('Type of Icon', 'agrarium_plugin'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'default',
                'options'   => [
                    'default'   => esc_html__('Default Icon', 'agrarium_plugin'),
                    'svg'       => esc_html__('SVG Icon', 'agrarium_plugin'),
                    'text'      => esc_html__('Text', 'agrarium_plugin')
                ]
            ]
        );

        $this->add_control(
            'default_icon',
            [
                'label'                     => esc_html__('Icon', 'agrarium_plugin'),
                'type'                      => Controls_Manager::ICONS,
                'label_block'               => true,
                'default'                   => [
                    'value'     => 'fas fa-star',
                    'library'   => 'fa-solid'
                ],
                'skin'                      => 'inline',
                'exclude_inline_options'    => ['svg'],
                'condition'                 => [
                    'icon_type' => 'default'
                ]
            ]
        );

        $this->add_control(
            'svg_icon',
            [
                'label'         => esc_html__('SVG Icon', 'agrarium_plugin'),
                'description'   => esc_html__('Enter svg code', 'agrarium_plugin'),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => '',
                'condition'     => [
                    'icon_type'     => 'svg'
                ]
            ]
        );

        $this->add_control(
            'text_icon',
            [
                'label'         => esc_html__('Text', 'agrarium_plugin'),
                'description'   => esc_html__('Enter text', 'agrarium_plugin'),
                'type'          => Controls_Manager::TEXT,
                'default'       => '',
                'condition'     => [
                    'icon_type'     => 'text'
                ]
            ]
        );

        $this->add_control(
            'icon_position',
            [
                'label'     => esc_html__( 'Icon Position', 'elementor' ),
                'type'      => Controls_Manager::CHOOSE,
                'default'   => 'top',
                'options'   => [
                    'left'      => [
                        'title'     => esc_html__( 'Left', 'elementor' ),
                        'icon'      => 'eicon-h-align-left',
                    ],
                    'top'       => [
                        'title'     => esc_html__( 'Top', 'elementor' ),
                        'icon'      => 'eicon-v-align-top',
                    ],
                    'right'     => [
                        'title'     => esc_html__( 'Right', 'elementor' ),
                        'icon'      => 'eicon-h-align-right',
                    ],
                    'center'    => [
                        'title'     => esc_html__( 'Over', 'elementor' ),
                        'icon'      => 'eicon-v-align-middle',
                    ],
                ],
                'prefix_class'  => 'icon-position-',
                'toggle'        => false
            ]
        );

        $this->add_control(
            'background_type',
            [
                'label'     => esc_html__('Type of Background', 'agrarium_plugin'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'svg',
                'options'   => [
                    'none'              => esc_html__('None', 'agrarium_plugin'),
                    'svg'               => esc_html__('SVG', 'agrarium_plugin'),
                    'image'             => esc_html__('Image', 'agrarium_plugin'),
                    'color'             => esc_html__('Color', 'agrarium_plugin')
                ]
            ]
        );

        $this->add_control(
            'svg_background',
            [
                'label'         => esc_html__('SVG Background', 'agrarium_plugin'),
                'description'   => esc_html__('Enter svg code', 'agrarium_plugin'),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => '',
                'condition'     => [
                    'background_type' => 'svg'
                ]
            ]
        );

        $this->start_controls_tabs('background_settings_tabs');

            // ------------------------ //
            // ------ Normal Tab ------ //
            // ------------------------ //
            $this->start_controls_tab(
                'background_normal',
                [
                    'label'     => esc_html__('Normal', 'agrarium_plugin'),
                    'condition' => [
                        'background_type' => 'image'
                    ]
                ]
            );

                $this->add_control(
                    'bg_image',
                    [
                        'label'     => esc_html__('Choose Background Image', 'agrarium_plugin'),
                        'type'      => Controls_Manager::MEDIA,
                        'default'   => [],
                        'condition' => [
                            'background_type' => 'image'
                        ]
                    ]
                );

            $this->end_controls_tab();

            // ----------------------- //
            // ------ Hover Tab ------ //
            // ----------------------- //
            $this->start_controls_tab(
                'background_hover',
                [
                    'label'     => esc_html__('Hover', 'agrarium_plugin'),
                    'condition' => [
                        'background_type' => 'image'
                    ]
                ]
            );

                $this->add_control(
                    'bg_image_hover',
                    [
                        'label'     => esc_html__('Choose Background Image', 'agrarium_plugin'),
                        'type'      => Controls_Manager::MEDIA,
                        'default'   => [],
                        'condition' => [
                            'background_type' => 'image'
                        ]
                    ]
                );

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'title',
            [
                'label'         => esc_html__('Icon Box Title', 'agrarium_plugin'),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => esc_html__('Title', 'agrarium_plugin'),
                'placeholder'   => esc_html__('Enter Icon Box Title', 'agrarium_plugin'),
                'separator'     => 'before'
            ]
        );

        $this->add_control(
            'info',
            [
                'label' => esc_html__('Icon Box Information', 'agrarium_plugin'),
                'type' => Controls_Manager::WYSIWYG,
                'rows' => '10',
                'default' => '',
                'placeholder' => esc_html__('Enter Your Custom Information', 'agrarium_plugin')
            ]
        );

        $this->add_control(
            'frame_type',
            [
                'label'     => esc_html__('Frame Type', 'agrarium_plugin'),
                'type'      => Controls_Manager::SELECT,
                'default'   => '',
                'options'   => [
                    ''          => esc_html__('None', 'agrarium_plugin'),
                    'square'    => esc_html__('Square', 'agrarium_plugin'),
                    'square-2'  => esc_html__('Square Alter', 'agrarium_plugin'),
                    'triangle'  => esc_html__('Triangle', 'agrarium_plugin'),
                    'circle'    => esc_html__('Circle', 'agrarium_plugin')
                ]
            ]
        );

        $this->add_responsive_control(
            'icon_box_align',
            [
                'label'         => esc_html__('Icon Box Alignment', 'agrarium_plugin'),
                'type'          => Controls_Manager::CHOOSE,
                'options'       => [
                    'left'          => [
                        'title'         => esc_html__('Left', 'agrarium_plugin'),
                        'icon'          => 'fa fa-align-left',
                    ],
                    'center'        => [
                        'title'         => esc_html__('Center', 'agrarium_plugin'),
                        'icon'          => 'fa fa-align-center',
                    ],
                    'right'         => [
                        'title'         => esc_html__('Right', 'agrarium_plugin'),
                        'icon'          => 'fa fa-align-right',
                    ]
                ],
                'default'       => 'center',
                'selectors'     => [
                    '{{WRAPPER}} .icon-box-item' => 'text-align: {{VALUE}};',
                ],
                'separator'     => 'before',
                'prefix_class'  => 'alignment%s-'
            ]
        );

        $this->end_controls_section();

        // ----------------------------------- //
        // ---------- Icon Settings ---------- //
        // ----------------------------------- //
        $this->start_controls_section(
            'icon_settings',
            [
                'label' => esc_html__('Icon Settings', 'agrarium_plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'icon_container_size',
            [
                'label'     => esc_html__('Icon Container Size', 'agrarium_plugin'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px'        => [
                        'min'       => 50,
                        'max'       => 280
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .icon-container' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'icon_background_size',
            [
                'label'     => esc_html__('Icon Background Size', 'agrarium_plugin'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px'        => [
                        'min'       => 50,
                        'max'       => 280
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .icon-container .background' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};'
                ],
                'condition' => [
                    'background_type!' => 'none'
                ]
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label'     => esc_html__('Icon Size', 'agrarium_plugin'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px'        => [
                        'min'       => 5,
                        'max'       => 280
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .icon-container i' => 'font-size: {{SIZE}}{{UNIT}};'
                ],
                'condition' => [
                    'icon_type' => 'default'
                ]
            ]
        );

        $this->add_responsive_control(
            'icon_svg_size',
            [
                'label'     => esc_html__('Icon Size', 'agrarium_plugin'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px'        => [
                        'min'       => 5,
                        'max'       => 200
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .icon-container .icon' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};'
                ],
                'condition' => [
                    'icon_type' => 'svg'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'icon_text_typography',
                'label'     => esc_html__('Icon Text Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .icon-container .text',
                'condition' => [
                    'icon_type'     => 'text'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'      => 'icon_shadow',
                'label'     => esc_html__('Icon Shadow', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .icon-container'
            ]
        );


        $this->start_controls_tabs('icon_settings_tabs');

            // ------------------------ //
            // ------ Normal Tab ------ //
            // ------------------------ //
            $this->start_controls_tab(
                'icon_normal',
                [
                    'label' => esc_html__('Normal', 'agrarium_plugin')
                ]
            );

                $this->add_control(
                    'icon_color',
                    [
                        'label'     => esc_html__('Icon Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .icon-container i' => 'color: {{VALUE}};'
                        ],
                        'condition' => [
                            'icon_type' => 'default'
                        ]
                    ]
                );

                $this->add_control(
                    'icon_svg_color',
                    [
                        'label'     => esc_html__('Icon Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .icon-container .icon svg' => 'fill: {{VALUE}};'
                        ],
                        'condition' => [
                            'icon_type' => 'svg'
                        ]
                    ]
                );

                $this->add_control(
                    'icon_text_color',
                    [
                        'label'     => esc_html__('Icon Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .icon-container .text' => 'color: {{VALUE}};'
                        ],
                        'condition' => [
                            'icon_type' => 'text'
                        ]
                    ]
                );

                $this->add_control(
                    'icon_frame_color',
                    [
                        'label'     => esc_html__('Icon Frame Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .icon-container .frame' => 'fill: {{VALUE}};'
                        ],
                        'condition' => [
                            'frame_type!' => ''
                        ]
                    ]
                );

                $this->add_control(
                    'background_svg_color',
                    [
                        'label'     => esc_html__('Background SVG Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .icon-container .background svg' => 'fill: {{VALUE}};'
                        ],
                        'condition' => [
                            'background_type' => 'svg',
                        ]
                    ]
                );

                $this->add_control(
                    'background_color',
                    [
                        'label'     => esc_html__('Background Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .icon-container' => 'background-color: {{VALUE}};'
                        ],
                        'condition' => [
                            'background_type' => 'color',
                        ]
                    ]
                );

            $this->end_controls_tab();

            // ----------------------- //
            // ------ Hover Tab ------ //
            // ----------------------- //
            $this->start_controls_tab(
                'icon_hover',
                [
                    'label' => esc_html__('Hover', 'agrarium_plugin')
                ]
            );

                $this->add_control(
                    'icon_color_hover',
                    [
                        'label'     => esc_html__('Icon Color on Hover', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}:hover .icon-container i' => 'color: {{VALUE}};'
                        ],
                        'condition' => [
                            'icon_type' => 'default'
                        ]
                    ]
                );

                $this->add_control(
                    'icon_svg_color_hover',
                    [
                        'label'     => esc_html__('Icon Color on Hover', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}:hover .icon-container .icon svg' => 'fill: {{VALUE}};'
                        ],
                        'condition' => [
                            'icon_type' => 'svg'
                        ]
                    ]
                );

                $this->add_control(
                    'icon_text_color_hover',
                    [
                        'label'     => esc_html__('Icon Color on Hover', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}:hover .icon-container .text' => 'color: {{VALUE}};'
                        ],
                        'condition' => [
                            'icon_type' => 'text'
                        ]
                    ]
                );

                $this->add_control(
                    'icon_frame_color_hover',
                    [
                        'label'     => esc_html__('Icon Frame Color on Hover', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}:hover .icon-container .frame' => 'fill: {{VALUE}};'
                        ],
                        'condition' => [
                            'frame_type!' => ''
                        ]
                    ]
                );

                $this->add_control(
                    'background_svg_color_hover',
                    [
                        'label'     => esc_html__('Background SVG on Hover', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}:hover .icon-container .background svg' => 'fill: {{VALUE}};'
                        ],
                        'condition' => [
                            'background_type' => 'svg'
                        ]
                    ]
                );

                $this->add_control(
                    'background_color_hover',
                    [
                        'label'     => esc_html__('Background Color on Hover', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}:hover .icon-container' => 'background-color: {{VALUE}};'
                        ],
                        'condition' => [
                            'background_type' => 'color'
                        ]
                    ]
                );

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_responsive_control(
            'icon_margin',
            [
                'label'     => esc_html__('Icon top padding', 'agrarium_plugin'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px'        => [
                        'min'       => -100,
                        'max'       => 100
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .icon-container' => 'margin-top: {{SIZE}}{{UNIT}};'
                ],
                'condition' => [
                    'icon_position' => ['left', 'right']
                ]
            ]
        );

        $this->add_control(
            'hover_animation',
            [
                'label' => esc_html__( 'Hover Animation', 'elementor' ),
                'type' => Controls_Manager::HOVER_ANIMATION,                
                'prefix_class' => 'elementor-animation-'
            ]
        );

        $this->end_controls_section();


        // ------------------------------------ //
        // ---------- Title Settings ---------- //
        // ------------------------------------ //
        $this->start_controls_section(
            'title_settings',
            [
                'label' => esc_html__('Title Settings', 'agrarium_plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'title_typography',
                'label'     => esc_html__('Title Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .icon-box-title'
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__('Title Color', 'agrarium_plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .icon-box-title' => 'color: {{VALUE}};'
                ]
            ]
        );        

        $this->add_responsive_control(
            'title_margin',
            [
                'label'     => esc_html__('Space Between Icon and Title', 'agrarium_plugin'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px'        => [
                        'min'       => 0,
                        'max'       => 200
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}}.icon-position-left .icon-box-item .icon-container' => 'margin-right: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}}.icon-position-right .icon-box-item .icon-container' => 'margin-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}}.icon-position-top .icon-box-item .icon-container' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    '(tablet){{WRAPPER}} .icon-box-item .icon-container' => 'margin-bottom: {{title_margin_tablet.SIZE}}{{title_margin_tablet.UNIT}}; margin-left: 0!important; margin-right: 0!important;',
                    '(mobile){{WRAPPER}} .icon-box-item .icon-container' => 'margin-bottom: {{title_margin_mobile.SIZE}}{{title_margin_mobile.UNIT}}; margin-left: 0!important; margin-right: 0!important;',
                ]
            ]
        );

        $this->end_controls_section();


        // ---------------------------------------- //
        // ---------- Info Text Settings ---------- //
        // ---------------------------------------- //
        $this->start_controls_section(
            'text_settings',
            [
                'label' => esc_html__('Information Text Settings', 'agrarium_plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
            'info_color',
            [
                'label'     => esc_html__('Information Color', 'agrarium_plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .icon-box-info' => 'color: {{VALUE}};'
                ],
                'separator' => 'before'
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'info_typography',
                'label'     => esc_html__('Information Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .icon-box-info'
            ]
        );

        $this->add_responsive_control(
            'info_margin',
            [
                'label'     => esc_html__('Space Between Title and Text', 'agrarium_plugin'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px'        => [
                        'min'       => 0,
                        'max'       => 200
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .icon-box-info' => 'margin-top: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings        = $this->get_settings();

        $icon_type       = $settings['icon_type'];
        $default_icon    = $settings['default_icon'];
        $svg_icon        = $settings['svg_icon'];
        $text_icon       = $settings['text_icon'];

        $background_type = $settings['background_type'];
        $frame_type      = $settings['frame_type'];


        switch ( $frame_type ) {
            case 'square':
                $frame = '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="0 0 90.440002 100.92"><path d="m 90.44,15.41 h -1 V 1 H 0.5 V 0 h 89.94 z m -0.5,85.51 H 0 V 72.11 h 1 v 27.81 h 88.94 z" /></svg>';
                break;
            case 'square-2':
                $frame = '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="0 0 97.839996 97.830002"><path d="M 75.44,97.83 H 0 V 23.09 h 1 v 73.74 h 74.44 z m 22.4,-23.6 h -1 V 1 H 22.4 V 0 h 75.44 z" /></svg>';
                break;
            case 'triangle':
                $frame = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 204.77977 191.26611"><path d="m 0.55078125,0.00390625 c -0.49375001,0.04375 -0.66875001,0.44453123 -0.46875,1.14453125 C 0.48203126,2.0817709 4.6140624,16.882031 9.4140625,34.082031 14.214063,51.282032 19.014844,68.614323 20.214844,72.347656 c 1.066666,3.866667 2.399739,7.066406 3.066406,7.066406 0.533333,0 -3.60013,-16.933462 -9.466797,-37.466796 C 8.0811196,21.280598 3.680599,4.0816406 3.9472656,3.6816406 4.6139323,3.1483073 263.14766,59.547396 268.34766,61.414062 c 0.93333,0.266667 -9.59961,11.466927 -23.59961,24.933594 -13.86667,13.466667 -24.66667,24.534114 -24,24.800784 -12.53065,13.7741 53.59896,-49.466539 52.26562,-50.533206 -0.53333,-0.4 -61.46627,-14.133723 -135.59961,-30.40039 C 63.280721,13.948177 2.0817708,0.34869792 1.1484375,0.08203125 0.91510416,0.01536458 0.71536459,-0.01067708 0.55078125,0.00390625 Z M 169.28125,160.74805 c -0.8,0 -22.66601,20.40065 -48.66602,45.33398 -25.866663,24.93334 -47.467183,44.79896 -47.867183,44.26563 -0.533333,-0.53334 -5.600651,-18.00026 -11.333985,-38.9336 -9.466666,-34.4 -12.666015,-44.26653 -12.666015,-38.5332 0,2.26667 22.265885,81.19948 23.199219,82.13281 0.4,0.4 18.267707,-16.26497 39.734374,-36.93164 54.13334,-52.26667 59.19961,-57.33398 57.59961,-57.33398 z" /></svg>';
                break;
            case 'circle':
                $frame = '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="0 0 96.207634 96.270554"><path d="M 42.56,100.71028 C 25.871492,100.76384 10.120759,92.999493 0,79.73 L 0.79,79.12 C 14.525735,97.011529 38.130854,104.1682 59.489529,96.916701 80.848203,89.665201 95.216667,69.616091 95.22,47.06 95.274439,30.645934 87.621237,15.158105 74.55,5.23 L 75.16,4.44 C 93.42143,18.418153 100.74541,42.478777 93.369303,64.260917 85.993196,86.043058 65.557142,100.70328 42.56,100.71028 Z" /></svg>';
                break;
            default:
                $frame = '';
        }
        if ( $background_type == 'svg' ) {
            $svg_background = $settings['svg_background'];
        }
        if ( $background_type == 'image' ) {
            $bg_image = !empty($settings['bg_image']['url']) ? $settings['bg_image'] : array();
        }

        $title              = $settings['title'];
        $info               = $settings['info'];

        // ------------------------------------ //
        // ---------- Widget Content ---------- //
        // ------------------------------------ //
        ?>

        <div class="agrarium-icon-box-widget">
            <div class="icon-box-item">

                <div class="icon-container<?php echo ( !empty($background_type) ? ' background-type-' . esc_attr($background_type) : '' ); ?><?php echo ( !empty($frame_type) ? ' icon-frame-type-' . esc_attr($frame_type) : '' ); ?>">
                    <?php
                    if ($icon_type == 'default') {
                        echo '<i class="' . esc_attr($default_icon['value']) . '"></i>';
                    }
                    if ($icon_type == 'svg') {
                        echo '<span class="icon">' . agrarium_output_code($svg_icon) . '</span>';
                    }
                    if ($icon_type == 'text') {
                        echo '<span class="text">' . esc_html($text_icon) . '</span>';
                    }

                    if ( !empty($frame) ) {
                        echo '<span class="frame' . ( !empty($frame_type) ? ' frame-type-' . esc_attr($frame_type) : '' ) . '">' . agrarium_output_code($frame) . '</span>';
                    }

                    if ($background_type == 'image') {
                        if (!empty($bg_image['url'])) {
                            echo '<img class="icon-container-bg-image" src="' . esc_url($bg_image['url']) . '" alt="' . esc_html__('Background Image', 'agrarium_plugin') . '" />';
                        }
                    }
                    if ($background_type == 'svg' && !empty($svg_background)) {
                        echo '<span class="background">' . agrarium_output_code($svg_background) . '</span>';
                    }
                    ?>
                </div>

                <div class="content-container">
                    <?php
                    if ($title !== '') {
                        echo '<h5 class="icon-box-title">';
                            echo '<span class="agrarium-heading-content">' . agrarium_output_code($title) . '</span>';
                        echo '</h5>';
                    }
                    ?>
                    <?php 
                        if ($info !== '') {
                            echo '<div class="icon-box-info">';
                                echo agrarium_output_code($info);
                            echo '</div>';
                        }
                    ?>                    
                </div>
            </div>
        </div>
        <?php
    }

    protected function content_template() {}

    public function render_plain_content() {}
}