<?php
/*
 * Created by Artureanec
*/

namespace AgrariUm\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\REPEATER;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class AgrariUm_Price_Item_Widget extends Widget_Base {

    public function get_name() {
        return 'agrarium_price_item';
    }

    public function get_title() {
        return esc_html__('Price Item', 'agrarium_plugin');
    }

    public function get_icon() {
        return 'eicon-price-table';
    }

    public function get_categories() {
        return ['agrarium_widgets'];
    }

    protected function register_controls() {

        // ----------------------------- //
        // ---------- Content ---------- //
        // ----------------------------- //
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Price Item', 'agrarium_plugin')
            ]
        );

        $this->add_control(
            'block_type',
            [
                'label'     => esc_html__('Price Item Type', 'agrarium_plugin'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'standard',
                'options'   => [
                    'standard'  => esc_html__('Standard', 'agrarium_plugin'),
                    'wide'      => esc_html__('Wide', 'agrarium_plugin')
                ]
            ]
        );

        $this->add_control(
            'active_block_status',
            [
                'label'         => esc_html__('Highlight this block?', 'agrarium_plugin'),
                'type'          => Controls_Manager::SWITCHER,
                'label_off'     => esc_html__('No', 'agrarium_plugin'),
                'label_on'      => esc_html__('Yes', 'agrarium_plugin'),
                'return_value'  => 'yes',
                'default'       => 'no'
            ]
        );

        $this->add_control(
            'title',
            [
                'label'     => esc_html__('Title', 'agrarium_plugin'),
                'type'      => Controls_Manager::TEXT,
                'default'   => ''
            ]
        );
        $this->add_control(
            'best_choice_status',
            [
                'label'         => esc_html__('Show Best Choice Label?', 'agrarium_plugin'),
                'type'          => Controls_Manager::SWITCHER,
                'label_off'     => esc_html__('No', 'agrarium_plugin'),
                'label_on'      => esc_html__('Yes', 'agrarium_plugin'),
                'return_value'  => 'yes',
                'default'       => 'no'
            ]
        );
        $this->add_control(
            'best_choice_text',
            [
                'label'     => esc_html__('Best Choice Text', 'agrarium_plugin'),
                'type'      => Controls_Manager::TEXT,
                'default'   => 'Best Choice',
                'condition' => [
                    'best_choice_status' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'image',
            [
                'label'     => esc_html__('Image', 'agrarium_plugin'),
                'type'      => Controls_Manager::MEDIA,
                'condition' => [
                    'block_type' => 'standard'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'      => 'thumbnail',
                'exclude'   => ['1536x1536', '2048x2048', 'post-thumbnail', 'agrarium_post_thumbnail_mobile', 'agrarium_post_thumbnail_tablet', 'agrarium_post_thumbnail_default', 'agrarium_post_thumbnail_full', 'agrarium_post_grid_2_columns', 'agrarium_post_grid_3_columns', 'agrarium_post_grid_4_columns', 'agrarium_post_grid_5_columns', 'agrarium_post_grid_6_columns', 'agrarium_portfolio_thumbnail', 'agrarium_portfolio_grid_1_columns', 'agrarium_portfolio_grid_2_columns', 'agrarium_portfolio_grid_3_columns', 'agrarium_portfolio_grid_4_columns', 'agrarium_portfolio_grid_5_columns', 'agrarium_portfolio_grid_6_columns', 'agrarium_team_thumbnail', 'woocommerce_thumbnail', 'woocommerce_single', 'woocommerce_gallery_thumbnail'],
                'default'   => 'full',
                'condition' => [
                    'block_type' => 'standard'
                ]
            ]
        );

        $this->add_control(
            'currency',
            [
                'label'         => esc_html__('Currency', 'agrarium_plugin'),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => '$',
                'separator'     => 'before'
            ]
        );

        $this->add_control(
            'currency_position',
            [
                'label'     => esc_html__('Currency Position', 'agrarium_plugin'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'before',
                'options'   => [
                    'before'    => esc_html__('Before Price', 'agrarium_plugin'),
                    'after'     => esc_html__('After Price', 'agrarium_plugin')
                ]
            ]
        );

        $this->add_control(
            'price',
            [
                'label'     => esc_html__('Price', 'agrarium_plugin'),
                'type'      => Controls_Manager::TEXT,
                'default'   => ''
            ]
        );

        $this->add_control(
            'period',
            [
                'label'         => esc_html__('Period', 'agrarium_plugin'),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__('month', 'agrarium_plugin')
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'text',
            [
                'label'         => esc_html__( 'Text', 'agrarium_plugin' ),
                'type'          => Controls_Manager::TEXT,
                'label_block'   => true,
                'default'       => '',
                'placeholder'   => esc_html__( 'Enter Text', 'agrarium_plugin' ),
            ]
        );

        $repeater->add_control(
            'is_active',
            [
                'label'         => esc_html__('Highlight this field', 'agrarium_plugin'),
                'type'          => Controls_Manager::SWITCHER,
                'label_off'     => esc_html__('No', 'agrarium_plugin'),
                'label_on'      => esc_html__('Yes', 'agrarium_plugin'),
                'return_value'  => 'yes',
                'default'       => 'no'
            ]
        );

        $this->add_control(
            'custom_fields',
            [
                'label'         => esc_html__('Custom Fields', 'agrarium_plugin'),
                'type'          => Controls_Manager::REPEATER,
                'fields'        => $repeater->get_controls(),
                'prevent_empty' => false,
                'separator'     => 'before',
                'default'       => [
                    [
                        'text'      => '',
                        'is_active' => 'no'
                    ]
                ],
                'condition'     => [
                    'block_type'     => 'standard'
                ]
            ]
        );

        $this->add_control(
            'description',
            [
                'label'         => esc_html__('Short Description', 'agrarium_plugin'),
                'description'   => esc_html__('Enter description', 'agrarium_plugin'),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => '',
                'condition'     => [
                    'block_type'     => 'wide'
                ]
            ]
        );

        $this->add_control(
            'price_button_text',
            [
                'label'         => esc_html__('Button Text', 'agrarium_plugin'),
                'type'          => Controls_Manager::TEXT,
                'default'       => esc_html__('Get Started', 'agrarium_plugin'),
                'placeholder'   => esc_html__('Button Text', 'agrarium_plugin'),
                'separator'     => 'before'
            ]
        );

        $this->add_control(
            'button_link',
            [
                'label'         => esc_html__('Button Link', 'agrarium_plugin'),
                'type'          => Controls_Manager::URL,
                'placeholder'   => esc_url('http://your-link.com'),
                'default'       => [
                    'url'   => '',
                ]
            ]
        );

        $this->end_controls_section();

        // ----------------------------------------- //
        // ---------- Price Item Settings ---------- //
        // ----------------------------------------- //
        $this->start_controls_section(
            'section_settings',
            [
                'label' => esc_html__('Price Item Settings', 'agrarium_plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'              => 'item_bg',
                'label'             => esc_html__( 'Background', 'agrarium_plugin' ),
                'types'             => [ 'classic', 'gradient' ],
                'fields_options'    => [
                    'image' => [
                        'condition' => [
                            'background'  => 'image'
                        ]
                    ],
                    'color' => [
                        'label'     => esc_html__('Background Color', 'agrarium_plugin')
                    ]
                ],
                'selector'          => '{{WRAPPER}} .price-item'
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'      => 'item_shadow',
                'label'     => esc_html__('Item Shadow', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .price-item',
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label'         => esc_html__('Item Padding', 'agrarium_plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em', '%'],
                'selectors'     => [
                    '{{WRAPPER}} .price-item.price-item-type-standard' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .price-item.price-item-type-wide .price-item-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .price-item.price-item-type-standard .price-item-button-container' => 'margin: 0 -{{RIGHT}}{{UNIT}} 0 -{{LEFT}}{{UNIT}}'
                ]
            ]
        );

        $this->end_controls_section();

        // ------------------------------------ //
        // ---------- Title Settings ---------- //
        // ------------------------------------ //
        $this->start_controls_section(
            'section_title_settings',
            [
                'label' => esc_html__('Title Settings', 'agrarium_plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'title_typography',
                'label'     => esc_html__('Title Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .price-item-title'
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__('Title Color', 'agrarium_plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price-item .price-item-title' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'title_margin',
            [
                'label'     => esc_html__('Space After Title', 'agrarium_plugin'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px'        => [
                        'min'       => 0,
                        'max'       => 200
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .price-item-title-wrapper:not(:last-child)' => 'margin-bottom: {{SIZE}}{{UNIT}};'
                ],
                'condition' => [
                    'block_type'    => 'standard'
                ]
            ]
        );

        $this->end_controls_section();

        // ------------------------------------ //
        // ---------- Best Choice Settings ---------- //
        // ------------------------------------ //
        $this->start_controls_section(
            'section_best_choice_settings',
            [
                'label' => esc_html__('Best Choice Settings', 'agrarium_plugin'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'best_choice_status' => 'yes'
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'best_choice_typography',
                'label'     => esc_html__('Best Choice Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .price-item-best-choice'
            ]
        );

        $this->add_control(
            'best_choice_color',
            [
                'label'     => esc_html__('Best Choice Color', 'agrarium_plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price-item .price-item-best-choice' => 'color: {{VALUE}};'
                ]
            ]
        );
        $this->add_control(
            'best_choice_bg_color',
            [
                'label'     => esc_html__('Best Choice Background Color', 'agrarium_plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price-item .price-item-best-choice' => 'background-color: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();

        // ------------------------------------ //
        // ---------- Image Settings ---------- //
        // ------------------------------------ //
        $this->start_controls_section(
            'section_image_settings',
            [
                'label'     => esc_html__('Image Settings', 'agrarium_plugin'),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'block_type'    => 'standard'
                ]
            ]
        );

        $this->add_control(
            'image_margin',
            [
                'label'     => esc_html__('Space After Image', 'agrarium_plugin'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px'        => [
                        'min'       => 0,
                        'max'       => 200
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .price-item-image:not(:last-child)' => 'margin-bottom: {{SIZE}}{{UNIT}};'
                ],
                'condition' => [
                    'block_type'    => 'standard'
                ]
            ]
        );

        $this->end_controls_section();

        // ------------------------------------------ //
        // ---------- Price Block Settings ---------- //
        // ------------------------------------------ //
        $this->start_controls_section(
            'section_price_settings',
            [
                'label' => esc_html__('Price Block Settings', 'agrarium_plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'price_typography',
                'label'     => esc_html__('Price Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .price-item .price-wrapper .price'
            ]
        );

        $this->add_control(
            'price_color',
            [
                'label'     => esc_html__('Price Color', 'agrarium_plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price-item .price-wrapper .price' => 'color: {{VALUE}};'
                ],
                'separator' => 'after'
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'currency_typography',
                'label'     => esc_html__('Currency Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .price-item .price-wrapper .currency'
            ]
        );

        $this->add_control(
            'currency_color',
            [
                'label'     => esc_html__('Currency Color', 'agrarium_plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price-item .price-wrapper .currency' => 'color: {{VALUE}};'
                ],
                'separator' => 'after'
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'period_typography',
                'label'     => esc_html__('Period Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .price-item .price-item-period'
            ]
        );

        $this->add_control(
            'period_color',
            [
                'label'     => esc_html__('Period Color', 'agrarium_plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price-item .price-item-period' => 'color: {{VALUE}};'
                ],
                'separator' => 'after'
            ]
        );

        $this->add_control(
            'price_margin',
            [
                'label'     => esc_html__('Space After Price', 'agrarium_plugin'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px'        => [
                        'min'       => 0,
                        'max'       => 200
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .price-item-container:not(:last-child)' => 'margin-bottom: {{SIZE}}{{UNIT}};'
                ],
                'condition' => [
                    'block_type'    => 'standard'
                ]
            ]
        );

        $this->end_controls_section();

        // -------------------------------------- //
        // ---------- Content Settings ---------- //
        // -------------------------------------- //
        $this->start_controls_section(
            'section_content_settings',
            [
                'label' => esc_html__('Content Settings', 'agrarium_plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
            'separator_color',
            [
                'label'     => esc_html__('Separator Line Color', 'agrarium_plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price-item .price-item-custom-fields' => 'border-color: {{VALUE}};'
                ],
                'separator' => 'after',
                'condition' => [
                    'block_type' => 'standard'
                ]
            ]
        );

        $this->add_control(
            'fields_margin',
            [
                'label'     => esc_html__('Space Between Fields', 'agrarium_plugin'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px'        => [
                        'min'       => 0,
                        'max'       => 20
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .price-item .price-item-custom-field:not(:first-child)' => 'margin-top: {{SIZE}}{{UNIT}};'
                ],
                'condition' => [
                    'block_type' => 'standard'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'fields_typography',
                'label'     => esc_html__('Custom Fields Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .price-item .price-item-custom-field',
                'separator' => 'after',
                'condition' => [
                    'block_type' => 'standard'
                ]
            ]
        );

        $this->add_control(
            'content_margin',
            [
                'label'     => esc_html__('Space After Content', 'agrarium_plugin'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px'        => [
                        'min'       => 0,
                        'max'       => 200
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .price-item-custom-fields:not(:last-child)' => 'margin-bottom: {{SIZE}}{{UNIT}};'
                ],
                'condition' => [
                    'block_type'    => 'standard'
                ]
            ]
        );

        $this->add_responsive_control(
            'custom_field_padding',
            [
                'label'     => esc_html__('Space Before Fields', 'agrarium_plugin'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px'        => [
                        'min'       => 0,
                        'max'       => 200
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .price-item.price-item-type-standard .price-item-custom-fields .price-item-custom-field' => 'padding-left: {{SIZE}}{{UNIT}};'
                ],
                'condition' => [
                    'block_type'    => 'standard'
                ]
            ]
        );

        $this->start_controls_tabs(
            'fields_settings_tabs',
            [
                'condition' => [
                    'block_type' => 'standard'
            ]
        ]);

            // ------------------------ //
            // ------ Normal Tab ------ //
            // ------------------------ //
            $this->start_controls_tab(
                'tab_fields_normal',
                [
                    'label' => esc_html__('Normal', 'agrarium_plugin')
                ]
            );

                $this->add_control(
                    'fields_color',
                    [
                        'label'     => esc_html__('Custom Fields Text Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .price-item .price-item-custom-field:not(.active)' => 'color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'fields_icon_color',
                    [
                        'label'     => esc_html__('Custom Fields Icon Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .price-item .price-item-custom-field:not(.active):before' => 'color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();

            // ------------------------ //
            // ------ Active Tab ------ //
            // ------------------------ //
            $this->start_controls_tab(
                'tab_fields_active',
                [
                    'label' => esc_html__('Active', 'agrarium_plugin')
                ]
            );

                $this->add_control(
                    'active_fields_color',
                    [
                        'label'     => esc_html__('Custom Fields Text Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .price-item .price-item-custom-field.active' => 'color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'active_fields_icon_color',
                    [
                        'label'     => esc_html__('Custom Fields Icon Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .price-item .price-item-custom-field.active:before' => 'color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'description_typography',
                'label'     => esc_html__('Description Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .price-item .price-item-description',
                'separator' => 'after',
                'condition' => [
                    'block_type' => 'wide'
                ]
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label'     => esc_html__('Description Color', 'agrarium_plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price-item .price-item-description' => 'color: {{VALUE}};'
                ],
                'condition' => [
                    'block_type' => 'wide'
                ]
            ]
        );

        $this->end_controls_section();

        // ------------------------------------- //
        // ---------- Button Settings ---------- //
        // ------------------------------------- //
        $this->start_controls_section(
            'section_button_settings',
            [
                'label' => esc_html__('Button Settings', 'agrarium_plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'button_typography',
                'label'     => esc_html__('Button Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .price-item-button-container .agrarium-button'
            ]
        );

        $this->start_controls_tabs('button_settings_tabs');

            // ------------------------ //
            // ------ Normal Tab ------ //
            // ------------------------ //
            $this->start_controls_tab(
                'tab_button_normal',
                [
                    'label' => esc_html__('Normal', 'agrarium_plugin')
                ]
            );

                $this->add_control(
                    'button_color',
                    [
                        'label'     => esc_html__('Button Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .price-item-button-container .agrarium-button' => 'color: {{VALUE}};'
                        ]
                    ]
                );
                $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                        'name'      => 'button_box_shadow',
                        'label'     => esc_html__('Button Box Shadow', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selector'  => '{{WRAPPER}} .price-item-button-container .agrarium-button'
                    ]
                );

            $this->end_controls_tab();

            // ----------------------- //
            // ------ Hover Tab ------ //
            // ----------------------- //
            $this->start_controls_tab(
                'tab_button_hover',
                [
                    'label' => esc_html__('Hover', 'agrarium_plugin')
                ]
            );

                $this->add_control(
                    'button_color_hover',
                    [
                        'label'     => esc_html__('Button Hover Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .price-item-button-container .agrarium-button:hover' => 'color: {{VALUE}};'
                        ]
                    ]
                );
                $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                        'name'      => 'button_hover_box_shadow',
                        'label'     => esc_html__('Button Hover Box Shadow', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selector'  => '{{WRAPPER}} .price-item-button-container .agrarium-button:hover'
                    ]
                );

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'      => 'button_bg',
                'label'     => esc_html__( 'Button Background', 'agrarium_plugin' ),
                'types'     => [ 'classic', 'gradient' ],
                'selector'  => '{{WRAPPER}} .price-item-button-container .agrarium-button:after'
            ]
        );

        $this->add_control(
            'button_radius',
            [
                'label'         => esc_html__('Border Radius', 'agrarium_plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', '%'],
                'selectors'     => [
                    '{{WRAPPER}} .price-item-button-container .agrarium-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                'separator'     => 'before'
            ]
        );

        $this->add_control(
            'button_padding',
            [
                'label'         => esc_html__('Button Padding', 'agrarium_plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', '%'],
                'selectors'     => [
                    '{{WRAPPER}} .price-item-button-container .agrarium-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings               = $this->get_settings();

        $block_type             = $settings['block_type'];
        $title                  = $settings['title'];
        $best_choice_status     = $settings['best_choice_status'];
        $best_choice_text       = $settings['best_choice_text'];
        $image                  = $settings['image'];
        $active_block_status    = $settings['active_block_status'];
        $currency               = $settings['currency'];
        $currency_position      = $settings['currency_position'];
        $price                  = $settings['price'];
        $period                 = $settings['period'];
        $custom_fields          = $settings['custom_fields'];
        $description            = $settings['description'];
        $price_button_text      = $settings['price_button_text'];
        $button_link            = $settings['button_link'];
        $button_url             = $button_link['url'];

        if ( !empty($price_button_text) && empty($button_url) ) {
            $button_url         = '#';
        }

        // ------------------------------------ //
        // ---------- Widget Content ---------- //
        // ------------------------------------ //
        ?>

        <div class="agrarium-price-item-widget">            
            <div class="price-item<?php echo ($active_block_status == 'yes' ? ' active' : '') . ' price-item-type-' . esc_attr($block_type); ?>">
                <?php 
                    if($best_choice_status === 'yes' && !empty($best_choice_text)) {
                        echo '<span class="price-item-best-choice">' . esc_html($best_choice_text) . '</span>';
                    }
                ?>
                <div class="price-item-inner">

                    <?php
                    if ($title !== '') {
                        echo '<div class="price-item-title-wrapper">';
                            echo '<div class="price-item-title">' . esc_html($title) . '</div>';
                        echo '</div>';
                    }

                    if ( !empty($description) && $block_type == 'wide' ) {
                        echo '<div class="price-item-description">' . esc_html($description) . '</div>';
                    }

                    if ( !empty($image) ) {
                        echo '<div class="price-item-image">';
                            echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'image' );
                        echo '</div>';
                    }

                    if ( !empty($price) ) {
                        ?>
                        <div class="price-item-container price-item-currency-position-<?php echo esc_attr($currency_position); ?>">
                            <div class="price-wrapper">
                                <?php
                                if ( !empty($currency) && $currency_position == 'before' ) {
                                    echo '<span class="currency">' . esc_html($currency) . '</span>';
                                }

                                echo '<span class="price">' . esc_html($price) . '</span>';

                                if ( !empty($currency) && $currency_position == 'after' ) {
                                    echo '<span class="currency">' . esc_html($currency) . '</span>';
                                }
                                ?>
                            </div>

                            <?php
                            if ( !empty($period) ) {
                                echo '<div class="price-item-period">' . esc_html($period) . '</div>';
                            }
                            ?>
                        </div>
                        <?php
                    }

                    if ( !empty($custom_fields) && $block_type == 'standard' ) {
                        ?>
                        <div class="price-item-custom-fields">
                            <?php
                            foreach ($custom_fields as $field) {
                                $field_status_class = $field['is_active'] == 'yes' ? ' active' : '';
                                if ( !empty($field['text']) ) { ?>
                                    <div class="price-item-custom-field <?php echo esc_attr($field_status_class); ?>"><?php echo esc_html($field['text']); ?></div>
                                <?php }
                            }
                            ?>
                        </div>
                        <?php
                    }
                    ?>

                    <?php
                        if ( !empty($price_button_text) ) { ?>
                            <div class="price-item-button-container">
                                <a class="agrarium-button" href="<?php echo esc_url($button_url); ?>" <?php echo (($button_link['is_external'] == true) ? 'target="_blank"' : ''); echo (($button_link['nofollow'] == 'on') ? 'rel="nofollow"' : ''); ?>><?php echo esc_html($price_button_text); ?></a>
                            </div>
                        <?php }
                    ?>
                </div>
            </div>
        </div>
        <?php
    }

    protected function content_template() {}

    public function render_plain_content() {}
}