<?php
/*
 * Created by Artureanec
*/

namespace AgrariUm\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\REPEATER;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class AgrariUm_Product_Carousel_Widget extends Widget_Base {

    public function get_name() {
        return 'agrarium_product_carousel';
    }

    public function get_title() {
        return esc_html__('Product Carousel', 'agrarium_plugin');
    }

    public function get_icon() {
        return 'eicon-testimonial-carousel';
    }

    public function get_categories() {
        return ['agrarium_widgets'];
    }

    public function get_script_depends() {
        return ['product_carousel_widget'];
    }

    protected function register_controls() {

        // ----------------------------- //
        // ---------- Content ---------- //
        // ----------------------------- //
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Product Carousel', 'agrarium_plugin')
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'image',
            [
                'label'     => esc_html__('Product Image', 'agrarium_plugin'),
                'type'      => Controls_Manager::MEDIA,
                'default'   => [
                    'url'       => Utils::get_placeholder_image_src(),
                ]
            ]
        );
        $repeater->add_responsive_control(
            'image_align',
            [
                'label'     => esc_html__('Image Alignment', 'agrarium_plugin'),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'      => [
                        'title'     => esc_html__('Left', 'agrarium_plugin'),
                        'icon'      => 'fa fa-align-left',
                    ],
                    'center'    => [
                        'title'     => esc_html__('Center', 'agrarium_plugin'),
                        'icon'      => 'fa fa-align-center',
                    ],
                    'right'     => [
                        'title'     => esc_html__('Right', 'agrarium_plugin'),
                        'icon'      => 'fa fa-align-right',
                    ]
                ],
                'default'   => 'center',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .product-image-wrapper' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $repeater->add_control(
           'title',
           [
               'label'         => esc_html__('Product Title', 'agrarium_plugin'),
               'type'          => Controls_Manager::TEXT,
               'placeholder'   => esc_html__('Enter Title', 'agrarium_plugin'),
               'default'       => ''
           ]
        );

        $repeater->add_control(
           'subtitle',
           [
               'label'         => esc_html__('Product Subtitle', 'agrarium_plugin'),
               'type'          => Controls_Manager::TEXT,
               'placeholder'   => esc_html__('Enter Subtitle', 'agrarium_plugin'),
               'default'       => ''
           ]
        );

        $repeater->add_control(
           'price',
           [
               'label'         => esc_html__('Product Price', 'agrarium_plugin'),
               'type'          => Controls_Manager::TEXT,
               'placeholder'   => esc_html__('Enter Price', 'agrarium_plugin'),
               'default'       => ''
           ]
        );

        $repeater->add_control(
            'description',
            [
                'label'         => esc_html__('Product Description', 'agrarium_plugin'),
                'type'          => Controls_Manager::WYSIWYG,
                'rows'          => '10',
                'default'       => '',
                'placeholder'   => esc_html__('Enter Description', 'agrarium_plugin'),
                'separator'     => 'before'
            ]
        );           
        $repeater->add_control(
            'button_text',
            [
                'label'     => esc_html__('Button Text', 'agrarium_plugin'),
                'type'      => Controls_Manager::TEXT,
                'default'   => esc_html__('Button', 'agrarium_plugin')
            ]
        );

        $repeater->add_control(
            'button_link',
            [
                'label'         => esc_html__('Button Link', 'agrarium_plugin'),
                'type'          => Controls_Manager::URL,
                'label_block'   => true,
                'default'       => [
                    'url'           => '',
                    'is_external'   => 'true',
                ],
                'placeholder'   => esc_html__( 'http://your-link.com', 'agrarium_plugin' )
            ]
        );

        $repeater->add_responsive_control(
            'button_align',
            [
                'label'     => esc_html__('Button Alignment', 'agrarium_plugin'),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'      => [
                        'title'     => esc_html__('Left', 'agrarium_plugin'),
                        'icon'      => 'fa fa-align-left',
                    ],
                    'center'    => [
                        'title'     => esc_html__('Center', 'agrarium_plugin'),
                        'icon'      => 'fa fa-align-center',
                    ],
                    'right'     => [
                        'title'     => esc_html__('Right', 'agrarium_plugin'),
                        'icon'      => 'fa fa-align-right',
                    ]
                ],
                'default'   => 'center',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .product-button' => 'text-align: {{VALUE}};',
                ]
            ]
        );
        $this->add_control(
            'product_items',
            [
                'label'         => esc_html__('Products', 'agrarium_plugin'),
                'type'          => Controls_Manager::REPEATER,
                'fields'        => $repeater->get_controls(),
                'title_field'   => '{{{name}}}',
                'prevent_empty' => false,
                'separator'     => 'before'
            ]
        );

        $this->end_controls_section();

        // ---------------------------- //
        // ---------- Slider ---------- //
        // ---------------------------- //
        $this->start_controls_section(
            'section_slider',
            [
                'label' => esc_html__('Slider Settings', 'agrarium_plugin')
            ]
        );

        $this->add_control(
            'speed',
            [
                'label'     => esc_html__('Animation Speed', 'agrarium_plugin'),
                'type'      => Controls_Manager::NUMBER,
                'default'   => 500,
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'infinite',
            [
                'label'     => esc_html__('Infinite Loop', 'agrarium_plugin'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'yes',
                'options'   => [
                    'yes'       => esc_html__('Yes', 'agrarium_plugin'),
                    'no'        => esc_html__('No', 'agrarium_plugin'),
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label'     => esc_html__('Autoplay', 'agrarium_plugin'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'yes',
                'options'   => [
                    'yes'       => esc_html__('Yes', 'agrarium_plugin'),
                    'no'        => esc_html__('No', 'agrarium_plugin'),
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'autoplay_speed',
            [
                'label'     => esc_html__('Autoplay Speed', 'agrarium_plugin'),
                'type'      => Controls_Manager::NUMBER,
                'default'   => 300,
                'step'      => 100,
                'condition' => [
                    'autoplay'  => 'yes'
                ]
            ]
        );

        $this->add_control(
            'autoplay_timeout',
            [
                'label'     => esc_html__('Autoplay Timeout', 'agrarium_plugin'),
                'type'      => Controls_Manager::NUMBER,
                'default'   => 5000,
                'step'      => 100,
                'condition' => [
                    'autoplay'  => 'yes'
                ]
            ]
        );

        $this->add_control(
            'pause_on_hover',
            [
                'label'     => esc_html__('Pause on Hover', 'agrarium_plugin'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'yes',
                'options'   => [
                    'yes'       => esc_html__('Yes', 'agrarium_plugin'),
                    'no'        => esc_html__('No', 'agrarium_plugin'),
                ],
                'condition' => [
                    'autoplay'  => 'yes'
                ]
            ]
        );

        $this->end_controls_section();

        // ----------------------------------------- //
        // ---------- Pagination Settings ---------- //
        // ----------------------------------------- //
        $this->start_controls_section(
            'section_pagination_settings',
            [
                'label' => esc_html__('Pagination Settings', 'agrarium_plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->start_controls_tabs('pagination_settings_tabs');

            // ------------------------ //
            // ------ Normal Tab ------ //
            // ------------------------ //
            $this->start_controls_tab(
                'pagination_normal',
                [
                    'label' => esc_html__('Normal', 'agrarium_plugin')
                ]
            );

                $this->add_control(
                    'dot_color',
                    [
                        'label'     => esc_html__('Pagination Dot Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .slick-dots li button:before' => 'border-color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'dot_border',
                    [
                        'label'     => esc_html__('Pagination Dot Border', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .slick-dots li button:after' => 'border-color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();

            // ------------------------ //
            // ------ Active Tab ------ //
            // ------------------------ //
            $this->start_controls_tab(
                'pagination_active',
                [
                    'label' => esc_html__('Active', 'agrarium_plugin')
                ]
            );

                $this->add_control(
                    'dot_active',
                    [
                        'label'     => esc_html__('Pagination Active Dot Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .slick-dots li.slick-active button:before' => 'background-color: {{VALUE}}; border-color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'dot_border_active',
                    [
                        'label'     => esc_html__('Pagination Active Dot Border', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .slick-dots li.slick-active button:after' => 'border-color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        // -------------------------------------- //
        // ---------- Content Settings ---------- //
        // -------------------------------------- //
        $this->start_controls_section(
            'section_content_settings',
            [
                'label' => esc_html__('Content Settings', 'agrarium_plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'title_typography',
                'label'     => esc_html__('Title Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .product-item .product-title',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__('Title Color', 'agrarium_plugin'),
                'type'      => Controls_Manager::COLOR,
                'separator' => 'after',
                'selectors' => [
                    '{{WRAPPER}} .product-item .product-title' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'subtitle_typography',
                'label'     => esc_html__('Subtitle Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .product-item .product-subtitle',
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'subtitle_color',
            [
                'label'     => esc_html__('Subtitle Color', 'agrarium_plugin'),
                'type'      => Controls_Manager::COLOR,
                'separator' => 'after',
                'selectors' => [
                    '{{WRAPPER}} .product-item .product-subtitle' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'price_typography',
                'label'     => esc_html__('Price Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .product-item .product-price',
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'price_color',
            [
                'label'     => esc_html__('Price Color', 'agrarium_plugin'),
                'type'      => Controls_Manager::COLOR,
                'separator' => 'after',
                'selectors' => [
                    '{{WRAPPER}} .product-item .product-price' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'description_typography',
                'label'     => esc_html__('Description Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .product-item .product-description',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label'     => esc_html__('Description Color', 'agrarium_plugin'),
                'type'      => Controls_Manager::COLOR,
                'separator' => 'after',
                'selectors' => [
                    '{{WRAPPER}} .product-item .product-description' => 'color: {{VALUE}};'
                ]
            ]
        );  
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'button_typography',
                'label'     => esc_html__('Button Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .agrarium-button'
            ]
        );
        $this->start_controls_tabs('button_settings_tabs');

            // ------------------------ //
            // ------ Normal Tab ------ //
            // ------------------------ //
            $this->start_controls_tab(
                'tab_button_normal',
                [
                    'label' => esc_html__('Normal', 'agrarium_plugin')
                ]
            );

                $this->add_control(
                    'button_color',
                    [
                        'label'     => esc_html__('Button Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .agrarium-button' => 'color: {{VALUE}};'
                        ]
                    ]
                );                

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name'      => 'button_bg',
                        'label'     => esc_html__( 'Button Background', 'agrarium_plugin' ),
                        'types'     => [ 'classic', 'gradient' ],
                        'selector'  => '{{WRAPPER}} .agrarium-button'
                    ]
                );
                $this->add_control(
                    'button_border',
                    [
                        'label'     => esc_html__('Border Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .agrarium-button' => 'border-color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();

            // ----------------------- //
            // ------ Hover Tab ------ //
            // ----------------------- //
            $this->start_controls_tab(
                'tab_button_hover',
                [
                    'label' => esc_html__('Hover', 'agrarium_plugin')
                ]
            );

                $this->add_control(
                    'button_color_hover',
                    [
                        'label'     => esc_html__('Button Hover Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .agrarium-button:hover' => 'color: {{VALUE}};'
                        ]
                    ]
                );
                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name'      => 'button_bg_hover',
                        'label'     => esc_html__( 'Button Hover Background', 'agrarium_plugin' ),
                        'types'     => [ 'classic', 'gradient' ],
                        'selector'  => '{{WRAPPER}} .agrarium-button:after'
                    ]
                );
                $this->add_control(
                    'button_border_hover',
                    [
                        'label'     => esc_html__('Border Hover Color', 'agrarium_plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .agrarium-button:hover' => 'border-color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'button_radius',
            [
                'label'         => esc_html__('Button Border Radius', 'agrarium_plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', '%'],
                'selectors'     => [
                    '{{WRAPPER}} .agrarium-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_control(
            'button_padding',
            [
                'label'         => esc_html__('Button Padding', 'agrarium_plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', '%'],
                'selectors'     => [
                    '{{WRAPPER}} .agrarium-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings           = $this->get_settings();

        $product_items = $settings['product_items'];
        $widget_id          = $this->get_id();

        $slider_options = [
            'arrows'        => false,
            'dots'          => true,
            'pauseOnHover'  => ('yes' === $settings['pause_on_hover']),
            'autoplay'      => ('yes' === $settings['autoplay']),
            'infinite'      => ('yes' === $settings['infinite']),
            'speed'         => absint($settings['speed'])
        ]; 

        // ------------------------------------ //
        // ---------- Widget Content ---------- //
        // ------------------------------------ //
        ?>

        
        <div class="product-carousel-wrapper">
            <div class="product-slider-container">
                <div class="product-slider" data-slider-options="<?php echo esc_attr(wp_json_encode($slider_options)); ?>">
                    <?php
                        foreach ($product_items as $item) {
                            echo '<div class="product-item-wrapper slider-item elementor-repeater-item-' . esc_attr($item['_id']) . '">';
                                echo '<div class="product-item">';
                                    $image = $item['image'];
                                    if(!empty($image['id'])) {
                                        $image_src      = $image['url'];
                                        $image_meta     = agrarium_get_attachment_meta($image['id']);
                                        $image_alt_text = $image_meta['alt'];
                                        $image_title    = $image_meta['title'];
                                        echo '<div class="product-image-wrapper">';
                                            echo '<img class="product-image" src="' . esc_url($image_src) . '" title="' . esc_attr($image_title) . '" alt="' . esc_attr($image_alt_text) . '"/>';
                                        echo '</div>';
                                    }                                
                                    echo '<div class="product-wrapper">';
                                        if ( !empty($item['title']) ) {
                                            echo '<h2 class="product-heading agrarium-heading">';
                                                if ( !empty($item['subtitle']) ) {
                                                    echo '<span class="product-subtitle agrarium-subheading">' . esc_html($item['subtitle']) . '</span>';
                                                }
                                                echo '<span class="product-title agrarium-heading-content">';
                                                    echo wp_kses_post($item['title']);
                                                echo '</span>';
                                            echo '</h2>';
                                        }
                                        if( !empty($item['price'])) {
                                            echo '<h4 class="product-price">' . esc_html($item['price']) . '</h4>';
                                        }
                                        echo ( !empty($item['description']) ? '<div class="product-description">' . wp_kses_post($item['description']) . '</div>' : '' );
                                        if(!empty($item['button_text'])) {   
                                            if ($item['button_link']['url'] !== '') {
                                                $button_url = $item['button_link']['url'];
                                            } else {
                                                $button_url = '#';
                                            }                           
                                            echo '<div class="product-button">';
                                                echo '<a class="agrarium-button" href="' . esc_url($button_url) . '" ' . (($item['button_link']['is_external'] == true) ? 'target="_blank"' : '') . (($item['button_link']['nofollow'] == 'on') ? 'rel="nofollow"' : '') . '>' . esc_html($item['button_text']) . '</a>';
                                            echo '</div>';
                                        }
                                    echo '</div>';
                                echo '</div>';
                            echo '</div>';
                        }
                    ?>
                </div>
            </div>
            <?php
                if(count($product_items) > 1) {
                    echo '<div class="slick-dots-navigation"></div>';
                }
            ?>
        </div>
        <?php
    }

    protected function content_template() {}

    public function render_plain_content() {}
}