<?php

/*
 * Created by Artureanec
*/

namespace AgrariUm\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class AgrariUm_Slogan_Widget extends Widget_Base {

    public function get_name() {
        return 'agrarium_slogan';
    }

    public function get_title() {
        return esc_html__('Slogan', 'agrarium_plugin');
    }

    public function get_icon() {
        return 'eicon-t-letter';
    }

    public function get_categories() {
        return ['agrarium_widgets'];
    }

    protected function register_controls() {

        // ----------------------------- //
        // ---------- Content ---------- //
        // ----------------------------- //
        $this->start_controls_section(
            'section_slogan',
            [
                'label' => esc_html__('Slogan', 'agrarium_plugin')
            ]
        );

        $this->add_responsive_control(
            'text',
            [
                'label'         => esc_html__('Text', 'agrarium_plugin'),
                'type'          => Controls_Manager::TEXTAREA,
                'placeholder'   => esc_html__('Enter Text', 'agrarium_plugin')
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'      => 'background_image',
                'label'     => esc_html__('Background Image', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .slogan',
                'type'      => ['classic']
            ]
        );

        $this->add_responsive_control(
            'text_align',
            [
                'label'     => esc_html__('Alignment', 'agrarium_plugin'),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'      => [
                        'title'     => esc_html__('Left', 'agrarium_plugin'),
                        'icon'      => 'fa fa-align-left',
                    ],
                    'center'    => [
                        'title'     => esc_html__('Center', 'agrarium_plugin'),
                        'icon'      => 'fa fa-align-center',
                    ],
                    'right'     => [
                        'title'     => esc_html__('Right', 'agrarium_plugin'),
                        'icon'      => 'fa fa-align-right',
                    ]
                ],
                'default'   => 'left',
                'selectors' => [
                    '{{WRAPPER}} .slogan' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // -------------------------------------- //
        // ---------- Heading Settings ---------- //
        // -------------------------------------- //
        $this->start_controls_section(
            'section_slogan_padding',
            [
                'label' => esc_html__('Slogan Padding', 'agrarium_plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_responsive_control(
            'slogan_padding',
            [
                'label'         => esc_html__('Padding', 'agrarium_plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em', '%'],
                'selectors'     => [
                    '{{WRAPPER}} .slogan' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_text_settings',
            [
                'label' => esc_html__('Text Settings', 'agrarium_plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'text_typography',
                'label'     => esc_html__('Slogan Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .slogan'
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__('Text Color', 'agrarium_plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slogan' => 'color: {{VALUE}}; background: none; -webkit-background-clip: unset; -webkit-text-fill-color: unset;',
                ],
                'separator' => 'after'
            ]
        );        

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name'      => 'text_shadow',
                'label'     => esc_html__('Text Shadow', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .slogan'
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {
        $settings   = $this->get_settings();
        $text    = $settings['text'];

        // ------------------------------------ //
        // ---------- Widget Content ---------- //
        // ------------------------------------ //
        if ( !empty($text) ) {
            echo '<div class="slogan">';
                echo wp_kses_post($text);
            echo '</div>';
        }
    }

    protected function content_template() {}

    public function render_plain_content() {}
}
