<?php

/*
 * Created by Artureanec
*/

namespace AgrariUm\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class AgrariUm_Vertical_Text_Widget extends Widget_Base {

    public function get_name() {
        return 'agrarium_vertical_text';
    }

    public function get_title() {
        return esc_html__('Vertical Text', 'agrarium_plugin');
    }

    public function get_icon() {
        return 'eicon-t-letter';
    }

    public function get_categories() {
        return ['agrarium_widgets'];
    }

    protected function register_controls() {

        // ----------------------------- //
        // ---------- Content ---------- //
        // ----------------------------- //
        $this->start_controls_section(
            'section_vertical_text',
            [
                'label' => esc_html__('Vertical Text', 'agrarium_plugin')
            ]
        );

        $this->add_control(
            'text',
            [
                'label'         => esc_html__('Text', 'agrarium_plugin'),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__('Enter Text', 'agrarium_plugin')
            ]
        );

        $this->add_responsive_control(
            'text_align',
            [
                'label'     => esc_html__('Alignment', 'agrarium_plugin'),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'      => [
                        'title'     => esc_html__('Left', 'agrarium_plugin'),
                        'icon'      => 'fa fa-align-left',
                    ],
                    'center'    => [
                        'title'     => esc_html__('Center', 'agrarium_plugin'),
                        'icon'      => 'fa fa-align-center',
                    ],
                    'right'     => [
                        'title'     => esc_html__('Right', 'agrarium_plugin'),
                        'icon'      => 'fa fa-align-right',
                    ]
                ],
                'default'   => 'left',
                'selectors' => [
                    '{{WRAPPER}} .vertical-text' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // -------------------------------------- //
        // ---------- Heading Settings ---------- //
        // -------------------------------------- //
        $this->start_controls_section(
            'section_text_settings',
            [
                'label' => esc_html__('Text Settings', 'agrarium_plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_control(
            'use_scroll_motion',
            [
                'label'         => esc_html__( 'Scroll Motion Effect', 'agrarium_plugin' ),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'On', 'agrarium_plugin' ),
                'label_off'     => esc_html__( 'Off', 'agrarium_plugin' ),
                'return_value'  => 'yes',
                'default'       => 'no',
                'prefix_class'  => 'scroll-motion-'
            ]
        );
        $this->add_control(
            'scroll_direction',
            [
                'label'     => esc_html__('Scroll Direction', 'agrarium_plugin'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'up',
                'options'   => [
                    'up'   => esc_html__('Up', 'agrarium_plugin'),
                    'down'   => esc_html__('Down', 'agrarium_plugin')
                ],
                'condition' => [
                    'use_scroll_motion' => 'yes'
                ],
                'separator'     => 'after',
                'prefix_class'  => 'scroll-motion-direction-'
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'text_typography',
                'label'     => esc_html__('Heading Typography', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .vertical-text'
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__('Text Color', 'agrarium_plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vertical-text' => 'color: {{VALUE}};'
                ],
                'separator' => 'after'
            ]
        );

        $this->add_control(
            'text_opacity',
            [
                'label'     => esc_html__('Opacity', 'agrarium_plugin'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    '%'         => [
                        'min'       => 0,
                        'max'       => 1,
                        'step'      => .01
                    ]
                ],
                'default'   => [
                    'unit'      => '%',
                    'size'      => 1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .vertical-text' => 'opacity: {{SIZE}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name'      => 'text_shadow',
                'label'     => esc_html__('Text Shadow', 'agrarium_plugin'),
                'selector'  => '{{WRAPPER}} .vertical-text'
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {
        $settings   = $this->get_settings();
        $text    = $settings['text'];

        // ------------------------------------ //
        // ---------- Widget Content ---------- //
        // ------------------------------------ //
        if ( !empty($text) ) {
            echo '<div class="vertical-text">';
                echo esc_html($text);
            echo '</div>';
        }
    }

    protected function content_template() {}

    public function render_plain_content() {}
}
