<?php
/*
 * Created by Artureanec
*/

if (!class_exists('Agrarium_Contacts_Widget')) {
    class Agrarium_Contacts_Widget extends WP_Widget {
        public function __construct() {
            parent::__construct(
                'Agrarium_Contacts_Widget',
                'Contacts Widget (Agrarium Theme)',
                array(
                    'description' => esc_html__('Contacts Widget by Agrarium Theme', 'agrarium_plugin'),
                    'mime_type'   => 'image'
                )
            );
        }

        public function update($new_instance, $old_instance) {
            $instance = $old_instance;

            $instance['color_scheme'] = esc_attr($new_instance['color_scheme']);
            $instance['title']       = esc_attr($new_instance['title']);
            $instance['logo']        = strip_tags($new_instance['logo']);
            $instance['logo_id']     = esc_attr($new_instance['logo_id']);
            $instance['retina']      = !empty($new_instance['retina']) ? esc_attr($new_instance['retina']) : '';
            $instance['show_labels'] = !empty($new_instance['show_labels']) ? esc_attr($new_instance['show_labels']) : '';
            $instance['address']     = wp_kses($new_instance['address'], array('br' => array(), 'strong' => array(), 'b' => array(), 'em' => array(), 'i' => array()));
            $instance['phone']       = wp_kses($new_instance['phone'], array('a' => array('href' => true), 'br' => array(), 'strong' => array(), 'b' => array(), 'em' => array(), 'i' => array()));
            $instance['email']       = wp_kses($new_instance['email'], array('a' => array('href' => true), 'br' => array(), 'strong' => array(), 'b' => array(), 'em' => array(), 'i' => array()));
            $instance['social']      = esc_attr($new_instance['social']);
            $instance['text']        = wp_kses($new_instance['text'], array('br' => array(), 'strong' => array(), 'b' => array(), 'em' => array(), 'i' => array()));
            $instance['copyright']   = wp_kses($new_instance['copyright'], array('br' => array(), 'strong' => array(), 'b' => array(), 'em' => array(), 'i' => array()));
            $instance['link_text']   = esc_attr($new_instance['link_text']);            
            $instance['contacts_link']  = esc_url($new_instance['contacts_link']);
            $instance['link_tab'] = !empty($new_instance['link_tab']) ? esc_attr($new_instance['link_tab']) : '';

            return $instance;
        }

        public function form($instance) {
            $default_values = array(
                'title'     => '',
                'color_scheme' => 'default',
                'logo'      => '',
                'logo_id'   => '',
                'retina'    => false,
                'show_labels' => false,
                'address'   => '',
                'phone'     => '',
                'email'     => '',
                'social'    => 'disabled',
                'text'      => '',
                'copyright' => '',
                'link_text' => '',
                'contacts_link' => '',
                'link_tab' => false
            );

            $instance = wp_parse_args((array)$instance, $default_values);
            $retina     = isset( $instance['retina'] ) ? (bool) $instance['retina'] : false;
            $show_labels     = isset( $instance['show_labels'] ) ? (bool) $instance['show_labels'] : false;
            $link_tab = isset( $instance['link_tab'] ) ? (bool) $instance['link_tab'] : false;
            ?>

            <div class="agrarium_widget">
                <div class="media-widget-control">
                    <p>
                        <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
                            <?php echo esc_html__('Title', 'agrarium_plugin'); ?>:
                        </label>
                        <input class="widefat"
                               type="text"
                               id="<?php echo esc_attr($this->get_field_id('title')); ?>"
                               name="<?php echo esc_attr($this->get_field_name('title')); ?>"
                               value="<?php echo esc_html($instance['title']); ?>"
                        />
                    </p>
                    <p>
                        <label for="<?php echo esc_attr($this->get_field_id('color_scheme')); ?>">
                            <?php echo esc_html__('Color Scheme', 'agrarium_plugin'); ?>:
                        </label>
                        <select name="<?php echo esc_attr($this->get_field_name('color_scheme')); ?>"
                                id="<?php echo esc_attr($this->get_field_id('color_scheme')); ?>">
                            <option value="default" <?php selected($instance['color_scheme'], 'disabled'); ?>><?php echo esc_html__('Default', 'agrarium_plugin'); ?></option>
                            <option value="contrast" <?php selected($instance['color_scheme'], 'enabled'); ?>><?php echo esc_html__('Contrast', 'agrarium_plugin'); ?></option>
                        </select>
                    </p>

                    <p>
                        <label for="<?php echo $this->get_field_id( 'logo' ); ?>"><?php echo esc_html__( 'Logo:', 'agrarium_plugin' ); ?></label>
                    </p>

                    <div class="media-widget-preview media_image">
                        <?php
                        $logo_id = !empty($instance['logo']) ? attachment_url_to_postid( $instance['logo'] ) : '';

                        if ( !empty($logo_id) ) {
                            if ( wp_get_attachment_image_url($logo_id, 'medium') ) {
                                $logo_url = wp_get_attachment_image_url($logo_id, 'medium');
                            } else {
                                $logo_url = wp_get_attachment_image_url($logo_id, 'full');
                            }
                        } else {
                            $logo_url = get_template_directory_uri() . '/img/null.png';
                        }
                        echo '<img class="attachment-thumb ' . $this->get_field_id( 'logo' ) . '_img' . (empty($instance['logo']) ? ' hidden' : '') . '" src="' . esc_url($logo_url) . '" />';
                        ?>
                        <div class="attachment-media-view">
                            <button type="button" id="<?php echo $this->get_field_id( 'logo' ) ?>" class="button select-media button-add-media not-selected js_custom_upload_media<?php echo empty($instance['logo']) ? ' empty' : ' hidden'; ?>"><?php echo esc_html__('Add Image', 'agrarium_plugin') ?></button>
                        </div>
                        <input hidden type="text" class="widefat <?php echo $this->get_field_id( 'logo' ) ?>_url" name="<?php echo esc_attr( $this->get_field_name( 'logo' ) ); ?>" value="<?php echo !empty($instance['logo']) ? $instance['logo'] : ''; ?>" />
                        <input hidden type="text" class="widefat2 <?php echo $this->get_field_id( 'logo' ) ?>_id" name="<?php echo esc_attr( $this->get_field_name( 'logo_id' ) ); ?>" value="<?php echo !empty($instance['logo_id']) ? $instance['logo_id'] : ''; ?>" />
                    </div>

                    <p class="media-widget-buttons">
                        <button id="<?php echo $this->get_field_id( 'logo' ).'_remove' ?>" type="button" class="button js_custom_remove_media<?php echo (empty($instance['logo']) ? ' hidden' : ''); ?>"><?php echo esc_html__('Replace Image', 'agrarium_plugin') ?></button>
                    </p>

                    <p>
                        <label for="<?php echo $this->get_field_id( 'retina' ); ?>">
                            <input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id( 'retina' ); ?>" name="<?php echo $this->get_field_name( 'retina' ); ?>"<?php checked( $retina ); ?> />
                            <?php esc_html_e( 'Logo Retina', 'agrarium_plugin' ); ?>
                        </label>
                    </p>
                    <p>
                        <label for="<?php echo $this->get_field_id( 'show_labels' ); ?>">
                            <input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id( 'show_labels' ); ?>" name="<?php echo $this->get_field_name( 'show_labels' ); ?>"<?php checked( $show_labels ); ?> />
                            <?php esc_html_e( 'Show Labels', 'agrarium_plugin' ); ?>
                        </label>
                    </p>
                    <p>
                        <label for="<?php echo esc_attr($this->get_field_id('address')); ?>">
                            <?php echo esc_html__('Address', 'agrarium_plugin'); ?>:
                        </label>
                        <textarea class="widefat"
                               id="<?php echo esc_attr($this->get_field_id('address')); ?>"
                               name="<?php echo esc_attr($this->get_field_name('address')); ?>"
                        ><?php echo wp_kses($instance['address'], array('br' => array(), 'strong' => array(), 'b' => array(), 'em' => array(), 'i' => array())); ?></textarea>
                    </p>

                    <p>
                        <label for="<?php echo esc_attr($this->get_field_id('phone')); ?>">
                            <?php echo esc_html__('Phone Number', 'agrarium_plugin'); ?>:
                        </label>
                        <textarea class="widefat"
                                  id="<?php echo esc_attr($this->get_field_id('phone')); ?>"
                                  name="<?php echo esc_attr($this->get_field_name('phone')); ?>"
                        ><?php echo wp_kses($instance['phone'], array('br' => array(), 'strong' => array(), 'b' => array(), 'em' => array(), 'i' => array())); ?></textarea>
                    </p>

                    <p>
                        <label for="<?php echo esc_attr($this->get_field_id('email')); ?>">
                            <?php echo esc_html__('Email', 'agrarium_plugin'); ?>:
                        </label>
                        <textarea class="widefat"
                                  id="<?php echo esc_attr($this->get_field_id('email')); ?>"
                                  name="<?php echo esc_attr($this->get_field_name('email')); ?>"
                        ><?php echo wp_kses($instance['email'], array('br' => array(), 'strong' => array(), 'b' => array(), 'em' => array(), 'i' => array())); ?></textarea>
                    </p>

                    <p>
                        <label for="<?php echo esc_attr($this->get_field_id('social')); ?>">
                            <?php echo esc_html__('Social Buttons', 'agrarium_plugin'); ?>:
                        </label>
                        <select name="<?php echo esc_attr($this->get_field_name('social')); ?>"
                                id="<?php echo esc_attr($this->get_field_id('social')); ?>">
                            <option value="disabled" <?php selected($instance['social'], 'disabled'); ?>><?php echo esc_html__('Disabled', 'agrarium_plugin'); ?></option>
                            <option value="enabled" <?php selected($instance['social'], 'enabled'); ?>><?php echo esc_html__('Enabled', 'agrarium_plugin'); ?></option>
                        </select>
                    </p>

                    <p>
                        <label for="<?php echo esc_attr($this->get_field_id('text')); ?>">
                            <?php echo esc_html__('Description', 'agrarium_plugin'); ?>:
                        </label>
                        <textarea class="widefat"
                                  id="<?php echo esc_attr($this->get_field_id('text')); ?>"
                                  name="<?php echo esc_attr($this->get_field_name('text')); ?>"
                        ><?php echo wp_kses($instance['text'], array('br' => array(), 'strong' => array(), 'b' => array(), 'em' => array(), 'i' => array())); ?></textarea>
                    </p>

                    <p>
                        <label for="<?php echo esc_attr($this->get_field_id('copyright')); ?>">
                            <?php echo esc_html__('Additional text', 'agrarium_plugin'); ?>:
                        </label>
                        <textarea class="widefat"
                                  id="<?php echo esc_attr($this->get_field_id('copyright')); ?>"
                                  name="<?php echo esc_attr($this->get_field_name('copyright')); ?>"
                        ><?php echo wp_kses($instance['copyright'], array('br' => array(), 'strong' => array(), 'b' => array(), 'em' => array(), 'i' => array())); ?></textarea>
                    </p>
                    <p>
                        <label for="<?php echo esc_attr($this->get_field_id('link_text')); ?>">
                            <?php echo esc_html__('Link Text', 'agrarium_plugin'); ?>:
                        </label>
                        <input class="widefat"
                               type="text"
                               id="<?php echo esc_attr($this->get_field_id('link_text')); ?>"
                               name="<?php echo esc_attr($this->get_field_name('link_text')); ?>"
                               value="<?php echo esc_html($instance['link_text']); ?>"
                        />
                    </p>
                    <p>
                        <label for="<?php echo esc_attr($this->get_field_id('contacts_link')); ?>">
                            <?php echo esc_html__('Contacts Link', 'agrarium_plugin'); ?>:
                        </label>
                        <input class="widefat"
                               type="text"
                               id="<?php echo esc_attr($this->get_field_id('contacts_link')); ?>"
                               name="<?php echo esc_attr($this->get_field_name('contacts_link')); ?>"
                               value="<?php echo esc_url($instance['contacts_link']); ?>"
                        />
                    </p>
                    <p>
                        <label for="<?php echo $this->get_field_id( 'link_tab' ); ?>">
                            <input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id( 'link_tab' ); ?>" name="<?php echo $this->get_field_name( 'link_tab' ); ?>"<?php checked( $link_tab ); ?> />
                            <?php esc_html_e( 'Open Link in New Tab', 'agrarium_plugin' ); ?>
                        </label>
                    </p>

                </div>
            </div>
            <?php
        }

        public function widget($args, $instance) {
            extract($args);

            echo $before_widget;
            $color_classes = '';
            if (isset($instance['color_scheme']) && $instance['color_scheme'] == 'contrast') {
                $color_classes .= ' color_scheme_contrast';
            }
            echo '<div class="widget_inner' . $color_classes . '">';
            if ($instance['title']) {
                echo $before_title;
                echo apply_filters('widget_title', $instance['title']);
                echo $after_title;
            }

            if ( !empty($instance['logo']) && !empty($instance['logo_id']) ) {
                $demo_url = 'https://demo.artureanec.com/themes/agrarium';
                $current_url = get_home_url();
                if ( strpos($instance['logo'], $demo_url) === false ) {
                    $url = $instance['logo'];
                } else {
                    $url = str_replace($demo_url, $current_url, $instance['logo']);
                }
                $logo_id = $instance['logo_id'];
                $logo_meta = wp_get_attachment_metadata( $logo_id );
                if ( $instance['retina'] == true ) {
                    $logo_width = (isset($logo_meta['width']) ? floor($logo_meta['width'] / 2 ) : 0);
                    $logo_height = (isset($logo_meta['height']) ? floor( $logo_meta['height'] / 2 ) : 0);
                } else {
                    $logo_width = (isset($logo_meta['width']) ? $logo_meta['width'] : 0);
                    $logo_height = (isset($logo_meta['height']) ? $logo_meta['height'] : 0);
                }
                echo '<div class="agrarium-contacts-widget-logo logo' . ($instance['retina'] == true ? ' retina-logo' : '') . '">';
                    echo '<a href="' . esc_url(home_url('/')) . '" class="logo-link">';
                        echo '<img width="' . esc_attr($logo_width) . '" height="' . esc_attr($logo_height) . '" src="'.esc_url($url).'" alt="' . esc_attr(get_post_meta(attachment_url_to_postid($url), '_wp_attachment_image_alt', TRUE)) . '" />';
                    echo '</a>';
                echo '</div>';
            }

            if ($instance['text'] !== '') {
                echo '
                    <div class="agrarium-contacts-widget-description">
                        <p>
                            ' . wp_kses($instance['text'], array('br' => array(), 'strong' => array(), 'b' => array(), 'em' => array(), 'i' => array())) . '
                        </p>
                    </div>
                ';
            }
            $label_class = '';
            if ($instance['show_labels'] == true) {
                $label_class = ' labeled';
            }
            if ($instance['address'] !== '') {
                echo '<div class="agrarium-contacts-widget-field agrarium-contacts-widget-address' . $label_class .'">';
                    if ($instance['show_labels'] == true) {
                        echo '<h6 class="field-label">' . esc_html__('Location', 'agrarium_plugin') . '</h6>';
                    }                    
                    echo wp_kses($instance['address'], array('br' => array(), 'strong' => array(), 'b' => array(), 'em' => array(), 'i' => array()));
                echo '</div>';
            }
            if ($instance['phone'] !== '') {
                echo '
                    <div class="agrarium-contacts-widget-field agrarium-contacts-widget-phone' . $label_class .'">';
                        if ($instance['show_labels'] == true) {
                            echo '<h6 class="field-label">' . esc_html__('Phone', 'agrarium_plugin') . '</h6>';
                        } 
                        echo wp_kses($instance['phone'], array('a' => array('href' => true), 'br' => array(), 'strong' => array(), 'b' => array(), 'em' => array(), 'i' => array())) . '
                    </div>
                ';
            }
            if ($instance['email'] !== '') {
                echo '
                    <div class="agrarium-contacts-widget-field agrarium-contacts-widget-email' . $label_class .'">';
                       if ($instance['show_labels'] == true) {
                            echo '<h6 class="field-label">' . esc_html__('Email', 'agrarium_plugin') . '</h6>';
                        } 
                        echo wp_kses($instance['email'], array('a' => array('href' => true), 'br' => array(), 'strong' => array(), 'b' => array(), 'em' => array(), 'i' => array())) . '
                    </div>
                ';
            }            

            if (isset($instance['social']) && $instance['social'] == 'enabled') {
                echo agrarium_socials_output('widget-socials wrapper-socials');
            }
            if ($instance['link_text'] !== '' && $instance['contacts_link'] !== '') {
                echo '
                    <div class="agrarium-contacts-widget-link">
                        <p>
                            <a href="' . esc_url($instance['contacts_link']) . '"' . ($instance['link_tab'] == true ? ' target=_blank' : '' ) . '>
                            <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                 viewBox="0 0 385 512" style="enable-background:new 0 0 385 512;" xml:space="preserve"><g><g><path d="M192.3,0C86.4,0,0.3,86.1,0.3,192c0,133.1,173.3,307.9,180.7,315.3c3.1,3.1,7.2,4.7,11.3,4.7c4.1,0,8.2-1.6,11.3-4.7
                                        c7.4-7.4,180.7-182.2,180.7-315.3C384.3,86.1,298.2,0,192.3,0z M192.3,472.9C154.1,432,32.3,293.7,32.3,192
                                        c0-88.2,71.8-160,160-160s160,71.8,160,160C352.3,293.6,230.5,432,192.3,472.9z"/></g></g><g><g><path d="M192.3,96c-52.9,0-96,43.1-96,96s43.1,96,96,96s96-43.1,96-96S245.3,96,192.3,96z M192.3,256c-35.3,0-64-28.7-64-64
                                        s28.7-64,64-64s64,28.7,64,64S227.6,256,192.3,256z"/></g></g></svg>' .
                            wp_kses($instance['link_text'], array('br' => array(), 'strong' => array(), 'b' => array(), 'em' => array(), 'i' => array())) .
                           ' </a>
                        </p>
                    </div>
                ';
            }

            if ($instance['copyright'] !== '') {
                echo '
                    <div class="agrarium-contacts-widget-copyright">
                        <p>
                            ' . wp_kses($instance['copyright'], array('br' => array(), 'strong' => array(), 'b' => array(), 'em' => array(), 'i' => array())) . '
                        </p>
                    </div>
                ';
            }
            echo '</div>';
            echo $after_widget;
        }
    }
}
